/*!
 * Webflow: Front-end site library
 * @license MIT
 * Inline scripts may access the api using an async handler:
 *   var Webflow = Webflow || [];
 *   Webflow.push(readyFunction);
 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 270);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    "default": obj
  };
}

module.exports = _interopRequireDefault;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(4);
var getOwnPropertyDescriptor = __webpack_require__(110).f;
var hide = __webpack_require__(22);
var redefine = __webpack_require__(72);
var setGlobal = __webpack_require__(112);
var copyConstructorProperties = __webpack_require__(164);
var isForced = __webpack_require__(284);

/*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global;
  } else if (STATIC) {
    target = global[TARGET] || setGlobal(TARGET, {});
  } else {
    target = (global[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.noTargetGet) {
      descriptor = getOwnPropertyDescriptor(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty === typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      hide(sourceProperty, 'sham', true);
    }
    // extend global
    redefine(target, key, sourceProperty, options);
  }
};


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

var path = __webpack_require__(77);
var has = __webpack_require__(12);
var wrappedWellKnownSymbolModule = __webpack_require__(170);
var defineProperty = __webpack_require__(13).f;

module.exports = function (NAME) {
  var Symbol = path.Symbol || (path.Symbol = {});
  if (!has(Symbol, NAME)) defineProperty(Symbol, NAME, {
    value: wrappedWellKnownSymbolModule.f(NAME)
  });
};


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(4);
var shared = __webpack_require__(51);
var uid = __webpack_require__(113);
var NATIVE_SYMBOL = __webpack_require__(167);

var Symbol = global.Symbol;
var store = shared('wks');

module.exports = function (name) {
  return store[name] || (store[name] = NATIVE_SYMBOL && Symbol[name]
    || (NATIVE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {var O = 'object';
var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
module.exports =
  // eslint-disable-next-line no-undef
  check(typeof globalThis == O && globalThis) ||
  check(typeof window == O && window) ||
  check(typeof self == O && self) ||
  check(typeof global == O && global) ||
  // eslint-disable-next-line no-new-func
  Function('return this')();

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(42)))

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(30);

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.github.io/ecma262/#sec-tolength
module.exports = function (argument) {
  return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),
/* 6 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

var requireObjectCoercible = __webpack_require__(70);

// `ToObject` abstract operation
// https://tc39.github.io/ecma262/#sec-toobject
module.exports = function (argument) {
  return Object(requireObjectCoercible(argument));
};


/***/ }),
/* 8 */
/***/ (function(module, exports) {

function _extends() {
  module.exports = _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

module.exports = _extends;

/***/ }),
/* 9 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),
/* 10 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),
/* 11 */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};


/***/ }),
/* 12 */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;

module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(16);
var IE8_DOM_DEFINE = __webpack_require__(161);
var anObject = __webpack_require__(29);
var toPrimitive = __webpack_require__(71);

var nativeDefineProperty = Object.defineProperty;

// `Object.defineProperty` method
// https://tc39.github.io/ecma262/#sec-object.defineproperty
exports.f = DESCRIPTORS ? nativeDefineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return nativeDefineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var freeGlobal = __webpack_require__(206);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  CUSTOMER_ID_RE: true,
  CHARGE_ID_RE: true,
  PAYMENT_INTENT_ID_RE: true,
  PAYMENT_METHOD_RE: true,
  SUBSCRIPTION_RE: true,
  SUBSCRIPTION_PLAN_RE: true,
  BALTXN_ID_RE: true,
  INVOICE_ID_RE: true,
  REFUND_ID_RE: true,
  ORDER_ID_RE: true,
  SHIPPING_METHODS: true,
  INVENTORY_TYPE_FINITE: true,
  INVENTORY_TYPE_INFINITE: true,
  INFINITE_INVENTORY: true,
  MAX_TOTAL_ORDER_PRICE: true,
  MAX_PRODUCT_DIMENSION: true,
  PRICE_TEMPLATE_CURRENCY_SYMBOL: true,
  PRICE_TEMPLATE_AMOUNT: true,
  PRICE_TEMPLATE_CURRENCY_CODE: true,
  PRICE_TEMPLATE_OPTIONS: true,
  DEFAULT_PRICE_TEMPLATE_VALUE: true,
  CSV_CURRENCY_TEMPLATE: true,
  CSV_INTEGRATION_CURRENCY_TEMPLATE: true,
  DOWNLOAD_FILES_FAKE_DATA: true,
  DOWNLOAD_FILES_KEY_PATH: true,
  DOWNLOAD_FILES_EDITABLE_FIELDS: true,
  SUBSCRIPTION_INTERVAL_ENUM: true,
  SUBSCRIPTION_PLAN_STATUS_ENUM: true,
  SUBSCRIPTION_STATUS_ENUM: true,
  STRIPE_SUBSCRIPTION_STATUS_ENUM: true,
  ECOMMERCE_PROVIDER_NAME_ENUM: true,
  BILLING_METHOD_TYPES: true,
  PHYSICAL_PRODUCT_TYPE: true,
  DIGITAL_PRODUCT_TYPE: true,
  SERVICE_PRODUCT_TYPE: true,
  ADVANCED_PRODUCT_TYPE: true,
  TEMPLATE_PRODUCT_TYPES: true,
  DEFAULT_PRODUCT_TYPE_ID: true,
  DISCOUNTS_CSV_IMPORT_EXPORT_COLUMNS: true,
  REQUIRED_DISCOUNT_IMPORT_FIELDS: true
};
exports.REQUIRED_DISCOUNT_IMPORT_FIELDS = exports.DISCOUNTS_CSV_IMPORT_EXPORT_COLUMNS = exports.DEFAULT_PRODUCT_TYPE_ID = exports.TEMPLATE_PRODUCT_TYPES = exports.ADVANCED_PRODUCT_TYPE = exports.SERVICE_PRODUCT_TYPE = exports.DIGITAL_PRODUCT_TYPE = exports.PHYSICAL_PRODUCT_TYPE = exports.BILLING_METHOD_TYPES = exports.ECOMMERCE_PROVIDER_NAME_ENUM = exports.STRIPE_SUBSCRIPTION_STATUS_ENUM = exports.SUBSCRIPTION_STATUS_ENUM = exports.SUBSCRIPTION_PLAN_STATUS_ENUM = exports.SUBSCRIPTION_INTERVAL_ENUM = exports.DOWNLOAD_FILES_EDITABLE_FIELDS = exports.DOWNLOAD_FILES_KEY_PATH = exports.DOWNLOAD_FILES_FAKE_DATA = exports.CSV_INTEGRATION_CURRENCY_TEMPLATE = exports.CSV_CURRENCY_TEMPLATE = exports.DEFAULT_PRICE_TEMPLATE_VALUE = exports.PRICE_TEMPLATE_OPTIONS = exports.PRICE_TEMPLATE_CURRENCY_CODE = exports.PRICE_TEMPLATE_AMOUNT = exports.PRICE_TEMPLATE_CURRENCY_SYMBOL = exports.MAX_PRODUCT_DIMENSION = exports.MAX_TOTAL_ORDER_PRICE = exports.INFINITE_INVENTORY = exports.INVENTORY_TYPE_INFINITE = exports.INVENTORY_TYPE_FINITE = exports.SHIPPING_METHODS = exports.ORDER_ID_RE = exports.REFUND_ID_RE = exports.INVOICE_ID_RE = exports.BALTXN_ID_RE = exports.SUBSCRIPTION_PLAN_RE = exports.SUBSCRIPTION_RE = exports.PAYMENT_METHOD_RE = exports.PAYMENT_INTENT_ID_RE = exports.CHARGE_ID_RE = exports.CUSTOMER_ID_RE = void 0;

var _extends2 = _interopRequireDefault(__webpack_require__(8));

var _camelCase = _interopRequireDefault(__webpack_require__(450));

var _pluginConstants = __webpack_require__(468);

Object.keys(_pluginConstants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _pluginConstants[key];
    }
  });
}); // REGEXES

var CUSTOMER_ID_RE = /^cus_/i;
exports.CUSTOMER_ID_RE = CUSTOMER_ID_RE;
var CHARGE_ID_RE = /^ch_/i;
exports.CHARGE_ID_RE = CHARGE_ID_RE;
var PAYMENT_INTENT_ID_RE = /^pi_/i;
exports.PAYMENT_INTENT_ID_RE = PAYMENT_INTENT_ID_RE;
var PAYMENT_METHOD_RE = /^pm_/i;
exports.PAYMENT_METHOD_RE = PAYMENT_METHOD_RE;
var SUBSCRIPTION_RE = /^sub_/i;
exports.SUBSCRIPTION_RE = SUBSCRIPTION_RE;
var SUBSCRIPTION_PLAN_RE = /^plan_/i;
exports.SUBSCRIPTION_PLAN_RE = SUBSCRIPTION_PLAN_RE;
var BALTXN_ID_RE = /^txn_/i;
exports.BALTXN_ID_RE = BALTXN_ID_RE;
var INVOICE_ID_RE = /^in_/i;
exports.INVOICE_ID_RE = INVOICE_ID_RE;
var REFUND_ID_RE = /^re_/i;
exports.REFUND_ID_RE = REFUND_ID_RE;
var ORDER_ID_RE = /^[0-9a-f]{5,}$/; // @TODO - Once we extract the Commerce plugin to packages, move `pluginConstants` there.

exports.ORDER_ID_RE = ORDER_ID_RE;
var SHIPPING_METHOD_FLAT = 'flat-rate';
var SHIPPING_METHOD_PERCENTAGE = 'percentage';
var SHIPPING_METHOD_PRICE = 'price';
var SHIPPING_METHOD_QUANTITY = 'quantity';
var SHIPPING_METHOD_WEIGHT = 'weight';
var SHIPPING_METHODS = Object.freeze({
  FLAT: SHIPPING_METHOD_FLAT,
  PERCENTAGE: SHIPPING_METHOD_PERCENTAGE,
  PRICE: SHIPPING_METHOD_PRICE,
  QUANTITY: SHIPPING_METHOD_QUANTITY,
  WEIGHT: SHIPPING_METHOD_WEIGHT
});
exports.SHIPPING_METHODS = SHIPPING_METHODS;
var INVENTORY_TYPE_FINITE = 'finite';
exports.INVENTORY_TYPE_FINITE = INVENTORY_TYPE_FINITE;
var INVENTORY_TYPE_INFINITE = 'infinite';
exports.INVENTORY_TYPE_INFINITE = INVENTORY_TYPE_INFINITE;
var INFINITE_INVENTORY = {
  inventoryType: INVENTORY_TYPE_INFINITE,
  quantity: 0
}; // Stripe maximum charge. From stripe: The only limit to the maximum amount you can charge a customer
// is a technical one. The amount value supports up to eight digits (e.g., a value of 99999999 for a
// USD charge of $999,999.99).

exports.INFINITE_INVENTORY = INFINITE_INVENTORY;
var MAX_TOTAL_ORDER_PRICE = 99999999;
exports.MAX_TOTAL_ORDER_PRICE = MAX_TOTAL_ORDER_PRICE;
var MAX_PRODUCT_DIMENSION = 9000000000000000;
exports.MAX_PRODUCT_DIMENSION = MAX_PRODUCT_DIMENSION;

function _withDerivedValue(_ref) {
  var label = _ref.label,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'PlainText' : _ref$type,
      _ref$path = _ref.path,
      path = _ref$path === void 0 ? (0, _camelCase["default"])(label) : _ref$path,
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? {
    readOnly: false,
    isNotAddable: false
  } : _ref$options;
  return (0, _extends2["default"])({
    label: label,
    type: type
  }, Object.keys(options).reduce(function (acc, key) {
    // This is hacky because the EmbedTokenOptionType type is a Map<string, string | null> and
    // it will be a significant amount of work to refactor EmbedTokenOptionType to a more
    // appropriate type (like a plain object or even Record)
    // To get around this, boolean options are represented as true if they exist on the option and
    // false if they do not...
    var value = options[key];

    if (typeof value === 'boolean') {
      if (value) {
        acc[key] = 'true';
      }

      return acc;
    }

    acc[key] = value;
    return acc;
  }, {}), {
    value: JSON.stringify({
      path: path,
      type: type
    })
  });
}

var PRICE_TEMPLATE_CURRENCY_SYMBOL = _withDerivedValue({
  label: 'Currency symbol',
  path: 'symbol'
});

exports.PRICE_TEMPLATE_CURRENCY_SYMBOL = PRICE_TEMPLATE_CURRENCY_SYMBOL;

var PRICE_TEMPLATE_AMOUNT = _withDerivedValue({
  label: 'Amount',
  type: 'CommercePrice',
  options: {
    readOnly: true,
    isNotAddable: true
  }
});

exports.PRICE_TEMPLATE_AMOUNT = PRICE_TEMPLATE_AMOUNT;

var PRICE_TEMPLATE_CURRENCY_CODE = _withDerivedValue({
  label: 'Currency code'
});

exports.PRICE_TEMPLATE_CURRENCY_CODE = PRICE_TEMPLATE_CURRENCY_CODE;
var PRICE_TEMPLATE_OPTIONS = [PRICE_TEMPLATE_CURRENCY_SYMBOL, PRICE_TEMPLATE_AMOUNT, PRICE_TEMPLATE_CURRENCY_CODE];
exports.PRICE_TEMPLATE_OPTIONS = PRICE_TEMPLATE_OPTIONS;

var _intoToken = function _intoToken(option) {
  return "{{wf ".concat(option.value, " }}");
};

var DEFAULT_PRICE_TEMPLATE_VALUE = [_intoToken(PRICE_TEMPLATE_CURRENCY_SYMBOL), ' ', _intoToken(PRICE_TEMPLATE_AMOUNT), ' ', _intoToken(PRICE_TEMPLATE_CURRENCY_CODE)].join('');
exports.DEFAULT_PRICE_TEMPLATE_VALUE = DEFAULT_PRICE_TEMPLATE_VALUE;
var CSV_CURRENCY_TEMPLATE = [_intoToken(PRICE_TEMPLATE_CURRENCY_SYMBOL), _intoToken(PRICE_TEMPLATE_AMOUNT)].join('');
exports.CSV_CURRENCY_TEMPLATE = CSV_CURRENCY_TEMPLATE;
var CSV_INTEGRATION_CURRENCY_TEMPLATE = [_intoToken(PRICE_TEMPLATE_AMOUNT), ' ', _intoToken(PRICE_TEMPLATE_CURRENCY_CODE)].join('');
exports.CSV_INTEGRATION_CURRENCY_TEMPLATE = CSV_INTEGRATION_CURRENCY_TEMPLATE;
var DOWNLOAD_FILES_FAKE_DATA = [{
  id: '5d8fcb6d94dd1853060fb3b3',
  name: 'The modern web design process - Webflow Ebook.pdf',
  url: 'https://assets-global.website-files.com/5cf6b7202bf8199f50d43e6c/5e9dd8a680b972888929747b_The%20modern%20web%20design%20process%20-%20Webflow%20Ebook.pdf'
}, {
  id: '5d8fcb6d94dd1853060fb3b4',
  name: 'The freelance web designers guide - Webflow Ebook.pdf',
  url: 'https://assets-global.website-files.com/5cf6b7202bf8199f50d43e6c/5e9dd8e6abe52b33243a22cf_The%20freelance%20web%20designer%E2%80%99s%20guide%20-%20Webflow%20Ebook.pdf'
}];
exports.DOWNLOAD_FILES_FAKE_DATA = DOWNLOAD_FILES_FAKE_DATA;
var DOWNLOAD_FILES_KEY_PATH = 'download-files';
exports.DOWNLOAD_FILES_KEY_PATH = DOWNLOAD_FILES_KEY_PATH;
var DOWNLOAD_FILES_EDITABLE_FIELDS = {
  name: true,
  url: true
}; // Subscriptions ----------------------------------------------------

exports.DOWNLOAD_FILES_EDITABLE_FIELDS = DOWNLOAD_FILES_EDITABLE_FIELDS;
var SUBSCRIPTION_INTERVAL_ENUM = ['day', 'week', 'month', 'year'];
exports.SUBSCRIPTION_INTERVAL_ENUM = SUBSCRIPTION_INTERVAL_ENUM;
var SUBSCRIPTION_PLAN_STATUS_ENUM = ['active', 'inactive'];
exports.SUBSCRIPTION_PLAN_STATUS_ENUM = SUBSCRIPTION_PLAN_STATUS_ENUM;
var SUBSCRIPTION_STATUS_ENUM = {
  active: 'active',
  pastdue: 'pastdue',
  unpaid: 'unpaid',
  canceled: 'canceled',
  incomplete: 'incomplete',
  incompleteexpired: 'incompleteexpired',
  trialing: 'trialing',
  unknown: "unknown"
};
exports.SUBSCRIPTION_STATUS_ENUM = SUBSCRIPTION_STATUS_ENUM;
var STRIPE_SUBSCRIPTION_STATUS_ENUM = {
  active: 'active',
  past_due: 'past_due',
  unpaid: 'unpaid',
  canceled: 'canceled',
  incomplete: 'incomplete',
  incomplete_expired: 'incomplete_expired',
  trialing: 'trialing'
};
exports.STRIPE_SUBSCRIPTION_STATUS_ENUM = STRIPE_SUBSCRIPTION_STATUS_ENUM;
var ECOMMERCE_PROVIDER_NAME_ENUM = {
  stripe: 'stripe'
};
exports.ECOMMERCE_PROVIDER_NAME_ENUM = ECOMMERCE_PROVIDER_NAME_ENUM;
var BILLING_METHOD_TYPES = {
  subscription: 'subscription',
  oneTime: 'one-time'
}; // Product Types

exports.BILLING_METHOD_TYPES = BILLING_METHOD_TYPES;
var DEFAULT_PRODUCT_TYPE_PRODUCT_FIELDS = [{
  fieldSlug: 'name',
  required: true
}, {
  fieldSlug: 'slug',
  required: true
}, {
  fieldSlug: 'sku-properties',
  required: false
}, {
  fieldSlug: 'category',
  required: false
}, {
  fieldSlug: 'description',
  required: false
}, {
  fieldSlug: 'tax-category',
  required: false
}, {
  fieldSlug: 'default-sku',
  required: false
}, {
  fieldSlug: 'ec-product-type',
  required: false
}, {
  fieldSlug: 'options',
  required: false
}];
var DEFAULT_PRODUCT_TYPE_SKU_FIELDS = [{
  fieldSlug: 'sku-values',
  required: false
}, {
  fieldSlug: 'product',
  required: false
}, {
  fieldSlug: 'main-image',
  required: false
}, {
  fieldSlug: 'more-images',
  required: false
}, {
  fieldSlug: 'price',
  required: true
}, {
  fieldSlug: 'compare-at-price',
  required: false
}, {
  fieldSlug: 'ec-sku-subscription-plan',
  required: false
}, {
  fieldSlug: 'sku',
  required: false
}, {
  fieldSlug: 'ec-sku-billing-method',
  required: false
}, {
  fieldSlug: 'track-inventory',
  required: false
}, {
  fieldSlug: 'quantity',
  required: false
}];
var PHYSICAL_PRODUCT_TYPE = {
  name: 'Physical',
  id: 'ff42fee0113744f693a764e3431a9cc2',
  fields: {
    product: [].concat(DEFAULT_PRODUCT_TYPE_PRODUCT_FIELDS, [{
      fieldSlug: 'shippable',
      required: false
    }]),
    sku: [].concat(DEFAULT_PRODUCT_TYPE_SKU_FIELDS, [{
      fieldSlug: 'weight',
      required: false
    }, {
      fieldSlug: 'width',
      required: false
    }, {
      fieldSlug: 'height',
      required: false
    }, {
      fieldSlug: 'length',
      required: false
    }])
  }
};
exports.PHYSICAL_PRODUCT_TYPE = PHYSICAL_PRODUCT_TYPE;
var DIGITAL_PRODUCT_TYPE = {
  name: 'Digital',
  id: 'f22027db68002190aef89a4a2b7ac8a1',
  fields: {
    product: [].concat(DEFAULT_PRODUCT_TYPE_PRODUCT_FIELDS),
    sku: [].concat(DEFAULT_PRODUCT_TYPE_SKU_FIELDS, [{
      fieldSlug: 'include-downloads',
      required: false
    }, {
      fieldSlug: 'download-files',
      required: false
    }])
  }
};
exports.DIGITAL_PRODUCT_TYPE = DIGITAL_PRODUCT_TYPE;
var SERVICE_PRODUCT_TYPE = {
  name: 'Service',
  id: 'c599e43b1a1c34d5a323aedf75d3adf6',
  fields: {
    product: [].concat(DEFAULT_PRODUCT_TYPE_PRODUCT_FIELDS),
    sku: [].concat(DEFAULT_PRODUCT_TYPE_SKU_FIELDS)
  }
};
exports.SERVICE_PRODUCT_TYPE = SERVICE_PRODUCT_TYPE;
var ADVANCED_PRODUCT_TYPE = {
  name: 'Advanced',
  id: 'b6ccc1830db4b1babeb06a9ac5f6dd76'
};
exports.ADVANCED_PRODUCT_TYPE = ADVANCED_PRODUCT_TYPE;
var TEMPLATE_PRODUCT_TYPES = [PHYSICAL_PRODUCT_TYPE, DIGITAL_PRODUCT_TYPE, SERVICE_PRODUCT_TYPE, ADVANCED_PRODUCT_TYPE];
exports.TEMPLATE_PRODUCT_TYPES = TEMPLATE_PRODUCT_TYPES;
var DEFAULT_PRODUCT_TYPE_ID = PHYSICAL_PRODUCT_TYPE.id;
exports.DEFAULT_PRODUCT_TYPE_ID = DEFAULT_PRODUCT_TYPE_ID;
var DISCOUNTS_CSV_IMPORT_EXPORT_COLUMNS = ['name', 'code', 'notes', 'type', 'percentOff', 'amountOff', 'validOn', 'expiresOn', 'enabled', // 'active' is being replaced with 'enabled'
'orderMinimum', // archived is disabled until we have UI for it
// 'archived',
'totalUsage', 'maxAmountOff', // NOTE: for dot-notation fields to be properly expanded
// during import, you need to add the camel-case flattened property to
// the 'KEYS_TO_EXPAND' variable in `entrypoints/server/lib/ecommerce/csvImport/discountCsvImport.js`
// Example: 'usage.limit.total' -> 'usageLimitTotal'
'usage.limit.total', 'usage.limit.customer', 'appliesTo.scope', 'appliesTo.filter', 'appliesTo.applyOnce'];
exports.DISCOUNTS_CSV_IMPORT_EXPORT_COLUMNS = DISCOUNTS_CSV_IMPORT_EXPORT_COLUMNS;
var REQUIRED_DISCOUNT_IMPORT_FIELDS = ['name', 'code', 'type', ['percentOff', 'amountOff']];
exports.REQUIRED_DISCOUNT_IMPORT_FIELDS = REQUIRED_DISCOUNT_IMPORT_FIELDS;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(11);

// Thank's IE8 for his funny defineProperty
module.exports = !fails(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 17 */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

var wellKnownSymbol = __webpack_require__(3);
var create = __webpack_require__(118);
var hide = __webpack_require__(22);

var UNSCOPABLES = wellKnownSymbol('unscopables');
var ArrayPrototype = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype[UNSCOPABLES] == undefined) {
  hide(ArrayPrototype, UNSCOPABLES, create(null));
}

// add a key to Array.prototype[@@unscopables]
module.exports = function (key) {
  ArrayPrototype[UNSCOPABLES][key] = true;
};


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(64),
    getRawTag = __webpack_require__(413),
    objectToString = __webpack_require__(414);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault2 = __webpack_require__(0);

var _taggedTemplateLiteral2 = _interopRequireDefault2(__webpack_require__(38));

function _templateObject() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n  query FetchCartInfo {\n    database @client {\n      id\n      commerceOrder {\n        statusFlags {\n          requiresShipping\n          isFreeOrder\n        }\n      }\n    }\n  }\n"]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchOrderStatusFlags = exports.hideElement = exports.showElement = exports.isFreeOrder = exports.executeLoadingCallbacks = exports.addLoadingCallback = exports.setElementLoading = exports.customDataFormToArray = exports.formToObject = exports.removeConditionalVisibilityClass = exports.addConditionalVisibilityClass = exports.removeWDynBindEmptyClass = exports.isProtocolHttps = exports.isProductionLikeEnv = exports.triggerRender = exports.findClosestElementByClassName = exports.findClosestElementWithAttribute = exports.findClosestElementByNodeType = exports.findAllElementsByNodeType = exports.findElementByNodeType = exports.safeParseJson = void 0;

var _apolloClient = _interopRequireDefault(__webpack_require__(80));

var _graphqlTag = _interopRequireDefault(__webpack_require__(39));

var _constants = __webpack_require__(15);

var _constants2 = __webpack_require__(230);

var _constants3 = __webpack_require__(235);
/* globals document, window, CustomEvent */


var safeParseJson = function safeParseJson(jsonString) {
  var json = null;

  try {
    if (jsonString != null) {
      json = JSON.parse(decodeURIComponent(jsonString));
    }
  } catch (e) {
    if (!(e instanceof SyntaxError && e.message.match(/\bJSON\b/i))) {
      throw e;
    }
  } finally {
    return json;
  }
};

exports.safeParseJson = safeParseJson;

var findElementByNodeType = function findElementByNodeType(type) {
  var scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document;
  return scope.querySelector("[".concat(_constants.DATA_ATTR_NODE_TYPE, "=\"").concat(type, "\"]"));
};

exports.findElementByNodeType = findElementByNodeType;

var findAllElementsByNodeType = function findAllElementsByNodeType(type) {
  var scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document;
  return Array.from(scope.querySelectorAll("[".concat(_constants.DATA_ATTR_NODE_TYPE, "=\"").concat(type, "\"]")));
};

exports.findAllElementsByNodeType = findAllElementsByNodeType;

var findClosestElementByNodeType = function findClosestElementByNodeType(nodeType, element) {
  var target = element;

  while (target) {
    if (target instanceof Element && target.getAttribute(_constants.DATA_ATTR_NODE_TYPE) === nodeType) {
      return target;
    } else {
      target = target instanceof Element ? target.parentElement : null;
    }
  }

  return target;
};

exports.findClosestElementByNodeType = findClosestElementByNodeType;

var findClosestElementWithAttribute = function findClosestElementWithAttribute(dataAttribute, element) {
  var target = element;

  while (target) {
    if (target instanceof Element && target.hasAttribute(dataAttribute)) {
      return target;
    } else {
      target = target instanceof Element ? target.parentElement : null;
    }
  }

  return target;
};

exports.findClosestElementWithAttribute = findClosestElementWithAttribute;

var findClosestElementByClassName = function findClosestElementByClassName(className, element) {
  var target = element;

  while (target) {
    if (target instanceof Element && target.classList.contains(className)) {
      return target;
    } else {
      target = target instanceof Element ? target.parentElement : null;
    }
  }

  return target;
};

exports.findClosestElementByClassName = findClosestElementByClassName;

var triggerRender = function triggerRender( // FIXME: weak type is used
// eslint-disable-next-line flowtype/no-weak-types
error) {
  var isInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var renderEvent = new CustomEvent(_constants.RENDER_TREE_EVENT, {
    detail: {
      error: error,
      isInitial: isInitial
    }
  });
  window.dispatchEvent(renderEvent);
};

exports.triggerRender = triggerRender;

var isProductionLikeEnv = function isProductionLikeEnv() {
  return  true || false;
};

exports.isProductionLikeEnv = isProductionLikeEnv;

var isProtocolHttps = function isProtocolHttps() {
  return !isProductionLikeEnv() || window.location.protocol === 'https:';
};

exports.isProtocolHttps = isProtocolHttps;

var removeClass = function removeClass(node, className) {
  if (node.classList.contains(className)) {
    node.classList.remove(className);

    if (node.classList.length === 0) {
      node.removeAttribute('class');
    }
  }
};

var removeWDynBindEmptyClass = function removeWDynBindEmptyClass(node) {
  return removeClass(node, _constants2.CLASS_NAME_W_DYN_BIND_EMPTY);
};

exports.removeWDynBindEmptyClass = removeWDynBindEmptyClass;

var addConditionalVisibilityClass = function addConditionalVisibilityClass(node) {
  node.classList.add(_constants3.CONDITION_INVISIBLE_CLASS);
};

exports.addConditionalVisibilityClass = addConditionalVisibilityClass;

var removeConditionalVisibilityClass = function removeConditionalVisibilityClass(node) {
  return removeClass(node, _constants3.CONDITION_INVISIBLE_CLASS);
}; // because microsoft edge doesn't support FormData.prototype.get, we are implementing our own
// partial version of it, for our specific purposes. this function follows FormData's spec, and will
// only return values from elements in a form with a `name` set. unlike FormData returning its own
// Map-like object, we just return a POJO. because that's all we need. thank you edge for this journey :)
// `toString` is used for our address data generation, as we want the values to be trimmed strings


exports.removeConditionalVisibilityClass = removeConditionalVisibilityClass;

var formToObject = function formToObject(form, toString) {
  var values = {};
  Array.from(form.elements).forEach(function (element) {
    var name = element.getAttribute('name');

    if (name && name !== '') {
      var value = toString ? String(element.value).trim() : element.value;
      values[name] = value == null || value === '' ? null : value;
    }
  });
  return values;
};

exports.formToObject = formToObject;

var customDataFormToArray = function customDataFormToArray(form) {
  var customData = [];

  if (!form || !(form instanceof HTMLFormElement)) {
    return customData;
  }

  Array.from(form.elements).forEach(function (element) {
    var name = element.getAttribute('name');

    if (element instanceof HTMLTextAreaElement && element.value) {
      customData.push({
        name: name ? name : 'Textarea',
        textArea: element.value
      });
    } else if (element instanceof HTMLInputElement) {
      if (element.type === 'checkbox') {
        customData.push({
          name: name ? name : 'Checkbox',
          checkbox: element.checked
        });
      } else if (element.value) {
        customData.push({
          name: name ? name : 'Text Input',
          textInput: element.value
        });
      }
    }
  });
  return customData;
};

exports.customDataFormToArray = customDataFormToArray;

var setElementLoading = function setElementLoading(el) {
  var tr = window.Webflow.tram(el);
  tr.set({
    opacity: 0.2
  });
  tr.add('opacity 500ms ease-in-out');

  var animate = function animate() {
    tr.start({
      opacity: 0.2
    }).then({
      opacity: 0.4
    }).then(animate);
  };

  animate();
  return function () {
    return tr.destroy();
  };
};

exports.setElementLoading = setElementLoading;
var loadingCallbacks = [];

var addLoadingCallback = function addLoadingCallback(cb) {
  loadingCallbacks.push(cb);
};

exports.addLoadingCallback = addLoadingCallback;

var executeLoadingCallbacks = function executeLoadingCallbacks() {
  var finishLoading;

  while ((finishLoading = loadingCallbacks.shift()) !== undefined) {
    finishLoading();
  }
};

exports.executeLoadingCallbacks = executeLoadingCallbacks;

var isFreeOrder = function isFreeOrder(response) {
  return response && response.data && response.data.database && response.data.database.commerceOrder && response.data.database.commerceOrder.statusFlags && response.data.database.commerceOrder.statusFlags.isFreeOrder === true;
};

exports.isFreeOrder = isFreeOrder;

var showElement = function showElement(element) {
  return element.style.removeProperty('display');
};

exports.showElement = showElement;

var hideElement = function hideElement(element) {
  return element.style.setProperty('display', 'none');
}; // the @client directive ensures we only fetch this from the local cache so that we don't wait on network
// we can only use this safely inside a rendered cart/checkout/confirmation container
// as to render that view, a query had to be made which *always* includes the flags listed below.
// if you are adding new flags to this, please ensure that the flags are *always* included
// for all types of commerce elements in `packages/systems/dynamo/utils/DynamoQuery/DynamoQuery.js`


exports.hideElement = hideElement;

var orderStatusFlagsQuery = _graphqlTag["default"](_templateObject());

var fetchOrderStatusFlags = function fetchOrderStatusFlags(apolloClient) {
  return apolloClient.query({
    query: orderStatusFlagsQuery
  }).then(function (data) {
    return data && data.data && data.data.database && data.data.database.commerceOrder && data.data.database.commerceOrder.statusFlags;
  });
};

exports.fetchOrderStatusFlags = fetchOrderStatusFlags;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

// toObject with fallback for non-array-like ES3 strings
var IndexedObject = __webpack_require__(69);
var requireObjectCoercible = __webpack_require__(70);

module.exports = function (it) {
  return IndexedObject(requireObjectCoercible(it));
};


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(16);
var definePropertyModule = __webpack_require__(13);
var createPropertyDescriptor = __webpack_require__(50);

module.exports = DESCRIPTORS ? function (object, key, value) {
  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var fails = __webpack_require__(11);

module.exports = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !method || !fails(function () {
    // eslint-disable-next-line no-useless-call,no-throw-literal
    method.call(null, argument || function () { throw 1; }, 1);
  });
};


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
 // @wf-will-never-add-flow-to-this-file

/* globals window, document, navigator, WEBFLOW_ENV_TEST */

/* eslint-disable no-var */

/**
 * Webflow: Core site library
 */

var Webflow = {};
var modules = {};
var primary = [];
var secondary = window.Webflow || [];
var $ = window.jQuery;
var $win = $(window);
var $doc = $(document);
var isFunction = $.isFunction;

var _ = Webflow._ = __webpack_require__(272);

var tram = Webflow.tram = __webpack_require__(158) && $.tram;
var domready = false;
var destroyed = false;
tram.config.hideBackface = false;
tram.config.keepInherited = true;
/**
 * Webflow.define - Define a named module
 * @param  {string} name
 * @param  {function} factory
 * @param  {object} options
 * @return {object}
 */

Webflow.define = function (name, factory, options) {
  if (modules[name]) {
    unbindModule(modules[name]);
  }

  var instance = modules[name] = factory($, _, options) || {};
  bindModule(instance);
  return instance;
};
/**
 * Webflow.require - Require a named module
 * @param  {string} name
 * @return {object}
 */


Webflow.require = function (name) {
  return modules[name];
};

function bindModule(module) {
  // If running in Webflow app, subscribe to design/preview events
  if (Webflow.env()) {
    isFunction(module.design) && $win.on('__wf_design', module.design);
    isFunction(module.preview) && $win.on('__wf_preview', module.preview);
  } // Subscribe to front-end destroy event


  isFunction(module.destroy) && $win.on('__wf_destroy', module.destroy); // Look for ready method on module

  if (module.ready && isFunction(module.ready)) {
    addReady(module);
  }
}

function addReady(module) {
  // If domready has already happened, run ready method
  if (domready) {
    module.ready();
    return;
  } // Otherwise add ready method to the primary queue (only once)


  if (_.contains(primary, module.ready)) {
    return;
  }

  primary.push(module.ready);
}

function unbindModule(module) {
  // Unsubscribe module from window events
  isFunction(module.design) && $win.off('__wf_design', module.design);
  isFunction(module.preview) && $win.off('__wf_preview', module.preview);
  isFunction(module.destroy) && $win.off('__wf_destroy', module.destroy); // Remove ready method from primary queue

  if (module.ready && isFunction(module.ready)) {
    removeReady(module);
  }
}

function removeReady(module) {
  primary = _.filter(primary, function (readyFn) {
    return readyFn !== module.ready;
  });
}
/**
 * Webflow.push - Add a ready handler into secondary queue
 * @param {function} ready  Callback to invoke on domready
 */


Webflow.push = function (ready) {
  // If domready has already happened, invoke handler
  if (domready) {
    isFunction(ready) && ready();
    return;
  } // Otherwise push into secondary queue


  secondary.push(ready);
};
/**
 * Webflow.env - Get the state of the Webflow app
 * @param {string} mode [optional]
 * @return {boolean}
 */


Webflow.env = function (mode) {
  var designFlag = window.__wf_design;
  var inApp = typeof designFlag !== 'undefined';

  if (!mode) {
    return inApp;
  }

  if (mode === 'design') {
    return inApp && designFlag;
  }

  if (mode === 'preview') {
    return inApp && !designFlag;
  }

  if (mode === 'slug') {
    return inApp && window.__wf_slug;
  }

  if (mode === 'editor') {
    return window.WebflowEditor;
  }

  if (mode === 'test') {
    return  false || window.__wf_test;
  }

  if (mode === 'frame') {
    return window !== window.top;
  }
}; // Feature detects + browser sniffs  ಠ_ಠ


var userAgent = navigator.userAgent.toLowerCase();
var touch = Webflow.env.touch = 'ontouchstart' in window || window.DocumentTouch && document instanceof window.DocumentTouch;
var chrome = Webflow.env.chrome = /chrome/.test(userAgent) && /Google/.test(navigator.vendor) && parseInt(userAgent.match(/chrome\/(\d+)\./)[1], 10);
var ios = Webflow.env.ios = /(ipod|iphone|ipad)/.test(userAgent);
Webflow.env.safari = /safari/.test(userAgent) && !chrome && !ios; // Maintain current touch target to prevent late clicks on touch devices

var touchTarget; // Listen for both events to support touch/mouse hybrid devices

touch && $doc.on('touchstart mousedown', function (evt) {
  touchTarget = evt.target;
});
/**
 * Webflow.validClick - validate click target against current touch target
 * @param  {HTMLElement} clickTarget  Element being clicked
 * @return {Boolean}  True if click target is valid (always true on non-touch)
 */

Webflow.validClick = touch ? function (clickTarget) {
  return clickTarget === touchTarget || $.contains(clickTarget, touchTarget);
} : function () {
  return true;
};
/**
 * Webflow.resize, Webflow.scroll - throttled event proxies
 */

var resizeEvents = 'resize.webflow orientationchange.webflow load.webflow';
var scrollEvents = 'scroll.webflow ' + resizeEvents;
Webflow.resize = eventProxy($win, resizeEvents);
Webflow.scroll = eventProxy($win, scrollEvents);
Webflow.redraw = eventProxy(); // Create a proxy instance for throttled events

function eventProxy(target, types) {
  // Set up throttled method (using custom frame-based _.throttle)
  var handlers = [];
  var proxy = {};
  proxy.up = _.throttle(function (evt) {
    _.each(handlers, function (h) {
      h(evt);
    });
  }); // Bind events to target

  if (target && types) {
    target.on(types, proxy.up);
  }
  /**
   * Add an event handler
   * @param  {function} handler
   */


  proxy.on = function (handler) {
    if (typeof handler !== 'function') {
      return;
    }

    if (_.contains(handlers, handler)) {
      return;
    }

    handlers.push(handler);
  };
  /**
   * Remove an event handler
   * @param  {function} handler
   */


  proxy.off = function (handler) {
    // If no arguments supplied, clear all handlers
    if (!arguments.length) {
      handlers = [];
      return;
    } // Otherwise, remove handler from the list


    handlers = _.filter(handlers, function (h) {
      return h !== handler;
    });
  };

  return proxy;
} // Webflow.location - Wrap window.location in api


Webflow.location = function (url) {
  window.location = url;
};

if (Webflow.env()) {
  // Ignore redirects inside a Webflow design/edit environment
  Webflow.location = function () {};
} // Webflow.ready - Call primary and secondary handlers


Webflow.ready = function () {
  domready = true; // Restore modules after destroy

  if (destroyed) {
    restoreModules(); // Otherwise run primary ready methods
  } else {
    _.each(primary, callReady);
  } // Run secondary ready methods


  _.each(secondary, callReady); // Trigger resize


  Webflow.resize.up();
};

function callReady(readyFn) {
  isFunction(readyFn) && readyFn();
}

function restoreModules() {
  destroyed = false;

  _.each(modules, bindModule);
}
/**
 * Webflow.load - Add a window load handler that will run even if load event has already happened
 * @param  {function} handler
 */


var deferLoad;

Webflow.load = function (handler) {
  deferLoad.then(handler);
};

function bindLoad() {
  // Reject any previous deferred (to support destroy)
  if (deferLoad) {
    deferLoad.reject();
    $win.off('load', deferLoad.resolve);
  } // Create deferred and bind window load event


  deferLoad = new $.Deferred();
  $win.on('load', deferLoad.resolve);
} // Webflow.destroy - Trigger a destroy event for all modules


Webflow.destroy = function (options) {
  options = options || {};
  destroyed = true;
  $win.triggerHandler('__wf_destroy'); // Allow domready reset for tests

  if (options.domready != null) {
    domready = options.domready;
  } // Unbind modules


  _.each(modules, unbindModule); // Clear any proxy event handlers


  Webflow.resize.off();
  Webflow.scroll.off();
  Webflow.redraw.off(); // Clear any queued ready methods

  primary = [];
  secondary = []; // If load event has not yet fired, replace the deferred

  if (deferLoad.state() === 'pending') {
    bindLoad();
  }
}; // Listen for domready


$(Webflow.ready); // Listen for window.onload and resolve deferred

bindLoad(); // Export commonjs module

module.exports = window.Webflow = Webflow;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

var bind = __webpack_require__(78);
var IndexedObject = __webpack_require__(69);
var toObject = __webpack_require__(7);
var toLength = __webpack_require__(5);
var arraySpeciesCreate = __webpack_require__(54);

var push = [].push;

// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex }` methods implementation
var createMethod = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject($this);
    var self = IndexedObject(O);
    var boundFunction = bind(callbackfn, that, 3);
    var length = toLength(self.length);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate;
    var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3: return true;              // some
          case 5: return value;             // find
          case 6: return index;             // findIndex
          case 2: push.call(target, value); // filter
        } else if (IS_EVERY) return false;  // every
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

module.exports = {
  // `Array.prototype.forEach` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
  forEach: createMethod(0),
  // `Array.prototype.map` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.map
  map: createMethod(1),
  // `Array.prototype.filter` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.filter
  filter: createMethod(2),
  // `Array.prototype.some` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.some
  some: createMethod(3),
  // `Array.prototype.every` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.every
  every: createMethod(4),
  // `Array.prototype.find` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.find
  find: createMethod(5),
  // `Array.prototype.findIndex` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod(6)
};


/***/ }),
/* 26 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 27 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(185);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "empty", function() { return _link__WEBPACK_IMPORTED_MODULE_0__["empty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "from", function() { return _link__WEBPACK_IMPORTED_MODULE_0__["from"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "split", function() { return _link__WEBPACK_IMPORTED_MODULE_0__["split"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "concat", function() { return _link__WEBPACK_IMPORTED_MODULE_0__["concat"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ApolloLink", function() { return _link__WEBPACK_IMPORTED_MODULE_0__["ApolloLink"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "execute", function() { return _link__WEBPACK_IMPORTED_MODULE_0__["execute"]; });

/* harmony import */ var _linkUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createOperation", function() { return _linkUtils__WEBPACK_IMPORTED_MODULE_1__["createOperation"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "makePromise", function() { return _linkUtils__WEBPACK_IMPORTED_MODULE_1__["makePromise"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toPromise", function() { return _linkUtils__WEBPACK_IMPORTED_MODULE_1__["toPromise"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "fromPromise", function() { return _linkUtils__WEBPACK_IMPORTED_MODULE_1__["fromPromise"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "fromError", function() { return _linkUtils__WEBPACK_IMPORTED_MODULE_1__["fromError"]; });

/* harmony import */ var zen_observable_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Observable", function() { return zen_observable_ts__WEBPACK_IMPORTED_MODULE_2__["default"]; });







/***/ }),
/* 28 */
/***/ (function(module, exports) {

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

module.exports = _classCallCheck;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(17);

module.exports = function (it) {
  if (!isObject(it)) {
    throw TypeError(String(it) + ' is not an object');
  } return it;
};


/***/ }),
/* 30 */
/***/ (function(module, exports) {

var ceil = Math.ceil;
var floor = Math.floor;

// `ToInteger` abstract operation
// https://tc39.github.io/ecma262/#sec-tointeger
module.exports = function (argument) {
  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
};


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

var classof = __webpack_require__(111);

// `IsArray` abstract operation
// https://tc39.github.io/ecma262/#sec-isarray
module.exports = Array.isArray || function isArray(arg) {
  return classof(arg) == 'Array';
};


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.print = print;

var _visitor = __webpack_require__(81);

/**
 * Converts an AST into a string, using one set of reasonable
 * formatting rules.
 */
function print(ast) {
  return (0, _visitor.visit)(ast, { leave: printDocASTReducer });
} /**
   * Copyright (c) 2015-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

var printDocASTReducer = {
  Name: function Name(node) {
    return node.value;
  },
  Variable: function Variable(node) {
    return '$' + node.name;
  },

  // Document

  Document: function Document(node) {
    return join(node.definitions, '\n\n') + '\n';
  },

  OperationDefinition: function OperationDefinition(node) {
    var op = node.operation;
    var name = node.name;
    var varDefs = wrap('(', join(node.variableDefinitions, ', '), ')');
    var directives = join(node.directives, ' ');
    var selectionSet = node.selectionSet;
    // Anonymous queries with no directives or variable definitions can use
    // the query short form.
    return !name && !directives && !varDefs && op === 'query' ? selectionSet : join([op, join([name, varDefs]), directives, selectionSet], ' ');
  },


  VariableDefinition: function VariableDefinition(_ref) {
    var variable = _ref.variable,
        type = _ref.type,
        defaultValue = _ref.defaultValue;
    return variable + ': ' + type + wrap(' = ', defaultValue);
  },

  SelectionSet: function SelectionSet(_ref2) {
    var selections = _ref2.selections;
    return block(selections);
  },

  Field: function Field(_ref3) {
    var alias = _ref3.alias,
        name = _ref3.name,
        args = _ref3.arguments,
        directives = _ref3.directives,
        selectionSet = _ref3.selectionSet;
    return join([wrap('', alias, ': ') + name + wrap('(', join(args, ', '), ')'), join(directives, ' '), selectionSet], ' ');
  },

  Argument: function Argument(_ref4) {
    var name = _ref4.name,
        value = _ref4.value;
    return name + ': ' + value;
  },

  // Fragments

  FragmentSpread: function FragmentSpread(_ref5) {
    var name = _ref5.name,
        directives = _ref5.directives;
    return '...' + name + wrap(' ', join(directives, ' '));
  },

  InlineFragment: function InlineFragment(_ref6) {
    var typeCondition = _ref6.typeCondition,
        directives = _ref6.directives,
        selectionSet = _ref6.selectionSet;
    return join(['...', wrap('on ', typeCondition), join(directives, ' '), selectionSet], ' ');
  },

  FragmentDefinition: function FragmentDefinition(_ref7) {
    var name = _ref7.name,
        typeCondition = _ref7.typeCondition,
        variableDefinitions = _ref7.variableDefinitions,
        directives = _ref7.directives,
        selectionSet = _ref7.selectionSet;
    return (
      // Note: fragment variable definitions are experimental and may be changed
      // or removed in the future.
      'fragment ' + name + wrap('(', join(variableDefinitions, ', '), ')') + ' ' + ('on ' + typeCondition + ' ' + wrap('', join(directives, ' '), ' ')) + selectionSet
    );
  },

  // Value

  IntValue: function IntValue(_ref8) {
    var value = _ref8.value;
    return value;
  },
  FloatValue: function FloatValue(_ref9) {
    var value = _ref9.value;
    return value;
  },
  StringValue: function StringValue(_ref10, key) {
    var value = _ref10.value,
        isBlockString = _ref10.block;
    return isBlockString ? printBlockString(value, key === 'description') : JSON.stringify(value);
  },
  BooleanValue: function BooleanValue(_ref11) {
    var value = _ref11.value;
    return value ? 'true' : 'false';
  },
  NullValue: function NullValue() {
    return 'null';
  },
  EnumValue: function EnumValue(_ref12) {
    var value = _ref12.value;
    return value;
  },
  ListValue: function ListValue(_ref13) {
    var values = _ref13.values;
    return '[' + join(values, ', ') + ']';
  },
  ObjectValue: function ObjectValue(_ref14) {
    var fields = _ref14.fields;
    return '{' + join(fields, ', ') + '}';
  },
  ObjectField: function ObjectField(_ref15) {
    var name = _ref15.name,
        value = _ref15.value;
    return name + ': ' + value;
  },

  // Directive

  Directive: function Directive(_ref16) {
    var name = _ref16.name,
        args = _ref16.arguments;
    return '@' + name + wrap('(', join(args, ', '), ')');
  },

  // Type

  NamedType: function NamedType(_ref17) {
    var name = _ref17.name;
    return name;
  },
  ListType: function ListType(_ref18) {
    var type = _ref18.type;
    return '[' + type + ']';
  },
  NonNullType: function NonNullType(_ref19) {
    var type = _ref19.type;
    return type + '!';
  },

  // Type System Definitions

  SchemaDefinition: function SchemaDefinition(_ref20) {
    var directives = _ref20.directives,
        operationTypes = _ref20.operationTypes;
    return join(['schema', join(directives, ' '), block(operationTypes)], ' ');
  },

  OperationTypeDefinition: function OperationTypeDefinition(_ref21) {
    var operation = _ref21.operation,
        type = _ref21.type;
    return operation + ': ' + type;
  },

  ScalarTypeDefinition: addDescription(function (_ref22) {
    var name = _ref22.name,
        directives = _ref22.directives;
    return join(['scalar', name, join(directives, ' ')], ' ');
  }),

  ObjectTypeDefinition: addDescription(function (_ref23) {
    var name = _ref23.name,
        interfaces = _ref23.interfaces,
        directives = _ref23.directives,
        fields = _ref23.fields;
    return join(['type', name, wrap('implements ', join(interfaces, ' & ')), join(directives, ' '), block(fields)], ' ');
  }),

  FieldDefinition: addDescription(function (_ref24) {
    var name = _ref24.name,
        args = _ref24.arguments,
        type = _ref24.type,
        directives = _ref24.directives;
    return name + wrap('(', join(args, ', '), ')') + ': ' + type + wrap(' ', join(directives, ' '));
  }),

  InputValueDefinition: addDescription(function (_ref25) {
    var name = _ref25.name,
        type = _ref25.type,
        defaultValue = _ref25.defaultValue,
        directives = _ref25.directives;
    return join([name + ': ' + type, wrap('= ', defaultValue), join(directives, ' ')], ' ');
  }),

  InterfaceTypeDefinition: addDescription(function (_ref26) {
    var name = _ref26.name,
        directives = _ref26.directives,
        fields = _ref26.fields;
    return join(['interface', name, join(directives, ' '), block(fields)], ' ');
  }),

  UnionTypeDefinition: addDescription(function (_ref27) {
    var name = _ref27.name,
        directives = _ref27.directives,
        types = _ref27.types;
    return join(['union', name, join(directives, ' '), types && types.length !== 0 ? '= ' + join(types, ' | ') : ''], ' ');
  }),

  EnumTypeDefinition: addDescription(function (_ref28) {
    var name = _ref28.name,
        directives = _ref28.directives,
        values = _ref28.values;
    return join(['enum', name, join(directives, ' '), block(values)], ' ');
  }),

  EnumValueDefinition: addDescription(function (_ref29) {
    var name = _ref29.name,
        directives = _ref29.directives;
    return join([name, join(directives, ' ')], ' ');
  }),

  InputObjectTypeDefinition: addDescription(function (_ref30) {
    var name = _ref30.name,
        directives = _ref30.directives,
        fields = _ref30.fields;
    return join(['input', name, join(directives, ' '), block(fields)], ' ');
  }),

  ScalarTypeExtension: function ScalarTypeExtension(_ref31) {
    var name = _ref31.name,
        directives = _ref31.directives;
    return join(['extend scalar', name, join(directives, ' ')], ' ');
  },

  ObjectTypeExtension: function ObjectTypeExtension(_ref32) {
    var name = _ref32.name,
        interfaces = _ref32.interfaces,
        directives = _ref32.directives,
        fields = _ref32.fields;
    return join(['extend type', name, wrap('implements ', join(interfaces, ' & ')), join(directives, ' '), block(fields)], ' ');
  },

  InterfaceTypeExtension: function InterfaceTypeExtension(_ref33) {
    var name = _ref33.name,
        directives = _ref33.directives,
        fields = _ref33.fields;
    return join(['extend interface', name, join(directives, ' '), block(fields)], ' ');
  },

  UnionTypeExtension: function UnionTypeExtension(_ref34) {
    var name = _ref34.name,
        directives = _ref34.directives,
        types = _ref34.types;
    return join(['extend union', name, join(directives, ' '), types && types.length !== 0 ? '= ' + join(types, ' | ') : ''], ' ');
  },

  EnumTypeExtension: function EnumTypeExtension(_ref35) {
    var name = _ref35.name,
        directives = _ref35.directives,
        values = _ref35.values;
    return join(['extend enum', name, join(directives, ' '), block(values)], ' ');
  },

  InputObjectTypeExtension: function InputObjectTypeExtension(_ref36) {
    var name = _ref36.name,
        directives = _ref36.directives,
        fields = _ref36.fields;
    return join(['extend input', name, join(directives, ' '), block(fields)], ' ');
  },

  DirectiveDefinition: addDescription(function (_ref37) {
    var name = _ref37.name,
        args = _ref37.arguments,
        locations = _ref37.locations;
    return 'directive @' + name + wrap('(', join(args, ', '), ')') + ' on ' + join(locations, ' | ');
  })
};

function addDescription(cb) {
  return function (node) {
    return join([node.description, cb(node)], '\n');
  };
}

/**
 * Given maybeArray, print an empty string if it is null or empty, otherwise
 * print all items together separated by separator if provided
 */
function join(maybeArray, separator) {
  return maybeArray ? maybeArray.filter(function (x) {
    return x;
  }).join(separator || '') : '';
}

/**
 * Given array, print each item on its own line, wrapped in an
 * indented "{ }" block.
 */
function block(array) {
  return array && array.length !== 0 ? '{\n' + indent(join(array, '\n')) + '\n}' : '';
}

/**
 * If maybeString is not null or empty, then wrap with start and end, otherwise
 * print an empty string.
 */
function wrap(start, maybeString, end) {
  return maybeString ? start + maybeString + (end || '') : '';
}

function indent(maybeString) {
  return maybeString && '  ' + maybeString.replace(/\n/g, '\n  ');
}

/**
 * Print a block string in the indented block form by adding a leading and
 * trailing blank line. However, if a block string starts with whitespace and is
 * a single-line, adding a leading blank line would strip that whitespace.
 */
function printBlockString(value, isDescription) {
  var escaped = value.replace(/"""/g, '\\"""');
  return (value[0] === ' ' || value[0] === '\t') && value.indexOf('\n') === -1 ? '"""' + escaped.replace(/"$/, '"\n') + '"""' : '"""\n' + (isDescription ? escaped : indent(escaped)) + '\n"""';
}

/***/ }),
/* 33 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _directives__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(176);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDirectiveInfoFromField", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["getDirectiveInfoFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "shouldInclude", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["shouldInclude"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "flattenSelections", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["flattenSelections"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDirectiveNames", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["getDirectiveNames"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "hasDirectives", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["hasDirectives"]; });

/* harmony import */ var _fragments__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(177);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFragmentQueryDocument", function() { return _fragments__WEBPACK_IMPORTED_MODULE_1__["getFragmentQueryDocument"]; });

/* harmony import */ var _getFromAST__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(120);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMutationDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getMutationDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "checkDocument", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["checkDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getOperationDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinitionOrDie", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getOperationDefinitionOrDie"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getOperationName", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getOperationName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinitions", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getFragmentDefinitions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getQueryDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getQueryDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getFragmentDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMainDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getMainDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createFragmentMap", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["createFragmentMap"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDefaultValues", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getDefaultValues"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "variablesInOperation", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["variablesInOperation"]; });

/* harmony import */ var _transform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(178);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "removeDirectivesFromDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["removeDirectivesFromDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addTypenameToDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["addTypenameToDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "removeConnectionDirectiveFromDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["removeConnectionDirectiveFromDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDirectivesFromDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["getDirectivesFromDocument"]; });

/* harmony import */ var _storeUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isScalarValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isScalarValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isNumberValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isNumberValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "valueToObjectRepresentation", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["valueToObjectRepresentation"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "storeKeyNameFromField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["storeKeyNameFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getStoreKeyName", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["getStoreKeyName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "argumentsObjectFromField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["argumentsObjectFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "resultKeyNameFromField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["resultKeyNameFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isInlineFragment", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isInlineFragment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isIdValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isIdValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toIdValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["toIdValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isJsonValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isJsonValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "valueFromNode", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["valueFromNode"]; });

/* harmony import */ var _util_assign__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(121);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return _util_assign__WEBPACK_IMPORTED_MODULE_5__["assign"]; });

/* harmony import */ var _util_cloneDeep__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(122);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "cloneDeep", function() { return _util_cloneDeep__WEBPACK_IMPORTED_MODULE_6__["cloneDeep"]; });

/* harmony import */ var _util_environment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(85);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getEnv", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["getEnv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isEnv", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isEnv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isProduction", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isProduction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isDevelopment", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isDevelopment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isTest", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isTest"]; });

/* harmony import */ var _util_errorHandling__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(179);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "tryFunctionOrLogError", function() { return _util_errorHandling__WEBPACK_IMPORTED_MODULE_8__["tryFunctionOrLogError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "graphQLResultHasError", function() { return _util_errorHandling__WEBPACK_IMPORTED_MODULE_8__["graphQLResultHasError"]; });

/* harmony import */ var _util_isEqual__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(180);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isEqual", function() { return _util_isEqual__WEBPACK_IMPORTED_MODULE_9__["isEqual"]; });

/* harmony import */ var _util_maybeDeepFreeze__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(181);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "maybeDeepFreeze", function() { return _util_maybeDeepFreeze__WEBPACK_IMPORTED_MODULE_10__["maybeDeepFreeze"]; });

/* harmony import */ var _util_warnOnce__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(182);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "warnOnceInDevelopment", function() { return _util_warnOnce__WEBPACK_IMPORTED_MODULE_11__["warnOnceInDevelopment"]; });

/* harmony import */ var _util_stripSymbols__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(183);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stripSymbols", function() { return _util_stripSymbols__WEBPACK_IMPORTED_MODULE_12__["stripSymbols"]; });
















/***/ }),
/* 34 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "validateOperation", function() { return validateOperation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LinkError", function() { return LinkError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isTerminating", function() { return isTerminating; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toPromise", function() { return toPromise; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "makePromise", function() { return makePromise; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fromPromise", function() { return fromPromise; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fromError", function() { return fromError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "transformOperation", function() { return transformOperation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createOperation", function() { return createOperation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getKey", function() { return getKey; });
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33);
/* harmony import */ var zen_observable_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86);
/* harmony import */ var graphql_language_printer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/* harmony import */ var graphql_language_printer__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(graphql_language_printer__WEBPACK_IMPORTED_MODULE_2__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};



function validateOperation(operation) {
    var OPERATION_FIELDS = [
        'query',
        'operationName',
        'variables',
        'extensions',
        'context',
    ];
    for (var _i = 0, _a = Object.keys(operation); _i < _a.length; _i++) {
        var key = _a[_i];
        if (OPERATION_FIELDS.indexOf(key) < 0) {
            throw new Error("illegal argument: " + key);
        }
    }
    return operation;
}
var LinkError = /** @class */ (function (_super) {
    __extends(LinkError, _super);
    function LinkError(message, link) {
        var _this = _super.call(this, message) || this;
        _this.link = link;
        return _this;
    }
    return LinkError;
}(Error));

function isTerminating(link) {
    return link.request.length <= 1;
}
function toPromise(observable) {
    var completed = false;
    return new Promise(function (resolve, reject) {
        observable.subscribe({
            next: function (data) {
                if (completed) {
                    console.warn("Promise Wrapper does not support multiple results from Observable");
                }
                else {
                    completed = true;
                    resolve(data);
                }
            },
            error: reject,
        });
    });
}
// backwards compat
var makePromise = toPromise;
function fromPromise(promise) {
    return new zen_observable_ts__WEBPACK_IMPORTED_MODULE_1__["default"](function (observer) {
        promise
            .then(function (value) {
            observer.next(value);
            observer.complete();
        })
            .catch(observer.error.bind(observer));
    });
}
function fromError(errorValue) {
    return new zen_observable_ts__WEBPACK_IMPORTED_MODULE_1__["default"](function (observer) {
        observer.error(errorValue);
    });
}
function transformOperation(operation) {
    var transformedOperation = {
        variables: operation.variables || {},
        extensions: operation.extensions || {},
        operationName: operation.operationName,
        query: operation.query,
    };
    // best guess at an operation name
    if (!transformedOperation.operationName) {
        transformedOperation.operationName =
            typeof transformedOperation.query !== 'string'
                ? Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getOperationName"])(transformedOperation.query)
                : '';
    }
    return transformedOperation;
}
function createOperation(starting, operation) {
    var context = __assign({}, starting);
    var setContext = function (next) {
        if (typeof next === 'function') {
            context = __assign({}, context, next(context));
        }
        else {
            context = __assign({}, context, next);
        }
    };
    var getContext = function () { return (__assign({}, context)); };
    Object.defineProperty(operation, 'setContext', {
        enumerable: false,
        value: setContext,
    });
    Object.defineProperty(operation, 'getContext', {
        enumerable: false,
        value: getContext,
    });
    Object.defineProperty(operation, 'toKey', {
        enumerable: false,
        value: function () { return getKey(operation); },
    });
    return operation;
}
function getKey(operation) {
    // XXX we're assuming here that variables will be serialized in the same order.
    // that might not always be true
    return Object(graphql_language_printer__WEBPACK_IMPORTED_MODULE_2__["print"])(operation.query) + "|" + JSON.stringify(operation.variables) + "|" + operation.operationName;
}


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault2 = __webpack_require__(0);

var _toConsumableArray2 = _interopRequireDefault2(__webpack_require__(92));

var _classCallCheck2 = _interopRequireDefault2(__webpack_require__(28));

var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(__webpack_require__(44));

var _extends2 = _interopRequireDefault(__webpack_require__(8));

var _stripeStore = __webpack_require__(62);

var enumeratePrototypeProps = function enumeratePrototypeProps(obj) {
  var propNames = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  if (obj == null) {
    return propNames;
  }

  return propNames.concat(enumeratePrototypeProps(Object.getPrototypeOf(obj))).concat(Object.keys(obj));
};

var createEventProxy = function createEventProxy(event, currentTarget) {
  var propertyDefinitions = enumeratePrototypeProps(event).filter(function (propName) {
    return propName !== 'currentTarget';
  }).reduce(function (proxies, propName) {
    proxies[propName] = // $FlowFixMe Object.keys is "unsound", always infers `string` as output
    typeof event[propName] === 'function' ? // Proxy all the event methods so they will act on the original event:
    // $FlowFixMe Object.keys is "unsound", always infers `string` as output
    {
      value: function value() {
        return event[propName].apply(event, arguments);
      }
    } : // Proxy static props/getters because invoking them directly may result in "Illegal invokation" error.
    // $FlowFixMe Object.keys is "unsound", always infers `string` as output
    {
      get: function get() {
        return event[propName];
      }
    };
    return proxies;
  }, {});
  var retargetedEvent = Object.create(event, (0, _extends2["default"])({
    // set currentTarget to the matched node:
    currentTarget: {
      value: currentTarget
    }
  }, propertyDefinitions));
  return retargetedEvent;
};

var EventHandlerProxyWithApolloClient = // FIXME: weak type is used
// eslint-disable-next-line flowtype/no-weak-types
function EventHandlerProxyWithApolloClient(apolloClient, stripeStore) {
  var _this = this;

  (0, _classCallCheck2["default"])(this, EventHandlerProxyWithApolloClient);
  (0, _defineProperty2["default"])(this, "on", function (eventName, eventMatcher, handler) {
    var existingHandlers = _this.eventHandlers[eventName] instanceof Array ? _this.eventHandlers[eventName] : [];
    _this.eventHandlers[eventName] = [].concat((0, _toConsumableArray2["default"])(existingHandlers), [_this.createHandlerProxy(eventName, eventMatcher, handler)]);
    return _this;
  });
  (0, _defineProperty2["default"])(this, "createHandlerProxy", function (eventName, eventMatcher, handler) {
    return function (event) {
      var match = eventMatcher(event);
      var eventProxy = match instanceof Element ? createEventProxy(event, match) : event;

      if (match) {
        handler(eventProxy, _this.apolloClient, _this.stripeStore);
      }
    };
  });
  (0, _defineProperty2["default"])(this, "attachHandlers", function (target) {
    Object.keys(_this.eventHandlers).forEach(function (eventName) {
      var handlerProxies = _this.eventHandlers[eventName];
      handlerProxies.forEach(function (handlerProxy) {
        return target.addEventListener(eventName, handlerProxy, true);
      });
    });
    return _this;
  });
  (0, _defineProperty2["default"])(this, "removeHandlers", function (target) {
    Object.keys(_this.eventHandlers).forEach(function (eventName) {
      var handlerProxies = _this.eventHandlers[eventName];
      handlerProxies.forEach(function (handlerProxy) {
        return target.removeEventListener(eventName, handlerProxy, true);
      });
    });
    return _this;
  });
  this.eventHandlers = {};
  this.apolloClient = apolloClient;
  this.stripeStore = stripeStore;
};

exports["default"] = EventHandlerProxyWithApolloClient;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsNative = __webpack_require__(412),
    getValue = __webpack_require__(417);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

var baseToString = __webpack_require__(452);

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

module.exports = toString;


/***/ }),
/* 38 */
/***/ (function(module, exports) {

function _taggedTemplateLiteral(strings, raw) {
  if (!raw) {
    raw = strings.slice(0);
  }

  return Object.freeze(Object.defineProperties(strings, {
    raw: {
      value: Object.freeze(raw)
    }
  }));
}

module.exports = _taggedTemplateLiteral;

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

var parser = __webpack_require__(470);

var parse = parser.parse;

// Strip insignificant whitespace
// Note that this could do a lot more, such as reorder fields etc.
function normalize(string) {
  return string.replace(/[\s,]+/g, ' ').trim();
}

// A map docString -> graphql document
var docCache = {};

// A map fragmentName -> [normalized source]
var fragmentSourceMap = {};

function cacheKeyFromLoc(loc) {
  return normalize(loc.source.body.substring(loc.start, loc.end));
}

// For testing.
function resetCaches() {
  docCache = {};
  fragmentSourceMap = {};
}

// Take a unstripped parsed document (query/mutation or even fragment), and
// check all fragment definitions, checking for name->source uniqueness.
// We also want to make sure only unique fragments exist in the document.
var printFragmentWarnings = true;
function processFragments(ast) {
  var astFragmentMap = {};
  var definitions = [];

  for (var i = 0; i < ast.definitions.length; i++) {
    var fragmentDefinition = ast.definitions[i];

    if (fragmentDefinition.kind === 'FragmentDefinition') {
      var fragmentName = fragmentDefinition.name.value;
      var sourceKey = cacheKeyFromLoc(fragmentDefinition.loc);

      // We know something about this fragment
      if (fragmentSourceMap.hasOwnProperty(fragmentName) && !fragmentSourceMap[fragmentName][sourceKey]) {

        // this is a problem because the app developer is trying to register another fragment with
        // the same name as one previously registered. So, we tell them about it.
        if (printFragmentWarnings) {
          console.warn("Warning: fragment with name " + fragmentName + " already exists.\n"
            + "graphql-tag enforces all fragment names across your application to be unique; read more about\n"
            + "this in the docs: http://dev.apollodata.com/core/fragments.html#unique-names");
        }

        fragmentSourceMap[fragmentName][sourceKey] = true;

      } else if (!fragmentSourceMap.hasOwnProperty(fragmentName)) {
        fragmentSourceMap[fragmentName] = {};
        fragmentSourceMap[fragmentName][sourceKey] = true;
      }

      if (!astFragmentMap[sourceKey]) {
        astFragmentMap[sourceKey] = true;
        definitions.push(fragmentDefinition);
      }
    } else {
      definitions.push(fragmentDefinition);
    }
  }

  ast.definitions = definitions;
  return ast;
}

function disableFragmentWarnings() {
  printFragmentWarnings = false;
}

function stripLoc(doc, removeLocAtThisLevel) {
  var docType = Object.prototype.toString.call(doc);

  if (docType === '[object Array]') {
    return doc.map(function (d) {
      return stripLoc(d, removeLocAtThisLevel);
    });
  }

  if (docType !== '[object Object]') {
    throw new Error('Unexpected input.');
  }

  // We don't want to remove the root loc field so we can use it
  // for fragment substitution (see below)
  if (removeLocAtThisLevel && doc.loc) {
    delete doc.loc;
  }

  // https://github.com/apollographql/graphql-tag/issues/40
  if (doc.loc) {
    delete doc.loc.startToken;
    delete doc.loc.endToken;
  }

  var keys = Object.keys(doc);
  var key;
  var value;
  var valueType;

  for (key in keys) {
    if (keys.hasOwnProperty(key)) {
      value = doc[keys[key]];
      valueType = Object.prototype.toString.call(value);

      if (valueType === '[object Object]' || valueType === '[object Array]') {
        doc[keys[key]] = stripLoc(value, true);
      }
    }
  }

  return doc;
}

var experimentalFragmentVariables = false;
function parseDocument(doc) {
  var cacheKey = normalize(doc);

  if (docCache[cacheKey]) {
    return docCache[cacheKey];
  }

  var parsed = parse(doc, { experimentalFragmentVariables: experimentalFragmentVariables });
  if (!parsed || parsed.kind !== 'Document') {
    throw new Error('Not a valid GraphQL document.');
  }

  // check that all "new" fragments inside the documents are consistent with
  // existing fragments of the same name
  parsed = processFragments(parsed);
  parsed = stripLoc(parsed, false);
  docCache[cacheKey] = parsed;

  return parsed;
}

function enableExperimentalFragmentVariables() {
  experimentalFragmentVariables = true;
}

function disableExperimentalFragmentVariables() {
  experimentalFragmentVariables = false;
}

// XXX This should eventually disallow arbitrary string interpolation, like Relay does
function gql(/* arguments */) {
  var args = Array.prototype.slice.call(arguments);

  var literals = args[0];

  // We always get literals[0] and then matching post literals for each arg given
  var result = (typeof(literals) === "string") ? literals : literals[0];

  for (var i = 1; i < args.length; i++) {
    if (args[i] && args[i].kind && args[i].kind === 'Document') {
      result += args[i].loc.source.body;
    } else {
      result += args[i];
    }

    result += literals[i];
  }

  return parseDocument(result);
}

// Support typescript, which isn't as nice as Babel about default exports
gql.default = gql;
gql.resetCaches = resetCaches;
gql.disableFragmentWarnings = disableFragmentWarnings;
gql.enableExperimentalFragmentVariables = enableExperimentalFragmentVariables;
gql.disableExperimentalFragmentVariables = disableExperimentalFragmentVariables;

module.exports = gql;


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(220),
    baseKeys = __webpack_require__(486),
    isArrayLike = __webpack_require__(46);

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

module.exports = keys;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var require;//! moment.js

;(function (global, factory) {
     true ? module.exports = factory() :
    undefined
}(this, (function () { 'use strict';

    var hookCallback;

    function hooks () {
        return hookCallback.apply(null, arguments);
    }

    // This is done to register the method called with moment()
    // without creating circular dependencies.
    function setHookCallback (callback) {
        hookCallback = callback;
    }

    function isArray(input) {
        return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
    }

    function isObject(input) {
        // IE8 will treat undefined and null as object if it wasn't for
        // input != null
        return input != null && Object.prototype.toString.call(input) === '[object Object]';
    }

    function isObjectEmpty(obj) {
        if (Object.getOwnPropertyNames) {
            return (Object.getOwnPropertyNames(obj).length === 0);
        } else {
            var k;
            for (k in obj) {
                if (obj.hasOwnProperty(k)) {
                    return false;
                }
            }
            return true;
        }
    }

    function isUndefined(input) {
        return input === void 0;
    }

    function isNumber(input) {
        return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
    }

    function isDate(input) {
        return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
    }

    function map(arr, fn) {
        var res = [], i;
        for (i = 0; i < arr.length; ++i) {
            res.push(fn(arr[i], i));
        }
        return res;
    }

    function hasOwnProp(a, b) {
        return Object.prototype.hasOwnProperty.call(a, b);
    }

    function extend(a, b) {
        for (var i in b) {
            if (hasOwnProp(b, i)) {
                a[i] = b[i];
            }
        }

        if (hasOwnProp(b, 'toString')) {
            a.toString = b.toString;
        }

        if (hasOwnProp(b, 'valueOf')) {
            a.valueOf = b.valueOf;
        }

        return a;
    }

    function createUTC (input, format, locale, strict) {
        return createLocalOrUTC(input, format, locale, strict, true).utc();
    }

    function defaultParsingFlags() {
        // We need to deep clone this object.
        return {
            empty           : false,
            unusedTokens    : [],
            unusedInput     : [],
            overflow        : -2,
            charsLeftOver   : 0,
            nullInput       : false,
            invalidMonth    : null,
            invalidFormat   : false,
            userInvalidated : false,
            iso             : false,
            parsedDateParts : [],
            meridiem        : null,
            rfc2822         : false,
            weekdayMismatch : false
        };
    }

    function getParsingFlags(m) {
        if (m._pf == null) {
            m._pf = defaultParsingFlags();
        }
        return m._pf;
    }

    var some;
    if (Array.prototype.some) {
        some = Array.prototype.some;
    } else {
        some = function (fun) {
            var t = Object(this);
            var len = t.length >>> 0;

            for (var i = 0; i < len; i++) {
                if (i in t && fun.call(this, t[i], i, t)) {
                    return true;
                }
            }

            return false;
        };
    }

    function isValid(m) {
        if (m._isValid == null) {
            var flags = getParsingFlags(m);
            var parsedParts = some.call(flags.parsedDateParts, function (i) {
                return i != null;
            });
            var isNowValid = !isNaN(m._d.getTime()) &&
                flags.overflow < 0 &&
                !flags.empty &&
                !flags.invalidMonth &&
                !flags.invalidWeekday &&
                !flags.weekdayMismatch &&
                !flags.nullInput &&
                !flags.invalidFormat &&
                !flags.userInvalidated &&
                (!flags.meridiem || (flags.meridiem && parsedParts));

            if (m._strict) {
                isNowValid = isNowValid &&
                    flags.charsLeftOver === 0 &&
                    flags.unusedTokens.length === 0 &&
                    flags.bigHour === undefined;
            }

            if (Object.isFrozen == null || !Object.isFrozen(m)) {
                m._isValid = isNowValid;
            }
            else {
                return isNowValid;
            }
        }
        return m._isValid;
    }

    function createInvalid (flags) {
        var m = createUTC(NaN);
        if (flags != null) {
            extend(getParsingFlags(m), flags);
        }
        else {
            getParsingFlags(m).userInvalidated = true;
        }

        return m;
    }

    // Plugins that add properties should also add the key here (null value),
    // so we can properly clone ourselves.
    var momentProperties = hooks.momentProperties = [];

    function copyConfig(to, from) {
        var i, prop, val;

        if (!isUndefined(from._isAMomentObject)) {
            to._isAMomentObject = from._isAMomentObject;
        }
        if (!isUndefined(from._i)) {
            to._i = from._i;
        }
        if (!isUndefined(from._f)) {
            to._f = from._f;
        }
        if (!isUndefined(from._l)) {
            to._l = from._l;
        }
        if (!isUndefined(from._strict)) {
            to._strict = from._strict;
        }
        if (!isUndefined(from._tzm)) {
            to._tzm = from._tzm;
        }
        if (!isUndefined(from._isUTC)) {
            to._isUTC = from._isUTC;
        }
        if (!isUndefined(from._offset)) {
            to._offset = from._offset;
        }
        if (!isUndefined(from._pf)) {
            to._pf = getParsingFlags(from);
        }
        if (!isUndefined(from._locale)) {
            to._locale = from._locale;
        }

        if (momentProperties.length > 0) {
            for (i = 0; i < momentProperties.length; i++) {
                prop = momentProperties[i];
                val = from[prop];
                if (!isUndefined(val)) {
                    to[prop] = val;
                }
            }
        }

        return to;
    }

    var updateInProgress = false;

    // Moment prototype object
    function Moment(config) {
        copyConfig(this, config);
        this._d = new Date(config._d != null ? config._d.getTime() : NaN);
        if (!this.isValid()) {
            this._d = new Date(NaN);
        }
        // Prevent infinite loop in case updateOffset creates new moment
        // objects.
        if (updateInProgress === false) {
            updateInProgress = true;
            hooks.updateOffset(this);
            updateInProgress = false;
        }
    }

    function isMoment (obj) {
        return obj instanceof Moment || (obj != null && obj._isAMomentObject != null);
    }

    function absFloor (number) {
        if (number < 0) {
            // -0 -> 0
            return Math.ceil(number) || 0;
        } else {
            return Math.floor(number);
        }
    }

    function toInt(argumentForCoercion) {
        var coercedNumber = +argumentForCoercion,
            value = 0;

        if (coercedNumber !== 0 && isFinite(coercedNumber)) {
            value = absFloor(coercedNumber);
        }

        return value;
    }

    // compare two arrays, return the number of differences
    function compareArrays(array1, array2, dontConvert) {
        var len = Math.min(array1.length, array2.length),
            lengthDiff = Math.abs(array1.length - array2.length),
            diffs = 0,
            i;
        for (i = 0; i < len; i++) {
            if ((dontConvert && array1[i] !== array2[i]) ||
                (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))) {
                diffs++;
            }
        }
        return diffs + lengthDiff;
    }

    function warn(msg) {
        if (hooks.suppressDeprecationWarnings === false &&
                (typeof console !==  'undefined') && console.warn) {
            console.warn('Deprecation warning: ' + msg);
        }
    }

    function deprecate(msg, fn) {
        var firstTime = true;

        return extend(function () {
            if (hooks.deprecationHandler != null) {
                hooks.deprecationHandler(null, msg);
            }
            if (firstTime) {
                var args = [];
                var arg;
                for (var i = 0; i < arguments.length; i++) {
                    arg = '';
                    if (typeof arguments[i] === 'object') {
                        arg += '\n[' + i + '] ';
                        for (var key in arguments[0]) {
                            arg += key + ': ' + arguments[0][key] + ', ';
                        }
                        arg = arg.slice(0, -2); // Remove trailing comma and space
                    } else {
                        arg = arguments[i];
                    }
                    args.push(arg);
                }
                warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + (new Error()).stack);
                firstTime = false;
            }
            return fn.apply(this, arguments);
        }, fn);
    }

    var deprecations = {};

    function deprecateSimple(name, msg) {
        if (hooks.deprecationHandler != null) {
            hooks.deprecationHandler(name, msg);
        }
        if (!deprecations[name]) {
            warn(msg);
            deprecations[name] = true;
        }
    }

    hooks.suppressDeprecationWarnings = false;
    hooks.deprecationHandler = null;

    function isFunction(input) {
        return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
    }

    function set (config) {
        var prop, i;
        for (i in config) {
            prop = config[i];
            if (isFunction(prop)) {
                this[i] = prop;
            } else {
                this['_' + i] = prop;
            }
        }
        this._config = config;
        // Lenient ordinal parsing accepts just a number in addition to
        // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
        // TODO: Remove "ordinalParse" fallback in next major release.
        this._dayOfMonthOrdinalParseLenient = new RegExp(
            (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) +
                '|' + (/\d{1,2}/).source);
    }

    function mergeConfigs(parentConfig, childConfig) {
        var res = extend({}, parentConfig), prop;
        for (prop in childConfig) {
            if (hasOwnProp(childConfig, prop)) {
                if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
                    res[prop] = {};
                    extend(res[prop], parentConfig[prop]);
                    extend(res[prop], childConfig[prop]);
                } else if (childConfig[prop] != null) {
                    res[prop] = childConfig[prop];
                } else {
                    delete res[prop];
                }
            }
        }
        for (prop in parentConfig) {
            if (hasOwnProp(parentConfig, prop) &&
                    !hasOwnProp(childConfig, prop) &&
                    isObject(parentConfig[prop])) {
                // make sure changes to properties don't modify parent config
                res[prop] = extend({}, res[prop]);
            }
        }
        return res;
    }

    function Locale(config) {
        if (config != null) {
            this.set(config);
        }
    }

    var keys;

    if (Object.keys) {
        keys = Object.keys;
    } else {
        keys = function (obj) {
            var i, res = [];
            for (i in obj) {
                if (hasOwnProp(obj, i)) {
                    res.push(i);
                }
            }
            return res;
        };
    }

    var defaultCalendar = {
        sameDay : '[Today at] LT',
        nextDay : '[Tomorrow at] LT',
        nextWeek : 'dddd [at] LT',
        lastDay : '[Yesterday at] LT',
        lastWeek : '[Last] dddd [at] LT',
        sameElse : 'L'
    };

    function calendar (key, mom, now) {
        var output = this._calendar[key] || this._calendar['sameElse'];
        return isFunction(output) ? output.call(mom, now) : output;
    }

    var defaultLongDateFormat = {
        LTS  : 'h:mm:ss A',
        LT   : 'h:mm A',
        L    : 'MM/DD/YYYY',
        LL   : 'MMMM D, YYYY',
        LLL  : 'MMMM D, YYYY h:mm A',
        LLLL : 'dddd, MMMM D, YYYY h:mm A'
    };

    function longDateFormat (key) {
        var format = this._longDateFormat[key],
            formatUpper = this._longDateFormat[key.toUpperCase()];

        if (format || !formatUpper) {
            return format;
        }

        this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {
            return val.slice(1);
        });

        return this._longDateFormat[key];
    }

    var defaultInvalidDate = 'Invalid date';

    function invalidDate () {
        return this._invalidDate;
    }

    var defaultOrdinal = '%d';
    var defaultDayOfMonthOrdinalParse = /\d{1,2}/;

    function ordinal (number) {
        return this._ordinal.replace('%d', number);
    }

    var defaultRelativeTime = {
        future : 'in %s',
        past   : '%s ago',
        s  : 'a few seconds',
        ss : '%d seconds',
        m  : 'a minute',
        mm : '%d minutes',
        h  : 'an hour',
        hh : '%d hours',
        d  : 'a day',
        dd : '%d days',
        M  : 'a month',
        MM : '%d months',
        y  : 'a year',
        yy : '%d years'
    };

    function relativeTime (number, withoutSuffix, string, isFuture) {
        var output = this._relativeTime[string];
        return (isFunction(output)) ?
            output(number, withoutSuffix, string, isFuture) :
            output.replace(/%d/i, number);
    }

    function pastFuture (diff, output) {
        var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
        return isFunction(format) ? format(output) : format.replace(/%s/i, output);
    }

    var aliases = {};

    function addUnitAlias (unit, shorthand) {
        var lowerCase = unit.toLowerCase();
        aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
    }

    function normalizeUnits(units) {
        return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
    }

    function normalizeObjectUnits(inputObject) {
        var normalizedInput = {},
            normalizedProp,
            prop;

        for (prop in inputObject) {
            if (hasOwnProp(inputObject, prop)) {
                normalizedProp = normalizeUnits(prop);
                if (normalizedProp) {
                    normalizedInput[normalizedProp] = inputObject[prop];
                }
            }
        }

        return normalizedInput;
    }

    var priorities = {};

    function addUnitPriority(unit, priority) {
        priorities[unit] = priority;
    }

    function getPrioritizedUnits(unitsObj) {
        var units = [];
        for (var u in unitsObj) {
            units.push({unit: u, priority: priorities[u]});
        }
        units.sort(function (a, b) {
            return a.priority - b.priority;
        });
        return units;
    }

    function zeroFill(number, targetLength, forceSign) {
        var absNumber = '' + Math.abs(number),
            zerosToFill = targetLength - absNumber.length,
            sign = number >= 0;
        return (sign ? (forceSign ? '+' : '') : '-') +
            Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
    }

    var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;

    var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;

    var formatFunctions = {};

    var formatTokenFunctions = {};

    // token:    'M'
    // padded:   ['MM', 2]
    // ordinal:  'Mo'
    // callback: function () { this.month() + 1 }
    function addFormatToken (token, padded, ordinal, callback) {
        var func = callback;
        if (typeof callback === 'string') {
            func = function () {
                return this[callback]();
            };
        }
        if (token) {
            formatTokenFunctions[token] = func;
        }
        if (padded) {
            formatTokenFunctions[padded[0]] = function () {
                return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
            };
        }
        if (ordinal) {
            formatTokenFunctions[ordinal] = function () {
                return this.localeData().ordinal(func.apply(this, arguments), token);
            };
        }
    }

    function removeFormattingTokens(input) {
        if (input.match(/\[[\s\S]/)) {
            return input.replace(/^\[|\]$/g, '');
        }
        return input.replace(/\\/g, '');
    }

    function makeFormatFunction(format) {
        var array = format.match(formattingTokens), i, length;

        for (i = 0, length = array.length; i < length; i++) {
            if (formatTokenFunctions[array[i]]) {
                array[i] = formatTokenFunctions[array[i]];
            } else {
                array[i] = removeFormattingTokens(array[i]);
            }
        }

        return function (mom) {
            var output = '', i;
            for (i = 0; i < length; i++) {
                output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];
            }
            return output;
        };
    }

    // format date using native date object
    function formatMoment(m, format) {
        if (!m.isValid()) {
            return m.localeData().invalidDate();
        }

        format = expandFormat(format, m.localeData());
        formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);

        return formatFunctions[format](m);
    }

    function expandFormat(format, locale) {
        var i = 5;

        function replaceLongDateFormatTokens(input) {
            return locale.longDateFormat(input) || input;
        }

        localFormattingTokens.lastIndex = 0;
        while (i >= 0 && localFormattingTokens.test(format)) {
            format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
            localFormattingTokens.lastIndex = 0;
            i -= 1;
        }

        return format;
    }

    var match1         = /\d/;            //       0 - 9
    var match2         = /\d\d/;          //      00 - 99
    var match3         = /\d{3}/;         //     000 - 999
    var match4         = /\d{4}/;         //    0000 - 9999
    var match6         = /[+-]?\d{6}/;    // -999999 - 999999
    var match1to2      = /\d\d?/;         //       0 - 99
    var match3to4      = /\d\d\d\d?/;     //     999 - 9999
    var match5to6      = /\d\d\d\d\d\d?/; //   99999 - 999999
    var match1to3      = /\d{1,3}/;       //       0 - 999
    var match1to4      = /\d{1,4}/;       //       0 - 9999
    var match1to6      = /[+-]?\d{1,6}/;  // -999999 - 999999

    var matchUnsigned  = /\d+/;           //       0 - inf
    var matchSigned    = /[+-]?\d+/;      //    -inf - inf

    var matchOffset    = /Z|[+-]\d\d:?\d\d/gi; // +00:00 -00:00 +0000 -0000 or Z
    var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z

    var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/; // 123456789 123456789.123

    // any word (or two) characters or numbers including two/three word month in arabic.
    // includes scottish gaelic two word and hyphenated months
    var matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;

    var regexes = {};

    function addRegexToken (token, regex, strictRegex) {
        regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
            return (isStrict && strictRegex) ? strictRegex : regex;
        };
    }

    function getParseRegexForToken (token, config) {
        if (!hasOwnProp(regexes, token)) {
            return new RegExp(unescapeFormat(token));
        }

        return regexes[token](config._strict, config._locale);
    }

    // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
    function unescapeFormat(s) {
        return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
            return p1 || p2 || p3 || p4;
        }));
    }

    function regexEscape(s) {
        return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
    }

    var tokens = {};

    function addParseToken (token, callback) {
        var i, func = callback;
        if (typeof token === 'string') {
            token = [token];
        }
        if (isNumber(callback)) {
            func = function (input, array) {
                array[callback] = toInt(input);
            };
        }
        for (i = 0; i < token.length; i++) {
            tokens[token[i]] = func;
        }
    }

    function addWeekParseToken (token, callback) {
        addParseToken(token, function (input, array, config, token) {
            config._w = config._w || {};
            callback(input, config._w, config, token);
        });
    }

    function addTimeToArrayFromToken(token, input, config) {
        if (input != null && hasOwnProp(tokens, token)) {
            tokens[token](input, config._a, config, token);
        }
    }

    var YEAR = 0;
    var MONTH = 1;
    var DATE = 2;
    var HOUR = 3;
    var MINUTE = 4;
    var SECOND = 5;
    var MILLISECOND = 6;
    var WEEK = 7;
    var WEEKDAY = 8;

    // FORMATTING

    addFormatToken('Y', 0, 0, function () {
        var y = this.year();
        return y <= 9999 ? '' + y : '+' + y;
    });

    addFormatToken(0, ['YY', 2], 0, function () {
        return this.year() % 100;
    });

    addFormatToken(0, ['YYYY',   4],       0, 'year');
    addFormatToken(0, ['YYYYY',  5],       0, 'year');
    addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');

    // ALIASES

    addUnitAlias('year', 'y');

    // PRIORITIES

    addUnitPriority('year', 1);

    // PARSING

    addRegexToken('Y',      matchSigned);
    addRegexToken('YY',     match1to2, match2);
    addRegexToken('YYYY',   match1to4, match4);
    addRegexToken('YYYYY',  match1to6, match6);
    addRegexToken('YYYYYY', match1to6, match6);

    addParseToken(['YYYYY', 'YYYYYY'], YEAR);
    addParseToken('YYYY', function (input, array) {
        array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
    });
    addParseToken('YY', function (input, array) {
        array[YEAR] = hooks.parseTwoDigitYear(input);
    });
    addParseToken('Y', function (input, array) {
        array[YEAR] = parseInt(input, 10);
    });

    // HELPERS

    function daysInYear(year) {
        return isLeapYear(year) ? 366 : 365;
    }

    function isLeapYear(year) {
        return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
    }

    // HOOKS

    hooks.parseTwoDigitYear = function (input) {
        return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
    };

    // MOMENTS

    var getSetYear = makeGetSet('FullYear', true);

    function getIsLeapYear () {
        return isLeapYear(this.year());
    }

    function makeGetSet (unit, keepTime) {
        return function (value) {
            if (value != null) {
                set$1(this, unit, value);
                hooks.updateOffset(this, keepTime);
                return this;
            } else {
                return get(this, unit);
            }
        };
    }

    function get (mom, unit) {
        return mom.isValid() ?
            mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
    }

    function set$1 (mom, unit, value) {
        if (mom.isValid() && !isNaN(value)) {
            if (unit === 'FullYear' && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
                mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value, mom.month(), daysInMonth(value, mom.month()));
            }
            else {
                mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
            }
        }
    }

    // MOMENTS

    function stringGet (units) {
        units = normalizeUnits(units);
        if (isFunction(this[units])) {
            return this[units]();
        }
        return this;
    }


    function stringSet (units, value) {
        if (typeof units === 'object') {
            units = normalizeObjectUnits(units);
            var prioritized = getPrioritizedUnits(units);
            for (var i = 0; i < prioritized.length; i++) {
                this[prioritized[i].unit](units[prioritized[i].unit]);
            }
        } else {
            units = normalizeUnits(units);
            if (isFunction(this[units])) {
                return this[units](value);
            }
        }
        return this;
    }

    function mod(n, x) {
        return ((n % x) + x) % x;
    }

    var indexOf;

    if (Array.prototype.indexOf) {
        indexOf = Array.prototype.indexOf;
    } else {
        indexOf = function (o) {
            // I know
            var i;
            for (i = 0; i < this.length; ++i) {
                if (this[i] === o) {
                    return i;
                }
            }
            return -1;
        };
    }

    function daysInMonth(year, month) {
        if (isNaN(year) || isNaN(month)) {
            return NaN;
        }
        var modMonth = mod(month, 12);
        year += (month - modMonth) / 12;
        return modMonth === 1 ? (isLeapYear(year) ? 29 : 28) : (31 - modMonth % 7 % 2);
    }

    // FORMATTING

    addFormatToken('M', ['MM', 2], 'Mo', function () {
        return this.month() + 1;
    });

    addFormatToken('MMM', 0, 0, function (format) {
        return this.localeData().monthsShort(this, format);
    });

    addFormatToken('MMMM', 0, 0, function (format) {
        return this.localeData().months(this, format);
    });

    // ALIASES

    addUnitAlias('month', 'M');

    // PRIORITY

    addUnitPriority('month', 8);

    // PARSING

    addRegexToken('M',    match1to2);
    addRegexToken('MM',   match1to2, match2);
    addRegexToken('MMM',  function (isStrict, locale) {
        return locale.monthsShortRegex(isStrict);
    });
    addRegexToken('MMMM', function (isStrict, locale) {
        return locale.monthsRegex(isStrict);
    });

    addParseToken(['M', 'MM'], function (input, array) {
        array[MONTH] = toInt(input) - 1;
    });

    addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
        var month = config._locale.monthsParse(input, token, config._strict);
        // if we didn't find a month name, mark the date as invalid.
        if (month != null) {
            array[MONTH] = month;
        } else {
            getParsingFlags(config).invalidMonth = input;
        }
    });

    // LOCALES

    var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;
    var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');
    function localeMonths (m, format) {
        if (!m) {
            return isArray(this._months) ? this._months :
                this._months['standalone'];
        }
        return isArray(this._months) ? this._months[m.month()] :
            this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
    }

    var defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');
    function localeMonthsShort (m, format) {
        if (!m) {
            return isArray(this._monthsShort) ? this._monthsShort :
                this._monthsShort['standalone'];
        }
        return isArray(this._monthsShort) ? this._monthsShort[m.month()] :
            this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
    }

    function handleStrictParse(monthName, format, strict) {
        var i, ii, mom, llc = monthName.toLocaleLowerCase();
        if (!this._monthsParse) {
            // this is not used
            this._monthsParse = [];
            this._longMonthsParse = [];
            this._shortMonthsParse = [];
            for (i = 0; i < 12; ++i) {
                mom = createUTC([2000, i]);
                this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
                this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
            }
        }

        if (strict) {
            if (format === 'MMM') {
                ii = indexOf.call(this._shortMonthsParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._longMonthsParse, llc);
                return ii !== -1 ? ii : null;
            }
        } else {
            if (format === 'MMM') {
                ii = indexOf.call(this._shortMonthsParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._longMonthsParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._longMonthsParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortMonthsParse, llc);
                return ii !== -1 ? ii : null;
            }
        }
    }

    function localeMonthsParse (monthName, format, strict) {
        var i, mom, regex;

        if (this._monthsParseExact) {
            return handleStrictParse.call(this, monthName, format, strict);
        }

        if (!this._monthsParse) {
            this._monthsParse = [];
            this._longMonthsParse = [];
            this._shortMonthsParse = [];
        }

        // TODO: add sorting
        // Sorting makes sure if one month (or abbr) is a prefix of another
        // see sorting in computeMonthsParse
        for (i = 0; i < 12; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, i]);
            if (strict && !this._longMonthsParse[i]) {
                this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
                this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
            }
            if (!strict && !this._monthsParse[i]) {
                regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
                this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
            }
            // test the regex
            if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
                return i;
            } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
                return i;
            } else if (!strict && this._monthsParse[i].test(monthName)) {
                return i;
            }
        }
    }

    // MOMENTS

    function setMonth (mom, value) {
        var dayOfMonth;

        if (!mom.isValid()) {
            // No op
            return mom;
        }

        if (typeof value === 'string') {
            if (/^\d+$/.test(value)) {
                value = toInt(value);
            } else {
                value = mom.localeData().monthsParse(value);
                // TODO: Another silent failure?
                if (!isNumber(value)) {
                    return mom;
                }
            }
        }

        dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
        mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
        return mom;
    }

    function getSetMonth (value) {
        if (value != null) {
            setMonth(this, value);
            hooks.updateOffset(this, true);
            return this;
        } else {
            return get(this, 'Month');
        }
    }

    function getDaysInMonth () {
        return daysInMonth(this.year(), this.month());
    }

    var defaultMonthsShortRegex = matchWord;
    function monthsShortRegex (isStrict) {
        if (this._monthsParseExact) {
            if (!hasOwnProp(this, '_monthsRegex')) {
                computeMonthsParse.call(this);
            }
            if (isStrict) {
                return this._monthsShortStrictRegex;
            } else {
                return this._monthsShortRegex;
            }
        } else {
            if (!hasOwnProp(this, '_monthsShortRegex')) {
                this._monthsShortRegex = defaultMonthsShortRegex;
            }
            return this._monthsShortStrictRegex && isStrict ?
                this._monthsShortStrictRegex : this._monthsShortRegex;
        }
    }

    var defaultMonthsRegex = matchWord;
    function monthsRegex (isStrict) {
        if (this._monthsParseExact) {
            if (!hasOwnProp(this, '_monthsRegex')) {
                computeMonthsParse.call(this);
            }
            if (isStrict) {
                return this._monthsStrictRegex;
            } else {
                return this._monthsRegex;
            }
        } else {
            if (!hasOwnProp(this, '_monthsRegex')) {
                this._monthsRegex = defaultMonthsRegex;
            }
            return this._monthsStrictRegex && isStrict ?
                this._monthsStrictRegex : this._monthsRegex;
        }
    }

    function computeMonthsParse () {
        function cmpLenRev(a, b) {
            return b.length - a.length;
        }

        var shortPieces = [], longPieces = [], mixedPieces = [],
            i, mom;
        for (i = 0; i < 12; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, i]);
            shortPieces.push(this.monthsShort(mom, ''));
            longPieces.push(this.months(mom, ''));
            mixedPieces.push(this.months(mom, ''));
            mixedPieces.push(this.monthsShort(mom, ''));
        }
        // Sorting makes sure if one month (or abbr) is a prefix of another it
        // will match the longer piece.
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);
        for (i = 0; i < 12; i++) {
            shortPieces[i] = regexEscape(shortPieces[i]);
            longPieces[i] = regexEscape(longPieces[i]);
        }
        for (i = 0; i < 24; i++) {
            mixedPieces[i] = regexEscape(mixedPieces[i]);
        }

        this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
        this._monthsShortRegex = this._monthsRegex;
        this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
        this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
    }

    function createDate (y, m, d, h, M, s, ms) {
        // can't just apply() to create a date:
        // https://stackoverflow.com/q/181348
        var date = new Date(y, m, d, h, M, s, ms);

        // the date constructor remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0 && isFinite(date.getFullYear())) {
            date.setFullYear(y);
        }
        return date;
    }

    function createUTCDate (y) {
        var date = new Date(Date.UTC.apply(null, arguments));

        // the Date.UTC function remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0 && isFinite(date.getUTCFullYear())) {
            date.setUTCFullYear(y);
        }
        return date;
    }

    // start-of-first-week - start-of-year
    function firstWeekOffset(year, dow, doy) {
        var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
            fwd = 7 + dow - doy,
            // first-week day local weekday -- which local weekday is fwd
            fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;

        return -fwdlw + fwd - 1;
    }

    // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
    function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
        var localWeekday = (7 + weekday - dow) % 7,
            weekOffset = firstWeekOffset(year, dow, doy),
            dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
            resYear, resDayOfYear;

        if (dayOfYear <= 0) {
            resYear = year - 1;
            resDayOfYear = daysInYear(resYear) + dayOfYear;
        } else if (dayOfYear > daysInYear(year)) {
            resYear = year + 1;
            resDayOfYear = dayOfYear - daysInYear(year);
        } else {
            resYear = year;
            resDayOfYear = dayOfYear;
        }

        return {
            year: resYear,
            dayOfYear: resDayOfYear
        };
    }

    function weekOfYear(mom, dow, doy) {
        var weekOffset = firstWeekOffset(mom.year(), dow, doy),
            week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
            resWeek, resYear;

        if (week < 1) {
            resYear = mom.year() - 1;
            resWeek = week + weeksInYear(resYear, dow, doy);
        } else if (week > weeksInYear(mom.year(), dow, doy)) {
            resWeek = week - weeksInYear(mom.year(), dow, doy);
            resYear = mom.year() + 1;
        } else {
            resYear = mom.year();
            resWeek = week;
        }

        return {
            week: resWeek,
            year: resYear
        };
    }

    function weeksInYear(year, dow, doy) {
        var weekOffset = firstWeekOffset(year, dow, doy),
            weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
        return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
    }

    // FORMATTING

    addFormatToken('w', ['ww', 2], 'wo', 'week');
    addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

    // ALIASES

    addUnitAlias('week', 'w');
    addUnitAlias('isoWeek', 'W');

    // PRIORITIES

    addUnitPriority('week', 5);
    addUnitPriority('isoWeek', 5);

    // PARSING

    addRegexToken('w',  match1to2);
    addRegexToken('ww', match1to2, match2);
    addRegexToken('W',  match1to2);
    addRegexToken('WW', match1to2, match2);

    addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
        week[token.substr(0, 1)] = toInt(input);
    });

    // HELPERS

    // LOCALES

    function localeWeek (mom) {
        return weekOfYear(mom, this._week.dow, this._week.doy).week;
    }

    var defaultLocaleWeek = {
        dow : 0, // Sunday is the first day of the week.
        doy : 6  // The week that contains Jan 1st is the first week of the year.
    };

    function localeFirstDayOfWeek () {
        return this._week.dow;
    }

    function localeFirstDayOfYear () {
        return this._week.doy;
    }

    // MOMENTS

    function getSetWeek (input) {
        var week = this.localeData().week(this);
        return input == null ? week : this.add((input - week) * 7, 'd');
    }

    function getSetISOWeek (input) {
        var week = weekOfYear(this, 1, 4).week;
        return input == null ? week : this.add((input - week) * 7, 'd');
    }

    // FORMATTING

    addFormatToken('d', 0, 'do', 'day');

    addFormatToken('dd', 0, 0, function (format) {
        return this.localeData().weekdaysMin(this, format);
    });

    addFormatToken('ddd', 0, 0, function (format) {
        return this.localeData().weekdaysShort(this, format);
    });

    addFormatToken('dddd', 0, 0, function (format) {
        return this.localeData().weekdays(this, format);
    });

    addFormatToken('e', 0, 0, 'weekday');
    addFormatToken('E', 0, 0, 'isoWeekday');

    // ALIASES

    addUnitAlias('day', 'd');
    addUnitAlias('weekday', 'e');
    addUnitAlias('isoWeekday', 'E');

    // PRIORITY
    addUnitPriority('day', 11);
    addUnitPriority('weekday', 11);
    addUnitPriority('isoWeekday', 11);

    // PARSING

    addRegexToken('d',    match1to2);
    addRegexToken('e',    match1to2);
    addRegexToken('E',    match1to2);
    addRegexToken('dd',   function (isStrict, locale) {
        return locale.weekdaysMinRegex(isStrict);
    });
    addRegexToken('ddd',   function (isStrict, locale) {
        return locale.weekdaysShortRegex(isStrict);
    });
    addRegexToken('dddd',   function (isStrict, locale) {
        return locale.weekdaysRegex(isStrict);
    });

    addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
        var weekday = config._locale.weekdaysParse(input, token, config._strict);
        // if we didn't get a weekday name, mark the date as invalid
        if (weekday != null) {
            week.d = weekday;
        } else {
            getParsingFlags(config).invalidWeekday = input;
        }
    });

    addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
        week[token] = toInt(input);
    });

    // HELPERS

    function parseWeekday(input, locale) {
        if (typeof input !== 'string') {
            return input;
        }

        if (!isNaN(input)) {
            return parseInt(input, 10);
        }

        input = locale.weekdaysParse(input);
        if (typeof input === 'number') {
            return input;
        }

        return null;
    }

    function parseIsoWeekday(input, locale) {
        if (typeof input === 'string') {
            return locale.weekdaysParse(input) % 7 || 7;
        }
        return isNaN(input) ? null : input;
    }

    // LOCALES

    var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');
    function localeWeekdays (m, format) {
        if (!m) {
            return isArray(this._weekdays) ? this._weekdays :
                this._weekdays['standalone'];
        }
        return isArray(this._weekdays) ? this._weekdays[m.day()] :
            this._weekdays[this._weekdays.isFormat.test(format) ? 'format' : 'standalone'][m.day()];
    }

    var defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');
    function localeWeekdaysShort (m) {
        return (m) ? this._weekdaysShort[m.day()] : this._weekdaysShort;
    }

    var defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');
    function localeWeekdaysMin (m) {
        return (m) ? this._weekdaysMin[m.day()] : this._weekdaysMin;
    }

    function handleStrictParse$1(weekdayName, format, strict) {
        var i, ii, mom, llc = weekdayName.toLocaleLowerCase();
        if (!this._weekdaysParse) {
            this._weekdaysParse = [];
            this._shortWeekdaysParse = [];
            this._minWeekdaysParse = [];

            for (i = 0; i < 7; ++i) {
                mom = createUTC([2000, 1]).day(i);
                this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
                this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
                this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
            }
        }

        if (strict) {
            if (format === 'dddd') {
                ii = indexOf.call(this._weekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else if (format === 'ddd') {
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            }
        } else {
            if (format === 'dddd') {
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else if (format === 'ddd') {
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._minWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            }
        }
    }

    function localeWeekdaysParse (weekdayName, format, strict) {
        var i, mom, regex;

        if (this._weekdaysParseExact) {
            return handleStrictParse$1.call(this, weekdayName, format, strict);
        }

        if (!this._weekdaysParse) {
            this._weekdaysParse = [];
            this._minWeekdaysParse = [];
            this._shortWeekdaysParse = [];
            this._fullWeekdaysParse = [];
        }

        for (i = 0; i < 7; i++) {
            // make the regex if we don't have it already

            mom = createUTC([2000, 1]).day(i);
            if (strict && !this._fullWeekdaysParse[i]) {
                this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\\.?') + '$', 'i');
                this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$', 'i');
                this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$', 'i');
            }
            if (!this._weekdaysParse[i]) {
                regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
                this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
            }
            // test the regex
            if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
                return i;
            } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
                return i;
            } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
                return i;
            } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
                return i;
            }
        }
    }

    // MOMENTS

    function getSetDayOfWeek (input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
        if (input != null) {
            input = parseWeekday(input, this.localeData());
            return this.add(input - day, 'd');
        } else {
            return day;
        }
    }

    function getSetLocaleDayOfWeek (input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
        return input == null ? weekday : this.add(input - weekday, 'd');
    }

    function getSetISODayOfWeek (input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }

        // behaves the same as moment#day except
        // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
        // as a setter, sunday should belong to the previous week.

        if (input != null) {
            var weekday = parseIsoWeekday(input, this.localeData());
            return this.day(this.day() % 7 ? weekday : weekday - 7);
        } else {
            return this.day() || 7;
        }
    }

    var defaultWeekdaysRegex = matchWord;
    function weekdaysRegex (isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysStrictRegex;
            } else {
                return this._weekdaysRegex;
            }
        } else {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                this._weekdaysRegex = defaultWeekdaysRegex;
            }
            return this._weekdaysStrictRegex && isStrict ?
                this._weekdaysStrictRegex : this._weekdaysRegex;
        }
    }

    var defaultWeekdaysShortRegex = matchWord;
    function weekdaysShortRegex (isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysShortStrictRegex;
            } else {
                return this._weekdaysShortRegex;
            }
        } else {
            if (!hasOwnProp(this, '_weekdaysShortRegex')) {
                this._weekdaysShortRegex = defaultWeekdaysShortRegex;
            }
            return this._weekdaysShortStrictRegex && isStrict ?
                this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
        }
    }

    var defaultWeekdaysMinRegex = matchWord;
    function weekdaysMinRegex (isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, '_weekdaysRegex')) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysMinStrictRegex;
            } else {
                return this._weekdaysMinRegex;
            }
        } else {
            if (!hasOwnProp(this, '_weekdaysMinRegex')) {
                this._weekdaysMinRegex = defaultWeekdaysMinRegex;
            }
            return this._weekdaysMinStrictRegex && isStrict ?
                this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
        }
    }


    function computeWeekdaysParse () {
        function cmpLenRev(a, b) {
            return b.length - a.length;
        }

        var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [],
            i, mom, minp, shortp, longp;
        for (i = 0; i < 7; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, 1]).day(i);
            minp = this.weekdaysMin(mom, '');
            shortp = this.weekdaysShort(mom, '');
            longp = this.weekdays(mom, '');
            minPieces.push(minp);
            shortPieces.push(shortp);
            longPieces.push(longp);
            mixedPieces.push(minp);
            mixedPieces.push(shortp);
            mixedPieces.push(longp);
        }
        // Sorting makes sure if one weekday (or abbr) is a prefix of another it
        // will match the longer piece.
        minPieces.sort(cmpLenRev);
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);
        for (i = 0; i < 7; i++) {
            shortPieces[i] = regexEscape(shortPieces[i]);
            longPieces[i] = regexEscape(longPieces[i]);
            mixedPieces[i] = regexEscape(mixedPieces[i]);
        }

        this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
        this._weekdaysShortRegex = this._weekdaysRegex;
        this._weekdaysMinRegex = this._weekdaysRegex;

        this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
        this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
        this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
    }

    // FORMATTING

    function hFormat() {
        return this.hours() % 12 || 12;
    }

    function kFormat() {
        return this.hours() || 24;
    }

    addFormatToken('H', ['HH', 2], 0, 'hour');
    addFormatToken('h', ['hh', 2], 0, hFormat);
    addFormatToken('k', ['kk', 2], 0, kFormat);

    addFormatToken('hmm', 0, 0, function () {
        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
    });

    addFormatToken('hmmss', 0, 0, function () {
        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) +
            zeroFill(this.seconds(), 2);
    });

    addFormatToken('Hmm', 0, 0, function () {
        return '' + this.hours() + zeroFill(this.minutes(), 2);
    });

    addFormatToken('Hmmss', 0, 0, function () {
        return '' + this.hours() + zeroFill(this.minutes(), 2) +
            zeroFill(this.seconds(), 2);
    });

    function meridiem (token, lowercase) {
        addFormatToken(token, 0, 0, function () {
            return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
        });
    }

    meridiem('a', true);
    meridiem('A', false);

    // ALIASES

    addUnitAlias('hour', 'h');

    // PRIORITY
    addUnitPriority('hour', 13);

    // PARSING

    function matchMeridiem (isStrict, locale) {
        return locale._meridiemParse;
    }

    addRegexToken('a',  matchMeridiem);
    addRegexToken('A',  matchMeridiem);
    addRegexToken('H',  match1to2);
    addRegexToken('h',  match1to2);
    addRegexToken('k',  match1to2);
    addRegexToken('HH', match1to2, match2);
    addRegexToken('hh', match1to2, match2);
    addRegexToken('kk', match1to2, match2);

    addRegexToken('hmm', match3to4);
    addRegexToken('hmmss', match5to6);
    addRegexToken('Hmm', match3to4);
    addRegexToken('Hmmss', match5to6);

    addParseToken(['H', 'HH'], HOUR);
    addParseToken(['k', 'kk'], function (input, array, config) {
        var kInput = toInt(input);
        array[HOUR] = kInput === 24 ? 0 : kInput;
    });
    addParseToken(['a', 'A'], function (input, array, config) {
        config._isPm = config._locale.isPM(input);
        config._meridiem = input;
    });
    addParseToken(['h', 'hh'], function (input, array, config) {
        array[HOUR] = toInt(input);
        getParsingFlags(config).bigHour = true;
    });
    addParseToken('hmm', function (input, array, config) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
        getParsingFlags(config).bigHour = true;
    });
    addParseToken('hmmss', function (input, array, config) {
        var pos1 = input.length - 4;
        var pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
        getParsingFlags(config).bigHour = true;
    });
    addParseToken('Hmm', function (input, array, config) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
    });
    addParseToken('Hmmss', function (input, array, config) {
        var pos1 = input.length - 4;
        var pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
    });

    // LOCALES

    function localeIsPM (input) {
        // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
        // Using charAt should be more compatible.
        return ((input + '').toLowerCase().charAt(0) === 'p');
    }

    var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;
    function localeMeridiem (hours, minutes, isLower) {
        if (hours > 11) {
            return isLower ? 'pm' : 'PM';
        } else {
            return isLower ? 'am' : 'AM';
        }
    }


    // MOMENTS

    // Setting the hour should keep the time, because the user explicitly
    // specified which hour they want. So trying to maintain the same hour (in
    // a new timezone) makes sense. Adding/subtracting hours does not follow
    // this rule.
    var getSetHour = makeGetSet('Hours', true);

    var baseConfig = {
        calendar: defaultCalendar,
        longDateFormat: defaultLongDateFormat,
        invalidDate: defaultInvalidDate,
        ordinal: defaultOrdinal,
        dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
        relativeTime: defaultRelativeTime,

        months: defaultLocaleMonths,
        monthsShort: defaultLocaleMonthsShort,

        week: defaultLocaleWeek,

        weekdays: defaultLocaleWeekdays,
        weekdaysMin: defaultLocaleWeekdaysMin,
        weekdaysShort: defaultLocaleWeekdaysShort,

        meridiemParse: defaultLocaleMeridiemParse
    };

    // internal storage for locale config files
    var locales = {};
    var localeFamilies = {};
    var globalLocale;

    function normalizeLocale(key) {
        return key ? key.toLowerCase().replace('_', '-') : key;
    }

    // pick the locale from the array
    // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
    // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
    function chooseLocale(names) {
        var i = 0, j, next, locale, split;

        while (i < names.length) {
            split = normalizeLocale(names[i]).split('-');
            j = split.length;
            next = normalizeLocale(names[i + 1]);
            next = next ? next.split('-') : null;
            while (j > 0) {
                locale = loadLocale(split.slice(0, j).join('-'));
                if (locale) {
                    return locale;
                }
                if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {
                    //the next array item is better than a shallower substring of this one
                    break;
                }
                j--;
            }
            i++;
        }
        return globalLocale;
    }

    function loadLocale(name) {
        var oldLocale = null;
        // TODO: Find a better way to register and load all the locales in Node
        if (!locales[name] && (typeof module !== 'undefined') &&
                module && module.exports) {
            try {
                oldLocale = globalLocale._abbr;
                var aliasedRequire = require;
                __webpack_require__(534)("./" + name);
                getSetGlobalLocale(oldLocale);
            } catch (e) {}
        }
        return locales[name];
    }

    // This function will load locale and then set the global locale.  If
    // no arguments are passed in, it will simply return the current global
    // locale key.
    function getSetGlobalLocale (key, values) {
        var data;
        if (key) {
            if (isUndefined(values)) {
                data = getLocale(key);
            }
            else {
                data = defineLocale(key, values);
            }

            if (data) {
                // moment.duration._locale = moment._locale = data;
                globalLocale = data;
            }
            else {
                if ((typeof console !==  'undefined') && console.warn) {
                    //warn user if arguments are passed but the locale could not be set
                    console.warn('Locale ' + key +  ' not found. Did you forget to load it?');
                }
            }
        }

        return globalLocale._abbr;
    }

    function defineLocale (name, config) {
        if (config !== null) {
            var locale, parentConfig = baseConfig;
            config.abbr = name;
            if (locales[name] != null) {
                deprecateSimple('defineLocaleOverride',
                        'use moment.updateLocale(localeName, config) to change ' +
                        'an existing locale. moment.defineLocale(localeName, ' +
                        'config) should only be used for creating a new locale ' +
                        'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
                parentConfig = locales[name]._config;
            } else if (config.parentLocale != null) {
                if (locales[config.parentLocale] != null) {
                    parentConfig = locales[config.parentLocale]._config;
                } else {
                    locale = loadLocale(config.parentLocale);
                    if (locale != null) {
                        parentConfig = locale._config;
                    } else {
                        if (!localeFamilies[config.parentLocale]) {
                            localeFamilies[config.parentLocale] = [];
                        }
                        localeFamilies[config.parentLocale].push({
                            name: name,
                            config: config
                        });
                        return null;
                    }
                }
            }
            locales[name] = new Locale(mergeConfigs(parentConfig, config));

            if (localeFamilies[name]) {
                localeFamilies[name].forEach(function (x) {
                    defineLocale(x.name, x.config);
                });
            }

            // backwards compat for now: also set the locale
            // make sure we set the locale AFTER all child locales have been
            // created, so we won't end up with the child locale set.
            getSetGlobalLocale(name);


            return locales[name];
        } else {
            // useful for testing
            delete locales[name];
            return null;
        }
    }

    function updateLocale(name, config) {
        if (config != null) {
            var locale, tmpLocale, parentConfig = baseConfig;
            // MERGE
            tmpLocale = loadLocale(name);
            if (tmpLocale != null) {
                parentConfig = tmpLocale._config;
            }
            config = mergeConfigs(parentConfig, config);
            locale = new Locale(config);
            locale.parentLocale = locales[name];
            locales[name] = locale;

            // backwards compat for now: also set the locale
            getSetGlobalLocale(name);
        } else {
            // pass null for config to unupdate, useful for tests
            if (locales[name] != null) {
                if (locales[name].parentLocale != null) {
                    locales[name] = locales[name].parentLocale;
                } else if (locales[name] != null) {
                    delete locales[name];
                }
            }
        }
        return locales[name];
    }

    // returns locale data
    function getLocale (key) {
        var locale;

        if (key && key._locale && key._locale._abbr) {
            key = key._locale._abbr;
        }

        if (!key) {
            return globalLocale;
        }

        if (!isArray(key)) {
            //short-circuit everything else
            locale = loadLocale(key);
            if (locale) {
                return locale;
            }
            key = [key];
        }

        return chooseLocale(key);
    }

    function listLocales() {
        return keys(locales);
    }

    function checkOverflow (m) {
        var overflow;
        var a = m._a;

        if (a && getParsingFlags(m).overflow === -2) {
            overflow =
                a[MONTH]       < 0 || a[MONTH]       > 11  ? MONTH :
                a[DATE]        < 1 || a[DATE]        > daysInMonth(a[YEAR], a[MONTH]) ? DATE :
                a[HOUR]        < 0 || a[HOUR]        > 24 || (a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0)) ? HOUR :
                a[MINUTE]      < 0 || a[MINUTE]      > 59  ? MINUTE :
                a[SECOND]      < 0 || a[SECOND]      > 59  ? SECOND :
                a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND :
                -1;

            if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
                overflow = DATE;
            }
            if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
                overflow = WEEK;
            }
            if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
                overflow = WEEKDAY;
            }

            getParsingFlags(m).overflow = overflow;
        }

        return m;
    }

    // Pick the first defined of two or three arguments.
    function defaults(a, b, c) {
        if (a != null) {
            return a;
        }
        if (b != null) {
            return b;
        }
        return c;
    }

    function currentDateArray(config) {
        // hooks is actually the exported moment object
        var nowValue = new Date(hooks.now());
        if (config._useUTC) {
            return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
        }
        return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
    }

    // convert an array to a date.
    // the array should mirror the parameters below
    // note: all values past the year are optional and will default to the lowest possible value.
    // [year, month, day , hour, minute, second, millisecond]
    function configFromArray (config) {
        var i, date, input = [], currentDate, expectedWeekday, yearToUse;

        if (config._d) {
            return;
        }

        currentDate = currentDateArray(config);

        //compute day of the year from weeks and weekdays
        if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
            dayOfYearFromWeekInfo(config);
        }

        //if the day of the year is set, figure out what it is
        if (config._dayOfYear != null) {
            yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

            if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {
                getParsingFlags(config)._overflowDayOfYear = true;
            }

            date = createUTCDate(yearToUse, 0, config._dayOfYear);
            config._a[MONTH] = date.getUTCMonth();
            config._a[DATE] = date.getUTCDate();
        }

        // Default to current date.
        // * if no year, month, day of month are given, default to today
        // * if day of month is given, default month and year
        // * if month is given, default only year
        // * if year is given, don't default anything
        for (i = 0; i < 3 && config._a[i] == null; ++i) {
            config._a[i] = input[i] = currentDate[i];
        }

        // Zero out whatever was not defaulted, including time
        for (; i < 7; i++) {
            config._a[i] = input[i] = (config._a[i] == null) ? (i === 2 ? 1 : 0) : config._a[i];
        }

        // Check for 24:00:00.000
        if (config._a[HOUR] === 24 &&
                config._a[MINUTE] === 0 &&
                config._a[SECOND] === 0 &&
                config._a[MILLISECOND] === 0) {
            config._nextDay = true;
            config._a[HOUR] = 0;
        }

        config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
        expectedWeekday = config._useUTC ? config._d.getUTCDay() : config._d.getDay();

        // Apply timezone offset from input. The actual utcOffset can be changed
        // with parseZone.
        if (config._tzm != null) {
            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
        }

        if (config._nextDay) {
            config._a[HOUR] = 24;
        }

        // check for mismatching day of week
        if (config._w && typeof config._w.d !== 'undefined' && config._w.d !== expectedWeekday) {
            getParsingFlags(config).weekdayMismatch = true;
        }
    }

    function dayOfYearFromWeekInfo(config) {
        var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;

        w = config._w;
        if (w.GG != null || w.W != null || w.E != null) {
            dow = 1;
            doy = 4;

            // TODO: We need to take the current isoWeekYear, but that depends on
            // how we interpret now (local, utc, fixed offset). So create
            // a now version of current config (take local/utc/offset flags, and
            // create now).
            weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
            week = defaults(w.W, 1);
            weekday = defaults(w.E, 1);
            if (weekday < 1 || weekday > 7) {
                weekdayOverflow = true;
            }
        } else {
            dow = config._locale._week.dow;
            doy = config._locale._week.doy;

            var curWeek = weekOfYear(createLocal(), dow, doy);

            weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);

            // Default to current week.
            week = defaults(w.w, curWeek.week);

            if (w.d != null) {
                // weekday -- low day numbers are considered next week
                weekday = w.d;
                if (weekday < 0 || weekday > 6) {
                    weekdayOverflow = true;
                }
            } else if (w.e != null) {
                // local weekday -- counting starts from begining of week
                weekday = w.e + dow;
                if (w.e < 0 || w.e > 6) {
                    weekdayOverflow = true;
                }
            } else {
                // default to begining of week
                weekday = dow;
            }
        }
        if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
            getParsingFlags(config)._overflowWeeks = true;
        } else if (weekdayOverflow != null) {
            getParsingFlags(config)._overflowWeekday = true;
        } else {
            temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
            config._a[YEAR] = temp.year;
            config._dayOfYear = temp.dayOfYear;
        }
    }

    // iso 8601 regex
    // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
    var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
    var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;

    var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;

    var isoDates = [
        ['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/],
        ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/],
        ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/],
        ['GGGG-[W]WW', /\d{4}-W\d\d/, false],
        ['YYYY-DDD', /\d{4}-\d{3}/],
        ['YYYY-MM', /\d{4}-\d\d/, false],
        ['YYYYYYMMDD', /[+-]\d{10}/],
        ['YYYYMMDD', /\d{8}/],
        // YYYYMM is NOT allowed by the standard
        ['GGGG[W]WWE', /\d{4}W\d{3}/],
        ['GGGG[W]WW', /\d{4}W\d{2}/, false],
        ['YYYYDDD', /\d{7}/]
    ];

    // iso time formats and regexes
    var isoTimes = [
        ['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/],
        ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/],
        ['HH:mm:ss', /\d\d:\d\d:\d\d/],
        ['HH:mm', /\d\d:\d\d/],
        ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/],
        ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/],
        ['HHmmss', /\d\d\d\d\d\d/],
        ['HHmm', /\d\d\d\d/],
        ['HH', /\d\d/]
    ];

    var aspNetJsonRegex = /^\/?Date\((\-?\d+)/i;

    // date from iso format
    function configFromISO(config) {
        var i, l,
            string = config._i,
            match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
            allowTime, dateFormat, timeFormat, tzFormat;

        if (match) {
            getParsingFlags(config).iso = true;

            for (i = 0, l = isoDates.length; i < l; i++) {
                if (isoDates[i][1].exec(match[1])) {
                    dateFormat = isoDates[i][0];
                    allowTime = isoDates[i][2] !== false;
                    break;
                }
            }
            if (dateFormat == null) {
                config._isValid = false;
                return;
            }
            if (match[3]) {
                for (i = 0, l = isoTimes.length; i < l; i++) {
                    if (isoTimes[i][1].exec(match[3])) {
                        // match[2] should be 'T' or space
                        timeFormat = (match[2] || ' ') + isoTimes[i][0];
                        break;
                    }
                }
                if (timeFormat == null) {
                    config._isValid = false;
                    return;
                }
            }
            if (!allowTime && timeFormat != null) {
                config._isValid = false;
                return;
            }
            if (match[4]) {
                if (tzRegex.exec(match[4])) {
                    tzFormat = 'Z';
                } else {
                    config._isValid = false;
                    return;
                }
            }
            config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
            configFromStringAndFormat(config);
        } else {
            config._isValid = false;
        }
    }

    // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
    var rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;

    function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
        var result = [
            untruncateYear(yearStr),
            defaultLocaleMonthsShort.indexOf(monthStr),
            parseInt(dayStr, 10),
            parseInt(hourStr, 10),
            parseInt(minuteStr, 10)
        ];

        if (secondStr) {
            result.push(parseInt(secondStr, 10));
        }

        return result;
    }

    function untruncateYear(yearStr) {
        var year = parseInt(yearStr, 10);
        if (year <= 49) {
            return 2000 + year;
        } else if (year <= 999) {
            return 1900 + year;
        }
        return year;
    }

    function preprocessRFC2822(s) {
        // Remove comments and folding whitespace and replace multiple-spaces with a single space
        return s.replace(/\([^)]*\)|[\n\t]/g, ' ').replace(/(\s\s+)/g, ' ').replace(/^\s\s*/, '').replace(/\s\s*$/, '');
    }

    function checkWeekday(weekdayStr, parsedInput, config) {
        if (weekdayStr) {
            // TODO: Replace the vanilla JS Date object with an indepentent day-of-week check.
            var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr),
                weekdayActual = new Date(parsedInput[0], parsedInput[1], parsedInput[2]).getDay();
            if (weekdayProvided !== weekdayActual) {
                getParsingFlags(config).weekdayMismatch = true;
                config._isValid = false;
                return false;
            }
        }
        return true;
    }

    var obsOffsets = {
        UT: 0,
        GMT: 0,
        EDT: -4 * 60,
        EST: -5 * 60,
        CDT: -5 * 60,
        CST: -6 * 60,
        MDT: -6 * 60,
        MST: -7 * 60,
        PDT: -7 * 60,
        PST: -8 * 60
    };

    function calculateOffset(obsOffset, militaryOffset, numOffset) {
        if (obsOffset) {
            return obsOffsets[obsOffset];
        } else if (militaryOffset) {
            // the only allowed military tz is Z
            return 0;
        } else {
            var hm = parseInt(numOffset, 10);
            var m = hm % 100, h = (hm - m) / 100;
            return h * 60 + m;
        }
    }

    // date and time from ref 2822 format
    function configFromRFC2822(config) {
        var match = rfc2822.exec(preprocessRFC2822(config._i));
        if (match) {
            var parsedArray = extractFromRFC2822Strings(match[4], match[3], match[2], match[5], match[6], match[7]);
            if (!checkWeekday(match[1], parsedArray, config)) {
                return;
            }

            config._a = parsedArray;
            config._tzm = calculateOffset(match[8], match[9], match[10]);

            config._d = createUTCDate.apply(null, config._a);
            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);

            getParsingFlags(config).rfc2822 = true;
        } else {
            config._isValid = false;
        }
    }

    // date from iso format or fallback
    function configFromString(config) {
        var matched = aspNetJsonRegex.exec(config._i);

        if (matched !== null) {
            config._d = new Date(+matched[1]);
            return;
        }

        configFromISO(config);
        if (config._isValid === false) {
            delete config._isValid;
        } else {
            return;
        }

        configFromRFC2822(config);
        if (config._isValid === false) {
            delete config._isValid;
        } else {
            return;
        }

        // Final attempt, use Input Fallback
        hooks.createFromInputFallback(config);
    }

    hooks.createFromInputFallback = deprecate(
        'value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' +
        'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' +
        'discouraged and will be removed in an upcoming major release. Please refer to ' +
        'http://momentjs.com/guides/#/warnings/js-date/ for more info.',
        function (config) {
            config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
        }
    );

    // constant that refers to the ISO standard
    hooks.ISO_8601 = function () {};

    // constant that refers to the RFC 2822 form
    hooks.RFC_2822 = function () {};

    // date from string and format string
    function configFromStringAndFormat(config) {
        // TODO: Move this to another part of the creation flow to prevent circular deps
        if (config._f === hooks.ISO_8601) {
            configFromISO(config);
            return;
        }
        if (config._f === hooks.RFC_2822) {
            configFromRFC2822(config);
            return;
        }
        config._a = [];
        getParsingFlags(config).empty = true;

        // This array is used to make a Date, either with `new Date` or `Date.UTC`
        var string = '' + config._i,
            i, parsedInput, tokens, token, skipped,
            stringLength = string.length,
            totalParsedInputLength = 0;

        tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];

        for (i = 0; i < tokens.length; i++) {
            token = tokens[i];
            parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];
            // console.log('token', token, 'parsedInput', parsedInput,
            //         'regex', getParseRegexForToken(token, config));
            if (parsedInput) {
                skipped = string.substr(0, string.indexOf(parsedInput));
                if (skipped.length > 0) {
                    getParsingFlags(config).unusedInput.push(skipped);
                }
                string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
                totalParsedInputLength += parsedInput.length;
            }
            // don't parse if it's not a known token
            if (formatTokenFunctions[token]) {
                if (parsedInput) {
                    getParsingFlags(config).empty = false;
                }
                else {
                    getParsingFlags(config).unusedTokens.push(token);
                }
                addTimeToArrayFromToken(token, parsedInput, config);
            }
            else if (config._strict && !parsedInput) {
                getParsingFlags(config).unusedTokens.push(token);
            }
        }

        // add remaining unparsed input length to the string
        getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;
        if (string.length > 0) {
            getParsingFlags(config).unusedInput.push(string);
        }

        // clear _12h flag if hour is <= 12
        if (config._a[HOUR] <= 12 &&
            getParsingFlags(config).bigHour === true &&
            config._a[HOUR] > 0) {
            getParsingFlags(config).bigHour = undefined;
        }

        getParsingFlags(config).parsedDateParts = config._a.slice(0);
        getParsingFlags(config).meridiem = config._meridiem;
        // handle meridiem
        config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);

        configFromArray(config);
        checkOverflow(config);
    }


    function meridiemFixWrap (locale, hour, meridiem) {
        var isPm;

        if (meridiem == null) {
            // nothing to do
            return hour;
        }
        if (locale.meridiemHour != null) {
            return locale.meridiemHour(hour, meridiem);
        } else if (locale.isPM != null) {
            // Fallback
            isPm = locale.isPM(meridiem);
            if (isPm && hour < 12) {
                hour += 12;
            }
            if (!isPm && hour === 12) {
                hour = 0;
            }
            return hour;
        } else {
            // this is not supposed to happen
            return hour;
        }
    }

    // date from string and array of format strings
    function configFromStringAndArray(config) {
        var tempConfig,
            bestMoment,

            scoreToBeat,
            i,
            currentScore;

        if (config._f.length === 0) {
            getParsingFlags(config).invalidFormat = true;
            config._d = new Date(NaN);
            return;
        }

        for (i = 0; i < config._f.length; i++) {
            currentScore = 0;
            tempConfig = copyConfig({}, config);
            if (config._useUTC != null) {
                tempConfig._useUTC = config._useUTC;
            }
            tempConfig._f = config._f[i];
            configFromStringAndFormat(tempConfig);

            if (!isValid(tempConfig)) {
                continue;
            }

            // if there is any input that was not parsed add a penalty for that format
            currentScore += getParsingFlags(tempConfig).charsLeftOver;

            //or tokens
            currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;

            getParsingFlags(tempConfig).score = currentScore;

            if (scoreToBeat == null || currentScore < scoreToBeat) {
                scoreToBeat = currentScore;
                bestMoment = tempConfig;
            }
        }

        extend(config, bestMoment || tempConfig);
    }

    function configFromObject(config) {
        if (config._d) {
            return;
        }

        var i = normalizeObjectUnits(config._i);
        config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {
            return obj && parseInt(obj, 10);
        });

        configFromArray(config);
    }

    function createFromConfig (config) {
        var res = new Moment(checkOverflow(prepareConfig(config)));
        if (res._nextDay) {
            // Adding is smart enough around DST
            res.add(1, 'd');
            res._nextDay = undefined;
        }

        return res;
    }

    function prepareConfig (config) {
        var input = config._i,
            format = config._f;

        config._locale = config._locale || getLocale(config._l);

        if (input === null || (format === undefined && input === '')) {
            return createInvalid({nullInput: true});
        }

        if (typeof input === 'string') {
            config._i = input = config._locale.preparse(input);
        }

        if (isMoment(input)) {
            return new Moment(checkOverflow(input));
        } else if (isDate(input)) {
            config._d = input;
        } else if (isArray(format)) {
            configFromStringAndArray(config);
        } else if (format) {
            configFromStringAndFormat(config);
        }  else {
            configFromInput(config);
        }

        if (!isValid(config)) {
            config._d = null;
        }

        return config;
    }

    function configFromInput(config) {
        var input = config._i;
        if (isUndefined(input)) {
            config._d = new Date(hooks.now());
        } else if (isDate(input)) {
            config._d = new Date(input.valueOf());
        } else if (typeof input === 'string') {
            configFromString(config);
        } else if (isArray(input)) {
            config._a = map(input.slice(0), function (obj) {
                return parseInt(obj, 10);
            });
            configFromArray(config);
        } else if (isObject(input)) {
            configFromObject(config);
        } else if (isNumber(input)) {
            // from milliseconds
            config._d = new Date(input);
        } else {
            hooks.createFromInputFallback(config);
        }
    }

    function createLocalOrUTC (input, format, locale, strict, isUTC) {
        var c = {};

        if (locale === true || locale === false) {
            strict = locale;
            locale = undefined;
        }

        if ((isObject(input) && isObjectEmpty(input)) ||
                (isArray(input) && input.length === 0)) {
            input = undefined;
        }
        // object construction must be done this way.
        // https://github.com/moment/moment/issues/1423
        c._isAMomentObject = true;
        c._useUTC = c._isUTC = isUTC;
        c._l = locale;
        c._i = input;
        c._f = format;
        c._strict = strict;

        return createFromConfig(c);
    }

    function createLocal (input, format, locale, strict) {
        return createLocalOrUTC(input, format, locale, strict, false);
    }

    var prototypeMin = deprecate(
        'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',
        function () {
            var other = createLocal.apply(null, arguments);
            if (this.isValid() && other.isValid()) {
                return other < this ? this : other;
            } else {
                return createInvalid();
            }
        }
    );

    var prototypeMax = deprecate(
        'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',
        function () {
            var other = createLocal.apply(null, arguments);
            if (this.isValid() && other.isValid()) {
                return other > this ? this : other;
            } else {
                return createInvalid();
            }
        }
    );

    // Pick a moment m from moments so that m[fn](other) is true for all
    // other. This relies on the function fn to be transitive.
    //
    // moments should either be an array of moment objects or an array, whose
    // first element is an array of moment objects.
    function pickBy(fn, moments) {
        var res, i;
        if (moments.length === 1 && isArray(moments[0])) {
            moments = moments[0];
        }
        if (!moments.length) {
            return createLocal();
        }
        res = moments[0];
        for (i = 1; i < moments.length; ++i) {
            if (!moments[i].isValid() || moments[i][fn](res)) {
                res = moments[i];
            }
        }
        return res;
    }

    // TODO: Use [].sort instead?
    function min () {
        var args = [].slice.call(arguments, 0);

        return pickBy('isBefore', args);
    }

    function max () {
        var args = [].slice.call(arguments, 0);

        return pickBy('isAfter', args);
    }

    var now = function () {
        return Date.now ? Date.now() : +(new Date());
    };

    var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];

    function isDurationValid(m) {
        for (var key in m) {
            if (!(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
                return false;
            }
        }

        var unitHasDecimal = false;
        for (var i = 0; i < ordering.length; ++i) {
            if (m[ordering[i]]) {
                if (unitHasDecimal) {
                    return false; // only allow non-integers for smallest unit
                }
                if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
                    unitHasDecimal = true;
                }
            }
        }

        return true;
    }

    function isValid$1() {
        return this._isValid;
    }

    function createInvalid$1() {
        return createDuration(NaN);
    }

    function Duration (duration) {
        var normalizedInput = normalizeObjectUnits(duration),
            years = normalizedInput.year || 0,
            quarters = normalizedInput.quarter || 0,
            months = normalizedInput.month || 0,
            weeks = normalizedInput.week || 0,
            days = normalizedInput.day || 0,
            hours = normalizedInput.hour || 0,
            minutes = normalizedInput.minute || 0,
            seconds = normalizedInput.second || 0,
            milliseconds = normalizedInput.millisecond || 0;

        this._isValid = isDurationValid(normalizedInput);

        // representation for dateAddRemove
        this._milliseconds = +milliseconds +
            seconds * 1e3 + // 1000
            minutes * 6e4 + // 1000 * 60
            hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
        // Because of dateAddRemove treats 24 hours as different from a
        // day when working around DST, we need to store them separately
        this._days = +days +
            weeks * 7;
        // It is impossible to translate months into days without knowing
        // which months you are are talking about, so we have to store
        // it separately.
        this._months = +months +
            quarters * 3 +
            years * 12;

        this._data = {};

        this._locale = getLocale();

        this._bubble();
    }

    function isDuration (obj) {
        return obj instanceof Duration;
    }

    function absRound (number) {
        if (number < 0) {
            return Math.round(-1 * number) * -1;
        } else {
            return Math.round(number);
        }
    }

    // FORMATTING

    function offset (token, separator) {
        addFormatToken(token, 0, 0, function () {
            var offset = this.utcOffset();
            var sign = '+';
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            }
            return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~(offset) % 60, 2);
        });
    }

    offset('Z', ':');
    offset('ZZ', '');

    // PARSING

    addRegexToken('Z',  matchShortOffset);
    addRegexToken('ZZ', matchShortOffset);
    addParseToken(['Z', 'ZZ'], function (input, array, config) {
        config._useUTC = true;
        config._tzm = offsetFromString(matchShortOffset, input);
    });

    // HELPERS

    // timezone chunker
    // '+10:00' > ['10',  '00']
    // '-1530'  > ['-15', '30']
    var chunkOffset = /([\+\-]|\d\d)/gi;

    function offsetFromString(matcher, string) {
        var matches = (string || '').match(matcher);

        if (matches === null) {
            return null;
        }

        var chunk   = matches[matches.length - 1] || [];
        var parts   = (chunk + '').match(chunkOffset) || ['-', 0, 0];
        var minutes = +(parts[1] * 60) + toInt(parts[2]);

        return minutes === 0 ?
          0 :
          parts[0] === '+' ? minutes : -minutes;
    }

    // Return a moment from input, that is local/utc/zone equivalent to model.
    function cloneWithOffset(input, model) {
        var res, diff;
        if (model._isUTC) {
            res = model.clone();
            diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
            // Use low-level api, because this fn is low-level api.
            res._d.setTime(res._d.valueOf() + diff);
            hooks.updateOffset(res, false);
            return res;
        } else {
            return createLocal(input).local();
        }
    }

    function getDateOffset (m) {
        // On Firefox.24 Date#getTimezoneOffset returns a floating point.
        // https://github.com/moment/moment/pull/1871
        return -Math.round(m._d.getTimezoneOffset() / 15) * 15;
    }

    // HOOKS

    // This function will be called whenever a moment is mutated.
    // It is intended to keep the offset in sync with the timezone.
    hooks.updateOffset = function () {};

    // MOMENTS

    // keepLocalTime = true means only change the timezone, without
    // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
    // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
    // +0200, so we adjust the time as needed, to be valid.
    //
    // Keeping the time actually adds/subtracts (one hour)
    // from the actual represented time. That is why we call updateOffset
    // a second time. In case it wants us to change the offset again
    // _changeInProgress == true case, then we have to adjust, because
    // there is no such time in the given timezone.
    function getSetOffset (input, keepLocalTime, keepMinutes) {
        var offset = this._offset || 0,
            localAdjust;
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        if (input != null) {
            if (typeof input === 'string') {
                input = offsetFromString(matchShortOffset, input);
                if (input === null) {
                    return this;
                }
            } else if (Math.abs(input) < 16 && !keepMinutes) {
                input = input * 60;
            }
            if (!this._isUTC && keepLocalTime) {
                localAdjust = getDateOffset(this);
            }
            this._offset = input;
            this._isUTC = true;
            if (localAdjust != null) {
                this.add(localAdjust, 'm');
            }
            if (offset !== input) {
                if (!keepLocalTime || this._changeInProgress) {
                    addSubtract(this, createDuration(input - offset, 'm'), 1, false);
                } else if (!this._changeInProgress) {
                    this._changeInProgress = true;
                    hooks.updateOffset(this, true);
                    this._changeInProgress = null;
                }
            }
            return this;
        } else {
            return this._isUTC ? offset : getDateOffset(this);
        }
    }

    function getSetZone (input, keepLocalTime) {
        if (input != null) {
            if (typeof input !== 'string') {
                input = -input;
            }

            this.utcOffset(input, keepLocalTime);

            return this;
        } else {
            return -this.utcOffset();
        }
    }

    function setOffsetToUTC (keepLocalTime) {
        return this.utcOffset(0, keepLocalTime);
    }

    function setOffsetToLocal (keepLocalTime) {
        if (this._isUTC) {
            this.utcOffset(0, keepLocalTime);
            this._isUTC = false;

            if (keepLocalTime) {
                this.subtract(getDateOffset(this), 'm');
            }
        }
        return this;
    }

    function setOffsetToParsedOffset () {
        if (this._tzm != null) {
            this.utcOffset(this._tzm, false, true);
        } else if (typeof this._i === 'string') {
            var tZone = offsetFromString(matchOffset, this._i);
            if (tZone != null) {
                this.utcOffset(tZone);
            }
            else {
                this.utcOffset(0, true);
            }
        }
        return this;
    }

    function hasAlignedHourOffset (input) {
        if (!this.isValid()) {
            return false;
        }
        input = input ? createLocal(input).utcOffset() : 0;

        return (this.utcOffset() - input) % 60 === 0;
    }

    function isDaylightSavingTime () {
        return (
            this.utcOffset() > this.clone().month(0).utcOffset() ||
            this.utcOffset() > this.clone().month(5).utcOffset()
        );
    }

    function isDaylightSavingTimeShifted () {
        if (!isUndefined(this._isDSTShifted)) {
            return this._isDSTShifted;
        }

        var c = {};

        copyConfig(c, this);
        c = prepareConfig(c);

        if (c._a) {
            var other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
            this._isDSTShifted = this.isValid() &&
                compareArrays(c._a, other.toArray()) > 0;
        } else {
            this._isDSTShifted = false;
        }

        return this._isDSTShifted;
    }

    function isLocal () {
        return this.isValid() ? !this._isUTC : false;
    }

    function isUtcOffset () {
        return this.isValid() ? this._isUTC : false;
    }

    function isUtc () {
        return this.isValid() ? this._isUTC && this._offset === 0 : false;
    }

    // ASP.NET json date format regex
    var aspNetRegex = /^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;

    // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
    // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
    // and further modified to allow for strings containing both week and day
    var isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;

    function createDuration (input, key) {
        var duration = input,
            // matching against regexp is expensive, do it on demand
            match = null,
            sign,
            ret,
            diffRes;

        if (isDuration(input)) {
            duration = {
                ms : input._milliseconds,
                d  : input._days,
                M  : input._months
            };
        } else if (isNumber(input)) {
            duration = {};
            if (key) {
                duration[key] = input;
            } else {
                duration.milliseconds = input;
            }
        } else if (!!(match = aspNetRegex.exec(input))) {
            sign = (match[1] === '-') ? -1 : 1;
            duration = {
                y  : 0,
                d  : toInt(match[DATE])                         * sign,
                h  : toInt(match[HOUR])                         * sign,
                m  : toInt(match[MINUTE])                       * sign,
                s  : toInt(match[SECOND])                       * sign,
                ms : toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match
            };
        } else if (!!(match = isoRegex.exec(input))) {
            sign = (match[1] === '-') ? -1 : (match[1] === '+') ? 1 : 1;
            duration = {
                y : parseIso(match[2], sign),
                M : parseIso(match[3], sign),
                w : parseIso(match[4], sign),
                d : parseIso(match[5], sign),
                h : parseIso(match[6], sign),
                m : parseIso(match[7], sign),
                s : parseIso(match[8], sign)
            };
        } else if (duration == null) {// checks for null or undefined
            duration = {};
        } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
            diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));

            duration = {};
            duration.ms = diffRes.milliseconds;
            duration.M = diffRes.months;
        }

        ret = new Duration(duration);

        if (isDuration(input) && hasOwnProp(input, '_locale')) {
            ret._locale = input._locale;
        }

        return ret;
    }

    createDuration.fn = Duration.prototype;
    createDuration.invalid = createInvalid$1;

    function parseIso (inp, sign) {
        // We'd normally use ~~inp for this, but unfortunately it also
        // converts floats to ints.
        // inp may be undefined, so careful calling replace on it.
        var res = inp && parseFloat(inp.replace(',', '.'));
        // apply sign while we're at it
        return (isNaN(res) ? 0 : res) * sign;
    }

    function positiveMomentsDifference(base, other) {
        var res = {milliseconds: 0, months: 0};

        res.months = other.month() - base.month() +
            (other.year() - base.year()) * 12;
        if (base.clone().add(res.months, 'M').isAfter(other)) {
            --res.months;
        }

        res.milliseconds = +other - +(base.clone().add(res.months, 'M'));

        return res;
    }

    function momentsDifference(base, other) {
        var res;
        if (!(base.isValid() && other.isValid())) {
            return {milliseconds: 0, months: 0};
        }

        other = cloneWithOffset(other, base);
        if (base.isBefore(other)) {
            res = positiveMomentsDifference(base, other);
        } else {
            res = positiveMomentsDifference(other, base);
            res.milliseconds = -res.milliseconds;
            res.months = -res.months;
        }

        return res;
    }

    // TODO: remove 'name' arg after deprecation is removed
    function createAdder(direction, name) {
        return function (val, period) {
            var dur, tmp;
            //invert the arguments, but complain about it
            if (period !== null && !isNaN(+period)) {
                deprecateSimple(name, 'moment().' + name  + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' +
                'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
                tmp = val; val = period; period = tmp;
            }

            val = typeof val === 'string' ? +val : val;
            dur = createDuration(val, period);
            addSubtract(this, dur, direction);
            return this;
        };
    }

    function addSubtract (mom, duration, isAdding, updateOffset) {
        var milliseconds = duration._milliseconds,
            days = absRound(duration._days),
            months = absRound(duration._months);

        if (!mom.isValid()) {
            // No op
            return;
        }

        updateOffset = updateOffset == null ? true : updateOffset;

        if (months) {
            setMonth(mom, get(mom, 'Month') + months * isAdding);
        }
        if (days) {
            set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
        }
        if (milliseconds) {
            mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
        }
        if (updateOffset) {
            hooks.updateOffset(mom, days || months);
        }
    }

    var add      = createAdder(1, 'add');
    var subtract = createAdder(-1, 'subtract');

    function getCalendarFormat(myMoment, now) {
        var diff = myMoment.diff(now, 'days', true);
        return diff < -6 ? 'sameElse' :
                diff < -1 ? 'lastWeek' :
                diff < 0 ? 'lastDay' :
                diff < 1 ? 'sameDay' :
                diff < 2 ? 'nextDay' :
                diff < 7 ? 'nextWeek' : 'sameElse';
    }

    function calendar$1 (time, formats) {
        // We want to compare the start of today, vs this.
        // Getting start-of-today depends on whether we're local/utc/offset or not.
        var now = time || createLocal(),
            sod = cloneWithOffset(now, this).startOf('day'),
            format = hooks.calendarFormat(this, sod) || 'sameElse';

        var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);

        return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
    }

    function clone () {
        return new Moment(this);
    }

    function isAfter (input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
        if (units === 'millisecond') {
            return this.valueOf() > localInput.valueOf();
        } else {
            return localInput.valueOf() < this.clone().startOf(units).valueOf();
        }
    }

    function isBefore (input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
        if (units === 'millisecond') {
            return this.valueOf() < localInput.valueOf();
        } else {
            return this.clone().endOf(units).valueOf() < localInput.valueOf();
        }
    }

    function isBetween (from, to, units, inclusivity) {
        inclusivity = inclusivity || '()';
        return (inclusivity[0] === '(' ? this.isAfter(from, units) : !this.isBefore(from, units)) &&
            (inclusivity[1] === ')' ? this.isBefore(to, units) : !this.isAfter(to, units));
    }

    function isSame (input, units) {
        var localInput = isMoment(input) ? input : createLocal(input),
            inputMs;
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(units || 'millisecond');
        if (units === 'millisecond') {
            return this.valueOf() === localInput.valueOf();
        } else {
            inputMs = localInput.valueOf();
            return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
        }
    }

    function isSameOrAfter (input, units) {
        return this.isSame(input, units) || this.isAfter(input,units);
    }

    function isSameOrBefore (input, units) {
        return this.isSame(input, units) || this.isBefore(input,units);
    }

    function diff (input, units, asFloat) {
        var that,
            zoneDelta,
            output;

        if (!this.isValid()) {
            return NaN;
        }

        that = cloneWithOffset(input, this);

        if (!that.isValid()) {
            return NaN;
        }

        zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;

        units = normalizeUnits(units);

        switch (units) {
            case 'year': output = monthDiff(this, that) / 12; break;
            case 'month': output = monthDiff(this, that); break;
            case 'quarter': output = monthDiff(this, that) / 3; break;
            case 'second': output = (this - that) / 1e3; break; // 1000
            case 'minute': output = (this - that) / 6e4; break; // 1000 * 60
            case 'hour': output = (this - that) / 36e5; break; // 1000 * 60 * 60
            case 'day': output = (this - that - zoneDelta) / 864e5; break; // 1000 * 60 * 60 * 24, negate dst
            case 'week': output = (this - that - zoneDelta) / 6048e5; break; // 1000 * 60 * 60 * 24 * 7, negate dst
            default: output = this - that;
        }

        return asFloat ? output : absFloor(output);
    }

    function monthDiff (a, b) {
        // difference in months
        var wholeMonthDiff = ((b.year() - a.year()) * 12) + (b.month() - a.month()),
            // b is in (anchor - 1 month, anchor + 1 month)
            anchor = a.clone().add(wholeMonthDiff, 'months'),
            anchor2, adjust;

        if (b - anchor < 0) {
            anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
            // linear across the month
            adjust = (b - anchor) / (anchor - anchor2);
        } else {
            anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
            // linear across the month
            adjust = (b - anchor) / (anchor2 - anchor);
        }

        //check for negative zero, return zero if negative zero
        return -(wholeMonthDiff + adjust) || 0;
    }

    hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
    hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

    function toString () {
        return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
    }

    function toISOString(keepOffset) {
        if (!this.isValid()) {
            return null;
        }
        var utc = keepOffset !== true;
        var m = utc ? this.clone().utc() : this;
        if (m.year() < 0 || m.year() > 9999) {
            return formatMoment(m, utc ? 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');
        }
        if (isFunction(Date.prototype.toISOString)) {
            // native implementation is ~50x faster, use it when we can
            if (utc) {
                return this.toDate().toISOString();
            } else {
                return new Date(this.valueOf() + this.utcOffset() * 60 * 1000).toISOString().replace('Z', formatMoment(m, 'Z'));
            }
        }
        return formatMoment(m, utc ? 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYY-MM-DD[T]HH:mm:ss.SSSZ');
    }

    /**
     * Return a human readable representation of a moment that can
     * also be evaluated to get a new moment which is the same
     *
     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
     */
    function inspect () {
        if (!this.isValid()) {
            return 'moment.invalid(/* ' + this._i + ' */)';
        }
        var func = 'moment';
        var zone = '';
        if (!this.isLocal()) {
            func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
            zone = 'Z';
        }
        var prefix = '[' + func + '("]';
        var year = (0 <= this.year() && this.year() <= 9999) ? 'YYYY' : 'YYYYYY';
        var datetime = '-MM-DD[T]HH:mm:ss.SSS';
        var suffix = zone + '[")]';

        return this.format(prefix + year + datetime + suffix);
    }

    function format (inputString) {
        if (!inputString) {
            inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
        }
        var output = formatMoment(this, inputString);
        return this.localeData().postformat(output);
    }

    function from (time, withoutSuffix) {
        if (this.isValid() &&
                ((isMoment(time) && time.isValid()) ||
                 createLocal(time).isValid())) {
            return createDuration({to: this, from: time}).locale(this.locale()).humanize(!withoutSuffix);
        } else {
            return this.localeData().invalidDate();
        }
    }

    function fromNow (withoutSuffix) {
        return this.from(createLocal(), withoutSuffix);
    }

    function to (time, withoutSuffix) {
        if (this.isValid() &&
                ((isMoment(time) && time.isValid()) ||
                 createLocal(time).isValid())) {
            return createDuration({from: this, to: time}).locale(this.locale()).humanize(!withoutSuffix);
        } else {
            return this.localeData().invalidDate();
        }
    }

    function toNow (withoutSuffix) {
        return this.to(createLocal(), withoutSuffix);
    }

    // If passed a locale key, it will set the locale for this
    // instance.  Otherwise, it will return the locale configuration
    // variables for this instance.
    function locale (key) {
        var newLocaleData;

        if (key === undefined) {
            return this._locale._abbr;
        } else {
            newLocaleData = getLocale(key);
            if (newLocaleData != null) {
                this._locale = newLocaleData;
            }
            return this;
        }
    }

    var lang = deprecate(
        'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',
        function (key) {
            if (key === undefined) {
                return this.localeData();
            } else {
                return this.locale(key);
            }
        }
    );

    function localeData () {
        return this._locale;
    }

    function startOf (units) {
        units = normalizeUnits(units);
        // the following switch intentionally omits break keywords
        // to utilize falling through the cases.
        switch (units) {
            case 'year':
                this.month(0);
                /* falls through */
            case 'quarter':
            case 'month':
                this.date(1);
                /* falls through */
            case 'week':
            case 'isoWeek':
            case 'day':
            case 'date':
                this.hours(0);
                /* falls through */
            case 'hour':
                this.minutes(0);
                /* falls through */
            case 'minute':
                this.seconds(0);
                /* falls through */
            case 'second':
                this.milliseconds(0);
        }

        // weeks are a special case
        if (units === 'week') {
            this.weekday(0);
        }
        if (units === 'isoWeek') {
            this.isoWeekday(1);
        }

        // quarters are also special
        if (units === 'quarter') {
            this.month(Math.floor(this.month() / 3) * 3);
        }

        return this;
    }

    function endOf (units) {
        units = normalizeUnits(units);
        if (units === undefined || units === 'millisecond') {
            return this;
        }

        // 'date' is an alias for 'day', so it should be considered as such.
        if (units === 'date') {
            units = 'day';
        }

        return this.startOf(units).add(1, (units === 'isoWeek' ? 'week' : units)).subtract(1, 'ms');
    }

    function valueOf () {
        return this._d.valueOf() - ((this._offset || 0) * 60000);
    }

    function unix () {
        return Math.floor(this.valueOf() / 1000);
    }

    function toDate () {
        return new Date(this.valueOf());
    }

    function toArray () {
        var m = this;
        return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
    }

    function toObject () {
        var m = this;
        return {
            years: m.year(),
            months: m.month(),
            date: m.date(),
            hours: m.hours(),
            minutes: m.minutes(),
            seconds: m.seconds(),
            milliseconds: m.milliseconds()
        };
    }

    function toJSON () {
        // new Date(NaN).toJSON() === null
        return this.isValid() ? this.toISOString() : null;
    }

    function isValid$2 () {
        return isValid(this);
    }

    function parsingFlags () {
        return extend({}, getParsingFlags(this));
    }

    function invalidAt () {
        return getParsingFlags(this).overflow;
    }

    function creationData() {
        return {
            input: this._i,
            format: this._f,
            locale: this._locale,
            isUTC: this._isUTC,
            strict: this._strict
        };
    }

    // FORMATTING

    addFormatToken(0, ['gg', 2], 0, function () {
        return this.weekYear() % 100;
    });

    addFormatToken(0, ['GG', 2], 0, function () {
        return this.isoWeekYear() % 100;
    });

    function addWeekYearFormatToken (token, getter) {
        addFormatToken(0, [token, token.length], 0, getter);
    }

    addWeekYearFormatToken('gggg',     'weekYear');
    addWeekYearFormatToken('ggggg',    'weekYear');
    addWeekYearFormatToken('GGGG',  'isoWeekYear');
    addWeekYearFormatToken('GGGGG', 'isoWeekYear');

    // ALIASES

    addUnitAlias('weekYear', 'gg');
    addUnitAlias('isoWeekYear', 'GG');

    // PRIORITY

    addUnitPriority('weekYear', 1);
    addUnitPriority('isoWeekYear', 1);


    // PARSING

    addRegexToken('G',      matchSigned);
    addRegexToken('g',      matchSigned);
    addRegexToken('GG',     match1to2, match2);
    addRegexToken('gg',     match1to2, match2);
    addRegexToken('GGGG',   match1to4, match4);
    addRegexToken('gggg',   match1to4, match4);
    addRegexToken('GGGGG',  match1to6, match6);
    addRegexToken('ggggg',  match1to6, match6);

    addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
        week[token.substr(0, 2)] = toInt(input);
    });

    addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
        week[token] = hooks.parseTwoDigitYear(input);
    });

    // MOMENTS

    function getSetWeekYear (input) {
        return getSetWeekYearHelper.call(this,
                input,
                this.week(),
                this.weekday(),
                this.localeData()._week.dow,
                this.localeData()._week.doy);
    }

    function getSetISOWeekYear (input) {
        return getSetWeekYearHelper.call(this,
                input, this.isoWeek(), this.isoWeekday(), 1, 4);
    }

    function getISOWeeksInYear () {
        return weeksInYear(this.year(), 1, 4);
    }

    function getWeeksInYear () {
        var weekInfo = this.localeData()._week;
        return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
    }

    function getSetWeekYearHelper(input, week, weekday, dow, doy) {
        var weeksTarget;
        if (input == null) {
            return weekOfYear(this, dow, doy).year;
        } else {
            weeksTarget = weeksInYear(input, dow, doy);
            if (week > weeksTarget) {
                week = weeksTarget;
            }
            return setWeekAll.call(this, input, week, weekday, dow, doy);
        }
    }

    function setWeekAll(weekYear, week, weekday, dow, doy) {
        var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
            date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);

        this.year(date.getUTCFullYear());
        this.month(date.getUTCMonth());
        this.date(date.getUTCDate());
        return this;
    }

    // FORMATTING

    addFormatToken('Q', 0, 'Qo', 'quarter');

    // ALIASES

    addUnitAlias('quarter', 'Q');

    // PRIORITY

    addUnitPriority('quarter', 7);

    // PARSING

    addRegexToken('Q', match1);
    addParseToken('Q', function (input, array) {
        array[MONTH] = (toInt(input) - 1) * 3;
    });

    // MOMENTS

    function getSetQuarter (input) {
        return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
    }

    // FORMATTING

    addFormatToken('D', ['DD', 2], 'Do', 'date');

    // ALIASES

    addUnitAlias('date', 'D');

    // PRIORITY
    addUnitPriority('date', 9);

    // PARSING

    addRegexToken('D',  match1to2);
    addRegexToken('DD', match1to2, match2);
    addRegexToken('Do', function (isStrict, locale) {
        // TODO: Remove "ordinalParse" fallback in next major release.
        return isStrict ?
          (locale._dayOfMonthOrdinalParse || locale._ordinalParse) :
          locale._dayOfMonthOrdinalParseLenient;
    });

    addParseToken(['D', 'DD'], DATE);
    addParseToken('Do', function (input, array) {
        array[DATE] = toInt(input.match(match1to2)[0]);
    });

    // MOMENTS

    var getSetDayOfMonth = makeGetSet('Date', true);

    // FORMATTING

    addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

    // ALIASES

    addUnitAlias('dayOfYear', 'DDD');

    // PRIORITY
    addUnitPriority('dayOfYear', 4);

    // PARSING

    addRegexToken('DDD',  match1to3);
    addRegexToken('DDDD', match3);
    addParseToken(['DDD', 'DDDD'], function (input, array, config) {
        config._dayOfYear = toInt(input);
    });

    // HELPERS

    // MOMENTS

    function getSetDayOfYear (input) {
        var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
        return input == null ? dayOfYear : this.add((input - dayOfYear), 'd');
    }

    // FORMATTING

    addFormatToken('m', ['mm', 2], 0, 'minute');

    // ALIASES

    addUnitAlias('minute', 'm');

    // PRIORITY

    addUnitPriority('minute', 14);

    // PARSING

    addRegexToken('m',  match1to2);
    addRegexToken('mm', match1to2, match2);
    addParseToken(['m', 'mm'], MINUTE);

    // MOMENTS

    var getSetMinute = makeGetSet('Minutes', false);

    // FORMATTING

    addFormatToken('s', ['ss', 2], 0, 'second');

    // ALIASES

    addUnitAlias('second', 's');

    // PRIORITY

    addUnitPriority('second', 15);

    // PARSING

    addRegexToken('s',  match1to2);
    addRegexToken('ss', match1to2, match2);
    addParseToken(['s', 'ss'], SECOND);

    // MOMENTS

    var getSetSecond = makeGetSet('Seconds', false);

    // FORMATTING

    addFormatToken('S', 0, 0, function () {
        return ~~(this.millisecond() / 100);
    });

    addFormatToken(0, ['SS', 2], 0, function () {
        return ~~(this.millisecond() / 10);
    });

    addFormatToken(0, ['SSS', 3], 0, 'millisecond');
    addFormatToken(0, ['SSSS', 4], 0, function () {
        return this.millisecond() * 10;
    });
    addFormatToken(0, ['SSSSS', 5], 0, function () {
        return this.millisecond() * 100;
    });
    addFormatToken(0, ['SSSSSS', 6], 0, function () {
        return this.millisecond() * 1000;
    });
    addFormatToken(0, ['SSSSSSS', 7], 0, function () {
        return this.millisecond() * 10000;
    });
    addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
        return this.millisecond() * 100000;
    });
    addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
        return this.millisecond() * 1000000;
    });


    // ALIASES

    addUnitAlias('millisecond', 'ms');

    // PRIORITY

    addUnitPriority('millisecond', 16);

    // PARSING

    addRegexToken('S',    match1to3, match1);
    addRegexToken('SS',   match1to3, match2);
    addRegexToken('SSS',  match1to3, match3);

    var token;
    for (token = 'SSSS'; token.length <= 9; token += 'S') {
        addRegexToken(token, matchUnsigned);
    }

    function parseMs(input, array) {
        array[MILLISECOND] = toInt(('0.' + input) * 1000);
    }

    for (token = 'S'; token.length <= 9; token += 'S') {
        addParseToken(token, parseMs);
    }
    // MOMENTS

    var getSetMillisecond = makeGetSet('Milliseconds', false);

    // FORMATTING

    addFormatToken('z',  0, 0, 'zoneAbbr');
    addFormatToken('zz', 0, 0, 'zoneName');

    // MOMENTS

    function getZoneAbbr () {
        return this._isUTC ? 'UTC' : '';
    }

    function getZoneName () {
        return this._isUTC ? 'Coordinated Universal Time' : '';
    }

    var proto = Moment.prototype;

    proto.add               = add;
    proto.calendar          = calendar$1;
    proto.clone             = clone;
    proto.diff              = diff;
    proto.endOf             = endOf;
    proto.format            = format;
    proto.from              = from;
    proto.fromNow           = fromNow;
    proto.to                = to;
    proto.toNow             = toNow;
    proto.get               = stringGet;
    proto.invalidAt         = invalidAt;
    proto.isAfter           = isAfter;
    proto.isBefore          = isBefore;
    proto.isBetween         = isBetween;
    proto.isSame            = isSame;
    proto.isSameOrAfter     = isSameOrAfter;
    proto.isSameOrBefore    = isSameOrBefore;
    proto.isValid           = isValid$2;
    proto.lang              = lang;
    proto.locale            = locale;
    proto.localeData        = localeData;
    proto.max               = prototypeMax;
    proto.min               = prototypeMin;
    proto.parsingFlags      = parsingFlags;
    proto.set               = stringSet;
    proto.startOf           = startOf;
    proto.subtract          = subtract;
    proto.toArray           = toArray;
    proto.toObject          = toObject;
    proto.toDate            = toDate;
    proto.toISOString       = toISOString;
    proto.inspect           = inspect;
    proto.toJSON            = toJSON;
    proto.toString          = toString;
    proto.unix              = unix;
    proto.valueOf           = valueOf;
    proto.creationData      = creationData;
    proto.year       = getSetYear;
    proto.isLeapYear = getIsLeapYear;
    proto.weekYear    = getSetWeekYear;
    proto.isoWeekYear = getSetISOWeekYear;
    proto.quarter = proto.quarters = getSetQuarter;
    proto.month       = getSetMonth;
    proto.daysInMonth = getDaysInMonth;
    proto.week           = proto.weeks        = getSetWeek;
    proto.isoWeek        = proto.isoWeeks     = getSetISOWeek;
    proto.weeksInYear    = getWeeksInYear;
    proto.isoWeeksInYear = getISOWeeksInYear;
    proto.date       = getSetDayOfMonth;
    proto.day        = proto.days             = getSetDayOfWeek;
    proto.weekday    = getSetLocaleDayOfWeek;
    proto.isoWeekday = getSetISODayOfWeek;
    proto.dayOfYear  = getSetDayOfYear;
    proto.hour = proto.hours = getSetHour;
    proto.minute = proto.minutes = getSetMinute;
    proto.second = proto.seconds = getSetSecond;
    proto.millisecond = proto.milliseconds = getSetMillisecond;
    proto.utcOffset            = getSetOffset;
    proto.utc                  = setOffsetToUTC;
    proto.local                = setOffsetToLocal;
    proto.parseZone            = setOffsetToParsedOffset;
    proto.hasAlignedHourOffset = hasAlignedHourOffset;
    proto.isDST                = isDaylightSavingTime;
    proto.isLocal              = isLocal;
    proto.isUtcOffset          = isUtcOffset;
    proto.isUtc                = isUtc;
    proto.isUTC                = isUtc;
    proto.zoneAbbr = getZoneAbbr;
    proto.zoneName = getZoneName;
    proto.dates  = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
    proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
    proto.years  = deprecate('years accessor is deprecated. Use year instead', getSetYear);
    proto.zone   = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
    proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);

    function createUnix (input) {
        return createLocal(input * 1000);
    }

    function createInZone () {
        return createLocal.apply(null, arguments).parseZone();
    }

    function preParsePostFormat (string) {
        return string;
    }

    var proto$1 = Locale.prototype;

    proto$1.calendar        = calendar;
    proto$1.longDateFormat  = longDateFormat;
    proto$1.invalidDate     = invalidDate;
    proto$1.ordinal         = ordinal;
    proto$1.preparse        = preParsePostFormat;
    proto$1.postformat      = preParsePostFormat;
    proto$1.relativeTime    = relativeTime;
    proto$1.pastFuture      = pastFuture;
    proto$1.set             = set;

    proto$1.months            =        localeMonths;
    proto$1.monthsShort       =        localeMonthsShort;
    proto$1.monthsParse       =        localeMonthsParse;
    proto$1.monthsRegex       = monthsRegex;
    proto$1.monthsShortRegex  = monthsShortRegex;
    proto$1.week = localeWeek;
    proto$1.firstDayOfYear = localeFirstDayOfYear;
    proto$1.firstDayOfWeek = localeFirstDayOfWeek;

    proto$1.weekdays       =        localeWeekdays;
    proto$1.weekdaysMin    =        localeWeekdaysMin;
    proto$1.weekdaysShort  =        localeWeekdaysShort;
    proto$1.weekdaysParse  =        localeWeekdaysParse;

    proto$1.weekdaysRegex       =        weekdaysRegex;
    proto$1.weekdaysShortRegex  =        weekdaysShortRegex;
    proto$1.weekdaysMinRegex    =        weekdaysMinRegex;

    proto$1.isPM = localeIsPM;
    proto$1.meridiem = localeMeridiem;

    function get$1 (format, index, field, setter) {
        var locale = getLocale();
        var utc = createUTC().set(setter, index);
        return locale[field](utc, format);
    }

    function listMonthsImpl (format, index, field) {
        if (isNumber(format)) {
            index = format;
            format = undefined;
        }

        format = format || '';

        if (index != null) {
            return get$1(format, index, field, 'month');
        }

        var i;
        var out = [];
        for (i = 0; i < 12; i++) {
            out[i] = get$1(format, i, field, 'month');
        }
        return out;
    }

    // ()
    // (5)
    // (fmt, 5)
    // (fmt)
    // (true)
    // (true, 5)
    // (true, fmt, 5)
    // (true, fmt)
    function listWeekdaysImpl (localeSorted, format, index, field) {
        if (typeof localeSorted === 'boolean') {
            if (isNumber(format)) {
                index = format;
                format = undefined;
            }

            format = format || '';
        } else {
            format = localeSorted;
            index = format;
            localeSorted = false;

            if (isNumber(format)) {
                index = format;
                format = undefined;
            }

            format = format || '';
        }

        var locale = getLocale(),
            shift = localeSorted ? locale._week.dow : 0;

        if (index != null) {
            return get$1(format, (index + shift) % 7, field, 'day');
        }

        var i;
        var out = [];
        for (i = 0; i < 7; i++) {
            out[i] = get$1(format, (i + shift) % 7, field, 'day');
        }
        return out;
    }

    function listMonths (format, index) {
        return listMonthsImpl(format, index, 'months');
    }

    function listMonthsShort (format, index) {
        return listMonthsImpl(format, index, 'monthsShort');
    }

    function listWeekdays (localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
    }

    function listWeekdaysShort (localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
    }

    function listWeekdaysMin (localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
    }

    getSetGlobalLocale('en', {
        dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (toInt(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        }
    });

    // Side effect imports

    hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
    hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);

    var mathAbs = Math.abs;

    function abs () {
        var data           = this._data;

        this._milliseconds = mathAbs(this._milliseconds);
        this._days         = mathAbs(this._days);
        this._months       = mathAbs(this._months);

        data.milliseconds  = mathAbs(data.milliseconds);
        data.seconds       = mathAbs(data.seconds);
        data.minutes       = mathAbs(data.minutes);
        data.hours         = mathAbs(data.hours);
        data.months        = mathAbs(data.months);
        data.years         = mathAbs(data.years);

        return this;
    }

    function addSubtract$1 (duration, input, value, direction) {
        var other = createDuration(input, value);

        duration._milliseconds += direction * other._milliseconds;
        duration._days         += direction * other._days;
        duration._months       += direction * other._months;

        return duration._bubble();
    }

    // supports only 2.0-style add(1, 's') or add(duration)
    function add$1 (input, value) {
        return addSubtract$1(this, input, value, 1);
    }

    // supports only 2.0-style subtract(1, 's') or subtract(duration)
    function subtract$1 (input, value) {
        return addSubtract$1(this, input, value, -1);
    }

    function absCeil (number) {
        if (number < 0) {
            return Math.floor(number);
        } else {
            return Math.ceil(number);
        }
    }

    function bubble () {
        var milliseconds = this._milliseconds;
        var days         = this._days;
        var months       = this._months;
        var data         = this._data;
        var seconds, minutes, hours, years, monthsFromDays;

        // if we have a mix of positive and negative values, bubble down first
        // check: https://github.com/moment/moment/issues/2166
        if (!((milliseconds >= 0 && days >= 0 && months >= 0) ||
                (milliseconds <= 0 && days <= 0 && months <= 0))) {
            milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
            days = 0;
            months = 0;
        }

        // The following code bubbles up values, see the tests for
        // examples of what that means.
        data.milliseconds = milliseconds % 1000;

        seconds           = absFloor(milliseconds / 1000);
        data.seconds      = seconds % 60;

        minutes           = absFloor(seconds / 60);
        data.minutes      = minutes % 60;

        hours             = absFloor(minutes / 60);
        data.hours        = hours % 24;

        days += absFloor(hours / 24);

        // convert days to months
        monthsFromDays = absFloor(daysToMonths(days));
        months += monthsFromDays;
        days -= absCeil(monthsToDays(monthsFromDays));

        // 12 months -> 1 year
        years = absFloor(months / 12);
        months %= 12;

        data.days   = days;
        data.months = months;
        data.years  = years;

        return this;
    }

    function daysToMonths (days) {
        // 400 years have 146097 days (taking into account leap year rules)
        // 400 years have 12 months === 4800
        return days * 4800 / 146097;
    }

    function monthsToDays (months) {
        // the reverse of daysToMonths
        return months * 146097 / 4800;
    }

    function as (units) {
        if (!this.isValid()) {
            return NaN;
        }
        var days;
        var months;
        var milliseconds = this._milliseconds;

        units = normalizeUnits(units);

        if (units === 'month' || units === 'year') {
            days   = this._days   + milliseconds / 864e5;
            months = this._months + daysToMonths(days);
            return units === 'month' ? months : months / 12;
        } else {
            // handle milliseconds separately because of floating point math errors (issue #1867)
            days = this._days + Math.round(monthsToDays(this._months));
            switch (units) {
                case 'week'   : return days / 7     + milliseconds / 6048e5;
                case 'day'    : return days         + milliseconds / 864e5;
                case 'hour'   : return days * 24    + milliseconds / 36e5;
                case 'minute' : return days * 1440  + milliseconds / 6e4;
                case 'second' : return days * 86400 + milliseconds / 1000;
                // Math.floor prevents floating point math errors here
                case 'millisecond': return Math.floor(days * 864e5) + milliseconds;
                default: throw new Error('Unknown unit ' + units);
            }
        }
    }

    // TODO: Use this.as('ms')?
    function valueOf$1 () {
        if (!this.isValid()) {
            return NaN;
        }
        return (
            this._milliseconds +
            this._days * 864e5 +
            (this._months % 12) * 2592e6 +
            toInt(this._months / 12) * 31536e6
        );
    }

    function makeAs (alias) {
        return function () {
            return this.as(alias);
        };
    }

    var asMilliseconds = makeAs('ms');
    var asSeconds      = makeAs('s');
    var asMinutes      = makeAs('m');
    var asHours        = makeAs('h');
    var asDays         = makeAs('d');
    var asWeeks        = makeAs('w');
    var asMonths       = makeAs('M');
    var asYears        = makeAs('y');

    function clone$1 () {
        return createDuration(this);
    }

    function get$2 (units) {
        units = normalizeUnits(units);
        return this.isValid() ? this[units + 's']() : NaN;
    }

    function makeGetter(name) {
        return function () {
            return this.isValid() ? this._data[name] : NaN;
        };
    }

    var milliseconds = makeGetter('milliseconds');
    var seconds      = makeGetter('seconds');
    var minutes      = makeGetter('minutes');
    var hours        = makeGetter('hours');
    var days         = makeGetter('days');
    var months       = makeGetter('months');
    var years        = makeGetter('years');

    function weeks () {
        return absFloor(this.days() / 7);
    }

    var round = Math.round;
    var thresholds = {
        ss: 44,         // a few seconds to seconds
        s : 45,         // seconds to minute
        m : 45,         // minutes to hour
        h : 22,         // hours to day
        d : 26,         // days to month
        M : 11          // months to year
    };

    // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
    function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
        return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
    }

    function relativeTime$1 (posNegDuration, withoutSuffix, locale) {
        var duration = createDuration(posNegDuration).abs();
        var seconds  = round(duration.as('s'));
        var minutes  = round(duration.as('m'));
        var hours    = round(duration.as('h'));
        var days     = round(duration.as('d'));
        var months   = round(duration.as('M'));
        var years    = round(duration.as('y'));

        var a = seconds <= thresholds.ss && ['s', seconds]  ||
                seconds < thresholds.s   && ['ss', seconds] ||
                minutes <= 1             && ['m']           ||
                minutes < thresholds.m   && ['mm', minutes] ||
                hours   <= 1             && ['h']           ||
                hours   < thresholds.h   && ['hh', hours]   ||
                days    <= 1             && ['d']           ||
                days    < thresholds.d   && ['dd', days]    ||
                months  <= 1             && ['M']           ||
                months  < thresholds.M   && ['MM', months]  ||
                years   <= 1             && ['y']           || ['yy', years];

        a[2] = withoutSuffix;
        a[3] = +posNegDuration > 0;
        a[4] = locale;
        return substituteTimeAgo.apply(null, a);
    }

    // This function allows you to set the rounding function for relative time strings
    function getSetRelativeTimeRounding (roundingFunction) {
        if (roundingFunction === undefined) {
            return round;
        }
        if (typeof(roundingFunction) === 'function') {
            round = roundingFunction;
            return true;
        }
        return false;
    }

    // This function allows you to set a threshold for relative time strings
    function getSetRelativeTimeThreshold (threshold, limit) {
        if (thresholds[threshold] === undefined) {
            return false;
        }
        if (limit === undefined) {
            return thresholds[threshold];
        }
        thresholds[threshold] = limit;
        if (threshold === 's') {
            thresholds.ss = limit - 1;
        }
        return true;
    }

    function humanize (withSuffix) {
        if (!this.isValid()) {
            return this.localeData().invalidDate();
        }

        var locale = this.localeData();
        var output = relativeTime$1(this, !withSuffix, locale);

        if (withSuffix) {
            output = locale.pastFuture(+this, output);
        }

        return locale.postformat(output);
    }

    var abs$1 = Math.abs;

    function sign(x) {
        return ((x > 0) - (x < 0)) || +x;
    }

    function toISOString$1() {
        // for ISO strings we do not use the normal bubbling rules:
        //  * milliseconds bubble up until they become hours
        //  * days do not bubble at all
        //  * months bubble up until they become years
        // This is because there is no context-free conversion between hours and days
        // (think of clock changes)
        // and also not between days and months (28-31 days per month)
        if (!this.isValid()) {
            return this.localeData().invalidDate();
        }

        var seconds = abs$1(this._milliseconds) / 1000;
        var days         = abs$1(this._days);
        var months       = abs$1(this._months);
        var minutes, hours, years;

        // 3600 seconds -> 60 minutes -> 1 hour
        minutes           = absFloor(seconds / 60);
        hours             = absFloor(minutes / 60);
        seconds %= 60;
        minutes %= 60;

        // 12 months -> 1 year
        years  = absFloor(months / 12);
        months %= 12;


        // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
        var Y = years;
        var M = months;
        var D = days;
        var h = hours;
        var m = minutes;
        var s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, '') : '';
        var total = this.asSeconds();

        if (!total) {
            // this is the same as C#'s (Noda) and python (isodate)...
            // but not other JS (goog.date)
            return 'P0D';
        }

        var totalSign = total < 0 ? '-' : '';
        var ymSign = sign(this._months) !== sign(total) ? '-' : '';
        var daysSign = sign(this._days) !== sign(total) ? '-' : '';
        var hmsSign = sign(this._milliseconds) !== sign(total) ? '-' : '';

        return totalSign + 'P' +
            (Y ? ymSign + Y + 'Y' : '') +
            (M ? ymSign + M + 'M' : '') +
            (D ? daysSign + D + 'D' : '') +
            ((h || m || s) ? 'T' : '') +
            (h ? hmsSign + h + 'H' : '') +
            (m ? hmsSign + m + 'M' : '') +
            (s ? hmsSign + s + 'S' : '');
    }

    var proto$2 = Duration.prototype;

    proto$2.isValid        = isValid$1;
    proto$2.abs            = abs;
    proto$2.add            = add$1;
    proto$2.subtract       = subtract$1;
    proto$2.as             = as;
    proto$2.asMilliseconds = asMilliseconds;
    proto$2.asSeconds      = asSeconds;
    proto$2.asMinutes      = asMinutes;
    proto$2.asHours        = asHours;
    proto$2.asDays         = asDays;
    proto$2.asWeeks        = asWeeks;
    proto$2.asMonths       = asMonths;
    proto$2.asYears        = asYears;
    proto$2.valueOf        = valueOf$1;
    proto$2._bubble        = bubble;
    proto$2.clone          = clone$1;
    proto$2.get            = get$2;
    proto$2.milliseconds   = milliseconds;
    proto$2.seconds        = seconds;
    proto$2.minutes        = minutes;
    proto$2.hours          = hours;
    proto$2.days           = days;
    proto$2.weeks          = weeks;
    proto$2.months         = months;
    proto$2.years          = years;
    proto$2.humanize       = humanize;
    proto$2.toISOString    = toISOString$1;
    proto$2.toString       = toISOString$1;
    proto$2.toJSON         = toISOString$1;
    proto$2.locale         = locale;
    proto$2.localeData     = localeData;

    proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
    proto$2.lang = lang;

    // Side effect imports

    // FORMATTING

    addFormatToken('X', 0, 0, 'unix');
    addFormatToken('x', 0, 0, 'valueOf');

    // PARSING

    addRegexToken('x', matchSigned);
    addRegexToken('X', matchTimestamp);
    addParseToken('X', function (input, array, config) {
        config._d = new Date(parseFloat(input, 10) * 1000);
    });
    addParseToken('x', function (input, array, config) {
        config._d = new Date(toInt(input));
    });

    // Side effect imports


    hooks.version = '2.22.2';

    setHookCallback(createLocal);

    hooks.fn                    = proto;
    hooks.min                   = min;
    hooks.max                   = max;
    hooks.now                   = now;
    hooks.utc                   = createUTC;
    hooks.unix                  = createUnix;
    hooks.months                = listMonths;
    hooks.isDate                = isDate;
    hooks.locale                = getSetGlobalLocale;
    hooks.invalid               = createInvalid;
    hooks.duration              = createDuration;
    hooks.isMoment              = isMoment;
    hooks.weekdays              = listWeekdays;
    hooks.parseZone             = createInZone;
    hooks.localeData            = getLocale;
    hooks.isDuration            = isDuration;
    hooks.monthsShort           = listMonthsShort;
    hooks.weekdaysMin           = listWeekdaysMin;
    hooks.defineLocale          = defineLocale;
    hooks.updateLocale          = updateLocale;
    hooks.locales               = listLocales;
    hooks.weekdaysShort         = listWeekdaysShort;
    hooks.normalizeUnits        = normalizeUnits;
    hooks.relativeTimeRounding  = getSetRelativeTimeRounding;
    hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
    hooks.calendarFormat        = getCalendarFormat;
    hooks.prototype             = proto;

    // currently HTML5 input type only supports 24-hour formats
    hooks.HTML5_FMT = {
        DATETIME_LOCAL: 'YYYY-MM-DDTHH:mm',             // <input type="datetime-local" />
        DATETIME_LOCAL_SECONDS: 'YYYY-MM-DDTHH:mm:ss',  // <input type="datetime-local" step="1" />
        DATETIME_LOCAL_MS: 'YYYY-MM-DDTHH:mm:ss.SSS',   // <input type="datetime-local" step="0.001" />
        DATE: 'YYYY-MM-DD',                             // <input type="date" />
        TIME: 'HH:mm',                                  // <input type="time" />
        TIME_SECONDS: 'HH:mm:ss',                       // <input type="time" step="1" />
        TIME_MS: 'HH:mm:ss.SSS',                        // <input type="time" step="0.001" />
        WEEK: 'YYYY-[W]WW',                             // <input type="week" />
        MONTH: 'YYYY-MM'                                // <input type="month" />
    };

    return hooks;

})));

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(60)(module)))

/***/ }),
/* 42 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 43 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NetworkStatus", function() { return NetworkStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNetworkRequestInFlight", function() { return isNetworkRequestInFlight; });
/**
 * The current status of a query’s execution in our system.
 */
var NetworkStatus;
(function (NetworkStatus) {
    /**
     * The query has never been run before and the query is now currently running. A query will still
     * have this network status even if a partial data result was returned from the cache, but a
     * query was dispatched anyway.
     */
    NetworkStatus[NetworkStatus["loading"] = 1] = "loading";
    /**
     * If `setVariables` was called and a query was fired because of that then the network status
     * will be `setVariables` until the result of that query comes back.
     */
    NetworkStatus[NetworkStatus["setVariables"] = 2] = "setVariables";
    /**
     * Indicates that `fetchMore` was called on this query and that the query created is currently in
     * flight.
     */
    NetworkStatus[NetworkStatus["fetchMore"] = 3] = "fetchMore";
    /**
     * Similar to the `setVariables` network status. It means that `refetch` was called on a query
     * and the refetch request is currently in flight.
     */
    NetworkStatus[NetworkStatus["refetch"] = 4] = "refetch";
    /**
     * Indicates that a polling query is currently in flight. So for example if you are polling a
     * query every 10 seconds then the network status will switch to `poll` every 10 seconds whenever
     * a poll request has been sent but not resolved.
     */
    NetworkStatus[NetworkStatus["poll"] = 6] = "poll";
    /**
     * No request is in flight for this query, and no errors happened. Everything is OK.
     */
    NetworkStatus[NetworkStatus["ready"] = 7] = "ready";
    /**
     * No request is in flight for this query, but one or more errors were detected.
     */
    NetworkStatus[NetworkStatus["error"] = 8] = "error";
})(NetworkStatus || (NetworkStatus = {}));
/**
 * Returns true if there is currently a network request in flight according to a given network
 * status.
 */
function isNetworkRequestInFlight(networkStatus) {
    return networkStatus < 7;
}


/***/ }),
/* 44 */
/***/ (function(module, exports) {

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

module.exports = _defineProperty;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(19),
    isObject = __webpack_require__(9);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(45),
    isLength = __webpack_require__(147);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  log: function log() {
    if (false) { var _console; }
  },
  error: function error() {
    if (false) { var _console2; }
  }
};
exports["default"] = _default;

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

var arrayWithHoles = __webpack_require__(252);

var iterableToArrayLimit = __webpack_require__(530);

var nonIterableRest = __webpack_require__(253);

function _slicedToArray(arr, i) {
  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || nonIterableRest();
}

module.exports = _slicedToArray;

/***/ }),
/* 49 */
/***/ (function(module, exports) {

function _typeof2(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof2 = function _typeof2(obj) { return typeof obj; }; } else { _typeof2 = function _typeof2(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof2(obj); }

function _typeof(obj) {
  if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
    module.exports = _typeof = function _typeof(obj) {
      return _typeof2(obj);
    };
  } else {
    module.exports = _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
    };
  }

  return _typeof(obj);
}

module.exports = _typeof;

/***/ }),
/* 50 */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(4);
var setGlobal = __webpack_require__(112);
var IS_PURE = __webpack_require__(73);

var SHARED = '__core-js_shared__';
var store = global[SHARED] || setGlobal(SHARED, {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.1.3',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2019 Denis Pushkarev (zloirock.ru)'
});


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(30);

var max = Math.max;
var min = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(length, length).
module.exports = function (index, length) {
  var integer = toInteger(index);
  return integer < 0 ? max(integer + length, 0) : min(integer, length);
};


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var toPrimitive = __webpack_require__(71);
var definePropertyModule = __webpack_require__(13);
var createPropertyDescriptor = __webpack_require__(50);

module.exports = function (object, key, value) {
  var propertyKey = toPrimitive(key);
  if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
  else object[propertyKey] = value;
};


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(17);
var isArray = __webpack_require__(31);
var wellKnownSymbol = __webpack_require__(3);

var SPECIES = wellKnownSymbol('species');

// `ArraySpeciesCreate` abstract operation
// https://tc39.github.io/ecma262/#sec-arrayspeciescreate
module.exports = function (originalArray, length) {
  var C;
  if (isArray(originalArray)) {
    C = originalArray.constructor;
    // cross-realm fallback
    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
    else if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
};


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(11);
var wellKnownSymbol = __webpack_require__(3);

var SPECIES = wellKnownSymbol('species');

module.exports = function (METHOD_NAME) {
  return !fails(function () {
    var array = [];
    var constructor = array.constructor = {};
    constructor[SPECIES] = function () {
      return { foo: 1 };
    };
    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

var defineProperty = __webpack_require__(13).f;
var has = __webpack_require__(12);
var wellKnownSymbol = __webpack_require__(3);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');

module.exports = function (it, TAG, STATIC) {
  if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
    defineProperty(it, TO_STRING_TAG, { configurable: true, value: TAG });
  }
};


/***/ }),
/* 57 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 58 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FetchType", function() { return FetchType; });
var FetchType;
(function (FetchType) {
    FetchType[FetchType["normal"] = 1] = "normal";
    FetchType[FetchType["refetch"] = 2] = "refetch";
    FetchType[FetchType["poll"] = 3] = "poll";
})(FetchType || (FetchType = {}));


/***/ }),
/* 59 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _directives__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(191);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDirectiveInfoFromField", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["getDirectiveInfoFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "shouldInclude", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["shouldInclude"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "flattenSelections", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["flattenSelections"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDirectiveNames", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["getDirectiveNames"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "hasDirectives", function() { return _directives__WEBPACK_IMPORTED_MODULE_0__["hasDirectives"]; });

/* harmony import */ var _fragments__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(192);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFragmentQueryDocument", function() { return _fragments__WEBPACK_IMPORTED_MODULE_1__["getFragmentQueryDocument"]; });

/* harmony import */ var _getFromAST__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(127);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMutationDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getMutationDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "checkDocument", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["checkDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getOperationDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinitionOrDie", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getOperationDefinitionOrDie"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getOperationName", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getOperationName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinitions", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getFragmentDefinitions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getQueryDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getQueryDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getFragmentDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMainDefinition", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getMainDefinition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createFragmentMap", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["createFragmentMap"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDefaultValues", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["getDefaultValues"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "variablesInOperation", function() { return _getFromAST__WEBPACK_IMPORTED_MODULE_2__["variablesInOperation"]; });

/* harmony import */ var _transform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(193);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "removeDirectivesFromDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["removeDirectivesFromDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addTypenameToDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["addTypenameToDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "removeConnectionDirectiveFromDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["removeConnectionDirectiveFromDocument"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getDirectivesFromDocument", function() { return _transform__WEBPACK_IMPORTED_MODULE_3__["getDirectivesFromDocument"]; });

/* harmony import */ var _storeUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(88);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isScalarValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isScalarValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isNumberValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isNumberValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "valueToObjectRepresentation", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["valueToObjectRepresentation"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "storeKeyNameFromField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["storeKeyNameFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getStoreKeyName", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["getStoreKeyName"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "argumentsObjectFromField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["argumentsObjectFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "resultKeyNameFromField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["resultKeyNameFromField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isField", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isField"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isInlineFragment", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isInlineFragment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isIdValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isIdValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toIdValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["toIdValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isJsonValue", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["isJsonValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "valueFromNode", function() { return _storeUtils__WEBPACK_IMPORTED_MODULE_4__["valueFromNode"]; });

/* harmony import */ var _util_assign__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(128);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return _util_assign__WEBPACK_IMPORTED_MODULE_5__["assign"]; });

/* harmony import */ var _util_cloneDeep__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(129);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "cloneDeep", function() { return _util_cloneDeep__WEBPACK_IMPORTED_MODULE_6__["cloneDeep"]; });

/* harmony import */ var _util_environment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(89);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getEnv", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["getEnv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isEnv", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isEnv"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isProduction", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isProduction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isDevelopment", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isDevelopment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isTest", function() { return _util_environment__WEBPACK_IMPORTED_MODULE_7__["isTest"]; });

/* harmony import */ var _util_errorHandling__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(194);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "tryFunctionOrLogError", function() { return _util_errorHandling__WEBPACK_IMPORTED_MODULE_8__["tryFunctionOrLogError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "graphQLResultHasError", function() { return _util_errorHandling__WEBPACK_IMPORTED_MODULE_8__["graphQLResultHasError"]; });

/* harmony import */ var _util_isEqual__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(195);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isEqual", function() { return _util_isEqual__WEBPACK_IMPORTED_MODULE_9__["isEqual"]; });

/* harmony import */ var _util_maybeDeepFreeze__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(196);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "maybeDeepFreeze", function() { return _util_maybeDeepFreeze__WEBPACK_IMPORTED_MODULE_10__["maybeDeepFreeze"]; });

/* harmony import */ var _util_warnOnce__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(197);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "warnOnceInDevelopment", function() { return _util_warnOnce__WEBPACK_IMPORTED_MODULE_11__["warnOnceInDevelopment"]; });

/* harmony import */ var _util_stripSymbols__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(198);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "stripSymbols", function() { return _util_stripSymbols__WEBPACK_IMPORTED_MODULE_12__["stripSymbols"]; });
















/***/ }),
/* 60 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if (!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if (!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 61 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__extends", function() { return __extends; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__assign", function() { return __assign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__rest", function() { return __rest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__decorate", function() { return __decorate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__param", function() { return __param; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__metadata", function() { return __metadata; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__awaiter", function() { return __awaiter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__generator", function() { return __generator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__exportStar", function() { return __exportStar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__values", function() { return __values; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__read", function() { return __read; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__spread", function() { return __spread; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__await", function() { return __await; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__asyncGenerator", function() { return __asyncGenerator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__asyncDelegator", function() { return __asyncDelegator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__asyncValues", function() { return __asyncValues; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__makeTemplateObject", function() { return __makeTemplateObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__importStar", function() { return __importStar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__importDefault", function() { return __importDefault; });
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __exportStar(m, exports) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}

function __values(o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result.default = mod;
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault2 = __webpack_require__(0);

var _toConsumableArray2 = _interopRequireDefault2(__webpack_require__(92));

var _classCallCheck2 = _interopRequireDefault2(__webpack_require__(28));

var _createClass2 = _interopRequireDefault2(__webpack_require__(141));

var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateShippingOptionsFromMethods = exports.generateDisplayItemsFromOrder = exports.StripeStore = void 0;

var _StyleMapObserver = _interopRequireDefault(__webpack_require__(204));

var _debug = _interopRequireDefault(__webpack_require__(47));

var _constants = __webpack_require__(15);
/* globals window */


var StripeStore =
/*#__PURE__*/
function () {
  function StripeStore(docElement) {
    (0, _classCallCheck2["default"])(this, StripeStore);

    if (window.Webflow.env('design') || window.Webflow.env('preview')) {
      return;
    }

    var stripeJsElement = docElement.querySelector("[".concat(_constants.STRIPE_ECOMMERCE_KEY, "]"));

    if (!stripeJsElement) {
      this.store = {
        initialized: false,
        stripe: {},
        elements: [],
        elementInstances: [],
        cartPaymentRequests: [],
        styleMapObservers: {}
      };
      return _debug["default"].error("Stripe has not been set up for this project – Go to the project's Ecommerce Payment settings in the Designer to link Stripe.");
    }

    var ecommKey = stripeJsElement.getAttribute(_constants.STRIPE_ECOMMERCE_KEY);
    var ecommAccountId = stripeJsElement.getAttribute(_constants.STRIPE_ECOMMERCE_ACCOUNT_ID);
    var stripeOpts = ecommAccountId ? {
      stripeAccount: ecommAccountId
    } : null;
    var stripe = window.Stripe(ecommKey, stripeOpts);
    this.store = {
      initialized: true,
      stripe: stripe,
      elements: [],
      elementInstances: [],
      cartPaymentRequests: [],
      styleMapObservers: {}
    };
  }

  (0, _createClass2["default"])(StripeStore, [{
    key: "isInitialized",
    value: function isInitialized() {
      return this.store.initialized;
    }
  }, {
    key: "getStripeInstance",
    value: function getStripeInstance() {
      return this.store.stripe;
    }
  }, {
    key: "getElementsInstance",
    value: function getElementsInstance(index) {
      return this.store.elements[index];
    }
  }, {
    key: "getElement",
    value: function getElement(type, index) {
      return this.store.elementInstances[index][type];
    }
  }, {
    key: "createElementsInstance",
    value: function createElementsInstance(index) {
      if (this.store.elements[index]) {
        throw new Error("Storage already exists for checkout form instance ".concat(index));
      } else {
        var stripeInstance = this.getStripeInstance();
        this.store.elements[index] = stripeInstance.elements();
        this.store.elementInstances[index] = {};
      }
    } // FIXME: weak type is used
    // eslint-disable-next-line flowtype/no-weak-types

  }, {
    key: "createElement",
    value: function createElement(type, index, options) {
      if (!this.isInitialized()) {
        throw new Error("Stripe has not been set up for this project – Go to the project's Ecommerce Payment settings in the Designer to link Stripe.");
      }

      if (this.store.elementInstances[index][type]) {
        throw new Error("Stripe Element of type ".concat(type, " for instance ").concat(index, " already exists on this page"));
      }

      var el = this.store.elements[index].create(type, options);
      this.store.elementInstances[index][type] = el;
      return el;
    } // FIXME: weak type is used
    // eslint-disable-next-line flowtype/no-weak-types

  }, {
    key: "updateCartPaymentRequest",
    value: function updateCartPaymentRequest(index, orderData, siteData) {
      var stripeInstance = this.getStripeInstance();
      var requiresShipping = Boolean(orderData.statusFlags.requiresShipping);
      var options = {
        country: siteData.businessAddress.country || siteData.defaultCountry || 'US',
        currency: siteData.defaultCurrency.toLowerCase(),
        total: {
          amount: orderData.subtotal.value,
          label: 'Subtotal',
          pending: true
        },
        displayItems: generateDisplayItemsFromOrder(orderData, false),
        requestPayerName: true,
        requestPayerEmail: true,
        requestPayerPhone: false,
        requestShipping: requiresShipping
      };

      try {
        this.store.cartPaymentRequests[index] = stripeInstance.paymentRequest(options);
      } catch (error) {
        var ignoreError = false; // Stripe errors are `IntegrationError`s

        if (error.name === 'IntegrationError') {
          var unsupportedCountryPattern = /country should be one of the following strings(?:.*)You specified: (.*)./;
          var matches = error.message.match(unsupportedCountryPattern);
          ignoreError = Boolean(matches);
        } // We want the error to carry on if it's not exactly what we're looking for.


        if (!ignoreError) {
          throw error;
        } else {
          console.error(error);
        }
      }

      return this.store.cartPaymentRequests[index];
    }
  }, {
    key: "getCartPaymentRequest",
    value: function getCartPaymentRequest(index) {
      return this.store.cartPaymentRequests[index];
    }
  }]);
  return StripeStore;
}();

exports.StripeStore = StripeStore;

var generateDisplayItemsFromOrder = function generateDisplayItemsFromOrder( // FIXME: weak type is used
// eslint-disable-next-line flowtype/no-weak-types
orderData, showExtraItems) {
  return [].concat((0, _toConsumableArray2["default"])(orderData.userItems.map(function (item) {
    return {
      label: "".concat(item.product.f_name_, " ").concat(item.count > 1 ? "(".concat(item.count, ")") : ''),
      amount: item.rowTotal.value
    };
  })), (0, _toConsumableArray2["default"])(showExtraItems ? orderData.extraItems.map(function (item) {
    return {
      label: item.name,
      amount: item.price.value
    };
  }) : []));
};

exports.generateDisplayItemsFromOrder = generateDisplayItemsFromOrder;

var generateShippingOptionsFromMethods = function generateShippingOptionsFromMethods(shippingMethods) {
  return shippingMethods.map(function (method) {
    return {
      id: method.id,
      label: method.name,
      detail: method.description || '',
      amount: method.price.value
    };
  });
};

exports.generateShippingOptionsFromMethods = generateShippingOptionsFromMethods;

/***/ }),
/* 63 */
/***/ (function(module, exports) {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__(14);

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(14),
    stubFalse = __webpack_require__(434);

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

module.exports = isBuffer;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(60)(module)))

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(219),
    baseAssignValue = __webpack_require__(98);

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

module.exports = copyObject;


/***/ }),
/* 67 */
/***/ (function(module, exports) {

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

var DataView = __webpack_require__(501),
    Map = __webpack_require__(142),
    Promise = __webpack_require__(502),
    Set = __webpack_require__(503),
    WeakMap = __webpack_require__(504),
    baseGetTag = __webpack_require__(19),
    toSource = __webpack_require__(207);

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

module.exports = getTag;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(11);
var classof = __webpack_require__(111);

var split = ''.split;

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins
  return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;


/***/ }),
/* 70 */
/***/ (function(module, exports) {

// `RequireObjectCoercible` abstract operation
// https://tc39.github.io/ecma262/#sec-requireobjectcoercible
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on " + it);
  return it;
};


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(17);

// `ToPrimitive` abstract operation
// https://tc39.github.io/ecma262/#sec-toprimitive
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (input, PREFERRED_STRING) {
  if (!isObject(input)) return input;
  var fn, val;
  if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
  if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input))) return val;
  if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(4);
var shared = __webpack_require__(51);
var hide = __webpack_require__(22);
var has = __webpack_require__(12);
var setGlobal = __webpack_require__(112);
var nativeFunctionToString = __webpack_require__(163);
var InternalStateModule = __webpack_require__(74);

var getInternalState = InternalStateModule.get;
var enforceInternalState = InternalStateModule.enforce;
var TEMPLATE = String(nativeFunctionToString).split('toString');

shared('inspectSource', function (it) {
  return nativeFunctionToString.call(it);
});

(module.exports = function (O, key, value, options) {
  var unsafe = options ? !!options.unsafe : false;
  var simple = options ? !!options.enumerable : false;
  var noTargetGet = options ? !!options.noTargetGet : false;
  if (typeof value == 'function') {
    if (typeof key == 'string' && !has(value, 'name')) hide(value, 'name', key);
    enforceInternalState(value).source = TEMPLATE.join(typeof key == 'string' ? key : '');
  }
  if (O === global) {
    if (simple) O[key] = value;
    else setGlobal(key, value);
    return;
  } else if (!unsafe) {
    delete O[key];
  } else if (!noTargetGet && O[key]) {
    simple = true;
  }
  if (simple) O[key] = value;
  else hide(O, key, value);
// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
})(Function.prototype, 'toString', function toString() {
  return typeof this == 'function' && getInternalState(this).source || nativeFunctionToString.call(this);
});


/***/ }),
/* 73 */
/***/ (function(module, exports) {

module.exports = false;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

var NATIVE_WEAK_MAP = __webpack_require__(282);
var global = __webpack_require__(4);
var isObject = __webpack_require__(17);
var hide = __webpack_require__(22);
var objectHas = __webpack_require__(12);
var sharedKey = __webpack_require__(75);
var hiddenKeys = __webpack_require__(76);

var WeakMap = global.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject(it) || (state = get(it)).type !== TYPE) {
      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP) {
  var store = new WeakMap();
  var wmget = store.get;
  var wmhas = store.has;
  var wmset = store.set;
  set = function (it, metadata) {
    wmset.call(store, it, metadata);
    return metadata;
  };
  get = function (it) {
    return wmget.call(store, it) || {};
  };
  has = function (it) {
    return wmhas.call(store, it);
  };
} else {
  var STATE = sharedKey('state');
  hiddenKeys[STATE] = true;
  set = function (it, metadata) {
    hide(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return objectHas(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return objectHas(it, STATE);
  };
}

module.exports = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(51);
var uid = __webpack_require__(113);

var keys = shared('keys');

module.exports = function (key) {
  return keys[key] || (keys[key] = uid(key));
};


/***/ }),
/* 76 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(4);


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

var aFunction = __webpack_require__(79);

// optional / simple context binding
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 0: return function () {
      return fn.call(that);
    };
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),
/* 79 */
/***/ (function(module, exports) {

module.exports = function (it) {
  if (typeof it != 'function') {
    throw TypeError(String(it) + ' is not a function');
  } return it;
};


/***/ }),
/* 80 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var graphql_language_printer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "printAST", function() { return graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__["print"]; });

/* harmony import */ var _core_ObservableQuery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ObservableQuery", function() { return _core_ObservableQuery__WEBPACK_IMPORTED_MODULE_1__["ObservableQuery"]; });

/* harmony import */ var _core_networkStatus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NetworkStatus", function() { return _core_networkStatus__WEBPACK_IMPORTED_MODULE_2__["NetworkStatus"]; });

/* harmony import */ var _core_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FetchType", function() { return _core_types__WEBPACK_IMPORTED_MODULE_3__["FetchType"]; });

/* harmony import */ var _errors_ApolloError__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(87);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ApolloError", function() { return _errors_ApolloError__WEBPACK_IMPORTED_MODULE_4__["ApolloError"]; });

/* harmony import */ var _ApolloClient__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(186);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ApolloClient", function() { return _ApolloClient__WEBPACK_IMPORTED_MODULE_5__["default"]; });







// export the client as both default and named

/* harmony default export */ __webpack_exports__["default"] = (_ApolloClient__WEBPACK_IMPORTED_MODULE_5__["default"]);


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visit = visit;
exports.visitInParallel = visitInParallel;
exports.visitWithTypeInfo = visitWithTypeInfo;
exports.getVisitFn = getVisitFn;


/**
 * A visitor is comprised of visit functions, which are called on each node
 * during the visitor's traversal.
 */


/**
 * A visitor is provided to visit, it contains the collection of
 * relevant functions to be called during the visitor's traversal.
 */
/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict
 */

var QueryDocumentKeys = exports.QueryDocumentKeys = {
  Name: [],

  Document: ['definitions'],
  OperationDefinition: ['name', 'variableDefinitions', 'directives', 'selectionSet'],
  VariableDefinition: ['variable', 'type', 'defaultValue'],
  Variable: ['name'],
  SelectionSet: ['selections'],
  Field: ['alias', 'name', 'arguments', 'directives', 'selectionSet'],
  Argument: ['name', 'value'],

  FragmentSpread: ['name', 'directives'],
  InlineFragment: ['typeCondition', 'directives', 'selectionSet'],
  FragmentDefinition: ['name',
  // Note: fragment variable definitions are experimental and may be changed
  // or removed in the future.
  'variableDefinitions', 'typeCondition', 'directives', 'selectionSet'],

  IntValue: [],
  FloatValue: [],
  StringValue: [],
  BooleanValue: [],
  NullValue: [],
  EnumValue: [],
  ListValue: ['values'],
  ObjectValue: ['fields'],
  ObjectField: ['name', 'value'],

  Directive: ['name', 'arguments'],

  NamedType: ['name'],
  ListType: ['type'],
  NonNullType: ['type'],

  SchemaDefinition: ['directives', 'operationTypes'],
  OperationTypeDefinition: ['type'],

  ScalarTypeDefinition: ['description', 'name', 'directives'],
  ObjectTypeDefinition: ['description', 'name', 'interfaces', 'directives', 'fields'],
  FieldDefinition: ['description', 'name', 'arguments', 'type', 'directives'],
  InputValueDefinition: ['description', 'name', 'type', 'defaultValue', 'directives'],
  InterfaceTypeDefinition: ['description', 'name', 'directives', 'fields'],
  UnionTypeDefinition: ['description', 'name', 'directives', 'types'],
  EnumTypeDefinition: ['description', 'name', 'directives', 'values'],
  EnumValueDefinition: ['description', 'name', 'directives'],
  InputObjectTypeDefinition: ['description', 'name', 'directives', 'fields'],

  ScalarTypeExtension: ['name', 'directives'],
  ObjectTypeExtension: ['name', 'interfaces', 'directives', 'fields'],
  InterfaceTypeExtension: ['name', 'directives', 'fields'],
  UnionTypeExtension: ['name', 'directives', 'types'],
  EnumTypeExtension: ['name', 'directives', 'values'],
  InputObjectTypeExtension: ['name', 'directives', 'fields'],

  DirectiveDefinition: ['description', 'name', 'arguments', 'locations']
};

/**
 * A KeyMap describes each the traversable properties of each kind of node.
 */
var BREAK = exports.BREAK = {};

/**
 * visit() will walk through an AST using a depth first traversal, calling
 * the visitor's enter function at each node in the traversal, and calling the
 * leave function after visiting that node and all of its child nodes.
 *
 * By returning different values from the enter and leave functions, the
 * behavior of the visitor can be altered, including skipping over a sub-tree of
 * the AST (by returning false), editing the AST by returning a value or null
 * to remove the value, or to stop the whole traversal by returning BREAK.
 *
 * When using visit() to edit an AST, the original AST will not be modified, and
 * a new version of the AST with the changes applied will be returned from the
 * visit function.
 *
 *     const editedAST = visit(ast, {
 *       enter(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: skip visiting this node
 *         //   visitor.BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       },
 *       leave(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: no action
 *         //   visitor.BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       }
 *     });
 *
 * Alternatively to providing enter() and leave() functions, a visitor can
 * instead provide functions named the same as the kinds of AST nodes, or
 * enter/leave visitors at a named key, leading to four permutations of
 * visitor API:
 *
 * 1) Named visitors triggered when entering a node a specific kind.
 *
 *     visit(ast, {
 *       Kind(node) {
 *         // enter the "Kind" node
 *       }
 *     })
 *
 * 2) Named visitors that trigger upon entering and leaving a node of
 *    a specific kind.
 *
 *     visit(ast, {
 *       Kind: {
 *         enter(node) {
 *           // enter the "Kind" node
 *         }
 *         leave(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 *
 * 3) Generic visitors that trigger upon entering and leaving any node.
 *
 *     visit(ast, {
 *       enter(node) {
 *         // enter any node
 *       },
 *       leave(node) {
 *         // leave any node
 *       }
 *     })
 *
 * 4) Parallel visitors for entering and leaving nodes of a specific kind.
 *
 *     visit(ast, {
 *       enter: {
 *         Kind(node) {
 *           // enter the "Kind" node
 *         }
 *       },
 *       leave: {
 *         Kind(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 */
function visit(root, visitor) {
  var visitorKeys = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : QueryDocumentKeys;

  /* eslint-disable no-undef-init */
  var stack = undefined;
  var inArray = Array.isArray(root);
  var keys = [root];
  var index = -1;
  var edits = [];
  var node = undefined;
  var key = undefined;
  var parent = undefined;
  var path = [];
  var ancestors = [];
  var newRoot = root;
  /* eslint-enable no-undef-init */

  do {
    index++;
    var isLeaving = index === keys.length;
    var isEdited = isLeaving && edits.length !== 0;
    if (isLeaving) {
      key = ancestors.length === 0 ? undefined : path[path.length - 1];
      node = parent;
      parent = ancestors.pop();
      if (isEdited) {
        if (inArray) {
          node = node.slice();
        } else {
          var clone = {};
          for (var k in node) {
            if (node.hasOwnProperty(k)) {
              clone[k] = node[k];
            }
          }
          node = clone;
        }
        var editOffset = 0;
        for (var ii = 0; ii < edits.length; ii++) {
          var editKey = edits[ii][0];
          var editValue = edits[ii][1];
          if (inArray) {
            editKey -= editOffset;
          }
          if (inArray && editValue === null) {
            node.splice(editKey, 1);
            editOffset++;
          } else {
            node[editKey] = editValue;
          }
        }
      }
      index = stack.index;
      keys = stack.keys;
      edits = stack.edits;
      inArray = stack.inArray;
      stack = stack.prev;
    } else {
      key = parent ? inArray ? index : keys[index] : undefined;
      node = parent ? parent[key] : newRoot;
      if (node === null || node === undefined) {
        continue;
      }
      if (parent) {
        path.push(key);
      }
    }

    var result = void 0;
    if (!Array.isArray(node)) {
      if (!isNode(node)) {
        throw new Error('Invalid AST Node: ' + JSON.stringify(node));
      }
      var visitFn = getVisitFn(visitor, node.kind, isLeaving);
      if (visitFn) {
        result = visitFn.call(visitor, node, key, parent, path, ancestors);

        if (result === BREAK) {
          break;
        }

        if (result === false) {
          if (!isLeaving) {
            path.pop();
            continue;
          }
        } else if (result !== undefined) {
          edits.push([key, result]);
          if (!isLeaving) {
            if (isNode(result)) {
              node = result;
            } else {
              path.pop();
              continue;
            }
          }
        }
      }
    }

    if (result === undefined && isEdited) {
      edits.push([key, node]);
    }

    if (isLeaving) {
      path.pop();
    } else {
      stack = { inArray: inArray, index: index, keys: keys, edits: edits, prev: stack };
      inArray = Array.isArray(node);
      keys = inArray ? node : visitorKeys[node.kind] || [];
      index = -1;
      edits = [];
      if (parent) {
        ancestors.push(parent);
      }
      parent = node;
    }
  } while (stack !== undefined);

  if (edits.length !== 0) {
    newRoot = edits[edits.length - 1][1];
  }

  return newRoot;
}

function isNode(maybeNode) {
  return Boolean(maybeNode && typeof maybeNode.kind === 'string');
}

/**
 * Creates a new visitor instance which delegates to many visitors to run in
 * parallel. Each visitor will be visited for each node before moving on.
 *
 * If a prior visitor edits a node, no following visitors will see that node.
 */
function visitInParallel(visitors) {
  var skipping = new Array(visitors.length);

  return {
    enter: function enter(node) {
      for (var i = 0; i < visitors.length; i++) {
        if (!skipping[i]) {
          var fn = getVisitFn(visitors[i], node.kind, /* isLeaving */false);
          if (fn) {
            var result = fn.apply(visitors[i], arguments);
            if (result === false) {
              skipping[i] = node;
            } else if (result === BREAK) {
              skipping[i] = BREAK;
            } else if (result !== undefined) {
              return result;
            }
          }
        }
      }
    },
    leave: function leave(node) {
      for (var i = 0; i < visitors.length; i++) {
        if (!skipping[i]) {
          var fn = getVisitFn(visitors[i], node.kind, /* isLeaving */true);
          if (fn) {
            var result = fn.apply(visitors[i], arguments);
            if (result === BREAK) {
              skipping[i] = BREAK;
            } else if (result !== undefined && result !== false) {
              return result;
            }
          }
        } else if (skipping[i] === node) {
          skipping[i] = null;
        }
      }
    }
  };
}

/**
 * Creates a new visitor instance which maintains a provided TypeInfo instance
 * along with visiting visitor.
 */
function visitWithTypeInfo(typeInfo, visitor) {
  return {
    enter: function enter(node) {
      typeInfo.enter(node);
      var fn = getVisitFn(visitor, node.kind, /* isLeaving */false);
      if (fn) {
        var result = fn.apply(visitor, arguments);
        if (result !== undefined) {
          typeInfo.leave(node);
          if (isNode(result)) {
            typeInfo.enter(result);
          }
        }
        return result;
      }
    },
    leave: function leave(node) {
      var fn = getVisitFn(visitor, node.kind, /* isLeaving */true);
      var result = void 0;
      if (fn) {
        result = fn.apply(visitor, arguments);
      }
      typeInfo.leave(node);
      return result;
    }
  };
}

/**
 * Given a visitor instance, if it is leaving or not, and a node kind, return
 * the function the visitor runtime should call.
 */
function getVisitFn(visitor, kind, isLeaving) {
  var kindVisitor = visitor[kind];
  if (kindVisitor) {
    if (!isLeaving && typeof kindVisitor === 'function') {
      // { Kind() {} }
      return kindVisitor;
    }
    var kindSpecificVisitor = isLeaving ? kindVisitor.leave : kindVisitor.enter;
    if (typeof kindSpecificVisitor === 'function') {
      // { Kind: { enter() {}, leave() {} } }
      return kindSpecificVisitor;
    }
  } else {
    var specificVisitor = isLeaving ? visitor.leave : visitor.enter;
    if (specificVisitor) {
      if (typeof specificVisitor === 'function') {
        // { enter() {}, leave() {} }
        return specificVisitor;
      }
      var specificKindVisitor = specificVisitor[kind];
      if (typeof specificKindVisitor === 'function') {
        // { enter: { Kind() {} }, leave: { Kind() {} } }
        return specificKindVisitor;
      }
    }
  }
}

/***/ }),
/* 82 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasError", function() { return hasError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ObservableQuery", function() { return ObservableQuery; });
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33);
/* harmony import */ var _networkStatus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43);
/* harmony import */ var _util_Observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(184);
/* harmony import */ var _errors_ApolloError__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};





var hasError = function (storeValue, policy) {
    if (policy === void 0) { policy = 'none'; }
    return storeValue &&
        ((storeValue.graphQLErrors &&
            storeValue.graphQLErrors.length > 0 &&
            policy === 'none') ||
            storeValue.networkError);
};
var ObservableQuery = /** @class */ (function (_super) {
    __extends(ObservableQuery, _super);
    function ObservableQuery(_a) {
        var scheduler = _a.scheduler, options = _a.options, _b = _a.shouldSubscribe, shouldSubscribe = _b === void 0 ? true : _b;
        var _this = _super.call(this, function (observer) {
            return _this.onSubscribe(observer);
        }) || this;
        // active state
        _this.isCurrentlyPolling = false;
        _this.isTornDown = false;
        // query information
        _this.options = options;
        _this.variables = options.variables || {};
        _this.queryId = scheduler.queryManager.generateQueryId();
        _this.shouldSubscribe = shouldSubscribe;
        // related classes
        _this.scheduler = scheduler;
        _this.queryManager = scheduler.queryManager;
        // interal data stores
        _this.observers = [];
        _this.subscriptionHandles = [];
        return _this;
    }
    ObservableQuery.prototype.result = function () {
        var that = this;
        return new Promise(function (resolve, reject) {
            var subscription;
            var observer = {
                next: function (result) {
                    resolve(result);
                    // Stop the query within the QueryManager if we can before
                    // this function returns.
                    //
                    // We do this in order to prevent observers piling up within
                    // the QueryManager. Notice that we only fully unsubscribe
                    // from the subscription in a setTimeout(..., 0)  call. This call can
                    // actually be handled by the browser at a much later time. If queries
                    // are fired in the meantime, observers that should have been removed
                    // from the QueryManager will continue to fire, causing an unnecessary
                    // performance hit.
                    if (!that.observers.some(function (obs) { return obs !== observer; })) {
                        that.queryManager.removeQuery(that.queryId);
                    }
                    setTimeout(function () {
                        subscription.unsubscribe();
                    }, 0);
                },
                error: function (error) {
                    reject(error);
                },
            };
            subscription = that.subscribe(observer);
        });
    };
    /**
     * Return the result of the query from the local cache as well as some fetching status
     * `loading` and `networkStatus` allow to know if a request is in flight
     * `partial` lets you know if the result from the local cache is complete or partial
     * @return {result: Object, loading: boolean, networkStatus: number, partial: boolean}
     */
    ObservableQuery.prototype.currentResult = function () {
        if (this.isTornDown) {
            return {
                data: this.lastError ? {} : this.lastResult ? this.lastResult.data : {},
                error: this.lastError,
                loading: false,
                networkStatus: _networkStatus__WEBPACK_IMPORTED_MODULE_1__["NetworkStatus"].error,
            };
        }
        var queryStoreValue = this.queryManager.queryStore.get(this.queryId);
        if (hasError(queryStoreValue, this.options.errorPolicy)) {
            return {
                data: {},
                loading: false,
                networkStatus: queryStoreValue.networkStatus,
                error: new _errors_ApolloError__WEBPACK_IMPORTED_MODULE_3__["ApolloError"]({
                    graphQLErrors: queryStoreValue.graphQLErrors,
                    networkError: queryStoreValue.networkError,
                }),
            };
        }
        var _a = this.queryManager.getCurrentQueryResult(this), data = _a.data, partial = _a.partial;
        var queryLoading = !queryStoreValue ||
            queryStoreValue.networkStatus === _networkStatus__WEBPACK_IMPORTED_MODULE_1__["NetworkStatus"].loading;
        // We need to be careful about the loading state we show to the user, to try
        // and be vaguely in line with what the user would have seen from .subscribe()
        // but to still provide useful information synchronously when the query
        // will not end up hitting the server.
        // See more: https://github.com/apollostack/apollo-client/issues/707
        // Basically: is there a query in flight right now (modolo the next tick)?
        var loading = (this.options.fetchPolicy === 'network-only' && queryLoading) ||
            (partial && this.options.fetchPolicy !== 'cache-only');
        // if there is nothing in the query store, it means this query hasn't fired yet or it has been cleaned up. Therefore the
        // network status is dependent on queryLoading.
        var networkStatus;
        if (queryStoreValue) {
            networkStatus = queryStoreValue.networkStatus;
        }
        else {
            networkStatus = loading ? _networkStatus__WEBPACK_IMPORTED_MODULE_1__["NetworkStatus"].loading : _networkStatus__WEBPACK_IMPORTED_MODULE_1__["NetworkStatus"].ready;
        }
        var result = {
            data: data,
            loading: Object(_networkStatus__WEBPACK_IMPORTED_MODULE_1__["isNetworkRequestInFlight"])(networkStatus),
            networkStatus: networkStatus,
        };
        if (queryStoreValue &&
            queryStoreValue.graphQLErrors &&
            this.options.errorPolicy === 'all') {
            result.errors = queryStoreValue.graphQLErrors;
        }
        if (!partial) {
            var stale = false;
            this.lastResult = __assign({}, result, { stale: stale });
        }
        return __assign({}, result, { partial: partial });
    };
    // Returns the last result that observer.next was called with. This is not the same as
    // currentResult! If you're not sure which you need, then you probably need currentResult.
    ObservableQuery.prototype.getLastResult = function () {
        return this.lastResult;
    };
    ObservableQuery.prototype.getLastError = function () {
        return this.lastError;
    };
    ObservableQuery.prototype.resetLastResults = function () {
        delete this.lastResult;
        delete this.lastError;
        this.isTornDown = false;
    };
    ObservableQuery.prototype.refetch = function (variables) {
        var fetchPolicy = this.options.fetchPolicy;
        // early return if trying to read from cache during refetch
        if (fetchPolicy === 'cache-only') {
            return Promise.reject(new Error('cache-only fetchPolicy option should not be used together with query refetch.'));
        }
        if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(this.variables, variables)) {
            // update observable variables
            this.variables = Object.assign({}, this.variables, variables);
        }
        if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(this.options.variables, this.variables)) {
            // Update the existing options with new variables
            this.options.variables = Object.assign({}, this.options.variables, this.variables);
        }
        // Override fetchPolicy for this call only
        // only network-only and no-cache are safe to use
        var isNetworkFetchPolicy = fetchPolicy === 'network-only' || fetchPolicy === 'no-cache';
        var combinedOptions = __assign({}, this.options, { fetchPolicy: isNetworkFetchPolicy ? fetchPolicy : 'network-only' });
        return this.queryManager
            .fetchQuery(this.queryId, combinedOptions, _types__WEBPACK_IMPORTED_MODULE_4__["FetchType"].refetch)
            .then(function (result) { return Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["maybeDeepFreeze"])(result); });
    };
    ObservableQuery.prototype.fetchMore = function (fetchMoreOptions) {
        var _this = this;
        // early return if no update Query
        if (!fetchMoreOptions.updateQuery) {
            throw new Error('updateQuery option is required. This function defines how to update the query data with the new results.');
        }
        var combinedOptions;
        return Promise.resolve()
            .then(function () {
            var qid = _this.queryManager.generateQueryId();
            if (fetchMoreOptions.query) {
                // fetch a new query
                combinedOptions = fetchMoreOptions;
            }
            else {
                // fetch the same query with a possibly new variables
                combinedOptions = __assign({}, _this.options, fetchMoreOptions, { variables: Object.assign({}, _this.variables, fetchMoreOptions.variables) });
            }
            combinedOptions.fetchPolicy = 'network-only';
            return _this.queryManager.fetchQuery(qid, combinedOptions, _types__WEBPACK_IMPORTED_MODULE_4__["FetchType"].normal, _this.queryId);
        })
            .then(function (fetchMoreResult) {
            _this.updateQuery(function (previousResult) {
                return fetchMoreOptions.updateQuery(previousResult, {
                    fetchMoreResult: fetchMoreResult.data,
                    variables: combinedOptions.variables,
                });
            });
            return fetchMoreResult;
        });
    };
    // XXX the subscription variables are separate from the query variables.
    // if you want to update subscription variables, right now you have to do that separately,
    // and you can only do it by stopping the subscription and then subscribing again with new variables.
    ObservableQuery.prototype.subscribeToMore = function (options) {
        var _this = this;
        var subscription = this.queryManager
            .startGraphQLSubscription({
            query: options.document,
            variables: options.variables,
        })
            .subscribe({
            next: function (data) {
                if (options.updateQuery) {
                    _this.updateQuery(function (previous, _a) {
                        var variables = _a.variables;
                        return options.updateQuery(previous, {
                            subscriptionData: data,
                            variables: variables,
                        });
                    });
                }
            },
            error: function (err) {
                if (options.onError) {
                    options.onError(err);
                    return;
                }
                console.error('Unhandled GraphQL subscription error', err);
            },
        });
        this.subscriptionHandles.push(subscription);
        return function () {
            var i = _this.subscriptionHandles.indexOf(subscription);
            if (i >= 0) {
                _this.subscriptionHandles.splice(i, 1);
                subscription.unsubscribe();
            }
        };
    };
    // Note: if the query is not active (there are no subscribers), the promise
    // will return null immediately.
    ObservableQuery.prototype.setOptions = function (opts) {
        var oldOptions = this.options;
        this.options = Object.assign({}, this.options, opts);
        if (opts.pollInterval) {
            this.startPolling(opts.pollInterval);
        }
        else if (opts.pollInterval === 0) {
            this.stopPolling();
        }
        // If fetchPolicy went from cache-only to something else, or from something else to network-only
        var tryFetch = (oldOptions.fetchPolicy !== 'network-only' &&
            opts.fetchPolicy === 'network-only') ||
            (oldOptions.fetchPolicy === 'cache-only' &&
                opts.fetchPolicy !== 'cache-only') ||
            (oldOptions.fetchPolicy === 'standby' &&
                opts.fetchPolicy !== 'standby') ||
            false;
        return this.setVariables(this.options.variables, tryFetch, opts.fetchResults);
    };
    /**
     * Update the variables of this observable query, and fetch the new results
     * if they've changed. If you want to force new results, use `refetch`.
     *
     * Note: if the variables have not changed, the promise will return the old
     * results immediately, and the `next` callback will *not* fire.
     *
     * Note: if the query is not active (there are no subscribers), the promise
     * will return null immediately.
     *
     * @param variables: The new set of variables. If there are missing variables,
     * the previous values of those variables will be used.
     *
     * @param tryFetch: Try and fetch new results even if the variables haven't
     * changed (we may still just hit the store, but if there's nothing in there
     * this will refetch)
     *
     * @param fetchResults: Option to ignore fetching results when updating variables
     *
     */
    ObservableQuery.prototype.setVariables = function (variables, tryFetch, fetchResults) {
        if (tryFetch === void 0) { tryFetch = false; }
        if (fetchResults === void 0) { fetchResults = true; }
        // since setVariables restarts the subscription, we reset the tornDown status
        this.isTornDown = false;
        var newVariables = variables ? variables : this.variables;
        if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(newVariables, this.variables) && !tryFetch) {
            // If we have no observers, then we don't actually want to make a network
            // request. As soon as someone observes the query, the request will kick
            // off. For now, we just store any changes. (See #1077)
            if (this.observers.length === 0 || !fetchResults) {
                return new Promise(function (resolve) { return resolve(); });
            }
            return this.result();
        }
        else {
            this.variables = newVariables;
            this.options.variables = newVariables;
            // See comment above
            if (this.observers.length === 0) {
                return new Promise(function (resolve) { return resolve(); });
            }
            // Use the same options as before, but with new variables
            return this.queryManager
                .fetchQuery(this.queryId, __assign({}, this.options, { variables: this.variables }))
                .then(function (result) { return Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["maybeDeepFreeze"])(result); });
        }
    };
    ObservableQuery.prototype.updateQuery = function (mapFn) {
        var _a = this.queryManager.getQueryWithPreviousResult(this.queryId), previousResult = _a.previousResult, variables = _a.variables, document = _a.document;
        var newResult = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["tryFunctionOrLogError"])(function () {
            return mapFn(previousResult, { variables: variables });
        });
        if (newResult) {
            this.queryManager.dataStore.markUpdateQueryResult(document, variables, newResult);
            this.queryManager.broadcastQueries();
        }
    };
    ObservableQuery.prototype.stopPolling = function () {
        if (this.isCurrentlyPolling) {
            this.scheduler.stopPollingQuery(this.queryId);
            this.options.pollInterval = undefined;
            this.isCurrentlyPolling = false;
        }
    };
    ObservableQuery.prototype.startPolling = function (pollInterval) {
        if (this.options.fetchPolicy === 'cache-first' ||
            this.options.fetchPolicy === 'cache-only') {
            throw new Error('Queries that specify the cache-first and cache-only fetchPolicies cannot also be polling queries.');
        }
        if (this.isCurrentlyPolling) {
            this.scheduler.stopPollingQuery(this.queryId);
            this.isCurrentlyPolling = false;
        }
        this.options.pollInterval = pollInterval;
        this.isCurrentlyPolling = true;
        this.scheduler.startPollingQuery(this.options, this.queryId);
    };
    ObservableQuery.prototype.onSubscribe = function (observer) {
        var _this = this;
        // Zen Observable has its own error function, in order to log correctly
        // we need to declare a custom error if nothing is passed
        if (observer._subscription &&
            observer._subscription._observer &&
            !observer._subscription._observer.error) {
            observer._subscription._observer.error = function (error) {
                console.error('Unhandled error', error.message, error.stack);
            };
        }
        this.observers.push(observer);
        // Deliver initial result
        if (observer.next && this.lastResult)
            observer.next(this.lastResult);
        if (observer.error && this.lastError)
            observer.error(this.lastError);
        // setup the query if it hasn't been done before
        if (this.observers.length === 1)
            this.setUpQuery();
        return function () {
            _this.observers = _this.observers.filter(function (obs) { return obs !== observer; });
            if (_this.observers.length === 0) {
                _this.tearDownQuery();
            }
        };
    };
    ObservableQuery.prototype.setUpQuery = function () {
        var _this = this;
        if (this.shouldSubscribe) {
            this.queryManager.addObservableQuery(this.queryId, this);
        }
        if (!!this.options.pollInterval) {
            if (this.options.fetchPolicy === 'cache-first' ||
                this.options.fetchPolicy === 'cache-only') {
                throw new Error('Queries that specify the cache-first and cache-only fetchPolicies cannot also be polling queries.');
            }
            this.isCurrentlyPolling = true;
            this.scheduler.startPollingQuery(this.options, this.queryId);
        }
        var observer = {
            next: function (result) {
                _this.lastResult = result;
                _this.observers.forEach(function (obs) { return obs.next && obs.next(result); });
            },
            error: function (error) {
                _this.lastError = error;
                _this.observers.forEach(function (obs) { return obs.error && obs.error(error); });
            },
        };
        this.queryManager.startQuery(this.queryId, this.options, this.queryManager.queryListenerForObserver(this.queryId, this.options, observer));
    };
    ObservableQuery.prototype.tearDownQuery = function () {
        this.isTornDown = true;
        if (this.isCurrentlyPolling) {
            this.scheduler.stopPollingQuery(this.queryId);
            this.isCurrentlyPolling = false;
        }
        // stop all active GraphQL subscriptions
        this.subscriptionHandles.forEach(function (sub) { return sub.unsubscribe(); });
        this.subscriptionHandles = [];
        this.queryManager.removeObservableQuery(this.queryId);
        this.queryManager.stopQuery(this.queryId);
        this.observers = [];
    };
    return ObservableQuery;
}(_util_Observable__WEBPACK_IMPORTED_MODULE_2__["Observable"]));



/***/ }),
/* 83 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isScalarValue", function() { return isScalarValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNumberValue", function() { return isNumberValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueToObjectRepresentation", function() { return valueToObjectRepresentation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "storeKeyNameFromField", function() { return storeKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getStoreKeyName", function() { return getStoreKeyName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "argumentsObjectFromField", function() { return argumentsObjectFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resultKeyNameFromField", function() { return resultKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isField", function() { return isField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isInlineFragment", function() { return isInlineFragment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isIdValue", function() { return isIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toIdValue", function() { return toIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isJsonValue", function() { return isJsonValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueFromNode", function() { return valueFromNode; });
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(84);
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0__);
var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};

function isScalarValue(value) {
    return ['StringValue', 'BooleanValue', 'EnumValue'].indexOf(value.kind) > -1;
}
function isNumberValue(value) {
    return ['IntValue', 'FloatValue'].indexOf(value.kind) > -1;
}
function isStringValue(value) {
    return value.kind === 'StringValue';
}
function isBooleanValue(value) {
    return value.kind === 'BooleanValue';
}
function isIntValue(value) {
    return value.kind === 'IntValue';
}
function isFloatValue(value) {
    return value.kind === 'FloatValue';
}
function isVariable(value) {
    return value.kind === 'Variable';
}
function isObjectValue(value) {
    return value.kind === 'ObjectValue';
}
function isListValue(value) {
    return value.kind === 'ListValue';
}
function isEnumValue(value) {
    return value.kind === 'EnumValue';
}
function isNullValue(value) {
    return value.kind === 'NullValue';
}
function valueToObjectRepresentation(argObj, name, value, variables) {
    if (isIntValue(value) || isFloatValue(value)) {
        argObj[name.value] = Number(value.value);
    }
    else if (isBooleanValue(value) || isStringValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isObjectValue(value)) {
        var nestedArgObj_1 = {};
        value.fields.map(function (obj) {
            return valueToObjectRepresentation(nestedArgObj_1, obj.name, obj.value, variables);
        });
        argObj[name.value] = nestedArgObj_1;
    }
    else if (isVariable(value)) {
        var variableValue = (variables || {})[value.name.value];
        argObj[name.value] = variableValue;
    }
    else if (isListValue(value)) {
        argObj[name.value] = value.values.map(function (listValue) {
            var nestedArgArrayObj = {};
            valueToObjectRepresentation(nestedArgArrayObj, name, listValue, variables);
            return nestedArgArrayObj[name.value];
        });
    }
    else if (isEnumValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isNullValue(value)) {
        argObj[name.value] = null;
    }
    else {
        throw new Error("The inline argument \"" + name.value + "\" of kind \"" + value.kind + "\" is not supported.\n                    Use variables instead of inline arguments to overcome this limitation.");
    }
}
function storeKeyNameFromField(field, variables) {
    var directivesObj = null;
    if (field.directives) {
        directivesObj = {};
        field.directives.forEach(function (directive) {
            directivesObj[directive.name.value] = {};
            if (directive.arguments) {
                directive.arguments.forEach(function (_a) {
                    var name = _a.name, value = _a.value;
                    return valueToObjectRepresentation(directivesObj[directive.name.value], name, value, variables);
                });
            }
        });
    }
    var argObj = null;
    if (field.arguments && field.arguments.length) {
        argObj = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj, name, value, variables);
        });
    }
    return getStoreKeyName(field.name.value, argObj, directivesObj);
}
var KNOWN_DIRECTIVES = [
    'connection',
    'include',
    'skip',
    'client',
    'rest',
    'export',
];
function getStoreKeyName(fieldName, args, directives) {
    if (directives &&
        directives['connection'] &&
        directives['connection']['key']) {
        if (directives['connection']['filter'] &&
            directives['connection']['filter'].length > 0) {
            var filterKeys = directives['connection']['filter']
                ? directives['connection']['filter']
                : [];
            filterKeys.sort();
            var queryArgs_1 = args;
            var filteredArgs_1 = {};
            filterKeys.forEach(function (key) {
                filteredArgs_1[key] = queryArgs_1[key];
            });
            return directives['connection']['key'] + "(" + JSON.stringify(filteredArgs_1) + ")";
        }
        else {
            return directives['connection']['key'];
        }
    }
    var completeFieldName = fieldName;
    if (args) {
        // We can't use `JSON.stringify` here since it's non-deterministic,
        // and can lead to different store key names being created even though
        // the `args` object used during creation has the same properties/values.
        var stringifiedArgs = fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0___default()(args);
        completeFieldName += "(" + stringifiedArgs + ")";
    }
    if (directives) {
        Object.keys(directives).forEach(function (key) {
            if (KNOWN_DIRECTIVES.indexOf(key) !== -1)
                return;
            if (directives[key] && Object.keys(directives[key]).length) {
                completeFieldName += "@" + key + "(" + JSON.stringify(directives[key]) + ")";
            }
            else {
                completeFieldName += "@" + key;
            }
        });
    }
    return completeFieldName;
}
function argumentsObjectFromField(field, variables) {
    if (field.arguments && field.arguments.length) {
        var argObj_1 = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj_1, name, value, variables);
        });
        return argObj_1;
    }
    return null;
}
function resultKeyNameFromField(field) {
    return field.alias ? field.alias.value : field.name.value;
}
function isField(selection) {
    return selection.kind === 'Field';
}
function isInlineFragment(selection) {
    return selection.kind === 'InlineFragment';
}
function isIdValue(idObject) {
    return idObject && idObject.type === 'id';
}
function toIdValue(idConfig, generated) {
    if (generated === void 0) { generated = false; }
    return __assign({ type: 'id', generated: generated }, (typeof idConfig === 'string'
        ? { id: idConfig, typename: undefined }
        : idConfig));
}
function isJsonValue(jsonObject) {
    return (jsonObject != null &&
        typeof jsonObject === 'object' &&
        jsonObject.type === 'json');
}
function defaultValueFromVariable(node) {
    throw new Error("Variable nodes are not supported by valueFromNode");
}
/**
 * Evaluate a ValueNode and yield its value in its natural JS form.
 */
function valueFromNode(node, onVariable) {
    if (onVariable === void 0) { onVariable = defaultValueFromVariable; }
    switch (node.kind) {
        case 'Variable':
            return onVariable(node);
        case 'NullValue':
            return null;
        case 'IntValue':
            return parseInt(node.value, 10);
        case 'FloatValue':
            return parseFloat(node.value);
        case 'ListValue':
            return node.values.map(function (v) { return valueFromNode(v, onVariable); });
        case 'ObjectValue': {
            var value = {};
            for (var _i = 0, _a = node.fields; _i < _a.length; _i++) {
                var field = _a[_i];
                value[field.name.value] = valueFromNode(field.value, onVariable);
            }
            return value;
        }
        default:
            return node.value;
    }
}


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = function (data, opts) {
    if (!opts) opts = {};
    if (typeof opts === 'function') opts = { cmp: opts };
    var cycles = (typeof opts.cycles === 'boolean') ? opts.cycles : false;

    var cmp = opts.cmp && (function (f) {
        return function (node) {
            return function (a, b) {
                var aobj = { key: a, value: node[a] };
                var bobj = { key: b, value: node[b] };
                return f(aobj, bobj);
            };
        };
    })(opts.cmp);

    var seen = [];
    return (function stringify (node) {
        if (node && node.toJSON && typeof node.toJSON === 'function') {
            node = node.toJSON();
        }

        if (node === undefined) return;
        if (typeof node == 'number') return isFinite(node) ? '' + node : 'null';
        if (typeof node !== 'object') return JSON.stringify(node);

        var i, out;
        if (Array.isArray(node)) {
            out = '[';
            for (i = 0; i < node.length; i++) {
                if (i) out += ',';
                out += stringify(node[i]) || 'null';
            }
            return out + ']';
        }

        if (node === null) return 'null';

        if (seen.indexOf(node) !== -1) {
            if (cycles) return JSON.stringify('__cycle__');
            throw new TypeError('Converting circular structure to JSON');
        }

        var seenIndex = seen.push(node) - 1;
        var keys = Object.keys(node).sort(cmp && cmp(node));
        out = '';
        for (i = 0; i < keys.length; i++) {
            var key = keys[i];
            var value = stringify(node[key]);

            if (!value) continue;
            if (out) out += ',';
            out += JSON.stringify(key) + ':' + value;
        }
        seen.splice(seenIndex, 1);
        return '{' + out + '}';
    })(data);
};


/***/ }),
/* 85 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getEnv", function() { return getEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isEnv", function() { return isEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isProduction", function() { return isProduction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDevelopment", function() { return isDevelopment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isTest", function() { return isTest; });
function getEnv() {
    if (typeof process !== 'undefined' && "production") {
        return "production";
    }
    // default environment
    return 'development';
}
function isEnv(env) {
    return getEnv() === env;
}
function isProduction() {
    return isEnv('production') === true;
}
function isDevelopment() {
    return isEnv('development') === true;
}
function isTest() {
    return isEnv('test') === true;
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(26)))

/***/ }),
/* 86 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _zenObservable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(123);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Observable", function() { return _zenObservable__WEBPACK_IMPORTED_MODULE_0__["Observable"]; });



/* harmony default export */ __webpack_exports__["default"] = (_zenObservable__WEBPACK_IMPORTED_MODULE_0__["Observable"]);


/***/ }),
/* 87 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isApolloError", function() { return isApolloError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApolloError", function() { return ApolloError; });
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
function isApolloError(err) {
    return err.hasOwnProperty('graphQLErrors');
}
// Sets the error message on this error according to the
// the GraphQL and network errors that are present.
// If the error message has already been set through the
// constructor or otherwise, this function is a nop.
var generateErrorMessage = function (err) {
    var message = '';
    // If we have GraphQL errors present, add that to the error message.
    if (Array.isArray(err.graphQLErrors) && err.graphQLErrors.length !== 0) {
        err.graphQLErrors.forEach(function (graphQLError) {
            var errorMessage = graphQLError
                ? graphQLError.message
                : 'Error message not found.';
            message += "GraphQL error: " + errorMessage + "\n";
        });
    }
    if (err.networkError) {
        message += 'Network error: ' + err.networkError.message + '\n';
    }
    // strip newline from the end of the message
    message = message.replace(/\n$/, '');
    return message;
};
var ApolloError = /** @class */ (function (_super) {
    __extends(ApolloError, _super);
    // Constructs an instance of ApolloError given a GraphQLError
    // or a network error. Note that one of these has to be a valid
    // value or the constructed error will be meaningless.
    function ApolloError(_a) {
        var graphQLErrors = _a.graphQLErrors, networkError = _a.networkError, errorMessage = _a.errorMessage, extraInfo = _a.extraInfo;
        var _this = _super.call(this, errorMessage) || this;
        _this.graphQLErrors = graphQLErrors || [];
        _this.networkError = networkError || null;
        if (!errorMessage) {
            _this.message = generateErrorMessage(_this);
        }
        else {
            _this.message = errorMessage;
        }
        _this.extraInfo = extraInfo;
        // We're not using `Object.setPrototypeOf` here as it isn't fully
        // supported on Android (see issue #3236).
        _this.__proto__ = ApolloError.prototype;
        return _this;
    }
    return ApolloError;
}(Error));



/***/ }),
/* 88 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isScalarValue", function() { return isScalarValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNumberValue", function() { return isNumberValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueToObjectRepresentation", function() { return valueToObjectRepresentation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "storeKeyNameFromField", function() { return storeKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getStoreKeyName", function() { return getStoreKeyName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "argumentsObjectFromField", function() { return argumentsObjectFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resultKeyNameFromField", function() { return resultKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isField", function() { return isField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isInlineFragment", function() { return isInlineFragment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isIdValue", function() { return isIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toIdValue", function() { return toIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isJsonValue", function() { return isJsonValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueFromNode", function() { return valueFromNode; });
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(84);
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0__);
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function isScalarValue(value) {
    return ['StringValue', 'BooleanValue', 'EnumValue'].indexOf(value.kind) > -1;
}
function isNumberValue(value) {
    return ['IntValue', 'FloatValue'].indexOf(value.kind) > -1;
}
function isStringValue(value) {
    return value.kind === 'StringValue';
}
function isBooleanValue(value) {
    return value.kind === 'BooleanValue';
}
function isIntValue(value) {
    return value.kind === 'IntValue';
}
function isFloatValue(value) {
    return value.kind === 'FloatValue';
}
function isVariable(value) {
    return value.kind === 'Variable';
}
function isObjectValue(value) {
    return value.kind === 'ObjectValue';
}
function isListValue(value) {
    return value.kind === 'ListValue';
}
function isEnumValue(value) {
    return value.kind === 'EnumValue';
}
function isNullValue(value) {
    return value.kind === 'NullValue';
}
function valueToObjectRepresentation(argObj, name, value, variables) {
    if (isIntValue(value) || isFloatValue(value)) {
        argObj[name.value] = Number(value.value);
    }
    else if (isBooleanValue(value) || isStringValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isObjectValue(value)) {
        var nestedArgObj_1 = {};
        value.fields.map(function (obj) {
            return valueToObjectRepresentation(nestedArgObj_1, obj.name, obj.value, variables);
        });
        argObj[name.value] = nestedArgObj_1;
    }
    else if (isVariable(value)) {
        var variableValue = (variables || {})[value.name.value];
        argObj[name.value] = variableValue;
    }
    else if (isListValue(value)) {
        argObj[name.value] = value.values.map(function (listValue) {
            var nestedArgArrayObj = {};
            valueToObjectRepresentation(nestedArgArrayObj, name, listValue, variables);
            return nestedArgArrayObj[name.value];
        });
    }
    else if (isEnumValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isNullValue(value)) {
        argObj[name.value] = null;
    }
    else {
        throw new Error("The inline argument \"" + name.value + "\" of kind \"" + value.kind + "\"" +
            'is not supported. Use variables instead of inline arguments to ' +
            'overcome this limitation.');
    }
}
function storeKeyNameFromField(field, variables) {
    var directivesObj = null;
    if (field.directives) {
        directivesObj = {};
        field.directives.forEach(function (directive) {
            directivesObj[directive.name.value] = {};
            if (directive.arguments) {
                directive.arguments.forEach(function (_a) {
                    var name = _a.name, value = _a.value;
                    return valueToObjectRepresentation(directivesObj[directive.name.value], name, value, variables);
                });
            }
        });
    }
    var argObj = null;
    if (field.arguments && field.arguments.length) {
        argObj = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj, name, value, variables);
        });
    }
    return getStoreKeyName(field.name.value, argObj, directivesObj);
}
var KNOWN_DIRECTIVES = [
    'connection',
    'include',
    'skip',
    'client',
    'rest',
    'export',
];
function getStoreKeyName(fieldName, args, directives) {
    if (directives &&
        directives['connection'] &&
        directives['connection']['key']) {
        if (directives['connection']['filter'] &&
            directives['connection']['filter'].length > 0) {
            var filterKeys = directives['connection']['filter']
                ? directives['connection']['filter']
                : [];
            filterKeys.sort();
            var queryArgs_1 = args;
            var filteredArgs_1 = {};
            filterKeys.forEach(function (key) {
                filteredArgs_1[key] = queryArgs_1[key];
            });
            return directives['connection']['key'] + "(" + JSON.stringify(filteredArgs_1) + ")";
        }
        else {
            return directives['connection']['key'];
        }
    }
    var completeFieldName = fieldName;
    if (args) {
        var stringifiedArgs = fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_0___default()(args);
        completeFieldName += "(" + stringifiedArgs + ")";
    }
    if (directives) {
        Object.keys(directives).forEach(function (key) {
            if (KNOWN_DIRECTIVES.indexOf(key) !== -1)
                return;
            if (directives[key] && Object.keys(directives[key]).length) {
                completeFieldName += "@" + key + "(" + JSON.stringify(directives[key]) + ")";
            }
            else {
                completeFieldName += "@" + key;
            }
        });
    }
    return completeFieldName;
}
function argumentsObjectFromField(field, variables) {
    if (field.arguments && field.arguments.length) {
        var argObj_1 = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj_1, name, value, variables);
        });
        return argObj_1;
    }
    return null;
}
function resultKeyNameFromField(field) {
    return field.alias ? field.alias.value : field.name.value;
}
function isField(selection) {
    return selection.kind === 'Field';
}
function isInlineFragment(selection) {
    return selection.kind === 'InlineFragment';
}
function isIdValue(idObject) {
    return idObject &&
        idObject.type === 'id' &&
        typeof idObject.generated === 'boolean';
}
function toIdValue(idConfig, generated) {
    if (generated === void 0) { generated = false; }
    return __assign({ type: 'id', generated: generated }, (typeof idConfig === 'string'
        ? { id: idConfig, typename: undefined }
        : idConfig));
}
function isJsonValue(jsonObject) {
    return (jsonObject != null &&
        typeof jsonObject === 'object' &&
        jsonObject.type === 'json');
}
function defaultValueFromVariable(node) {
    throw new Error("Variable nodes are not supported by valueFromNode");
}
function valueFromNode(node, onVariable) {
    if (onVariable === void 0) { onVariable = defaultValueFromVariable; }
    switch (node.kind) {
        case 'Variable':
            return onVariable(node);
        case 'NullValue':
            return null;
        case 'IntValue':
            return parseInt(node.value, 10);
        case 'FloatValue':
            return parseFloat(node.value);
        case 'ListValue':
            return node.values.map(function (v) { return valueFromNode(v, onVariable); });
        case 'ObjectValue': {
            var value = {};
            for (var _i = 0, _a = node.fields; _i < _a.length; _i++) {
                var field = _a[_i];
                value[field.name.value] = valueFromNode(field.value, onVariable);
            }
            return value;
        }
        default:
            return node.value;
    }
}


/***/ }),
/* 89 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getEnv", function() { return getEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isEnv", function() { return isEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isProduction", function() { return isProduction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDevelopment", function() { return isDevelopment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isTest", function() { return isTest; });
function getEnv() {
    if (typeof process !== 'undefined' && "production") {
        return "production";
    }
    return 'development';
}
function isEnv(env) {
    return getEnv() === env;
}
function isProduction() {
    return isEnv('production') === true;
}
function isDevelopment() {
    return isEnv('development') === true;
}
function isTest() {
    return isEnv('test') === true;
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(26)))

/***/ }),
/* 90 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "InvariantError", function() { return InvariantError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "invariant", function() { return invariant; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "process", function() { return processStub; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61);


var genericMessage = "Invariant Violation";
var _a = Object.setPrototypeOf, setPrototypeOf = _a === void 0 ? function (obj, proto) {
    obj.__proto__ = proto;
    return obj;
} : _a;
var InvariantError = /** @class */ (function (_super) {
    Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__extends"])(InvariantError, _super);
    function InvariantError(message) {
        if (message === void 0) { message = genericMessage; }
        var _this = _super.call(this, typeof message === "number"
            ? genericMessage + ": " + message + " (see https://github.com/apollographql/invariant-packages)"
            : message) || this;
        _this.framesToPop = 1;
        _this.name = genericMessage;
        setPrototypeOf(_this, InvariantError.prototype);
        return _this;
    }
    return InvariantError;
}(Error));
function invariant(condition, message) {
    if (!condition) {
        throw new InvariantError(message);
    }
}
function wrapConsoleMethod(method) {
    return function () {
        return console[method].apply(console, arguments);
    };
}
(function (invariant) {
    invariant.warn = wrapConsoleMethod("warn");
    invariant.error = wrapConsoleMethod("error");
})(invariant || (invariant = {}));
// Code that uses ts-invariant with rollup-plugin-invariant may want to
// import this process stub to avoid errors evaluating process.env.NODE_ENV.
// However, because most ESM-to-CJS compilers will rewrite the process import
// as tsInvariant.process, which prevents proper replacement by minifiers, we
// also attempt to define the stub globally when it is not already defined.
var processStub = { env: {} };
if (typeof process === "object") {
    processStub = process;
}
else
    try {
        // Using Function to evaluate this assignment in global scope also escapes
        // the strict mode of the current module, thereby allowing the assignment.
        // Inspired by https://github.com/facebook/regenerator/pull/369.
        Function("stub", "process = stub")(processStub);
    }
    catch (atLeastWeTried) {
        // The assignment can fail if a Content Security Policy heavy-handedly
        // forbids Function usage. In those environments, developers should take
        // extra care to replace process.env.NODE_ENV in their production builds,
        // or define an appropriate global.process polyfill.
    }
var invariant$1 = invariant;

/* harmony default export */ __webpack_exports__["default"] = (invariant$1);



/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(26)))

/***/ }),
/* 91 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "equal", function() { return equal; });
var _a = Object.prototype, toString = _a.toString, hasOwnProperty = _a.hasOwnProperty;
var previousComparisons = new Map();
/**
 * Performs a deep equality check on two JavaScript values, tolerating cycles.
 */
function equal(a, b) {
    try {
        return check(a, b);
    }
    finally {
        previousComparisons.clear();
    }
}
function check(a, b) {
    // If the two values are strictly equal, our job is easy.
    if (a === b) {
        return true;
    }
    // Object.prototype.toString returns a representation of the runtime type of
    // the given value that is considerably more precise than typeof.
    var aTag = toString.call(a);
    var bTag = toString.call(b);
    // If the runtime types of a and b are different, they could maybe be equal
    // under some interpretation of equality, but for simplicity and performance
    // we just return false instead.
    if (aTag !== bTag) {
        return false;
    }
    switch (aTag) {
        case '[object Array]':
            // Arrays are a lot like other objects, but we can cheaply compare their
            // lengths as a short-cut before comparing their elements.
            if (a.length !== b.length)
                return false;
        // Fall through to object case...
        case '[object Object]': {
            if (previouslyCompared(a, b))
                return true;
            var aKeys = Object.keys(a);
            var bKeys = Object.keys(b);
            // If `a` and `b` have a different number of enumerable keys, they
            // must be different.
            var keyCount = aKeys.length;
            if (keyCount !== bKeys.length)
                return false;
            // Now make sure they have the same keys.
            for (var k = 0; k < keyCount; ++k) {
                if (!hasOwnProperty.call(b, aKeys[k])) {
                    return false;
                }
            }
            // Finally, check deep equality of all child properties.
            for (var k = 0; k < keyCount; ++k) {
                var key = aKeys[k];
                if (!check(a[key], b[key])) {
                    return false;
                }
            }
            return true;
        }
        case '[object Error]':
            return a.name === b.name && a.message === b.message;
        case '[object Number]':
            // Handle NaN, which is !== itself.
            if (a !== a)
                return b !== b;
        // Fall through to shared +a === +b case...
        case '[object Boolean]':
        case '[object Date]':
            return +a === +b;
        case '[object RegExp]':
        case '[object String]':
            return a == "" + b;
        case '[object Map]':
        case '[object Set]': {
            if (a.size !== b.size)
                return false;
            if (previouslyCompared(a, b))
                return true;
            var aIterator = a.entries();
            var isMap = aTag === '[object Map]';
            while (true) {
                var info = aIterator.next();
                if (info.done)
                    break;
                // If a instanceof Set, aValue === aKey.
                var _a = info.value, aKey = _a[0], aValue = _a[1];
                // So this works the same way for both Set and Map.
                if (!b.has(aKey)) {
                    return false;
                }
                // However, we care about deep equality of values only when dealing
                // with Map structures.
                if (isMap && !check(aValue, b.get(aKey))) {
                    return false;
                }
            }
            return true;
        }
    }
    // Otherwise the values are not equal.
    return false;
}
function previouslyCompared(a, b) {
    // Though cyclic references can make an object graph appear infinite from the
    // perspective of a depth-first traversal, the graph still contains a finite
    // number of distinct object references. We use the previousComparisons cache
    // to avoid comparing the same pair of object references more than once, which
    // guarantees termination (even if we end up comparing every object in one
    // graph to every object in the other graph, which is extremely unlikely),
    // while still allowing weird isomorphic structures (like rings with different
    // lengths) a chance to pass the equality test.
    var bSet = previousComparisons.get(a);
    if (bSet) {
        // Return true here because we can be sure false will be returned somewhere
        // else if the objects are not equivalent.
        if (bSet.has(b))
            return true;
    }
    else {
        previousComparisons.set(a, bSet = new Set);
    }
    bSet.add(b);
    return false;
}

/* harmony default export */ __webpack_exports__["default"] = (equal);




/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

var arrayWithoutHoles = __webpack_require__(399);

var iterableToArray = __webpack_require__(203);

var nonIterableSpread = __webpack_require__(400);

function _toConsumableArray(arr) {
  return arrayWithoutHoles(arr) || iterableToArray(arr) || nonIterableSpread();
}

module.exports = _toConsumableArray;

/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(94),
    stackClear = __webpack_require__(407),
    stackDelete = __webpack_require__(408),
    stackGet = __webpack_require__(409),
    stackHas = __webpack_require__(410),
    stackSet = __webpack_require__(411);

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

module.exports = Stack;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

var listCacheClear = __webpack_require__(402),
    listCacheDelete = __webpack_require__(403),
    listCacheGet = __webpack_require__(404),
    listCacheHas = __webpack_require__(405),
    listCacheSet = __webpack_require__(406);

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

var eq = __webpack_require__(63);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(36);

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

module.exports = nativeCreate;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

var isKeyable = __webpack_require__(426);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

var defineProperty = __webpack_require__(209);

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty) {
    defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

module.exports = baseAssignValue;


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

var overArg = __webpack_require__(217);

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

module.exports = getPrototype;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsTypedArray = __webpack_require__(436),
    baseUnary = __webpack_require__(101),
    nodeUtil = __webpack_require__(102);

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

module.exports = isTypedArray;


/***/ }),
/* 101 */
/***/ (function(module, exports) {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var freeGlobal = __webpack_require__(206);

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule && freeModule.require && freeModule.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

module.exports = nodeUtil;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(60)(module)))

/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(220),
    baseKeysIn = __webpack_require__(439),
    isArrayLike = __webpack_require__(46);

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

module.exports = keysIn;


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(19),
    isObjectLike = __webpack_require__(10);

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

var baseGet = __webpack_require__(231);

/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

module.exports = get;


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

var isSymbol = __webpack_require__(104);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = toKey;


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

var baseMatches = __webpack_require__(489),
    baseMatchesProperty = __webpack_require__(506),
    identity = __webpack_require__(67),
    isArray = __webpack_require__(6),
    property = __webpack_require__(510);

/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == 'object') {
    return isArray(value)
      ? baseMatchesProperty(value[0], value[1])
      : baseMatches(value);
  }
  return property(value);
}

module.exports = baseIteratee;


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderTree = exports.applySkuBoundConditionalVisibility = void 0;

var _extends2 = _interopRequireDefault(__webpack_require__(8));

var _ConditionUtils = __webpack_require__(528);

var _Transformers = __webpack_require__(569);

var _escape = _interopRequireDefault(__webpack_require__(262));

var _cloneDeep = _interopRequireDefault(__webpack_require__(573));

var _transform = _interopRequireDefault(__webpack_require__(589));

var _constants = __webpack_require__(15);

var _commerceUtils = __webpack_require__(20);

var _DynamoFormattingUtils = __webpack_require__(263);

var _Commerce = __webpack_require__(234);
/* globals window, document, HTMLElement */


var allowedFieldTypes = {
  innerHTML: {
    PlainText: 'innerText',
    HighlightedText: 'innerText',
    RichText: 'innerHTML',
    Number: 'innerText',
    Video: 'innerHTML',
    Option: 'innerText',
    Date: 'innerText',
    Phone: 'innerText',
    Email: 'innerText',
    CommercePrice: 'innerHTML',
    Link: 'innerText',
    ImageRef: false,
    FileRef: false,
    ItemRef: false,
    CommercePropValues: 'innerText'
  },
  'style.color': {
    Color: true
  },
  'style.background-color': {
    Color: true
  },
  'style.border-color': {
    Color: true
  },
  'style.background-image': {
    ImageRef: true
  },
  src: ['ImageRef'],
  alt: ['PlainText', 'Option', 'Number', 'Date', 'Phone', 'Email', 'Video', 'Link'],
  href: ['Phone', 'Email', 'Video', 'Link', 'FileRef'],
  id: ['PlainText'],
  "for": ['PlainText'],
  value: ['Number', 'PlainText'],
  checked: ['Bool'],
  'data-commerce-sku-id': ['ItemRef'],
  dataWHref: ['PlainText']
};

var isBindingPropToFieldTypeAllowed = function isBindingPropToFieldTypeAllowed(bindingProperty, type) {
  var allowedTypes = allowedFieldTypes[bindingProperty];
  return allowedTypes instanceof Array ? allowedTypes.indexOf(type) > -1 : allowedTypes && type in allowedTypes;
};

var getIn = function getIn(object, path) {
  var nextDotIndex = path.indexOf('.');

  if (object == null) {
    return null;
  }

  if (nextDotIndex !== -1) {
    var pathPart = path.slice(0, nextDotIndex);
    var restOfPath = path.slice(nextDotIndex + 1, path.length);
    return getIn(object[pathPart], restOfPath);
  }

  return object[path];
};

var applyBindingsMutation = function applyBindingsMutation(_ref) {
  var bindingProperty = _ref.bindingProperty,
      type = _ref.type,
      filter = _ref.filter,
      path = _ref.path,
      timezone = _ref.timezone,
      pageLinkHrefPrefix = _ref.pageLinkHrefPrefix,
      _ref$collectionSlugMa = _ref.collectionSlugMap,
      collectionSlugMap = _ref$collectionSlugMa === void 0 ? {} : _ref$collectionSlugMa,
      data = _ref.data,
      node = _ref.node,
      _ref$emailLinkSubject = _ref.emailLinkSubject,
      emailLinkSubject = _ref$emailLinkSubject === void 0 ? '' : _ref$emailLinkSubject;

  if (!isBindingPropToFieldTypeAllowed(bindingProperty, type)) {
    return;
  }

  var prefix = 'data.';
  var suffix = '';

  if (type === 'ImageRef' && bindingProperty === 'src') {
    suffix = '.url';
  }

  var rawValue;

  if (type === 'CommercePropValues') {
    rawValue = getCommercePropValue(data, "".concat(prefix).concat(path));
  } else {
    rawValue = getIn(data, "".concat(prefix).concat(path).concat(suffix));
  }

  var transformedValue = (0, _Transformers.transformers)(rawValue, filter, {
    timezone: timezone,
    pageLinkHrefPrefix: pageLinkHrefPrefix,
    collectionSlugMap: collectionSlugMap,
    currencySettings: window.__WEBFLOW_CURRENCY_SETTINGS
  });
  var detailPageHref = filter.type === 'detailPage' ? transformedValue : null;
  var propertyMutator = getPropertyMutator(bindingProperty, emailLinkSubject, detailPageHref);

  if (typeof propertyMutator === 'function') {
    propertyMutator(node, type, transformedValue);
  }
};

var applyBindings = function applyBindings(bindings, data, node) {
  if (bindings == null) {
    return;
  }

  bindings.forEach(function (binding) {
    Object.keys(binding).forEach(function (bindingProperty) {
      var bindingValue = binding[bindingProperty];
      var type = bindingValue.type,
          filter = bindingValue.filter,
          path = bindingValue.dataPath,
          timezone = bindingValue.timezone,
          pageLinkHrefPrefix = bindingValue.pageLinkHrefPrefix,
          collectionSlugMap = bindingValue.collectionSlugMap,
          emailLinkSubject = bindingValue.emailLinkSubject;
      applyBindingsMutation({
        bindingProperty: bindingProperty,
        type: type,
        filter: filter,
        path: path,
        timezone: timezone,
        pageLinkHrefPrefix: pageLinkHrefPrefix,
        collectionSlugMap: collectionSlugMap,
        data: data,
        node: node,
        emailLinkSubject: emailLinkSubject
      });
    });
  });
};

var applyConditionalVisibility = function applyConditionalVisibility(conditionData, data, node) {
  if (!conditionData) {
    return;
  }

  var condition = conditionData.condition,
      timezone = conditionData.timezone,
      dataPath = conditionData.dataPath,
      meta = conditionData.meta;
  var prefixedDataPath = "data.".concat(dataPath); // manually construct item when the condition is bound to Product Options

  var item = meta && meta.type === 'CommercePropValues' ? {
    name: getIn(data, "".concat(prefixedDataPath, ".name")),
    value: getCommercePropValue(data, prefixedDataPath)
  } : getIn(data, prefixedDataPath);

  if (item) {
    var isVisible = (0, _ConditionUtils.testCondition)({
      item: item,
      // pass in null as there are no ecommerce conditions that need a contextItem
      contextItem: null,
      timezone: timezone,
      condition: condition,
      graphQLSlugs: true
    });

    if (isVisible) {
      (0, _commerceUtils.removeConditionalVisibilityClass)(node);
    } else {
      (0, _commerceUtils.addConditionalVisibilityClass)(node);
    }
  }
};

var applySkuBoundConditionalVisibility = function applySkuBoundConditionalVisibility(_ref2) {
  var conditionData = _ref2.conditionData,
      newSkuItem = _ref2.newSkuItem,
      node = _ref2.node;
  var condition = conditionData.condition,
      timezone = conditionData.timezone;
  var skuConditionData = (0, _transform["default"])(condition.fields, function (data, val, field) {
    var skuField = field.split('default-sku:');

    if (skuField.length > 1) {
      data[skuField[1]] = val;
      return data;
    }
  }); // Need to flatten the inventory quantity to allow cond vis bound to inventory counts

  var inventoryQuantity = newSkuItem.inventory.type === 'infinite' ? null : newSkuItem.inventory.quantity;
  var itemWithFlattenedInventory = (0, _extends2["default"])({}, newSkuItem, {
    ecSkuInventoryQuantity: inventoryQuantity
  });
  var isVisible = (0, _ConditionUtils.testCondition)({
    item: itemWithFlattenedInventory,
    contextItem: null,
    timezone: timezone,
    condition: {
      fields: skuConditionData
    },
    graphQLSlugs: true
  });

  if (isVisible) {
    (0, _commerceUtils.removeConditionalVisibilityClass)(node);
  } else {
    (0, _commerceUtils.addConditionalVisibilityClass)(node);
  }
};

exports.applySkuBoundConditionalVisibility = applySkuBoundConditionalVisibility;

var createStyleMutator = function createStyleMutator(property) {
  return function (node, type, value) {
    if (!(node instanceof HTMLElement && typeof value === 'string')) {
      return;
    }

    if (type === 'ImageRef') {
      node.style.setProperty(property, "url(".concat(value, ")"));
    }

    node.style.setProperty(property, value);
  };
};

var createAttributeMutator = function createAttributeMutator(attribute) {
  return function (node, type, value) {
    var sanitizedString = value != null ? String(value) : '';
    node.setAttribute(attribute, sanitizedString);

    if (attribute === 'src' && sanitizedString) {
      (0, _commerceUtils.removeWDynBindEmptyClass)(node);
    }
  };
};

var valueMutator = function valueMutator(node, type, value) {
  if (node.hasRendered) {
    return;
  }

  var sanitizedString; // if it's a select element, and we have no value, we default to the last value
  // this was added for the case of the first render of the country select field
  // so that it isn't a blank select box when it's a new order without a country set

  if (node.tagName === 'SELECT') {
    sanitizedString = value != null ? String(value) : node.value || '';
  } else {
    sanitizedString = value != null ? String(value) : '';
  }

  node.setAttribute('value', sanitizedString);

  if (node.tagName === 'INPUT' && String(node.type).toLowerCase() === 'text') {
    node.hasRendered = true;
  }

  node.value = sanitizedString;
};

var checkedMutator = function checkedMutator(node, type, value) {
  node.checked = Boolean(value);
};

var aspectRatio = function aspectRatio(_ref3) {
  var height = _ref3.height,
      width = _ref3.width;
  return height && width ? height / width : 0;
};

var mutators = {
  innerHTML: function innerHTML(node, type, value) {
    var originalValue = value;

    if (type === 'Video') {
      /*
      TODO handle also innerHTML Video Links
      For example,
      innerHTML: [
        {
          id: 'video-id',
          slug: 'video',
          type: 'Video',
        },
        {
          id: 'url',
          slug: 'url',
          type: 'Link',
        },
      ],
       */
      value = value != null && value.metadata != null && typeof value.metadata.html === 'string' ? value.metadata.html : null;
    }

    var valueString = value != null ? String(value) : '';

    if (allowedFieldTypes.innerHTML[type] === 'innerHTML') {
      node.innerHTML = valueString;
    } else if (allowedFieldTypes.innerHTML[type] === 'innerText') {
      node.innerHTML = (0, _escape["default"])(valueString);
    } // Videos have their `padding-top` style set automatically to make them responsive, and are a locked style.
    // This is usually done in `shared/render/plugins/Embed/Video.jsx` on the server render. However, the render-time value
    // when rendering the cart is `0`, as the server does not have the associated data from the binding passed to it at
    // render-time, since we're not getting that data until we do the client-side render, after fetching the cart data.
    // So, along with setting the proper innerHTML binding for the embed itself, we also have to do an exception here
    // and set the `padding-top` to the video's aspect ratio (height over width).


    if (type === 'Video' && originalValue && originalValue.metadata && node instanceof HTMLElement) {
      node.style.setProperty('padding-top', "".concat(aspectRatio(originalValue.metadata) * 100, "%"));
    }

    if (node.innerHTML) {
      (0, _commerceUtils.removeWDynBindEmptyClass)(node);
    }
  },
  'style.color': createStyleMutator('color'),
  'style.background-color': createStyleMutator('background-color'),
  'style.border-color': createStyleMutator('border-color'),
  'style.background-image': createStyleMutator('background-image'),
  src: createAttributeMutator('src'),
  alt: createAttributeMutator('alt'),
  id: createAttributeMutator('id'),
  "for": createAttributeMutator('for'),
  value: valueMutator,
  checked: checkedMutator,
  'data-commerce-sku-id': createAttributeMutator('data-commerce-sku-id')
};

var hrefMutator = function hrefMutator(emailLinkSubject, detailPageHref) {
  return function (node, type, value) {
    if (detailPageHref) {
      node.setAttribute('href', String(detailPageHref) || '#');
    }

    if (value) {
      var href = String(value);

      switch (type) {
        case 'Phone':
          {
            node.setAttribute('href', (0, _DynamoFormattingUtils.formatPhone)(href, 'href'));
            break;
          }

        case 'Email':
          {
            var subject;

            try {
              subject = encodeURIComponent(emailLinkSubject);
            } catch (e) {
              subject = '';
            }

            var formattedEmail = (0, _DynamoFormattingUtils.formatEmail)(href, subject, 'href');
            node.setAttribute('href', formattedEmail || '#');
            break;
          }

        default:
          {
            node.setAttribute('href', href);
            break;
          }
      }
    } else {
      node.setAttribute('href', '#');
    }
  };
};

var getPropertyMutator = function getPropertyMutator(bindingProperty, emailLinkSubject, detailPageHref) {
  if (bindingProperty === 'href' || detailPageHref) {
    return hrefMutator(emailLinkSubject, detailPageHref);
  }

  if (typeof mutators[bindingProperty] === 'function') {
    return mutators[bindingProperty];
  }

  return null;
};

var getCommercePropValue = function getCommercePropValue(data, path) {
  var option = getIn(data, path);

  if (option) {
    var pathToOptionAsArray = path.split('.');
    var pathToCommercePropValues = pathToOptionAsArray.slice(0, pathToOptionAsArray.indexOf('product')).concat(['sku', 'f_sku_values_3dr']).join('.');
    var skuValues = getIn(data, pathToCommercePropValues);

    if (Array.isArray(skuValues)) {
      return (0, _Commerce.getProductOptionValueName)(option, (0, _Commerce.simplifySkuValues)(skuValues));
    }
  }

  return '';
};

var getTemplateScript = function getTemplateScript(node) {
  var templateId = node.getAttribute(_constants.WF_TEMPLATE_ID_DATA_KEY);
  var templateScript = templateId && node.parentElement && node.parentElement.querySelector("#".concat(templateId));
  return templateScript;
};

var createDomFragment = function createDomFragment(html) {
  var div = document.createElement('div');
  div.innerHTML = html;
  return div.children[0];
};

var getTemplateString = function getTemplateString(node, index) {
  var templateScript = getTemplateScript(node);
  var rawTemplateContent = templateScript && templateScript.textContent;
  var instanceRegEx = /([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}_instance-)\d+/gi;
  var decodedTemplate = rawTemplateContent && decodeURIComponent(rawTemplateContent).replace(instanceRegEx, "$1".concat(index));

  if (Boolean(decodedTemplate) && node.hasAttribute(_constants.WF_COLLECTION_DATA_KEY)) {
    var collectionPath = node.getAttribute(_constants.WF_COLLECTION_DATA_KEY);

    if (collectionPath && typeof collectionPath === 'string') {
      var searchTerm = encodeURIComponent("".concat(collectionPath, "[]")).replace(/\./g, '\\.');
      var templateSearchTerm = encodeURIComponent("".concat(collectionPath).concat(encodeURIComponent('[]'))).replace(/\./g, '\\.');
      var collectionPathRegExp = new RegExp("".concat(searchTerm, "|").concat(templateSearchTerm), 'g');
      return decodedTemplate && decodedTemplate.replace(collectionPathRegExp, "".concat(collectionPath, ".").concat(index));
    }
  }

  return decodedTemplate;
};

var walkTree = function walkTree(tree, callBack) {
  callBack(tree);

  if (!tree || !tree.children) {
    return tree;
  }

  for (var i = 0; i < tree.children.length; i++) {
    var child = tree.children[i];
    walkTree(child, callBack);
  }

  return tree;
};

var getTemplateCollection = function getTemplateCollection(node, data) {
  var collectionPath = node.hasAttribute(_constants.WF_COLLECTION_DATA_KEY) && node.getAttribute(_constants.WF_COLLECTION_DATA_KEY);
  return collectionPath ? getIn(data, "data.".concat(collectionPath)) : [];
};

var checkForAndApplyTemplateCollection = function checkForAndApplyTemplateCollection(node, data) {
  if (node && node.hasAttribute(_constants.WF_TEMPLATE_ID_DATA_KEY)) {
    var collection = getTemplateCollection(node, data);
    node.innerHTML = '';

    if (collection != null && collection.length > 0) {
      for (var index = 0; index < collection.length; index++) {
        var templateString = getTemplateString(node, index);
        var template = templateString && createDomFragment(templateString);

        if (template instanceof Element) {
          if (typeof node.append === 'function') {
            node.append(renderTree(template, data));
          } else if (typeof node.appendChild === 'function') {
            node.appendChild(renderTree(template, data));
          } else {
            throw new Error('Could not append child to node');
          }
        }
      }
    }
  }
};

var checkForAndApplyBindings = function checkForAndApplyBindings(node, data) {
  if (node && node.hasAttribute(_constants.WF_BINDING_DATA_KEY)) {
    var bindingData = (0, _commerceUtils.safeParseJson)(node.getAttribute(_constants.WF_BINDING_DATA_KEY));
    applyBindings(bindingData, data, node);
  }
};

var checkForAndApplyConditionalVisibility = function checkForAndApplyConditionalVisibility(node, data) {
  if (node && node.hasAttribute(_constants.WF_CONDITION_DATA_KEY)) {
    var conditionData = (0, _commerceUtils.safeParseJson)(node.getAttribute(_constants.WF_CONDITION_DATA_KEY));
    applyConditionalVisibility(conditionData, data, node);
  }
};

var renderTree = function renderTree(tree, data) {
  data = flattenOrderData(data);
  return walkTree(tree, function (node) {
    checkForAndApplyTemplateCollection(node, data);
    checkForAndApplyBindings(node, data);
    checkForAndApplyConditionalVisibility(node, data);
  });
};

exports.renderTree = renderTree;
var shippingDataReplacementPaths = {
  cardProvider: ['customerInfo', 'stripePayment', 'card', 'provider'],
  cardLastFour: ['customerInfo', 'stripePayment', 'card', 'last4'],
  cardExpiresMonth: ['customerInfo', 'stripePayment', 'card', 'expires', 'month'],
  cardExpiresYear: ['customerInfo', 'stripePayment', 'card', 'expires', 'year'],
  customerEmail: ['customerInfo', 'identity', 'email'],
  shippingAddressAddressee: ['customerInfo', 'shippingAddress', 'addressee'],
  shippingAddressLine1: ['customerInfo', 'shippingAddress', 'line1'],
  shippingAddressLine2: ['customerInfo', 'shippingAddress', 'line2'],
  shippingAddressCity: ['customerInfo', 'shippingAddress', 'city'],
  shippingAddressState: ['customerInfo', 'shippingAddress', 'state'],
  shippingAddressCountry: ['customerInfo', 'shippingAddress', 'country'],
  shippingAddressPostalCode: ['customerInfo', 'shippingAddress', 'postalCode'],
  billingAddressAddressee: ['customerInfo', 'billingAddress', 'addressee'],
  billingAddressLine1: ['customerInfo', 'billingAddress', 'line1'],
  billingAddressLine2: ['customerInfo', 'billingAddress', 'line2'],
  billingAddressCity: ['customerInfo', 'billingAddress', 'city'],
  billingAddressPostalCode: ['customerInfo', 'billingAddress', 'postalCode'],
  billingAddressState: ['customerInfo', 'billingAddress', 'state'],
  billingAddressCountry: ['customerInfo', 'billingAddress', 'country'],
  requiresShipping: ['statusFlags', 'requiresShipping'],
  hasDownloads: ['statusFlags', 'hasDownloads']
};

var flattenCustomData = function flattenCustomData(customData) {
  return customData.reduce(function (flattenedData, data) {
    if (data.textArea) {
      flattenedData.additionalTextArea = data.textArea;
    } else if (data.textInput) {
      flattenedData.additionalTextInput = data.textInput;
    } else if (data.checkbox !== null) {
      flattenedData.additionalCheckbox = data.checkbox;
    }

    return flattenedData;
  }, {});
};

var flattenOrderData = function flattenOrderData(data) {
  var orderExists = data && data.data && data.data.database && data.data.database.commerceOrder !== null;

  if (!orderExists) {
    return data;
  } // $FlowIgnore commerceOrder is defined if we've gotten here


  var commerceOrder = data.data.database.commerceOrder; // $FlowIgnore commerceOrder is defined if we've gotten here

  var paymentProcessor = commerceOrder.paymentProcessor; // $FlowIgnore commerceOrder is defined if we've gotten here

  var availableShippingMethods = commerceOrder.availableShippingMethods || [];
  var selectedShippingMethod = availableShippingMethods.find(function (shippingMethod) {
    return shippingMethod.selected === true;
  }); // $FlowIgnore commerceOrder is defined if we've gotten here

  var flattenedCustomData = commerceOrder.customData ? flattenCustomData(commerceOrder.customData) : {};
  var flattenedOrderData = (0, _extends2["default"])({}, commerceOrder, {
    shippingMethodName: selectedShippingMethod && selectedShippingMethod.name,
    shippingMethodDescription: selectedShippingMethod && selectedShippingMethod.description
  }, flattenedCustomData); // We have to deep clone the data here, as the properties from the data
  // returned by Apollo are read-only.

  var clonedData = (0, _cloneDeep["default"])(data);
  clonedData.data.database.commerceOrder = Object.keys(shippingDataReplacementPaths).reduce(function (updatedData, flattenPath) {
    // Override cardProvider for PayPal order
    if (flattenPath === 'cardProvider' && paymentProcessor === 'paypal') {
      updatedData = (0, _extends2["default"])({}, updatedData, {
        cardProvider: 'PayPal'
      });
      return updatedData;
    }

    var replacementFrom = shippingDataReplacementPaths[flattenPath];
    var replacementData = replacementFrom.reduce(function (acc, key) {
      return acc && acc[key];
    }, updatedData);
    updatedData[flattenPath] = replacementData;
    return updatedData;
  }, flattenedOrderData);
  return clonedData;
};

/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault2 = __webpack_require__(0);

var _taggedTemplateLiteral2 = _interopRequireDefault2(__webpack_require__(38));

var _toConsumableArray2 = _interopRequireDefault2(__webpack_require__(92));

function _templateObject() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n        ", "\n      "]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyDiscount = exports.trackOrderAndRedirect = exports.orderRequiresAdditionalAction = exports.getOrderDataFromGraphQLResponse = exports.createAttemptSubmitOrderRequest = exports.renderCheckoutFormContainers = exports.createUpdateObfuscatedOrderAddressMutation = exports.createRecalcOrderEstimationsMutation = exports.createStripePaymentMethodMutation = exports.createCustomDataMutation = exports.createOrderShippingMethodMutation = exports.createOrderAddressMutation = exports.createOrderIdentityMutation = exports.beforeUnloadHandler = exports.showErrorMessageForError = exports.updateErrorMessage = exports.initializeStripeElements = void 0;

var _extends2 = _interopRequireDefault(__webpack_require__(8));

var _apolloClient = _interopRequireDefault(__webpack_require__(80));

var _graphqlTag = _interopRequireDefault(__webpack_require__(39));

var _commerceUtils = __webpack_require__(20);

var _StyleMapObserver = _interopRequireDefault(__webpack_require__(204));

var _stripeStore = __webpack_require__(62);

var _constants = __webpack_require__(15);

var _rendering = __webpack_require__(108);

var _webPaymentsEvents = __webpack_require__(156);

var _checkoutMutations = __webpack_require__(265);
/* globals window, document, Event, HTMLInputElement */


var syncStylesToStripeElement = function syncStylesToStripeElement(stripeElement) {
  return function (appliedStyles) {
    stripeElement.update({
      style: _StyleMapObserver["default"].appliedStylesToStripeElementStyles(appliedStyles)
    });
  };
};

var initializeStripeElements = function initializeStripeElements(store) {
  if (window.Webflow.env('design') || window.Webflow.env('preview') || !store.isInitialized()) {
    return;
  }

  var checkoutFormContainers = (0, _commerceUtils.findAllElementsByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_FORM_CONTAINER);
  var cartWrappers = (0, _commerceUtils.findAllElementsByNodeType)(_constants.NODE_TYPE_COMMERCE_CART_WRAPPER);
  var allStripeElements = [].concat((0, _toConsumableArray2["default"])(checkoutFormContainers), (0, _toConsumableArray2["default"])(cartWrappers));
  allStripeElements.forEach(function (element, index) {
    store.createElementsInstance(index);
    element.setAttribute(_constants.STRIPE_ELEMENT_INSTANCE, String(index));
  });
  var stripeElements = document.querySelectorAll("[".concat(_constants.STRIPE_ELEMENT_TYPE, "]"));
  Array.from(stripeElements).forEach(function (element) {
    var type = element.getAttribute(_constants.STRIPE_ELEMENT_TYPE);

    if (!type) {
      throw new Error('Stripe element missing type string');
    }

    var checkoutFormContainer = (0, _commerceUtils.findClosestElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_FORM_CONTAINER, element);

    if (!checkoutFormContainer) {
      return;
    }

    var index = parseInt(checkoutFormContainer.getAttribute(_constants.STRIPE_ELEMENT_INSTANCE), 10);
    var el = store.createElement(type, index, {
      style: (0, _commerceUtils.safeParseJson)(element.getAttribute(_constants.STRIPE_ELEMENT_STYLE) || '{}'),
      classes: {
        focus: '-wfp-focus'
      }
    });
    el.mount(element); // eslint-disable-next-line no-unused-vars

    var styleMapObserver = new _StyleMapObserver["default"](element, {
      onChange: syncStylesToStripeElement(el)
    });
  });
};

exports.initializeStripeElements = initializeStripeElements;

var errorCodeToCheckoutErrorType = function errorCodeToCheckoutErrorType(code, msg) {
  switch (code) {
    case 'OrderTotalRange':
      if (msg && msg.match(/too small/i)) {
        return 'minimum';
      } else {
        return 'info';
      }

    case 'OrderExtrasChanged':
      return 'extras';

    case 'PriceChanged':
      return 'pricing';

    case 'StripeRejected':
      return 'billing';

    case 'NeedShippingAddress':
    case 'InvalidShippingAddress':
    case 'NeedShippingMethod':
      return 'shipping';

    case 'NeedPaymentMethod':
    case 'StripeFailure':
      return 'payment';

    case 'ItemNotFound':
      return 'product';
    // 'InvalidDiscount' has been renamed to 'DiscountInvalid', but it needs
    // to be listed here to support sites that haven't been published since this change.

    case 'InvalidDiscount':
    case 'DiscountInvalid':
    case 'DiscountDoesNotExist':
      {
        return 'invalid-discount';
      }

    case 'DiscountExpired':
      {
        return 'expired-discount';
      }

    case 'DiscountUsageReached':
      {
        return 'usage-reached-discount';
      }

    case 'DiscountRequirementsNotMet':
      {
        return 'requirements-not-met';
      }

    default:
      return 'info';
  }
}; // eslint-disable-next-line flowtype/no-weak-types


var getErrorType = function getErrorType(error) {
  if (error.graphQLErrors && error.graphQLErrors.length > 0) {
    return errorCodeToCheckoutErrorType(error.graphQLErrors[0].code, error.graphQLErrors[0].message);
  }

  if (error.code) {
    return errorCodeToCheckoutErrorType(error.code, error.message);
  }

  return 'info';
}; // FIXME: weak type is used
// eslint-disable-next-line flowtype/no-weak-types


var updateErrorMessage = function updateErrorMessage(element, error) {
  var errorText = element.querySelector(_constants.CART_CHECKOUT_ERROR_MESSAGE_SELECTOR);

  if (!errorText) {
    return;
  } // Handle Stripe.js client-side errors. We use Stripe.js's error message
  // as this error typically indicates that the user forgot to enter part of
  // their CC, or entered invalid data. The more specific the error, the more
  // helpful it will be for the user.


  if (error.type && error.type === 'validation_error') {
    errorText.textContent = error.message;
    return;
  }

  var errorType = getErrorType(error); // Get the default error message incase the node does not have the error attribute yet.

  var errorData = _constants.CHECKOUT_ERRORS[errorType.toUpperCase().replace(/\W/g, '_')] || {};
  var defaultErrorMessage = errorData.copy;
  var errorMessage = errorText.getAttribute((0, _constants.getCheckoutErrorMessageForType)(errorType)) || defaultErrorMessage;
  errorText.textContent = errorMessage;

  if (errorData.requiresRefresh) {
    errorText.setAttribute(_constants.NEEDS_REFRESH, 'true');
  } else {
    errorText.removeAttribute(_constants.NEEDS_REFRESH);
  }

  if (errorType === 'shipping') {
    updateRequiredFields(error);
  }
};

exports.updateErrorMessage = updateErrorMessage;
var elementNameByGraphQLError = {
  MISSING_STATE: 'address_state'
};

var updateRequiredFields = function updateRequiredFields(error) {
  if (!error.graphQLErrors || error.graphQLErrors.length === 0) {
    return;
  }

  var invalidShippingAddressError = error.graphQLErrors.find(function (gqlError) {
    return gqlError.code === 'InvalidShippingAddress';
  });

  if (!invalidShippingAddressError) {
    return;
  }

  invalidShippingAddressError.problems.forEach(function (problem) {
    var type = problem.type;
    var elementName = elementNameByGraphQLError[type];

    if (!elementName) {
      return;
    }

    var element = document.getElementsByName(elementName)[0];

    if (!(element instanceof HTMLInputElement)) {
      return;
    }

    element.required = true; // IE11 doesn't support the reportValidity API

    if (typeof element.reportValidity === 'function') {
      element.reportValidity();
    }
  });
};

var showErrorMessageForError = function showErrorMessageForError(err, scope) {
  var errorState = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_ERROR_STATE, scope);

  if (errorState) {
    errorState.style.removeProperty('display');
    updateErrorMessage(errorState, err);
  }
};

exports.showErrorMessageForError = showErrorMessageForError;

var beforeUnloadHandler = function beforeUnloadHandler(e) {
  e.preventDefault();
  e.returnValue = '';
};

exports.beforeUnloadHandler = beforeUnloadHandler;

var createOrderIdentityMutation = function createOrderIdentityMutation(apolloClient, email) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.updateOrderIdentityMutation,
    variables: {
      email: email
    }
  });
};

exports.createOrderIdentityMutation = createOrderIdentityMutation;

var createOrderAddressMutation = function createOrderAddressMutation(apolloClient, addressInfo) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.updateOrderAddressMutation,
    variables: addressInfo
  });
};

exports.createOrderAddressMutation = createOrderAddressMutation;

var createOrderShippingMethodMutation = function createOrderShippingMethodMutation(apolloClient, id) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.updateOrderShippingMethodMutation,
    variables: {
      id: id
    }
  });
};

exports.createOrderShippingMethodMutation = createOrderShippingMethodMutation;

var createCustomDataMutation = function createCustomDataMutation(apolloClient, customData) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.updateCustomData,
    variables: {
      customData: customData
    }
  });
};

exports.createCustomDataMutation = createCustomDataMutation;

var createStripePaymentMethodMutation = function createStripePaymentMethodMutation(apolloClient, id) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.updateOrderStripePaymentMethodMutation,
    variables: {
      paymentMethod: id
    }
  });
};

exports.createStripePaymentMethodMutation = createStripePaymentMethodMutation;

var createRecalcOrderEstimationsMutation = function createRecalcOrderEstimationsMutation(apolloClient) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.recalcOrderEstimationsMutation,
    errorPolicy: 'ignore'
  });
};

exports.createRecalcOrderEstimationsMutation = createRecalcOrderEstimationsMutation;

var createUpdateObfuscatedOrderAddressMutation = function createUpdateObfuscatedOrderAddressMutation(apolloClient, addressInfo) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.updateObfuscatedOrderAddressMutation,
    variables: addressInfo
  });
}; // FIXME: weak type is used
// eslint-disable-next-line flowtype/no-weak-types


exports.createUpdateObfuscatedOrderAddressMutation = createUpdateObfuscatedOrderAddressMutation;

var renderCheckout = function renderCheckout(checkout, data) {
  (0, _rendering.renderTree)(checkout, data);
  var shippingMethodsList = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_SHIPPING_METHODS_LIST, checkout);
  var shippingMethodsEmpty = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_SHIPPING_METHODS_EMPTY_STATE, checkout);
  var shippingAddressWrapper = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_SHIPPING_ADDRESS_WRAPPER, checkout);
  var billingAddressWrapper = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_BILLING_ADDRESS_WRAPPER, checkout);
  var billingAddressToggle = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_BILLING_ADDRESS_TOGGLE_CHECKBOX, checkout);
  var paymentInfoWrapper = checkout.querySelector('.w-commerce-commercecheckoutpaymentinfowrapper');

  if (!(shippingMethodsList instanceof Element) || !(shippingAddressWrapper instanceof Element) || !(billingAddressWrapper instanceof Element) || !(billingAddressToggle instanceof HTMLInputElement) || !(paymentInfoWrapper instanceof Element)) {
    return;
  }

  if (data.data && data.data.database && data.data.database.commerceOrder) {
    var _data$data$database$c = data.data.database.commerceOrder,
        availableShippingMethods = _data$data$database$c.availableShippingMethods,
        _data$data$database$c2 = _data$data$database$c.statusFlags,
        requiresShipping = _data$data$database$c2.requiresShipping,
        isFreeOrder = _data$data$database$c2.isFreeOrder,
        shippingAddressRequiresPostalCode = _data$data$database$c2.shippingAddressRequiresPostalCode,
        billingAddressRequiresPostalCode = _data$data$database$c2.billingAddressRequiresPostalCode;
    var shippingZipField = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_SHIPPING_ADDRESS_ZIP_FIELD, shippingAddressWrapper);

    if (shippingZipField instanceof HTMLInputElement) {
      shippingZipField.required = shippingAddressRequiresPostalCode;
    }

    var billingZipField = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CHECKOUT_BILLING_ADDRESS_ZIP_FIELD, billingAddressWrapper);

    if (billingZipField instanceof HTMLInputElement) {
      billingZipField.required = billingAddressRequiresPostalCode;
    }

    var paypalElement = document.querySelector("[".concat(_constants.PAYPAL_ELEMENT_INSTANCE, "]"));
    var paypalButton = checkout.querySelector("[".concat(_constants.PAYPAL_BUTTON_ELEMENT_INSTANCE, "]"));

    if (paypalElement && paypalButton) {
      if (isFreeOrder) {
        (0, _commerceUtils.hideElement)(paypalButton);
      } else {
        (0, _commerceUtils.showElement)(paypalButton);
      }
    } // Edge case: need to make sure if billing address is hidden because of default "same as shipping" checked, but
    // toggle itself is hidden because doesn't require shipping, the billing address is still visible


    if (!requiresShipping && billingAddressToggle.checked && billingAddressToggle.parentElement && billingAddressToggle.parentElement.classList.contains('w-condition-invisible')) {
      (0, _commerceUtils.showElement)(billingAddressWrapper);
    }

    if (!availableShippingMethods || availableShippingMethods.length < 1) {
      (0, _commerceUtils.hideElement)(shippingMethodsList); // TODO: remove this ugliness when we've properly constrained & restructured the checkout form
      // It is possible to remove the empty state so we can't return early, but don't want to crash here

      if (shippingMethodsEmpty instanceof Element) {
        (0, _commerceUtils.showElement)(shippingMethodsEmpty);
      }
    } else {
      // TODO remove after migration
      if (shippingMethodsEmpty instanceof Element) {
        (0, _commerceUtils.hideElement)(shippingMethodsEmpty);
      }

      (0, _commerceUtils.showElement)(shippingMethodsList);
    }

    if (isFreeOrder) {
      (0, _commerceUtils.hideElement)(paymentInfoWrapper);
    } else if (!isFreeOrder && paymentInfoWrapper.style.getPropertyValue('display') === 'none') {
      // was previously hidden
      (0, _commerceUtils.showElement)(paymentInfoWrapper);
    }
  } else {
    (0, _commerceUtils.hideElement)(shippingMethodsList); // TODO remove after migration

    if (shippingMethodsEmpty instanceof Element) {
      (0, _commerceUtils.showElement)(shippingMethodsEmpty);
    }

    (0, _commerceUtils.showElement)(paymentInfoWrapper);
  }
};

var runRenderOnCheckoutElement = function runRenderOnCheckoutElement(checkoutFormContainer, data, errors, stripeStore) {
  renderCheckout(checkoutFormContainer, (0, _extends2["default"])({}, data, {
    errors: errors.concat(data.errors).filter(Boolean)
  }));

  if (stripeStore) {
    (0, _webPaymentsEvents.updateWebPaymentsButton)(checkoutFormContainer, data, stripeStore);
  }
};

var renderCheckoutFormContainers = function renderCheckoutFormContainers(checkoutFormContainers, errors, apolloClient, stripeStore) {
  if (checkoutFormContainers.length === 0) {
    return;
  }

  checkoutFormContainers.forEach(function (checkoutFormContainer) {
    var queryOptions = {
      query: _graphqlTag["default"](_templateObject(), checkoutFormContainer.getAttribute(_constants.CHECKOUT_QUERY)),
      fetchPolicy: 'network-only',
      // errorPolicy is set to `all` so that we continue to get the cart data when an error occurs
      // this is important in cases like when the address entered doesn't have a shipping zone, as that returns
      // a graphQL error, but we still want to render what the customer has entered
      errorPolicy: 'all'
    };
    apolloClient.query(queryOptions).then(function (data) {
      if (data.data && data.data.database && data.data.database.commerceOrder && data.data.database.commerceOrder.availableShippingMethods) {
        var _data$data$database$c3 = data.data.database.commerceOrder,
            availableShippingMethods = _data$data$database$c3.availableShippingMethods,
            requiresShipping = _data$data$database$c3.statusFlags.requiresShipping;
        var selectedMethod = availableShippingMethods.find(function (method) {
          return method.selected === true;
        });

        if (!selectedMethod && requiresShipping) {
          var id = availableShippingMethods[0] ? availableShippingMethods[0].id : null;
          return createOrderShippingMethodMutation(apolloClient, id).then(function () {
            return createRecalcOrderEstimationsMutation(apolloClient);
          }).then(function () {
            return apolloClient.query(queryOptions);
          }).then(function (newData) {
            runRenderOnCheckoutElement(checkoutFormContainer, newData, errors, stripeStore);
          });
        }
      }

      if (data.data && data.data.database && data.data.database.commerceOrder && data.data.database.commerceOrder.statusFlags && data.data.database.commerceOrder.statusFlags.shouldRecalc) {
        return createRecalcOrderEstimationsMutation(apolloClient).then(function () {
          return apolloClient.query(queryOptions);
        }).then(function (newData) {
          runRenderOnCheckoutElement(checkoutFormContainer, newData, errors, stripeStore);
        });
      } else {
        runRenderOnCheckoutElement(checkoutFormContainer, data, errors, stripeStore);
      }
    })["catch"](function (err) {
      errors.push(err);
      renderCheckout(checkoutFormContainer, {
        errors: errors
      });
    });
  });
};

exports.renderCheckoutFormContainers = renderCheckoutFormContainers;

var createAttemptSubmitOrderRequest = function createAttemptSubmitOrderRequest(apolloClient, variables) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.attemptSubmitOrderMutation,
    variables: variables
  });
}; // FIXME: weak type is used
// eslint-disable-next-line flowtype/no-weak-types


exports.createAttemptSubmitOrderRequest = createAttemptSubmitOrderRequest;

var getOrderDataFromGraphQLResponse = function getOrderDataFromGraphQLResponse(data) {
  return data && data.data && data.data.ecommerceAttemptSubmitOrder;
};

exports.getOrderDataFromGraphQLResponse = getOrderDataFromGraphQLResponse;

var orderRequiresAdditionalAction = function orderRequiresAdditionalAction(status) {
  return status === _constants.REQUIRES_ACTION;
};

exports.orderRequiresAdditionalAction = orderRequiresAdditionalAction;

var trackOrderAndRedirect = function trackOrderAndRedirect( // FIXME: weak type is used
// eslint-disable-next-line flowtype/no-weak-types
order) {
  var isPayPal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var _order$customerPaid = order.customerPaid,
      decimalValue = _order$customerPaid.decimalValue,
      unit = _order$customerPaid.unit;

  if (typeof fbq === 'function') {
    fbq('track', 'Purchase', {
      value: decimalValue,
      currency: unit,
      content_ids: (order.purchasedItems || []).map(function (sku) {
        return sku.id;
      }),
      content_type: 'product',
      contents: (order.purchasedItems || []).map(function (sku) {
        return {
          id: sku.id,
          quantity: sku.count,
          item_price: sku.price && sku.price.decimalValue
        };
      })
    });
  }

  if (typeof gtag === 'function') {
    gtag('event', 'purchase', {
      transaction_id: order.orderId,
      value: decimalValue,
      currency: unit,
      items: (order.purchasedItems || []).map(function (sku) {
        return {
          id: sku.id,
          name: sku.name,
          quantity: sku.count,
          price: sku.price && sku.price.decimalValue
        };
      })
    });
  }

  var redirectUrl = "/order-confirmation?orderId=".concat(order.orderId, "&token=").concat(order.token);

  if (isPayPal) {
    var message = {
      isWebflow: true,
      type: 'success',
      detail: redirectUrl
    };
    window.parent.postMessage(JSON.stringify(message), window.location.origin);
  } else {
    window.location.href = redirectUrl;
  }
};

exports.trackOrderAndRedirect = trackOrderAndRedirect;

var applyDiscount = function applyDiscount(apolloClient, variables) {
  return apolloClient.mutate({
    mutation: _checkoutMutations.applyDiscountMutation,
    variables: variables
  });
};

exports.applyDiscount = applyDiscount;

/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(16);
var propertyIsEnumerableModule = __webpack_require__(160);
var createPropertyDescriptor = __webpack_require__(50);
var toIndexedObject = __webpack_require__(21);
var toPrimitive = __webpack_require__(71);
var has = __webpack_require__(12);
var IE8_DOM_DEFINE = __webpack_require__(161);

var nativeGetOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? nativeGetOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return nativeGetOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (has(O, P)) return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
};


/***/ }),
/* 111 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(4);
var hide = __webpack_require__(22);

module.exports = function (key, value) {
  try {
    hide(global, key, value);
  } catch (error) {
    global[key] = value;
  } return value;
};


/***/ }),
/* 113 */
/***/ (function(module, exports) {

var id = 0;
var postfix = Math.random();

module.exports = function (key) {
  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
};


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

var path = __webpack_require__(77);
var global = __webpack_require__(4);

var aFunction = function (variable) {
  return typeof variable == 'function' ? variable : undefined;
};

module.exports = function (namespace, method) {
  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace])
    : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
};


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

var internalObjectKeys = __webpack_require__(165);
var enumBugKeys = __webpack_require__(117);

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.github.io/ecma262/#sec-object.getownpropertynames
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

var toIndexedObject = __webpack_require__(21);
var toLength = __webpack_require__(5);
var toAbsoluteIndex = __webpack_require__(52);

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),
/* 117 */
/***/ (function(module, exports) {

// IE8- don't enum bug keys
module.exports = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];


/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(29);
var defineProperties = __webpack_require__(288);
var enumBugKeys = __webpack_require__(117);
var hiddenKeys = __webpack_require__(76);
var html = __webpack_require__(289);
var documentCreateElement = __webpack_require__(162);
var sharedKey = __webpack_require__(75);
var IE_PROTO = sharedKey('IE_PROTO');

var PROTOTYPE = 'prototype';
var Empty = function () { /* empty */ };

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var length = enumBugKeys.length;
  var lt = '<';
  var script = 'script';
  var gt = '>';
  var js = 'java' + script + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  iframe.src = String(js);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + script + gt + 'document.F=Object' + lt + '/' + script + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (length--) delete createDict[PROTOTYPE][enumBugKeys[length]];
  return createDict();
};

// `Object.create` method
// https://tc39.github.io/ecma262/#sec-object.create
module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : defineProperties(result, Properties);
};

hiddenKeys[IE_PROTO] = true;


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $forEach = __webpack_require__(25).forEach;
var sloppyArrayMethod = __webpack_require__(23);

// `Array.prototype.forEach` method implementation
// https://tc39.github.io/ecma262/#sec-array.prototype.foreach
module.exports = sloppyArrayMethod('forEach') ? function forEach(callbackfn /* , thisArg */) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
} : [].forEach;


/***/ }),
/* 120 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMutationDefinition", function() { return getMutationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "checkDocument", function() { return checkDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinition", function() { return getOperationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinitionOrDie", function() { return getOperationDefinitionOrDie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationName", function() { return getOperationName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinitions", function() { return getFragmentDefinitions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getQueryDefinition", function() { return getQueryDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinition", function() { return getFragmentDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMainDefinition", function() { return getMainDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createFragmentMap", function() { return createFragmentMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDefaultValues", function() { return getDefaultValues; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "variablesInOperation", function() { return variablesInOperation; });
/* harmony import */ var _util_assign__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(121);
/* harmony import */ var _storeUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83);


function getMutationDefinition(doc) {
    checkDocument(doc);
    var mutationDef = doc.definitions.filter(function (definition) {
        return definition.kind === 'OperationDefinition' &&
            definition.operation === 'mutation';
    })[0];
    if (!mutationDef) {
        throw new Error('Must contain a mutation definition.');
    }
    return mutationDef;
}
// Checks the document for errors and throws an exception if there is an error.
function checkDocument(doc) {
    if (doc.kind !== 'Document') {
        throw new Error("Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a \"gql\" tag? http://docs.apollostack.com/apollo-client/core.html#gql");
    }
    var operations = doc.definitions
        .filter(function (d) { return d.kind !== 'FragmentDefinition'; })
        .map(function (definition) {
        if (definition.kind !== 'OperationDefinition') {
            throw new Error("Schema type definitions not allowed in queries. Found: \"" + definition.kind + "\"");
        }
        return definition;
    });
    if (operations.length > 1) {
        throw new Error("Ambiguous GraphQL document: contains " + operations.length + " operations");
    }
}
function getOperationDefinition(doc) {
    checkDocument(doc);
    return doc.definitions.filter(function (definition) { return definition.kind === 'OperationDefinition'; })[0];
}
function getOperationDefinitionOrDie(document) {
    var def = getOperationDefinition(document);
    if (!def) {
        throw new Error("GraphQL document is missing an operation");
    }
    return def;
}
function getOperationName(doc) {
    return (doc.definitions
        .filter(function (definition) {
        return definition.kind === 'OperationDefinition' && definition.name;
    })
        .map(function (x) { return x.name.value; })[0] || null);
}
// Returns the FragmentDefinitions from a particular document as an array
function getFragmentDefinitions(doc) {
    return doc.definitions.filter(function (definition) { return definition.kind === 'FragmentDefinition'; });
}
function getQueryDefinition(doc) {
    var queryDef = getOperationDefinition(doc);
    if (!queryDef || queryDef.operation !== 'query') {
        throw new Error('Must contain a query definition.');
    }
    return queryDef;
}
function getFragmentDefinition(doc) {
    if (doc.kind !== 'Document') {
        throw new Error("Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a \"gql\" tag? http://docs.apollostack.com/apollo-client/core.html#gql");
    }
    if (doc.definitions.length > 1) {
        throw new Error('Fragment must have exactly one definition.');
    }
    var fragmentDef = doc.definitions[0];
    if (fragmentDef.kind !== 'FragmentDefinition') {
        throw new Error('Must be a fragment definition.');
    }
    return fragmentDef;
}
/**
 * Returns the first operation definition found in this document.
 * If no operation definition is found, the first fragment definition will be returned.
 * If no definitions are found, an error will be thrown.
 */
function getMainDefinition(queryDoc) {
    checkDocument(queryDoc);
    var fragmentDefinition;
    for (var _i = 0, _a = queryDoc.definitions; _i < _a.length; _i++) {
        var definition = _a[_i];
        if (definition.kind === 'OperationDefinition') {
            var operation = definition.operation;
            if (operation === 'query' ||
                operation === 'mutation' ||
                operation === 'subscription') {
                return definition;
            }
        }
        if (definition.kind === 'FragmentDefinition' && !fragmentDefinition) {
            // we do this because we want to allow multiple fragment definitions
            // to precede an operation definition.
            fragmentDefinition = definition;
        }
    }
    if (fragmentDefinition) {
        return fragmentDefinition;
    }
    throw new Error('Expected a parsed GraphQL query with a query, mutation, subscription, or a fragment.');
}
// Utility function that takes a list of fragment definitions and makes a hash out of them
// that maps the name of the fragment to the fragment definition.
function createFragmentMap(fragments) {
    if (fragments === void 0) { fragments = []; }
    var symTable = {};
    fragments.forEach(function (fragment) {
        symTable[fragment.name.value] = fragment;
    });
    return symTable;
}
function getDefaultValues(definition) {
    if (definition &&
        definition.variableDefinitions &&
        definition.variableDefinitions.length) {
        var defaultValues = definition.variableDefinitions
            .filter(function (_a) {
            var defaultValue = _a.defaultValue;
            return defaultValue;
        })
            .map(function (_a) {
            var variable = _a.variable, defaultValue = _a.defaultValue;
            var defaultValueObj = {};
            Object(_storeUtils__WEBPACK_IMPORTED_MODULE_1__["valueToObjectRepresentation"])(defaultValueObj, variable.name, defaultValue);
            return defaultValueObj;
        });
        return _util_assign__WEBPACK_IMPORTED_MODULE_0__["assign"].apply(void 0, [{}].concat(defaultValues));
    }
    return {};
}
/**
 * Returns the names of all variables declared by the operation.
 */
function variablesInOperation(operation) {
    var names = new Set();
    if (operation.variableDefinitions) {
        for (var _i = 0, _a = operation.variableDefinitions; _i < _a.length; _i++) {
            var definition = _a[_i];
            names.add(definition.variable.name.value);
        }
    }
    return names;
}


/***/ }),
/* 121 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return assign; });
function assign(target) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    sources.forEach(function (source) {
        if (typeof source === 'undefined' || source === null) {
            return;
        }
        Object.keys(source).forEach(function (key) {
            target[key] = source[key];
        });
    });
    return target;
}


/***/ }),
/* 122 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cloneDeep", function() { return cloneDeep; });
/**
 * Deeply clones a value to create a new instance.
 */
function cloneDeep(value) {
    // If the value is an array, create a new array where every item has been cloned.
    if (Array.isArray(value)) {
        return value.map(function (item) { return cloneDeep(item); });
    }
    // If the value is an object, go through all of the object’s properties and add them to a new
    // object.
    if (value !== null && typeof value === 'object') {
        var nextValue = {};
        for (var key in value) {
            if (value.hasOwnProperty(key)) {
                nextValue[key] = cloneDeep(value[key]);
            }
        }
        return nextValue;
    }
    // Otherwise this is some primitive value and it is therefore immutable so we can just return it
    // directly.
    return value;
}


/***/ }),
/* 123 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Observable", function() { return Observable; });
/* harmony import */ var zen_observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(124);
/* harmony import */ var zen_observable__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(zen_observable__WEBPACK_IMPORTED_MODULE_0__);

var Observable = zen_observable__WEBPACK_IMPORTED_MODULE_0___default.a;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(369).Observable;


/***/ }),
/* 125 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OperationBatcher", function() { return OperationBatcher; });
/* harmony import */ var apollo_link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27);
var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};

// QueryBatcher doesn't fire requests immediately. Requests that were enqueued within
// a certain amount of time (configurable through `batchInterval`) will be batched together
// into one query.
var OperationBatcher = /** @class */ (function () {
    function OperationBatcher(_a) {
        var batchInterval = _a.batchInterval, _b = _a.batchMax, batchMax = _b === void 0 ? 0 : _b, batchHandler = _a.batchHandler, _c = _a.batchKey, batchKey = _c === void 0 ? function () { return ''; } : _c;
        this.queuedRequests = new Map();
        this.batchInterval = batchInterval;
        this.batchMax = batchMax;
        this.batchHandler = batchHandler;
        this.batchKey = batchKey;
    }
    OperationBatcher.prototype.enqueueRequest = function (request) {
        var _this = this;
        var requestCopy = __assign({}, request);
        var queued = false;
        var key = this.batchKey(request.operation);
        if (!requestCopy.observable) {
            requestCopy.observable = new apollo_link__WEBPACK_IMPORTED_MODULE_0__["Observable"](function (observer) {
                if (!_this.queuedRequests.has(key)) {
                    _this.queuedRequests.set(key, []);
                }
                if (!queued) {
                    _this.queuedRequests.get(key).push(requestCopy);
                    queued = true;
                }
                //called for each subscriber, so need to save all listeners(next, error, complete)
                requestCopy.next = requestCopy.next || [];
                if (observer.next)
                    requestCopy.next.push(observer.next.bind(observer));
                requestCopy.error = requestCopy.error || [];
                if (observer.error)
                    requestCopy.error.push(observer.error.bind(observer));
                requestCopy.complete = requestCopy.complete || [];
                if (observer.complete)
                    requestCopy.complete.push(observer.complete.bind(observer));
                // The first enqueued request triggers the queue consumption after `batchInterval` milliseconds.
                if (_this.queuedRequests.get(key).length === 1) {
                    _this.scheduleQueueConsumption(key);
                }
                // When amount of requests reaches `batchMax`, trigger the queue consumption without waiting on the `batchInterval`.
                if (_this.queuedRequests.get(key).length === _this.batchMax) {
                    _this.consumeQueue(key);
                }
            });
        }
        return requestCopy.observable;
    };
    // Consumes the queue.
    // Returns a list of promises (one for each query).
    OperationBatcher.prototype.consumeQueue = function (key) {
        if (key === void 0) { key = ''; }
        var queuedRequests = this.queuedRequests.get(key);
        if (!queuedRequests) {
            return;
        }
        this.queuedRequests.delete(key);
        var requests = queuedRequests.map(function (queuedRequest) { return queuedRequest.operation; });
        var forwards = queuedRequests.map(function (queuedRequest) { return queuedRequest.forward; });
        var observables = [];
        var nexts = [];
        var errors = [];
        var completes = [];
        queuedRequests.forEach(function (batchableRequest, index) {
            observables.push(batchableRequest.observable);
            nexts.push(batchableRequest.next);
            errors.push(batchableRequest.error);
            completes.push(batchableRequest.complete);
        });
        var batchedObservable = this.batchHandler(requests, forwards) || apollo_link__WEBPACK_IMPORTED_MODULE_0__["Observable"].of();
        var onError = function (error) {
            //each callback list in batch
            errors.forEach(function (rejecters) {
                if (rejecters) {
                    //each subscriber to request
                    rejecters.forEach(function (e) { return e(error); });
                }
            });
        };
        batchedObservable.subscribe({
            next: function (results) {
                if (!Array.isArray(results)) {
                    results = [results];
                }
                if (nexts.length !== results.length) {
                    var error = new Error("server returned results with length " + results.length + ", expected length of " + nexts.length);
                    error.result = results;
                    return onError(error);
                }
                results.forEach(function (result, index) {
                    // attach the raw response to the context for usage
                    requests[index].setContext({ response: result });
                    if (nexts[index]) {
                        nexts[index].forEach(function (next) { return next(result); });
                    }
                });
            },
            error: onError,
            complete: function () {
                completes.forEach(function (complete) {
                    if (complete) {
                        //each subscriber to request
                        complete.forEach(function (c) { return c(); });
                    }
                });
            },
        });
        return observables;
    };
    OperationBatcher.prototype.scheduleQueueConsumption = function (key) {
        var _this = this;
        if (key === void 0) { key = ''; }
        setTimeout(function () {
            if (_this.queuedRequests.get(key) && _this.queuedRequests.get(key).length) {
                _this.consumeQueue(key);
            }
        }, this.batchInterval);
    };
    return OperationBatcher;
}());



/***/ }),
/* 126 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultDataIdFromObject", function() { return defaultDataIdFromObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "InMemoryCache", function() { return InMemoryCache; });
/* harmony import */ var _fixPolyfills__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(384);
/* harmony import */ var _fixPolyfills__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_fixPolyfills__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var apollo_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(385);
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59);
/* harmony import */ var _fragmentMatcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(130);
/* harmony import */ var _readFromStore__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(131);
/* harmony import */ var _writeToStore__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(134);
/* harmony import */ var _depTrackingCache__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(133);
/* harmony import */ var _optimism__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(132);
/* harmony import */ var _recordingCache__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(136);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};









var defaultConfig = {
    fragmentMatcher: new _fragmentMatcher__WEBPACK_IMPORTED_MODULE_3__["HeuristicFragmentMatcher"](),
    dataIdFromObject: defaultDataIdFromObject,
    addTypename: true,
};
function defaultDataIdFromObject(result) {
    if (result.__typename) {
        if (result.id !== undefined) {
            return result.__typename + ":" + result.id;
        }
        if (result._id !== undefined) {
            return result.__typename + ":" + result._id;
        }
    }
    return null;
}
var InMemoryCache = (function (_super) {
    __extends(InMemoryCache, _super);
    function InMemoryCache(config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this) || this;
        _this.optimistic = [];
        _this.watches = new Set();
        _this.typenameDocumentCache = new Map();
        _this.cacheKeyRoot = new _optimism__WEBPACK_IMPORTED_MODULE_7__["CacheKeyNode"]();
        _this.silenceBroadcast = false;
        _this.config = __assign({}, defaultConfig, config);
        if (_this.config.customResolvers) {
            console.warn('customResolvers have been renamed to cacheRedirects. Please update your config as we will be deprecating customResolvers in the next major version.');
            _this.config.cacheRedirects = _this.config.customResolvers;
        }
        if (_this.config.cacheResolvers) {
            console.warn('cacheResolvers have been renamed to cacheRedirects. Please update your config as we will be deprecating cacheResolvers in the next major version.');
            _this.config.cacheRedirects = _this.config.cacheResolvers;
        }
        _this.addTypename = _this.config.addTypename;
        _this.data = Object(_depTrackingCache__WEBPACK_IMPORTED_MODULE_6__["defaultNormalizedCacheFactory"])();
        _this.storeReader = new _readFromStore__WEBPACK_IMPORTED_MODULE_4__["StoreReader"](_this.cacheKeyRoot);
        _this.storeWriter = new _writeToStore__WEBPACK_IMPORTED_MODULE_5__["StoreWriter"]();
        var cache = _this;
        var maybeBroadcastWatch = cache.maybeBroadcastWatch;
        _this.maybeBroadcastWatch = Object(_optimism__WEBPACK_IMPORTED_MODULE_7__["wrap"])(function (c) {
            return maybeBroadcastWatch.call(_this, c);
        }, {
            makeCacheKey: function (c) {
                if (c.optimistic && cache.optimistic.length > 0) {
                    return;
                }
                if (c.previousResult) {
                    return;
                }
                if (cache.data instanceof _depTrackingCache__WEBPACK_IMPORTED_MODULE_6__["DepTrackingCache"]) {
                    return cache.cacheKeyRoot.lookup(c.query, JSON.stringify(c.variables));
                }
            }
        });
        return _this;
    }
    InMemoryCache.prototype.restore = function (data) {
        if (data)
            this.data.replace(data);
        return this;
    };
    InMemoryCache.prototype.extract = function (optimistic) {
        if (optimistic === void 0) { optimistic = false; }
        if (optimistic && this.optimistic.length > 0) {
            var patches = this.optimistic.map(function (opt) { return opt.data; });
            return Object.assign.apply(Object, [{}, this.data.toObject()].concat(patches));
        }
        return this.data.toObject();
    };
    InMemoryCache.prototype.read = function (query) {
        if (query.rootId && this.data.get(query.rootId) === undefined) {
            return null;
        }
        var store = (query.optimistic && this.optimistic.length)
            ? Object(_depTrackingCache__WEBPACK_IMPORTED_MODULE_6__["defaultNormalizedCacheFactory"])(this.extract(true))
            : this.data;
        return this.storeReader.readQueryFromStore({
            store: store,
            query: this.transformDocument(query.query),
            variables: query.variables,
            rootId: query.rootId,
            fragmentMatcherFunction: this.config.fragmentMatcher.match,
            previousResult: query.previousResult,
            config: this.config,
        });
    };
    InMemoryCache.prototype.write = function (write) {
        this.storeWriter.writeResultToStore({
            dataId: write.dataId,
            result: write.result,
            variables: write.variables,
            document: this.transformDocument(write.query),
            store: this.data,
            dataIdFromObject: this.config.dataIdFromObject,
            fragmentMatcherFunction: this.config.fragmentMatcher.match,
        });
        this.broadcastWatches();
    };
    InMemoryCache.prototype.diff = function (query) {
        var store = (query.optimistic && this.optimistic.length)
            ? Object(_depTrackingCache__WEBPACK_IMPORTED_MODULE_6__["defaultNormalizedCacheFactory"])(this.extract(true))
            : this.data;
        return this.storeReader.diffQueryAgainstStore({
            store: store,
            query: this.transformDocument(query.query),
            variables: query.variables,
            returnPartialData: query.returnPartialData,
            previousResult: query.previousResult,
            fragmentMatcherFunction: this.config.fragmentMatcher.match,
            config: this.config,
        });
    };
    InMemoryCache.prototype.watch = function (watch) {
        var _this = this;
        this.watches.add(watch);
        return function () {
            _this.watches.delete(watch);
        };
    };
    InMemoryCache.prototype.evict = function (query) {
        throw new Error("eviction is not implemented on InMemory Cache");
    };
    InMemoryCache.prototype.reset = function () {
        this.data.clear();
        this.broadcastWatches();
        return Promise.resolve();
    };
    InMemoryCache.prototype.removeOptimistic = function (id) {
        var _this = this;
        var toPerform = this.optimistic.filter(function (item) { return item.id !== id; });
        this.optimistic = [];
        toPerform.forEach(function (change) {
            _this.recordOptimisticTransaction(change.transaction, change.id);
        });
        this.broadcastWatches();
    };
    InMemoryCache.prototype.performTransaction = function (transaction) {
        var alreadySilenced = this.silenceBroadcast;
        this.silenceBroadcast = true;
        transaction(this);
        if (!alreadySilenced) {
            this.silenceBroadcast = false;
        }
        this.broadcastWatches();
    };
    InMemoryCache.prototype.recordOptimisticTransaction = function (transaction, id) {
        var _this = this;
        this.silenceBroadcast = true;
        var patch = Object(_recordingCache__WEBPACK_IMPORTED_MODULE_8__["record"])(this.extract(true), function (recordingCache) {
            var dataCache = _this.data;
            _this.data = recordingCache;
            _this.performTransaction(transaction);
            _this.data = dataCache;
        });
        this.optimistic.push({
            id: id,
            transaction: transaction,
            data: patch,
        });
        this.silenceBroadcast = false;
        this.broadcastWatches();
    };
    InMemoryCache.prototype.transformDocument = function (document) {
        if (this.addTypename) {
            var result = this.typenameDocumentCache.get(document);
            if (!result) {
                result = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_2__["addTypenameToDocument"])(document);
                this.typenameDocumentCache.set(document, result);
                this.typenameDocumentCache.set(result, result);
            }
            return result;
        }
        return document;
    };
    InMemoryCache.prototype.readQuery = function (options, optimistic) {
        if (optimistic === void 0) { optimistic = false; }
        return this.read({
            query: options.query,
            variables: options.variables,
            optimistic: optimistic,
        });
    };
    InMemoryCache.prototype.readFragment = function (options, optimistic) {
        if (optimistic === void 0) { optimistic = false; }
        return this.read({
            query: this.transformDocument(Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_2__["getFragmentQueryDocument"])(options.fragment, options.fragmentName)),
            variables: options.variables,
            rootId: options.id,
            optimistic: optimistic,
        });
    };
    InMemoryCache.prototype.writeQuery = function (options) {
        this.write({
            dataId: 'ROOT_QUERY',
            result: options.data,
            query: this.transformDocument(options.query),
            variables: options.variables,
        });
    };
    InMemoryCache.prototype.writeFragment = function (options) {
        this.write({
            dataId: options.id,
            result: options.data,
            query: this.transformDocument(Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_2__["getFragmentQueryDocument"])(options.fragment, options.fragmentName)),
            variables: options.variables,
        });
    };
    InMemoryCache.prototype.broadcastWatches = function () {
        var _this = this;
        if (!this.silenceBroadcast) {
            var optimistic_1 = this.optimistic.length > 0;
            this.watches.forEach(function (c) {
                _this.maybeBroadcastWatch(c);
                if (optimistic_1) {
                    _this.maybeBroadcastWatch.dirty(c);
                }
            });
        }
    };
    InMemoryCache.prototype.maybeBroadcastWatch = function (c) {
        c.callback(this.diff({
            query: c.query,
            variables: c.variables,
            previousResult: c.previousResult && c.previousResult(),
            optimistic: c.optimistic,
        }));
    };
    return InMemoryCache;
}(apollo_cache__WEBPACK_IMPORTED_MODULE_1__["ApolloCache"]));



/***/ }),
/* 127 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMutationDefinition", function() { return getMutationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "checkDocument", function() { return checkDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinition", function() { return getOperationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinitionOrDie", function() { return getOperationDefinitionOrDie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationName", function() { return getOperationName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinitions", function() { return getFragmentDefinitions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getQueryDefinition", function() { return getQueryDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinition", function() { return getFragmentDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMainDefinition", function() { return getMainDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createFragmentMap", function() { return createFragmentMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDefaultValues", function() { return getDefaultValues; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "variablesInOperation", function() { return variablesInOperation; });
/* harmony import */ var _util_assign__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(128);
/* harmony import */ var _storeUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88);


function getMutationDefinition(doc) {
    checkDocument(doc);
    var mutationDef = doc.definitions.filter(function (definition) {
        return definition.kind === 'OperationDefinition' &&
            definition.operation === 'mutation';
    })[0];
    if (!mutationDef) {
        throw new Error('Must contain a mutation definition.');
    }
    return mutationDef;
}
function checkDocument(doc) {
    if (doc.kind !== 'Document') {
        throw new Error("Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a \"gql\" tag? http://docs.apollostack.com/apollo-client/core.html#gql");
    }
    var operations = doc.definitions
        .filter(function (d) { return d.kind !== 'FragmentDefinition'; })
        .map(function (definition) {
        if (definition.kind !== 'OperationDefinition') {
            throw new Error("Schema type definitions not allowed in queries. Found: \"" + definition.kind + "\"");
        }
        return definition;
    });
    if (operations.length > 1) {
        throw new Error("Ambiguous GraphQL document: contains " + operations.length + " operations");
    }
}
function getOperationDefinition(doc) {
    checkDocument(doc);
    return doc.definitions.filter(function (definition) { return definition.kind === 'OperationDefinition'; })[0];
}
function getOperationDefinitionOrDie(document) {
    var def = getOperationDefinition(document);
    if (!def) {
        throw new Error("GraphQL document is missing an operation");
    }
    return def;
}
function getOperationName(doc) {
    return (doc.definitions
        .filter(function (definition) {
        return definition.kind === 'OperationDefinition' && definition.name;
    })
        .map(function (x) { return x.name.value; })[0] || null);
}
function getFragmentDefinitions(doc) {
    return doc.definitions.filter(function (definition) { return definition.kind === 'FragmentDefinition'; });
}
function getQueryDefinition(doc) {
    var queryDef = getOperationDefinition(doc);
    if (!queryDef || queryDef.operation !== 'query') {
        throw new Error('Must contain a query definition.');
    }
    return queryDef;
}
function getFragmentDefinition(doc) {
    if (doc.kind !== 'Document') {
        throw new Error("Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a \"gql\" tag? http://docs.apollostack.com/apollo-client/core.html#gql");
    }
    if (doc.definitions.length > 1) {
        throw new Error('Fragment must have exactly one definition.');
    }
    var fragmentDef = doc.definitions[0];
    if (fragmentDef.kind !== 'FragmentDefinition') {
        throw new Error('Must be a fragment definition.');
    }
    return fragmentDef;
}
function getMainDefinition(queryDoc) {
    checkDocument(queryDoc);
    var fragmentDefinition;
    for (var _i = 0, _a = queryDoc.definitions; _i < _a.length; _i++) {
        var definition = _a[_i];
        if (definition.kind === 'OperationDefinition') {
            var operation = definition.operation;
            if (operation === 'query' ||
                operation === 'mutation' ||
                operation === 'subscription') {
                return definition;
            }
        }
        if (definition.kind === 'FragmentDefinition' && !fragmentDefinition) {
            fragmentDefinition = definition;
        }
    }
    if (fragmentDefinition) {
        return fragmentDefinition;
    }
    throw new Error('Expected a parsed GraphQL query with a query, mutation, subscription, or a fragment.');
}
function createFragmentMap(fragments) {
    if (fragments === void 0) { fragments = []; }
    var symTable = {};
    fragments.forEach(function (fragment) {
        symTable[fragment.name.value] = fragment;
    });
    return symTable;
}
function getDefaultValues(definition) {
    if (definition &&
        definition.variableDefinitions &&
        definition.variableDefinitions.length) {
        var defaultValues = definition.variableDefinitions
            .filter(function (_a) {
            var defaultValue = _a.defaultValue;
            return defaultValue;
        })
            .map(function (_a) {
            var variable = _a.variable, defaultValue = _a.defaultValue;
            var defaultValueObj = {};
            Object(_storeUtils__WEBPACK_IMPORTED_MODULE_1__["valueToObjectRepresentation"])(defaultValueObj, variable.name, defaultValue);
            return defaultValueObj;
        });
        return _util_assign__WEBPACK_IMPORTED_MODULE_0__["assign"].apply(void 0, [{}].concat(defaultValues));
    }
    return {};
}
function variablesInOperation(operation) {
    var names = new Set();
    if (operation.variableDefinitions) {
        for (var _i = 0, _a = operation.variableDefinitions; _i < _a.length; _i++) {
            var definition = _a[_i];
            names.add(definition.variable.name.value);
        }
    }
    return names;
}


/***/ }),
/* 128 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return assign; });
function assign(target) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    sources.forEach(function (source) {
        if (typeof source === 'undefined' || source === null) {
            return;
        }
        Object.keys(source).forEach(function (key) {
            target[key] = source[key];
        });
    });
    return target;
}


/***/ }),
/* 129 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cloneDeep", function() { return cloneDeep; });
var toString = Object.prototype.toString;
function cloneDeep(value) {
    return cloneDeepHelper(value, new Map());
}
function cloneDeepHelper(val, seen) {
    switch (toString.call(val)) {
        case "[object Array]": {
            if (seen.has(val))
                return seen.get(val);
            var copy_1 = val.slice(0);
            seen.set(val, copy_1);
            copy_1.forEach(function (child, i) {
                copy_1[i] = cloneDeepHelper(child, seen);
            });
            return copy_1;
        }
        case "[object Object]": {
            if (seen.has(val))
                return seen.get(val);
            var copy_2 = Object.create(Object.getPrototypeOf(val));
            seen.set(val, copy_2);
            Object.keys(val).forEach(function (key) {
                copy_2[key] = cloneDeepHelper(val[key], seen);
            });
            return copy_2;
        }
        default:
            return val;
    }
}


/***/ }),
/* 130 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HeuristicFragmentMatcher", function() { return HeuristicFragmentMatcher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "IntrospectionFragmentMatcher", function() { return IntrospectionFragmentMatcher; });
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59);

var haveWarned = false;
var HeuristicFragmentMatcher = (function () {
    function HeuristicFragmentMatcher() {
    }
    HeuristicFragmentMatcher.prototype.ensureReady = function () {
        return Promise.resolve();
    };
    HeuristicFragmentMatcher.prototype.canBypassInit = function () {
        return true;
    };
    HeuristicFragmentMatcher.prototype.match = function (idValue, typeCondition, context) {
        var obj = context.store.get(idValue.id);
        if (!obj && idValue.id === 'ROOT_QUERY') {
            return true;
        }
        if (!obj) {
            return false;
        }
        if (!obj.__typename) {
            if (!haveWarned) {
                console.warn("You're using fragments in your queries, but either don't have the addTypename:\n  true option set in Apollo Client, or you are trying to write a fragment to the store without the __typename.\n   Please turn on the addTypename option and include __typename when writing fragments so that Apollo Client\n   can accurately match fragments.");
                console.warn('Could not find __typename on Fragment ', typeCondition, obj);
                console.warn("DEPRECATION WARNING: using fragments without __typename is unsupported behavior " +
                    "and will be removed in future versions of Apollo client. You should fix this and set addTypename to true now.");
                if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isTest"])()) {
                    haveWarned = true;
                }
            }
            return 'heuristic';
        }
        if (obj.__typename === typeCondition) {
            return true;
        }
        Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["warnOnceInDevelopment"])('You are using the simple (heuristic) fragment matcher, but your ' +
            'queries contain union or interface types. Apollo Client will not be ' +
            'able to accurately map fragments. To make this error go away, use ' +
            'the `IntrospectionFragmentMatcher` as described in the docs: ' +
            'https://www.apollographql.com/docs/react/recipes/fragment-matching.html', 'error');
        return 'heuristic';
    };
    return HeuristicFragmentMatcher;
}());

var IntrospectionFragmentMatcher = (function () {
    function IntrospectionFragmentMatcher(options) {
        if (options && options.introspectionQueryResultData) {
            this.possibleTypesMap = this.parseIntrospectionResult(options.introspectionQueryResultData);
            this.isReady = true;
        }
        else {
            this.isReady = false;
        }
        this.match = this.match.bind(this);
    }
    IntrospectionFragmentMatcher.prototype.match = function (idValue, typeCondition, context) {
        if (!this.isReady) {
            throw new Error('FragmentMatcher.match() was called before FragmentMatcher.init()');
        }
        var obj = context.store.get(idValue.id);
        if (!obj) {
            return false;
        }
        if (!obj.__typename) {
            throw new Error("Cannot match fragment because __typename property is missing: " + JSON.stringify(obj));
        }
        if (obj.__typename === typeCondition) {
            return true;
        }
        var implementingTypes = this.possibleTypesMap[typeCondition];
        if (implementingTypes && implementingTypes.indexOf(obj.__typename) > -1) {
            return true;
        }
        return false;
    };
    IntrospectionFragmentMatcher.prototype.parseIntrospectionResult = function (introspectionResultData) {
        var typeMap = {};
        introspectionResultData.__schema.types.forEach(function (type) {
            if (type.kind === 'UNION' || type.kind === 'INTERFACE') {
                typeMap[type.name] = type.possibleTypes.map(function (implementingType) { return implementingType.name; });
            }
        });
        return typeMap;
    };
    return IntrospectionFragmentMatcher;
}());



/***/ }),
/* 131 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreReader", function() { return StoreReader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "assertIdValue", function() { return assertIdValue; });
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59);
/* harmony import */ var _optimism__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(132);
/* harmony import */ var _depTrackingCache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(133);
/* harmony import */ var _queryKeyMaker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(391);
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};




var StoreReader = (function () {
    function StoreReader(cacheKeyRoot) {
        if (cacheKeyRoot === void 0) { cacheKeyRoot = new _optimism__WEBPACK_IMPORTED_MODULE_1__["CacheKeyNode"]; }
        var _this = this;
        this.cacheKeyRoot = cacheKeyRoot;
        var reader = this;
        var executeStoreQuery = reader.executeStoreQuery, executeSelectionSet = reader.executeSelectionSet;
        reader.keyMaker = new _queryKeyMaker__WEBPACK_IMPORTED_MODULE_3__["QueryKeyMaker"](cacheKeyRoot);
        this.executeStoreQuery = Object(_optimism__WEBPACK_IMPORTED_MODULE_1__["wrap"])(function (options) {
            return executeStoreQuery.call(_this, options);
        }, {
            makeCacheKey: function (_a) {
                var query = _a.query, rootValue = _a.rootValue, contextValue = _a.contextValue, variableValues = _a.variableValues, fragmentMatcher = _a.fragmentMatcher;
                if (contextValue.store instanceof _depTrackingCache__WEBPACK_IMPORTED_MODULE_2__["DepTrackingCache"]) {
                    return reader.cacheKeyRoot.lookup(reader.keyMaker.forQuery(query).lookupQuery(query), contextValue.store, fragmentMatcher, JSON.stringify(variableValues), rootValue.id);
                }
                return;
            }
        });
        this.executeSelectionSet = Object(_optimism__WEBPACK_IMPORTED_MODULE_1__["wrap"])(function (options) {
            return executeSelectionSet.call(_this, options);
        }, {
            makeCacheKey: function (_a) {
                var selectionSet = _a.selectionSet, rootValue = _a.rootValue, execContext = _a.execContext;
                if (execContext.contextValue.store instanceof _depTrackingCache__WEBPACK_IMPORTED_MODULE_2__["DepTrackingCache"]) {
                    return reader.cacheKeyRoot.lookup(reader.keyMaker.forQuery(execContext.query).lookupSelectionSet(selectionSet), execContext.contextValue.store, execContext.fragmentMatcher, JSON.stringify(execContext.variableValues), rootValue.id);
                }
                return;
            }
        });
    }
    StoreReader.prototype.readQueryFromStore = function (options) {
        var optsPatch = { returnPartialData: false };
        return this.diffQueryAgainstStore(__assign({}, options, optsPatch)).result;
    };
    StoreReader.prototype.diffQueryAgainstStore = function (_a) {
        var store = _a.store, query = _a.query, variables = _a.variables, previousResult = _a.previousResult, _b = _a.returnPartialData, returnPartialData = _b === void 0 ? true : _b, _c = _a.rootId, rootId = _c === void 0 ? 'ROOT_QUERY' : _c, fragmentMatcherFunction = _a.fragmentMatcherFunction, config = _a.config;
        var queryDefinition = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getQueryDefinition"])(query);
        variables = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["assign"])({}, Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getDefaultValues"])(queryDefinition), variables);
        var context = {
            store: store,
            dataIdFromObject: (config && config.dataIdFromObject) || null,
            cacheRedirects: (config && config.cacheRedirects) || {},
        };
        var execResult = this.executeStoreQuery({
            query: query,
            rootValue: {
                type: 'id',
                id: rootId,
                generated: true,
                typename: 'Query',
            },
            contextValue: context,
            variableValues: variables,
            fragmentMatcher: fragmentMatcherFunction,
        });
        var hasMissingFields = execResult.missing && execResult.missing.length > 0;
        if (hasMissingFields && !returnPartialData) {
            execResult.missing.forEach(function (info) {
                if (info.tolerable)
                    return;
                throw new Error("Can't find field " + info.fieldName + " on object " + JSON.stringify(info.object, null, 2) + ".");
            });
        }
        if (previousResult) {
            if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(previousResult, execResult.result)) {
                execResult.result = previousResult;
            }
        }
        return {
            result: execResult.result,
            complete: !hasMissingFields,
        };
    };
    StoreReader.prototype.executeStoreQuery = function (_a) {
        var query = _a.query, rootValue = _a.rootValue, contextValue = _a.contextValue, variableValues = _a.variableValues, _b = _a.fragmentMatcher, fragmentMatcher = _b === void 0 ? defaultFragmentMatcher : _b;
        var mainDefinition = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getMainDefinition"])(query);
        var fragments = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getFragmentDefinitions"])(query);
        var fragmentMap = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["createFragmentMap"])(fragments);
        var execContext = {
            query: query,
            fragmentMap: fragmentMap,
            contextValue: contextValue,
            variableValues: variableValues,
            fragmentMatcher: fragmentMatcher,
        };
        return this.executeSelectionSet({
            selectionSet: mainDefinition.selectionSet,
            rootValue: rootValue,
            execContext: execContext,
        });
    };
    StoreReader.prototype.executeSelectionSet = function (_a) {
        var _this = this;
        var selectionSet = _a.selectionSet, rootValue = _a.rootValue, execContext = _a.execContext;
        var fragmentMap = execContext.fragmentMap, contextValue = execContext.contextValue, variables = execContext.variableValues;
        var finalResult = {
            result: {},
        };
        var objectsToMerge = [];
        var object = contextValue.store.get(rootValue.id);
        var typename = (object && object.__typename) ||
            (rootValue.id === 'ROOT_QUERY' && 'Query') ||
            void 0;
        function handleMissing(result) {
            var _a;
            if (result.missing) {
                finalResult.missing = finalResult.missing || [];
                (_a = finalResult.missing).push.apply(_a, result.missing);
            }
            return result.result;
        }
        selectionSet.selections.forEach(function (selection) {
            var _a;
            if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["shouldInclude"])(selection, variables)) {
                return;
            }
            if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isField"])(selection)) {
                var fieldResult = handleMissing(_this.executeField(object, typename, selection, execContext));
                if (typeof fieldResult !== 'undefined') {
                    objectsToMerge.push((_a = {},
                        _a[Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["resultKeyNameFromField"])(selection)] = fieldResult,
                        _a));
                }
            }
            else {
                var fragment = void 0;
                if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isInlineFragment"])(selection)) {
                    fragment = selection;
                }
                else {
                    fragment = fragmentMap[selection.name.value];
                    if (!fragment) {
                        throw new Error("No fragment named " + selection.name.value);
                    }
                }
                var typeCondition = fragment.typeCondition.name.value;
                var match = execContext.fragmentMatcher(rootValue, typeCondition, contextValue);
                if (match) {
                    var fragmentExecResult = _this.executeSelectionSet({
                        selectionSet: fragment.selectionSet,
                        rootValue: rootValue,
                        execContext: execContext,
                    });
                    if (match === 'heuristic' && fragmentExecResult.missing) {
                        fragmentExecResult = __assign({}, fragmentExecResult, { missing: fragmentExecResult.missing.map(function (info) {
                                return __assign({}, info, { tolerable: true });
                            }) });
                    }
                    objectsToMerge.push(handleMissing(fragmentExecResult));
                }
            }
        });
        merge(finalResult.result, objectsToMerge);
        return finalResult;
    };
    StoreReader.prototype.executeField = function (object, typename, field, execContext) {
        var variables = execContext.variableValues, contextValue = execContext.contextValue;
        var fieldName = field.name.value;
        var args = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["argumentsObjectFromField"])(field, variables);
        var info = {
            resultKey: Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["resultKeyNameFromField"])(field),
            directives: Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getDirectiveInfoFromField"])(field, variables),
        };
        var readStoreResult = readStoreResolver(object, typename, fieldName, args, contextValue, info);
        if (Array.isArray(readStoreResult.result)) {
            return this.combineExecResults(readStoreResult, this.executeSubSelectedArray(field, readStoreResult.result, execContext));
        }
        if (!field.selectionSet) {
            assertSelectionSetForIdValue(field, readStoreResult.result);
            return readStoreResult;
        }
        if (readStoreResult.result == null) {
            return readStoreResult;
        }
        return this.combineExecResults(readStoreResult, this.executeSelectionSet({
            selectionSet: field.selectionSet,
            rootValue: readStoreResult.result,
            execContext: execContext,
        }));
    };
    StoreReader.prototype.combineExecResults = function () {
        var execResults = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            execResults[_i] = arguments[_i];
        }
        var missing = null;
        execResults.forEach(function (execResult) {
            if (execResult.missing) {
                missing = missing || [];
                missing.push.apply(missing, execResult.missing);
            }
        });
        return {
            result: execResults.pop().result,
            missing: missing,
        };
    };
    StoreReader.prototype.executeSubSelectedArray = function (field, result, execContext) {
        var _this = this;
        var missing = null;
        function handleMissing(childResult) {
            if (childResult.missing) {
                missing = missing || [];
                missing.push.apply(missing, childResult.missing);
            }
            return childResult.result;
        }
        result = result.map(function (item) {
            if (item === null) {
                return null;
            }
            if (Array.isArray(item)) {
                return handleMissing(_this.executeSubSelectedArray(field, item, execContext));
            }
            if (field.selectionSet) {
                return handleMissing(_this.executeSelectionSet({
                    selectionSet: field.selectionSet,
                    rootValue: item,
                    execContext: execContext,
                }));
            }
            assertSelectionSetForIdValue(field, item);
            return item;
        });
        return { result: result, missing: missing };
    };
    return StoreReader;
}());

function assertSelectionSetForIdValue(field, value) {
    if (!field.selectionSet && Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isIdValue"])(value)) {
        throw new Error("Missing selection set for object of type " + value.typename + " returned for query field " + field.name.value);
    }
}
function defaultFragmentMatcher() {
    return true;
}
function assertIdValue(idValue) {
    if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isIdValue"])(idValue)) {
        throw new Error("Encountered a sub-selection on the query, but the store doesn't have an object reference. This should never happen during normal use unless you have custom code that is directly manipulating the store; please file an issue.");
    }
}
function readStoreResolver(object, typename, fieldName, args, context, _a) {
    var resultKey = _a.resultKey, directives = _a.directives;
    var storeKeyName = fieldName;
    if (args || directives) {
        storeKeyName = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getStoreKeyName"])(storeKeyName, args, directives);
    }
    var fieldValue = void 0;
    if (object) {
        fieldValue = object[storeKeyName];
        if (typeof fieldValue === 'undefined' &&
            context.cacheRedirects &&
            typeof typename === 'string') {
            var type = context.cacheRedirects[typename];
            if (type) {
                var resolver = type[fieldName];
                if (resolver) {
                    fieldValue = resolver(object, args, {
                        getCacheKey: function (storeObj) {
                            return Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["toIdValue"])({
                                id: context.dataIdFromObject(storeObj),
                                typename: storeObj.__typename,
                            });
                        },
                    });
                }
            }
        }
    }
    if (typeof fieldValue === 'undefined') {
        return {
            result: fieldValue,
            missing: [{
                    object: object,
                    fieldName: storeKeyName,
                    tolerable: false,
                }],
        };
    }
    if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["isJsonValue"])(fieldValue)) {
        fieldValue = fieldValue.json;
    }
    return {
        result: fieldValue,
    };
}
var hasOwn = Object.prototype.hasOwnProperty;
function merge(target, sources) {
    var pastCopies = [];
    sources.forEach(function (source) {
        mergeHelper(target, source, pastCopies);
    });
    return target;
}
function mergeHelper(target, source, pastCopies) {
    if (source !== null && typeof source === 'object') {
        if (Object.isExtensible && !Object.isExtensible(target)) {
            target = shallowCopyForMerge(target, pastCopies);
        }
        Object.keys(source).forEach(function (sourceKey) {
            var sourceValue = source[sourceKey];
            if (hasOwn.call(target, sourceKey)) {
                var targetValue = target[sourceKey];
                if (sourceValue !== targetValue) {
                    target[sourceKey] = mergeHelper(shallowCopyForMerge(targetValue, pastCopies), sourceValue, pastCopies);
                }
            }
            else {
                target[sourceKey] = sourceValue;
            }
        });
    }
    return target;
}
function shallowCopyForMerge(value, pastCopies) {
    if (value !== null &&
        typeof value === 'object' &&
        pastCopies.indexOf(value) < 0) {
        if (Array.isArray(value)) {
            value = value.slice(0);
        }
        else {
            value = __assign({}, value);
        }
        pastCopies.push(value);
    }
    return value;
}


/***/ }),
/* 132 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "wrap", function() { return wrap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CacheKeyNode", function() { return CacheKeyNode; });
var wrap = __webpack_require__(387).wrap;

var CacheKeyNode = (function () {
    function CacheKeyNode() {
        this.children = null;
        this.key = null;
    }
    CacheKeyNode.prototype.lookup = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return this.lookupArray(args);
    };
    CacheKeyNode.prototype.lookupArray = function (array) {
        var node = this;
        array.forEach(function (value) {
            node = node.getOrCreate(value);
        });
        return node.key || (node.key = Object.create(null));
    };
    CacheKeyNode.prototype.getOrCreate = function (value) {
        var map = this.children || (this.children = new Map());
        var node = map.get(value);
        if (!node) {
            map.set(value, node = new CacheKeyNode());
        }
        return node;
    };
    return CacheKeyNode;
}());



/***/ }),
/* 133 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DepTrackingCache", function() { return DepTrackingCache; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultNormalizedCacheFactory", function() { return defaultNormalizedCacheFactory; });
/* harmony import */ var _optimism__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(132);

var hasOwn = Object.prototype.hasOwnProperty;
var DepTrackingCache = (function () {
    function DepTrackingCache(data) {
        if (data === void 0) { data = Object.create(null); }
        var _this = this;
        this.data = data;
        this.depend = Object(_optimism__WEBPACK_IMPORTED_MODULE_0__["wrap"])(function (dataId) { return _this.data[dataId]; }, {
            disposable: true,
            makeCacheKey: function (dataId) {
                return dataId;
            }
        });
    }
    DepTrackingCache.prototype.toObject = function () {
        return this.data;
    };
    DepTrackingCache.prototype.get = function (dataId) {
        this.depend(dataId);
        return this.data[dataId];
    };
    DepTrackingCache.prototype.set = function (dataId, value) {
        var oldValue = this.data[dataId];
        if (value !== oldValue) {
            this.data[dataId] = value;
            this.depend.dirty(dataId);
        }
    };
    DepTrackingCache.prototype.delete = function (dataId) {
        if (hasOwn.call(this.data, dataId)) {
            delete this.data[dataId];
            this.depend.dirty(dataId);
        }
    };
    DepTrackingCache.prototype.clear = function () {
        this.replace(null);
    };
    DepTrackingCache.prototype.replace = function (newData) {
        var _this = this;
        if (newData) {
            Object.keys(newData).forEach(function (dataId) {
                _this.set(dataId, newData[dataId]);
            });
            Object.keys(this.data).forEach(function (dataId) {
                if (!hasOwn.call(newData, dataId)) {
                    _this.delete(dataId);
                }
            });
        }
        else {
            Object.keys(this.data).forEach(function (dataId) {
                _this.delete(dataId);
            });
        }
    };
    return DepTrackingCache;
}());

function defaultNormalizedCacheFactory(seed) {
    return new DepTrackingCache(seed);
}


/***/ }),
/* 134 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WriteError", function() { return WriteError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "enhanceErrorWithDocument", function() { return enhanceErrorWithDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreWriter", function() { return StoreWriter; });
/* harmony import */ var graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var graphql_language_printer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59);
/* harmony import */ var _objectCache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(135);
/* harmony import */ var _depTrackingCache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(133);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};




var WriteError = (function (_super) {
    __extends(WriteError, _super);
    function WriteError() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.type = 'WriteError';
        return _this;
    }
    return WriteError;
}(Error));

function enhanceErrorWithDocument(error, document) {
    var enhancedError = new WriteError("Error writing result to store for query:\n " + Object(graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__["print"])(document));
    enhancedError.message += '\n' + error.message;
    enhancedError.stack = error.stack;
    return enhancedError;
}
var StoreWriter = (function () {
    function StoreWriter() {
    }
    StoreWriter.prototype.writeQueryToStore = function (_a) {
        var query = _a.query, result = _a.result, _b = _a.store, store = _b === void 0 ? Object(_depTrackingCache__WEBPACK_IMPORTED_MODULE_3__["defaultNormalizedCacheFactory"])() : _b, variables = _a.variables, dataIdFromObject = _a.dataIdFromObject, fragmentMatcherFunction = _a.fragmentMatcherFunction;
        return this.writeResultToStore({
            dataId: 'ROOT_QUERY',
            result: result,
            document: query,
            store: store,
            variables: variables,
            dataIdFromObject: dataIdFromObject,
            fragmentMatcherFunction: fragmentMatcherFunction,
        });
    };
    StoreWriter.prototype.writeResultToStore = function (_a) {
        var dataId = _a.dataId, result = _a.result, document = _a.document, _b = _a.store, store = _b === void 0 ? Object(_depTrackingCache__WEBPACK_IMPORTED_MODULE_3__["defaultNormalizedCacheFactory"])() : _b, variables = _a.variables, dataIdFromObject = _a.dataIdFromObject, fragmentMatcherFunction = _a.fragmentMatcherFunction;
        var operationDefinition = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["getOperationDefinition"])(document);
        try {
            return this.writeSelectionSetToStore({
                result: result,
                dataId: dataId,
                selectionSet: operationDefinition.selectionSet,
                context: {
                    store: store,
                    processedData: {},
                    variables: Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["assign"])({}, Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["getDefaultValues"])(operationDefinition), variables),
                    dataIdFromObject: dataIdFromObject,
                    fragmentMap: Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["createFragmentMap"])(Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["getFragmentDefinitions"])(document)),
                    fragmentMatcherFunction: fragmentMatcherFunction,
                },
            });
        }
        catch (e) {
            throw enhanceErrorWithDocument(e, document);
        }
    };
    StoreWriter.prototype.writeSelectionSetToStore = function (_a) {
        var _this = this;
        var result = _a.result, dataId = _a.dataId, selectionSet = _a.selectionSet, context = _a.context;
        var variables = context.variables, store = context.store, fragmentMap = context.fragmentMap;
        selectionSet.selections.forEach(function (selection) {
            if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["shouldInclude"])(selection, variables)) {
                return;
            }
            if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isField"])(selection)) {
                var resultFieldKey = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["resultKeyNameFromField"])(selection);
                var value = result[resultFieldKey];
                if (typeof value !== 'undefined') {
                    _this.writeFieldToStore({
                        dataId: dataId,
                        value: value,
                        field: selection,
                        context: context,
                    });
                }
                else {
                    var isDefered = selection.directives &&
                        selection.directives.length &&
                        selection.directives.some(function (directive) { return directive.name && directive.name.value === 'defer'; });
                    if (!isDefered && context.fragmentMatcherFunction) {
                        if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isProduction"])()) {
                            console.warn("Missing field " + resultFieldKey + " in " + JSON.stringify(result, null, 2).substring(0, 100));
                        }
                    }
                }
            }
            else {
                var fragment = void 0;
                if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isInlineFragment"])(selection)) {
                    fragment = selection;
                }
                else {
                    fragment = (fragmentMap || {})[selection.name.value];
                    if (!fragment) {
                        throw new Error("No fragment named " + selection.name.value + ".");
                    }
                }
                var matches = true;
                if (context.fragmentMatcherFunction && fragment.typeCondition) {
                    var idValue = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["toIdValue"])({ id: 'self', typename: undefined });
                    var fakeContext = {
                        store: new _objectCache__WEBPACK_IMPORTED_MODULE_2__["ObjectCache"]({ self: result }),
                        cacheRedirects: {},
                    };
                    var match = context.fragmentMatcherFunction(idValue, fragment.typeCondition.name.value, fakeContext);
                    if (!Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isProduction"])() && match === 'heuristic') {
                        console.error('WARNING: heuristic fragment matching going on!');
                    }
                    matches = !!match;
                }
                if (matches) {
                    _this.writeSelectionSetToStore({
                        result: result,
                        selectionSet: fragment.selectionSet,
                        dataId: dataId,
                        context: context,
                    });
                }
            }
        });
        return store;
    };
    StoreWriter.prototype.writeFieldToStore = function (_a) {
        var field = _a.field, value = _a.value, dataId = _a.dataId, context = _a.context;
        var _b;
        var variables = context.variables, dataIdFromObject = context.dataIdFromObject, store = context.store;
        var storeValue;
        var storeObject;
        var storeFieldName = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["storeKeyNameFromField"])(field, variables);
        if (!field.selectionSet || value === null) {
            storeValue =
                value != null && typeof value === 'object'
                    ?
                        { type: 'json', json: value }
                    :
                        value;
        }
        else if (Array.isArray(value)) {
            var generatedId = dataId + "." + storeFieldName;
            storeValue = this.processArrayValue(value, generatedId, field.selectionSet, context);
        }
        else {
            var valueDataId = dataId + "." + storeFieldName;
            var generated = true;
            if (!isGeneratedId(valueDataId)) {
                valueDataId = '$' + valueDataId;
            }
            if (dataIdFromObject) {
                var semanticId = dataIdFromObject(value);
                if (semanticId && isGeneratedId(semanticId)) {
                    throw new Error('IDs returned by dataIdFromObject cannot begin with the "$" character.');
                }
                if (semanticId ||
                    (typeof semanticId === 'number' && semanticId === 0)) {
                    valueDataId = semanticId;
                    generated = false;
                }
            }
            if (!isDataProcessed(valueDataId, field, context.processedData)) {
                this.writeSelectionSetToStore({
                    dataId: valueDataId,
                    result: value,
                    selectionSet: field.selectionSet,
                    context: context,
                });
            }
            var typename = value.__typename;
            storeValue = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["toIdValue"])({ id: valueDataId, typename: typename }, generated);
            storeObject = store.get(dataId);
            var escapedId = storeObject && storeObject[storeFieldName];
            if (escapedId !== storeValue && Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isIdValue"])(escapedId)) {
                var hadTypename = escapedId.typename !== undefined;
                var hasTypename = typename !== undefined;
                var typenameChanged = hadTypename && hasTypename && escapedId.typename !== typename;
                if (generated && !escapedId.generated && !typenameChanged) {
                    throw new Error("Store error: the application attempted to write an object with no provided id" +
                        (" but the store already contains an id of " + escapedId.id + " for this object. The selectionSet") +
                        " that was trying to be written is:\n" +
                        Object(graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__["print"])(field));
                }
                if (hadTypename && !hasTypename) {
                    throw new Error("Store error: the application attempted to write an object with no provided typename" +
                        (" but the store already contains an object with typename of " + escapedId.typename + " for the object of id " + escapedId.id + ". The selectionSet") +
                        " that was trying to be written is:\n" +
                        Object(graphql_language_printer__WEBPACK_IMPORTED_MODULE_0__["print"])(field));
                }
                if (escapedId.generated) {
                    if (typenameChanged) {
                        if (!generated) {
                            store.delete(escapedId.id);
                        }
                    }
                    else {
                        mergeWithGenerated(escapedId.id, storeValue.id, store);
                    }
                }
            }
        }
        storeObject = store.get(dataId);
        if (!storeObject || !Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isEqual"])(storeValue, storeObject[storeFieldName])) {
            store.set(dataId, __assign({}, storeObject, (_b = {}, _b[storeFieldName] = storeValue, _b)));
        }
    };
    StoreWriter.prototype.processArrayValue = function (value, generatedId, selectionSet, context) {
        var _this = this;
        return value.map(function (item, index) {
            if (item === null) {
                return null;
            }
            var itemDataId = generatedId + "." + index;
            if (Array.isArray(item)) {
                return _this.processArrayValue(item, itemDataId, selectionSet, context);
            }
            var generated = true;
            if (context.dataIdFromObject) {
                var semanticId = context.dataIdFromObject(item);
                if (semanticId) {
                    itemDataId = semanticId;
                    generated = false;
                }
            }
            if (!isDataProcessed(itemDataId, selectionSet, context.processedData)) {
                _this.writeSelectionSetToStore({
                    dataId: itemDataId,
                    result: item,
                    selectionSet: selectionSet,
                    context: context,
                });
            }
            return Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["toIdValue"])({ id: itemDataId, typename: item.__typename }, generated);
        });
    };
    return StoreWriter;
}());

function isGeneratedId(id) {
    return id[0] === '$';
}
function mergeWithGenerated(generatedKey, realKey, cache) {
    if (generatedKey === realKey) {
        return false;
    }
    var generated = cache.get(generatedKey);
    var real = cache.get(realKey);
    var madeChanges = false;
    Object.keys(generated).forEach(function (key) {
        var value = generated[key];
        var realValue = real[key];
        if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isIdValue"])(value) &&
            isGeneratedId(value.id) &&
            Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isIdValue"])(realValue) &&
            !Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isEqual"])(value, realValue) &&
            mergeWithGenerated(value.id, realValue.id, cache)) {
            madeChanges = true;
        }
    });
    cache.delete(generatedKey);
    var newRealValue = __assign({}, generated, real);
    if (Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isEqual"])(newRealValue, real)) {
        return madeChanges;
    }
    cache.set(realKey, newRealValue);
    return true;
}
function isDataProcessed(dataId, field, processedData) {
    if (!processedData) {
        return false;
    }
    if (processedData[dataId]) {
        if (processedData[dataId].indexOf(field) >= 0) {
            return true;
        }
        else {
            processedData[dataId].push(field);
        }
    }
    else {
        processedData[dataId] = [field];
    }
    return false;
}


/***/ }),
/* 135 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ObjectCache", function() { return ObjectCache; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultNormalizedCacheFactory", function() { return defaultNormalizedCacheFactory; });
var ObjectCache = (function () {
    function ObjectCache(data) {
        if (data === void 0) { data = Object.create(null); }
        this.data = data;
    }
    ObjectCache.prototype.toObject = function () {
        return this.data;
    };
    ObjectCache.prototype.get = function (dataId) {
        return this.data[dataId];
    };
    ObjectCache.prototype.set = function (dataId, value) {
        this.data[dataId] = value;
    };
    ObjectCache.prototype.delete = function (dataId) {
        this.data[dataId] = undefined;
    };
    ObjectCache.prototype.clear = function () {
        this.data = Object.create(null);
    };
    ObjectCache.prototype.replace = function (newData) {
        this.data = newData || Object.create(null);
    };
    return ObjectCache;
}());

function defaultNormalizedCacheFactory(seed) {
    return new ObjectCache(seed);
}


/***/ }),
/* 136 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RecordingCache", function() { return RecordingCache; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "record", function() { return record; });
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var RecordingCache = (function () {
    function RecordingCache(data) {
        if (data === void 0) { data = {}; }
        this.data = data;
        this.recordedData = {};
    }
    RecordingCache.prototype.record = function (transaction) {
        transaction(this);
        var recordedData = this.recordedData;
        this.recordedData = {};
        return recordedData;
    };
    RecordingCache.prototype.toObject = function () {
        return __assign({}, this.data, this.recordedData);
    };
    RecordingCache.prototype.get = function (dataId) {
        if (this.recordedData.hasOwnProperty(dataId)) {
            return this.recordedData[dataId];
        }
        return this.data[dataId];
    };
    RecordingCache.prototype.set = function (dataId, value) {
        if (this.get(dataId) !== value) {
            this.recordedData[dataId] = value;
        }
    };
    RecordingCache.prototype.delete = function (dataId) {
        this.recordedData[dataId] = undefined;
    };
    RecordingCache.prototype.clear = function () {
        var _this = this;
        Object.keys(this.data).forEach(function (dataId) { return _this.delete(dataId); });
        this.recordedData = {};
    };
    RecordingCache.prototype.replace = function (newData) {
        this.clear();
        this.recordedData = __assign({}, newData);
    };
    return RecordingCache;
}());

function record(startingState, transaction) {
    var recordingCache = new RecordingCache(startingState);
    return recordingCache.record(transaction);
}


/***/ }),
/* 137 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Observable", function() { return Observable; });
/* harmony import */ var zen_observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(124);
/* harmony import */ var zen_observable__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(zen_observable__WEBPACK_IMPORTED_MODULE_0__);


var Observable = zen_observable__WEBPACK_IMPORTED_MODULE_0___default.a;

/* harmony default export */ __webpack_exports__["default"] = (Observable);




/***/ }),
/* 138 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addTypenameToDocument", function() { return addTypenameToDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "argumentsObjectFromField", function() { return argumentsObjectFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return assign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "buildQueryFromSelectionSet", function() { return buildQueryFromSelectionSet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "canUseWeakMap", function() { return canUseWeakMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "checkDocument", function() { return checkDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cloneDeep", function() { return cloneDeep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createFragmentMap", function() { return createFragmentMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDefaultValues", function() { return getDefaultValues; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveInfoFromField", function() { return getDirectiveInfoFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveNames", function() { return getDirectiveNames; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectivesFromDocument", function() { return getDirectivesFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getEnv", function() { return getEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinition", function() { return getFragmentDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinitions", function() { return getFragmentDefinitions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentQueryDocument", function() { return getFragmentQueryDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getInclusionDirectives", function() { return getInclusionDirectives; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMainDefinition", function() { return getMainDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMutationDefinition", function() { return getMutationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinition", function() { return getOperationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinitionOrDie", function() { return getOperationDefinitionOrDie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationName", function() { return getOperationName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getQueryDefinition", function() { return getQueryDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getStoreKeyName", function() { return getStoreKeyName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "graphQLResultHasError", function() { return graphQLResultHasError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasClientExports", function() { return hasClientExports; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasDirectives", function() { return hasDirectives; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDevelopment", function() { return isDevelopment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isEnv", function() { return isEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isField", function() { return isField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isIdValue", function() { return isIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isInlineFragment", function() { return isInlineFragment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isJsonValue", function() { return isJsonValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNumberValue", function() { return isNumberValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isProduction", function() { return isProduction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isScalarValue", function() { return isScalarValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isTest", function() { return isTest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "maybeDeepFreeze", function() { return maybeDeepFreeze; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mergeDeep", function() { return mergeDeep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mergeDeepArray", function() { return mergeDeepArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeArgumentsFromDocument", function() { return removeArgumentsFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeClientSetsFromDocument", function() { return removeClientSetsFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeConnectionDirectiveFromDocument", function() { return removeConnectionDirectiveFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeDirectivesFromDocument", function() { return removeDirectivesFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeFragmentSpreadFromDocument", function() { return removeFragmentSpreadFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resultKeyNameFromField", function() { return resultKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shouldInclude", function() { return shouldInclude; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "storeKeyNameFromField", function() { return storeKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stripSymbols", function() { return stripSymbols; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toIdValue", function() { return toIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tryFunctionOrLogError", function() { return tryFunctionOrLogError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueFromNode", function() { return valueFromNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueToObjectRepresentation", function() { return valueToObjectRepresentation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "variablesInOperation", function() { return variablesInOperation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "warnOnceInDevelopment", function() { return warnOnceInDevelopment; });
/* harmony import */ var graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81);
/* harmony import */ var graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ts_invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(90);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(394);
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84);
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wry_equality__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isEqual", function() { return _wry_equality__WEBPACK_IMPORTED_MODULE_4__["equal"]; });







function isScalarValue(value) {
    return ['StringValue', 'BooleanValue', 'EnumValue'].indexOf(value.kind) > -1;
}
function isNumberValue(value) {
    return ['IntValue', 'FloatValue'].indexOf(value.kind) > -1;
}
function isStringValue(value) {
    return value.kind === 'StringValue';
}
function isBooleanValue(value) {
    return value.kind === 'BooleanValue';
}
function isIntValue(value) {
    return value.kind === 'IntValue';
}
function isFloatValue(value) {
    return value.kind === 'FloatValue';
}
function isVariable(value) {
    return value.kind === 'Variable';
}
function isObjectValue(value) {
    return value.kind === 'ObjectValue';
}
function isListValue(value) {
    return value.kind === 'ListValue';
}
function isEnumValue(value) {
    return value.kind === 'EnumValue';
}
function isNullValue(value) {
    return value.kind === 'NullValue';
}
function valueToObjectRepresentation(argObj, name, value, variables) {
    if (isIntValue(value) || isFloatValue(value)) {
        argObj[name.value] = Number(value.value);
    }
    else if (isBooleanValue(value) || isStringValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isObjectValue(value)) {
        var nestedArgObj_1 = {};
        value.fields.map(function (obj) {
            return valueToObjectRepresentation(nestedArgObj_1, obj.name, obj.value, variables);
        });
        argObj[name.value] = nestedArgObj_1;
    }
    else if (isVariable(value)) {
        var variableValue = (variables || {})[value.name.value];
        argObj[name.value] = variableValue;
    }
    else if (isListValue(value)) {
        argObj[name.value] = value.values.map(function (listValue) {
            var nestedArgArrayObj = {};
            valueToObjectRepresentation(nestedArgArrayObj, name, listValue, variables);
            return nestedArgArrayObj[name.value];
        });
    }
    else if (isEnumValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isNullValue(value)) {
        argObj[name.value] = null;
    }
    else {
        throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](17) : undefined;
    }
}
function storeKeyNameFromField(field, variables) {
    var directivesObj = null;
    if (field.directives) {
        directivesObj = {};
        field.directives.forEach(function (directive) {
            directivesObj[directive.name.value] = {};
            if (directive.arguments) {
                directive.arguments.forEach(function (_a) {
                    var name = _a.name, value = _a.value;
                    return valueToObjectRepresentation(directivesObj[directive.name.value], name, value, variables);
                });
            }
        });
    }
    var argObj = null;
    if (field.arguments && field.arguments.length) {
        argObj = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj, name, value, variables);
        });
    }
    return getStoreKeyName(field.name.value, argObj, directivesObj);
}
var KNOWN_DIRECTIVES = [
    'connection',
    'include',
    'skip',
    'client',
    'rest',
    'export',
];
function getStoreKeyName(fieldName, args, directives) {
    if (directives &&
        directives['connection'] &&
        directives['connection']['key']) {
        if (directives['connection']['filter'] &&
            directives['connection']['filter'].length > 0) {
            var filterKeys = directives['connection']['filter']
                ? directives['connection']['filter']
                : [];
            filterKeys.sort();
            var queryArgs_1 = args;
            var filteredArgs_1 = {};
            filterKeys.forEach(function (key) {
                filteredArgs_1[key] = queryArgs_1[key];
            });
            return directives['connection']['key'] + "(" + JSON.stringify(filteredArgs_1) + ")";
        }
        else {
            return directives['connection']['key'];
        }
    }
    var completeFieldName = fieldName;
    if (args) {
        var stringifiedArgs = fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3___default()(args);
        completeFieldName += "(" + stringifiedArgs + ")";
    }
    if (directives) {
        Object.keys(directives).forEach(function (key) {
            if (KNOWN_DIRECTIVES.indexOf(key) !== -1)
                return;
            if (directives[key] && Object.keys(directives[key]).length) {
                completeFieldName += "@" + key + "(" + JSON.stringify(directives[key]) + ")";
            }
            else {
                completeFieldName += "@" + key;
            }
        });
    }
    return completeFieldName;
}
function argumentsObjectFromField(field, variables) {
    if (field.arguments && field.arguments.length) {
        var argObj_1 = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj_1, name, value, variables);
        });
        return argObj_1;
    }
    return null;
}
function resultKeyNameFromField(field) {
    return field.alias ? field.alias.value : field.name.value;
}
function isField(selection) {
    return selection.kind === 'Field';
}
function isInlineFragment(selection) {
    return selection.kind === 'InlineFragment';
}
function isIdValue(idObject) {
    return idObject &&
        idObject.type === 'id' &&
        typeof idObject.generated === 'boolean';
}
function toIdValue(idConfig, generated) {
    if (generated === void 0) { generated = false; }
    return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({ type: 'id', generated: generated }, (typeof idConfig === 'string'
        ? { id: idConfig, typename: undefined }
        : idConfig));
}
function isJsonValue(jsonObject) {
    return (jsonObject != null &&
        typeof jsonObject === 'object' &&
        jsonObject.type === 'json');
}
function defaultValueFromVariable(node) {
    throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](18) : undefined;
}
function valueFromNode(node, onVariable) {
    if (onVariable === void 0) { onVariable = defaultValueFromVariable; }
    switch (node.kind) {
        case 'Variable':
            return onVariable(node);
        case 'NullValue':
            return null;
        case 'IntValue':
            return parseInt(node.value, 10);
        case 'FloatValue':
            return parseFloat(node.value);
        case 'ListValue':
            return node.values.map(function (v) { return valueFromNode(v, onVariable); });
        case 'ObjectValue': {
            var value = {};
            for (var _i = 0, _a = node.fields; _i < _a.length; _i++) {
                var field = _a[_i];
                value[field.name.value] = valueFromNode(field.value, onVariable);
            }
            return value;
        }
        default:
            return node.value;
    }
}

function getDirectiveInfoFromField(field, variables) {
    if (field.directives && field.directives.length) {
        var directiveObj_1 = {};
        field.directives.forEach(function (directive) {
            directiveObj_1[directive.name.value] = argumentsObjectFromField(directive, variables);
        });
        return directiveObj_1;
    }
    return null;
}
function shouldInclude(selection, variables) {
    if (variables === void 0) { variables = {}; }
    return getInclusionDirectives(selection.directives).every(function (_a) {
        var directive = _a.directive, ifArgument = _a.ifArgument;
        var evaledValue = false;
        if (ifArgument.value.kind === 'Variable') {
            evaledValue = variables[ifArgument.value.name.value];
             true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(evaledValue !== void 0, 1) : undefined;
        }
        else {
            evaledValue = ifArgument.value.value;
        }
        return directive.name.value === 'skip' ? !evaledValue : evaledValue;
    });
}
function getDirectiveNames(doc) {
    var names = [];
    Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        Directive: function (node) {
            names.push(node.name.value);
        },
    });
    return names;
}
function hasDirectives(names, doc) {
    return getDirectiveNames(doc).some(function (name) { return names.indexOf(name) > -1; });
}
function hasClientExports(document) {
    return (document &&
        hasDirectives(['client'], document) &&
        hasDirectives(['export'], document));
}
function isInclusionDirective(_a) {
    var value = _a.name.value;
    return value === 'skip' || value === 'include';
}
function getInclusionDirectives(directives) {
    return directives ? directives.filter(isInclusionDirective).map(function (directive) {
        var directiveArguments = directive.arguments;
        var directiveName = directive.name.value;
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(directiveArguments && directiveArguments.length === 1, 2) : undefined;
        var ifArgument = directiveArguments[0];
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(ifArgument.name && ifArgument.name.value === 'if', 3) : undefined;
        var ifValue = ifArgument.value;
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(ifValue &&
            (ifValue.kind === 'Variable' || ifValue.kind === 'BooleanValue'), 4) : undefined;
        return { directive: directive, ifArgument: ifArgument };
    }) : [];
}

function getFragmentQueryDocument(document, fragmentName) {
    var actualFragmentName = fragmentName;
    var fragments = [];
    document.definitions.forEach(function (definition) {
        if (definition.kind === 'OperationDefinition') {
            throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](5) : undefined;
        }
        if (definition.kind === 'FragmentDefinition') {
            fragments.push(definition);
        }
    });
    if (typeof actualFragmentName === 'undefined') {
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(fragments.length === 1, 6) : undefined;
        actualFragmentName = fragments[0].name.value;
    }
    var query = Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, document), { definitions: Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__spreadArrays"])([
            {
                kind: 'OperationDefinition',
                operation: 'query',
                selectionSet: {
                    kind: 'SelectionSet',
                    selections: [
                        {
                            kind: 'FragmentSpread',
                            name: {
                                kind: 'Name',
                                value: actualFragmentName,
                            },
                        },
                    ],
                },
            }
        ], document.definitions) });
    return query;
}

function assign(target) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    sources.forEach(function (source) {
        if (typeof source === 'undefined' || source === null) {
            return;
        }
        Object.keys(source).forEach(function (key) {
            target[key] = source[key];
        });
    });
    return target;
}

function getMutationDefinition(doc) {
    checkDocument(doc);
    var mutationDef = doc.definitions.filter(function (definition) {
        return definition.kind === 'OperationDefinition' &&
            definition.operation === 'mutation';
    })[0];
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(mutationDef, 7) : undefined;
    return mutationDef;
}
function checkDocument(doc) {
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(doc && doc.kind === 'Document', 8) : undefined;
    var operations = doc.definitions
        .filter(function (d) { return d.kind !== 'FragmentDefinition'; })
        .map(function (definition) {
        if (definition.kind !== 'OperationDefinition') {
            throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](9) : undefined;
        }
        return definition;
    });
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(operations.length <= 1, 10) : undefined;
    return doc;
}
function getOperationDefinition(doc) {
    checkDocument(doc);
    return doc.definitions.filter(function (definition) { return definition.kind === 'OperationDefinition'; })[0];
}
function getOperationDefinitionOrDie(document) {
    var def = getOperationDefinition(document);
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(def, 11) : undefined;
    return def;
}
function getOperationName(doc) {
    return (doc.definitions
        .filter(function (definition) {
        return definition.kind === 'OperationDefinition' && definition.name;
    })
        .map(function (x) { return x.name.value; })[0] || null);
}
function getFragmentDefinitions(doc) {
    return doc.definitions.filter(function (definition) { return definition.kind === 'FragmentDefinition'; });
}
function getQueryDefinition(doc) {
    var queryDef = getOperationDefinition(doc);
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(queryDef && queryDef.operation === 'query', 12) : undefined;
    return queryDef;
}
function getFragmentDefinition(doc) {
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(doc.kind === 'Document', 13) : undefined;
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(doc.definitions.length <= 1, 14) : undefined;
    var fragmentDef = doc.definitions[0];
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(fragmentDef.kind === 'FragmentDefinition', 15) : undefined;
    return fragmentDef;
}
function getMainDefinition(queryDoc) {
    checkDocument(queryDoc);
    var fragmentDefinition;
    for (var _i = 0, _a = queryDoc.definitions; _i < _a.length; _i++) {
        var definition = _a[_i];
        if (definition.kind === 'OperationDefinition') {
            var operation = definition.operation;
            if (operation === 'query' ||
                operation === 'mutation' ||
                operation === 'subscription') {
                return definition;
            }
        }
        if (definition.kind === 'FragmentDefinition' && !fragmentDefinition) {
            fragmentDefinition = definition;
        }
    }
    if (fragmentDefinition) {
        return fragmentDefinition;
    }
    throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](16) : undefined;
}
function createFragmentMap(fragments) {
    if (fragments === void 0) { fragments = []; }
    var symTable = {};
    fragments.forEach(function (fragment) {
        symTable[fragment.name.value] = fragment;
    });
    return symTable;
}
function getDefaultValues(definition) {
    if (definition &&
        definition.variableDefinitions &&
        definition.variableDefinitions.length) {
        var defaultValues = definition.variableDefinitions
            .filter(function (_a) {
            var defaultValue = _a.defaultValue;
            return defaultValue;
        })
            .map(function (_a) {
            var variable = _a.variable, defaultValue = _a.defaultValue;
            var defaultValueObj = {};
            valueToObjectRepresentation(defaultValueObj, variable.name, defaultValue);
            return defaultValueObj;
        });
        return assign.apply(void 0, Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__spreadArrays"])([{}], defaultValues));
    }
    return {};
}
function variablesInOperation(operation) {
    var names = new Set();
    if (operation.variableDefinitions) {
        for (var _i = 0, _a = operation.variableDefinitions; _i < _a.length; _i++) {
            var definition = _a[_i];
            names.add(definition.variable.name.value);
        }
    }
    return names;
}

function filterInPlace(array, test, context) {
    var target = 0;
    array.forEach(function (elem, i) {
        if (test.call(this, elem, i, array)) {
            array[target++] = elem;
        }
    }, context);
    array.length = target;
    return array;
}

var TYPENAME_FIELD = {
    kind: 'Field',
    name: {
        kind: 'Name',
        value: '__typename',
    },
};
function isEmpty(op, fragments) {
    return op.selectionSet.selections.every(function (selection) {
        return selection.kind === 'FragmentSpread' &&
            isEmpty(fragments[selection.name.value], fragments);
    });
}
function nullIfDocIsEmpty(doc) {
    return isEmpty(getOperationDefinition(doc) || getFragmentDefinition(doc), createFragmentMap(getFragmentDefinitions(doc)))
        ? null
        : doc;
}
function getDirectiveMatcher(directives) {
    return function directiveMatcher(directive) {
        return directives.some(function (dir) {
            return (dir.name && dir.name === directive.name.value) ||
                (dir.test && dir.test(directive));
        });
    };
}
function removeDirectivesFromDocument(directives, doc) {
    var variablesInUse = Object.create(null);
    var variablesToRemove = [];
    var fragmentSpreadsInUse = Object.create(null);
    var fragmentSpreadsToRemove = [];
    var modifiedDoc = nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        Variable: {
            enter: function (node, _key, parent) {
                if (parent.kind !== 'VariableDefinition') {
                    variablesInUse[node.name.value] = true;
                }
            },
        },
        Field: {
            enter: function (node) {
                if (directives && node.directives) {
                    var shouldRemoveField = directives.some(function (directive) { return directive.remove; });
                    if (shouldRemoveField &&
                        node.directives &&
                        node.directives.some(getDirectiveMatcher(directives))) {
                        if (node.arguments) {
                            node.arguments.forEach(function (arg) {
                                if (arg.value.kind === 'Variable') {
                                    variablesToRemove.push({
                                        name: arg.value.name.value,
                                    });
                                }
                            });
                        }
                        if (node.selectionSet) {
                            getAllFragmentSpreadsFromSelectionSet(node.selectionSet).forEach(function (frag) {
                                fragmentSpreadsToRemove.push({
                                    name: frag.name.value,
                                });
                            });
                        }
                        return null;
                    }
                }
            },
        },
        FragmentSpread: {
            enter: function (node) {
                fragmentSpreadsInUse[node.name.value] = true;
            },
        },
        Directive: {
            enter: function (node) {
                if (getDirectiveMatcher(directives)(node)) {
                    return null;
                }
            },
        },
    }));
    if (modifiedDoc &&
        filterInPlace(variablesToRemove, function (v) { return !variablesInUse[v.name]; }).length) {
        modifiedDoc = removeArgumentsFromDocument(variablesToRemove, modifiedDoc);
    }
    if (modifiedDoc &&
        filterInPlace(fragmentSpreadsToRemove, function (fs) { return !fragmentSpreadsInUse[fs.name]; })
            .length) {
        modifiedDoc = removeFragmentSpreadFromDocument(fragmentSpreadsToRemove, modifiedDoc);
    }
    return modifiedDoc;
}
function addTypenameToDocument(doc) {
    return Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(checkDocument(doc), {
        SelectionSet: {
            enter: function (node, _key, parent) {
                if (parent &&
                    parent.kind === 'OperationDefinition') {
                    return;
                }
                var selections = node.selections;
                if (!selections) {
                    return;
                }
                var skip = selections.some(function (selection) {
                    return (isField(selection) &&
                        (selection.name.value === '__typename' ||
                            selection.name.value.lastIndexOf('__', 0) === 0));
                });
                if (skip) {
                    return;
                }
                var field = parent;
                if (isField(field) &&
                    field.directives &&
                    field.directives.some(function (d) { return d.name.value === 'export'; })) {
                    return;
                }
                return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { selections: Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__spreadArrays"])(selections, [TYPENAME_FIELD]) });
            },
        },
    });
}
var connectionRemoveConfig = {
    test: function (directive) {
        var willRemove = directive.name.value === 'connection';
        if (willRemove) {
            if (!directive.arguments ||
                !directive.arguments.some(function (arg) { return arg.name.value === 'key'; })) {
                 true || false;
            }
        }
        return willRemove;
    },
};
function removeConnectionDirectiveFromDocument(doc) {
    return removeDirectivesFromDocument([connectionRemoveConfig], checkDocument(doc));
}
function hasDirectivesInSelectionSet(directives, selectionSet, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    return (selectionSet &&
        selectionSet.selections &&
        selectionSet.selections.some(function (selection) {
            return hasDirectivesInSelection(directives, selection, nestedCheck);
        }));
}
function hasDirectivesInSelection(directives, selection, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    if (!isField(selection)) {
        return true;
    }
    if (!selection.directives) {
        return false;
    }
    return (selection.directives.some(getDirectiveMatcher(directives)) ||
        (nestedCheck &&
            hasDirectivesInSelectionSet(directives, selection.selectionSet, nestedCheck)));
}
function getDirectivesFromDocument(directives, doc) {
    checkDocument(doc);
    var parentPath;
    return nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        SelectionSet: {
            enter: function (node, _key, _parent, path) {
                var currentPath = path.join('-');
                if (!parentPath ||
                    currentPath === parentPath ||
                    !currentPath.startsWith(parentPath)) {
                    if (node.selections) {
                        var selectionsWithDirectives = node.selections.filter(function (selection) { return hasDirectivesInSelection(directives, selection); });
                        if (hasDirectivesInSelectionSet(directives, node, false)) {
                            parentPath = currentPath;
                        }
                        return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { selections: selectionsWithDirectives });
                    }
                    else {
                        return null;
                    }
                }
            },
        },
    }));
}
function getArgumentMatcher(config) {
    return function argumentMatcher(argument) {
        return config.some(function (aConfig) {
            return argument.value &&
                argument.value.kind === 'Variable' &&
                argument.value.name &&
                (aConfig.name === argument.value.name.value ||
                    (aConfig.test && aConfig.test(argument)));
        });
    };
}
function removeArgumentsFromDocument(config, doc) {
    var argMatcher = getArgumentMatcher(config);
    return nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        OperationDefinition: {
            enter: function (node) {
                return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { variableDefinitions: node.variableDefinitions.filter(function (varDef) {
                        return !config.some(function (arg) { return arg.name === varDef.variable.name.value; });
                    }) });
            },
        },
        Field: {
            enter: function (node) {
                var shouldRemoveField = config.some(function (argConfig) { return argConfig.remove; });
                if (shouldRemoveField) {
                    var argMatchCount_1 = 0;
                    node.arguments.forEach(function (arg) {
                        if (argMatcher(arg)) {
                            argMatchCount_1 += 1;
                        }
                    });
                    if (argMatchCount_1 === 1) {
                        return null;
                    }
                }
            },
        },
        Argument: {
            enter: function (node) {
                if (argMatcher(node)) {
                    return null;
                }
            },
        },
    }));
}
function removeFragmentSpreadFromDocument(config, doc) {
    function enter(node) {
        if (config.some(function (def) { return def.name === node.name.value; })) {
            return null;
        }
    }
    return nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        FragmentSpread: { enter: enter },
        FragmentDefinition: { enter: enter },
    }));
}
function getAllFragmentSpreadsFromSelectionSet(selectionSet) {
    var allFragments = [];
    selectionSet.selections.forEach(function (selection) {
        if ((isField(selection) || isInlineFragment(selection)) &&
            selection.selectionSet) {
            getAllFragmentSpreadsFromSelectionSet(selection.selectionSet).forEach(function (frag) { return allFragments.push(frag); });
        }
        else if (selection.kind === 'FragmentSpread') {
            allFragments.push(selection);
        }
    });
    return allFragments;
}
function buildQueryFromSelectionSet(document) {
    var definition = getMainDefinition(document);
    var definitionOperation = definition.operation;
    if (definitionOperation === 'query') {
        return document;
    }
    var modifiedDoc = Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(document, {
        OperationDefinition: {
            enter: function (node) {
                return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { operation: 'query' });
            },
        },
    });
    return modifiedDoc;
}
function removeClientSetsFromDocument(document) {
    checkDocument(document);
    var modifiedDoc = removeDirectivesFromDocument([
        {
            test: function (directive) { return directive.name.value === 'client'; },
            remove: true,
        },
    ], document);
    if (modifiedDoc) {
        modifiedDoc = Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(modifiedDoc, {
            FragmentDefinition: {
                enter: function (node) {
                    if (node.selectionSet) {
                        var isTypenameOnly = node.selectionSet.selections.every(function (selection) {
                            return isField(selection) && selection.name.value === '__typename';
                        });
                        if (isTypenameOnly) {
                            return null;
                        }
                    }
                },
            },
        });
    }
    return modifiedDoc;
}

var canUseWeakMap = typeof WeakMap === 'function' && !(typeof navigator === 'object' &&
    navigator.product === 'ReactNative');

var toString = Object.prototype.toString;
function cloneDeep(value) {
    return cloneDeepHelper(value, new Map());
}
function cloneDeepHelper(val, seen) {
    switch (toString.call(val)) {
        case "[object Array]": {
            if (seen.has(val))
                return seen.get(val);
            var copy_1 = val.slice(0);
            seen.set(val, copy_1);
            copy_1.forEach(function (child, i) {
                copy_1[i] = cloneDeepHelper(child, seen);
            });
            return copy_1;
        }
        case "[object Object]": {
            if (seen.has(val))
                return seen.get(val);
            var copy_2 = Object.create(Object.getPrototypeOf(val));
            seen.set(val, copy_2);
            Object.keys(val).forEach(function (key) {
                copy_2[key] = cloneDeepHelper(val[key], seen);
            });
            return copy_2;
        }
        default:
            return val;
    }
}

function getEnv() {
    if (typeof process !== 'undefined' && "production") {
        return "production";
    }
    return 'development';
}
function isEnv(env) {
    return getEnv() === env;
}
function isProduction() {
    return isEnv('production') === true;
}
function isDevelopment() {
    return isEnv('development') === true;
}
function isTest() {
    return isEnv('test') === true;
}

function tryFunctionOrLogError(f) {
    try {
        return f();
    }
    catch (e) {
        if (console.error) {
            console.error(e);
        }
    }
}
function graphQLResultHasError(result) {
    return result.errors && result.errors.length;
}

function deepFreeze(o) {
    Object.freeze(o);
    Object.getOwnPropertyNames(o).forEach(function (prop) {
        if (o[prop] !== null &&
            (typeof o[prop] === 'object' || typeof o[prop] === 'function') &&
            !Object.isFrozen(o[prop])) {
            deepFreeze(o[prop]);
        }
    });
    return o;
}
function maybeDeepFreeze(obj) {
    if (isDevelopment() || isTest()) {
        var symbolIsPolyfilled = typeof Symbol === 'function' && typeof Symbol('') === 'string';
        if (!symbolIsPolyfilled) {
            return deepFreeze(obj);
        }
    }
    return obj;
}

var hasOwnProperty = Object.prototype.hasOwnProperty;
function mergeDeep() {
    var sources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        sources[_i] = arguments[_i];
    }
    return mergeDeepArray(sources);
}
function mergeDeepArray(sources) {
    var target = sources[0] || {};
    var count = sources.length;
    if (count > 1) {
        var pastCopies = [];
        target = shallowCopyForMerge(target, pastCopies);
        for (var i = 1; i < count; ++i) {
            target = mergeHelper(target, sources[i], pastCopies);
        }
    }
    return target;
}
function isObject(obj) {
    return obj !== null && typeof obj === 'object';
}
function mergeHelper(target, source, pastCopies) {
    if (isObject(source) && isObject(target)) {
        if (Object.isExtensible && !Object.isExtensible(target)) {
            target = shallowCopyForMerge(target, pastCopies);
        }
        Object.keys(source).forEach(function (sourceKey) {
            var sourceValue = source[sourceKey];
            if (hasOwnProperty.call(target, sourceKey)) {
                var targetValue = target[sourceKey];
                if (sourceValue !== targetValue) {
                    target[sourceKey] = mergeHelper(shallowCopyForMerge(targetValue, pastCopies), sourceValue, pastCopies);
                }
            }
            else {
                target[sourceKey] = sourceValue;
            }
        });
        return target;
    }
    return source;
}
function shallowCopyForMerge(value, pastCopies) {
    if (value !== null &&
        typeof value === 'object' &&
        pastCopies.indexOf(value) < 0) {
        if (Array.isArray(value)) {
            value = value.slice(0);
        }
        else {
            value = Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({ __proto__: Object.getPrototypeOf(value) }, value);
        }
        pastCopies.push(value);
    }
    return value;
}

var haveWarned = Object.create({});
function warnOnceInDevelopment(msg, type) {
    if (type === void 0) { type = 'warn'; }
    if (!isProduction() && !haveWarned[msg]) {
        if (!isTest()) {
            haveWarned[msg] = true;
        }
        if (type === 'error') {
            console.error(msg);
        }
        else {
            console.warn(msg);
        }
    }
}

function stripSymbols(data) {
    return JSON.parse(JSON.stringify(data));
}




/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(26)))

/***/ }),
/* 139 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Observable", function() { return Observable; });
/* harmony import */ var zen_observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(124);
/* harmony import */ var zen_observable__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(zen_observable__WEBPACK_IMPORTED_MODULE_0__);


var Observable = zen_observable__WEBPACK_IMPORTED_MODULE_0___default.a;

/* harmony default export */ __webpack_exports__["default"] = (Observable);




/***/ }),
/* 140 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addTypenameToDocument", function() { return addTypenameToDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "argumentsObjectFromField", function() { return argumentsObjectFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "assign", function() { return assign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "buildQueryFromSelectionSet", function() { return buildQueryFromSelectionSet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "canUseWeakMap", function() { return canUseWeakMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "checkDocument", function() { return checkDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cloneDeep", function() { return cloneDeep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createFragmentMap", function() { return createFragmentMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDefaultValues", function() { return getDefaultValues; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveInfoFromField", function() { return getDirectiveInfoFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveNames", function() { return getDirectiveNames; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectivesFromDocument", function() { return getDirectivesFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getEnv", function() { return getEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinition", function() { return getFragmentDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentDefinitions", function() { return getFragmentDefinitions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentQueryDocument", function() { return getFragmentQueryDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getInclusionDirectives", function() { return getInclusionDirectives; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMainDefinition", function() { return getMainDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMutationDefinition", function() { return getMutationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinition", function() { return getOperationDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationDefinitionOrDie", function() { return getOperationDefinitionOrDie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOperationName", function() { return getOperationName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getQueryDefinition", function() { return getQueryDefinition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getStoreKeyName", function() { return getStoreKeyName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "graphQLResultHasError", function() { return graphQLResultHasError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasClientExports", function() { return hasClientExports; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasDirectives", function() { return hasDirectives; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDevelopment", function() { return isDevelopment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isEnv", function() { return isEnv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isField", function() { return isField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isIdValue", function() { return isIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isInlineFragment", function() { return isInlineFragment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isJsonValue", function() { return isJsonValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNumberValue", function() { return isNumberValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isProduction", function() { return isProduction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isScalarValue", function() { return isScalarValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isTest", function() { return isTest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "maybeDeepFreeze", function() { return maybeDeepFreeze; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mergeDeep", function() { return mergeDeep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mergeDeepArray", function() { return mergeDeepArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeArgumentsFromDocument", function() { return removeArgumentsFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeClientSetsFromDocument", function() { return removeClientSetsFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeConnectionDirectiveFromDocument", function() { return removeConnectionDirectiveFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeDirectivesFromDocument", function() { return removeDirectivesFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeFragmentSpreadFromDocument", function() { return removeFragmentSpreadFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resultKeyNameFromField", function() { return resultKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shouldInclude", function() { return shouldInclude; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "storeKeyNameFromField", function() { return storeKeyNameFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stripSymbols", function() { return stripSymbols; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toIdValue", function() { return toIdValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tryFunctionOrLogError", function() { return tryFunctionOrLogError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueFromNode", function() { return valueFromNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "valueToObjectRepresentation", function() { return valueToObjectRepresentation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "variablesInOperation", function() { return variablesInOperation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "warnOnceInDevelopment", function() { return warnOnceInDevelopment; });
/* harmony import */ var graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81);
/* harmony import */ var graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ts_invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(90);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(398);
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84);
/* harmony import */ var fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wry_equality__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isEqual", function() { return _wry_equality__WEBPACK_IMPORTED_MODULE_4__["equal"]; });







function isScalarValue(value) {
    return ['StringValue', 'BooleanValue', 'EnumValue'].indexOf(value.kind) > -1;
}
function isNumberValue(value) {
    return ['IntValue', 'FloatValue'].indexOf(value.kind) > -1;
}
function isStringValue(value) {
    return value.kind === 'StringValue';
}
function isBooleanValue(value) {
    return value.kind === 'BooleanValue';
}
function isIntValue(value) {
    return value.kind === 'IntValue';
}
function isFloatValue(value) {
    return value.kind === 'FloatValue';
}
function isVariable(value) {
    return value.kind === 'Variable';
}
function isObjectValue(value) {
    return value.kind === 'ObjectValue';
}
function isListValue(value) {
    return value.kind === 'ListValue';
}
function isEnumValue(value) {
    return value.kind === 'EnumValue';
}
function isNullValue(value) {
    return value.kind === 'NullValue';
}
function valueToObjectRepresentation(argObj, name, value, variables) {
    if (isIntValue(value) || isFloatValue(value)) {
        argObj[name.value] = Number(value.value);
    }
    else if (isBooleanValue(value) || isStringValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isObjectValue(value)) {
        var nestedArgObj_1 = {};
        value.fields.map(function (obj) {
            return valueToObjectRepresentation(nestedArgObj_1, obj.name, obj.value, variables);
        });
        argObj[name.value] = nestedArgObj_1;
    }
    else if (isVariable(value)) {
        var variableValue = (variables || {})[value.name.value];
        argObj[name.value] = variableValue;
    }
    else if (isListValue(value)) {
        argObj[name.value] = value.values.map(function (listValue) {
            var nestedArgArrayObj = {};
            valueToObjectRepresentation(nestedArgArrayObj, name, listValue, variables);
            return nestedArgArrayObj[name.value];
        });
    }
    else if (isEnumValue(value)) {
        argObj[name.value] = value.value;
    }
    else if (isNullValue(value)) {
        argObj[name.value] = null;
    }
    else {
        throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](17) : undefined;
    }
}
function storeKeyNameFromField(field, variables) {
    var directivesObj = null;
    if (field.directives) {
        directivesObj = {};
        field.directives.forEach(function (directive) {
            directivesObj[directive.name.value] = {};
            if (directive.arguments) {
                directive.arguments.forEach(function (_a) {
                    var name = _a.name, value = _a.value;
                    return valueToObjectRepresentation(directivesObj[directive.name.value], name, value, variables);
                });
            }
        });
    }
    var argObj = null;
    if (field.arguments && field.arguments.length) {
        argObj = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj, name, value, variables);
        });
    }
    return getStoreKeyName(field.name.value, argObj, directivesObj);
}
var KNOWN_DIRECTIVES = [
    'connection',
    'include',
    'skip',
    'client',
    'rest',
    'export',
];
function getStoreKeyName(fieldName, args, directives) {
    if (directives &&
        directives['connection'] &&
        directives['connection']['key']) {
        if (directives['connection']['filter'] &&
            directives['connection']['filter'].length > 0) {
            var filterKeys = directives['connection']['filter']
                ? directives['connection']['filter']
                : [];
            filterKeys.sort();
            var queryArgs_1 = args;
            var filteredArgs_1 = {};
            filterKeys.forEach(function (key) {
                filteredArgs_1[key] = queryArgs_1[key];
            });
            return directives['connection']['key'] + "(" + JSON.stringify(filteredArgs_1) + ")";
        }
        else {
            return directives['connection']['key'];
        }
    }
    var completeFieldName = fieldName;
    if (args) {
        var stringifiedArgs = fast_json_stable_stringify__WEBPACK_IMPORTED_MODULE_3___default()(args);
        completeFieldName += "(" + stringifiedArgs + ")";
    }
    if (directives) {
        Object.keys(directives).forEach(function (key) {
            if (KNOWN_DIRECTIVES.indexOf(key) !== -1)
                return;
            if (directives[key] && Object.keys(directives[key]).length) {
                completeFieldName += "@" + key + "(" + JSON.stringify(directives[key]) + ")";
            }
            else {
                completeFieldName += "@" + key;
            }
        });
    }
    return completeFieldName;
}
function argumentsObjectFromField(field, variables) {
    if (field.arguments && field.arguments.length) {
        var argObj_1 = {};
        field.arguments.forEach(function (_a) {
            var name = _a.name, value = _a.value;
            return valueToObjectRepresentation(argObj_1, name, value, variables);
        });
        return argObj_1;
    }
    return null;
}
function resultKeyNameFromField(field) {
    return field.alias ? field.alias.value : field.name.value;
}
function isField(selection) {
    return selection.kind === 'Field';
}
function isInlineFragment(selection) {
    return selection.kind === 'InlineFragment';
}
function isIdValue(idObject) {
    return idObject &&
        idObject.type === 'id' &&
        typeof idObject.generated === 'boolean';
}
function toIdValue(idConfig, generated) {
    if (generated === void 0) { generated = false; }
    return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({ type: 'id', generated: generated }, (typeof idConfig === 'string'
        ? { id: idConfig, typename: undefined }
        : idConfig));
}
function isJsonValue(jsonObject) {
    return (jsonObject != null &&
        typeof jsonObject === 'object' &&
        jsonObject.type === 'json');
}
function defaultValueFromVariable(node) {
    throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](18) : undefined;
}
function valueFromNode(node, onVariable) {
    if (onVariable === void 0) { onVariable = defaultValueFromVariable; }
    switch (node.kind) {
        case 'Variable':
            return onVariable(node);
        case 'NullValue':
            return null;
        case 'IntValue':
            return parseInt(node.value, 10);
        case 'FloatValue':
            return parseFloat(node.value);
        case 'ListValue':
            return node.values.map(function (v) { return valueFromNode(v, onVariable); });
        case 'ObjectValue': {
            var value = {};
            for (var _i = 0, _a = node.fields; _i < _a.length; _i++) {
                var field = _a[_i];
                value[field.name.value] = valueFromNode(field.value, onVariable);
            }
            return value;
        }
        default:
            return node.value;
    }
}

function getDirectiveInfoFromField(field, variables) {
    if (field.directives && field.directives.length) {
        var directiveObj_1 = {};
        field.directives.forEach(function (directive) {
            directiveObj_1[directive.name.value] = argumentsObjectFromField(directive, variables);
        });
        return directiveObj_1;
    }
    return null;
}
function shouldInclude(selection, variables) {
    if (variables === void 0) { variables = {}; }
    return getInclusionDirectives(selection.directives).every(function (_a) {
        var directive = _a.directive, ifArgument = _a.ifArgument;
        var evaledValue = false;
        if (ifArgument.value.kind === 'Variable') {
            evaledValue = variables[ifArgument.value.name.value];
             true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(evaledValue !== void 0, 1) : undefined;
        }
        else {
            evaledValue = ifArgument.value.value;
        }
        return directive.name.value === 'skip' ? !evaledValue : evaledValue;
    });
}
function getDirectiveNames(doc) {
    var names = [];
    Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        Directive: function (node) {
            names.push(node.name.value);
        },
    });
    return names;
}
function hasDirectives(names, doc) {
    return getDirectiveNames(doc).some(function (name) { return names.indexOf(name) > -1; });
}
function hasClientExports(document) {
    return (document &&
        hasDirectives(['client'], document) &&
        hasDirectives(['export'], document));
}
function isInclusionDirective(_a) {
    var value = _a.name.value;
    return value === 'skip' || value === 'include';
}
function getInclusionDirectives(directives) {
    return directives ? directives.filter(isInclusionDirective).map(function (directive) {
        var directiveArguments = directive.arguments;
        var directiveName = directive.name.value;
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(directiveArguments && directiveArguments.length === 1, 2) : undefined;
        var ifArgument = directiveArguments[0];
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(ifArgument.name && ifArgument.name.value === 'if', 3) : undefined;
        var ifValue = ifArgument.value;
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(ifValue &&
            (ifValue.kind === 'Variable' || ifValue.kind === 'BooleanValue'), 4) : undefined;
        return { directive: directive, ifArgument: ifArgument };
    }) : [];
}

function getFragmentQueryDocument(document, fragmentName) {
    var actualFragmentName = fragmentName;
    var fragments = [];
    document.definitions.forEach(function (definition) {
        if (definition.kind === 'OperationDefinition') {
            throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](5) : undefined;
        }
        if (definition.kind === 'FragmentDefinition') {
            fragments.push(definition);
        }
    });
    if (typeof actualFragmentName === 'undefined') {
         true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(fragments.length === 1, 6) : undefined;
        actualFragmentName = fragments[0].name.value;
    }
    var query = Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, document), { definitions: Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__spreadArrays"])([
            {
                kind: 'OperationDefinition',
                operation: 'query',
                selectionSet: {
                    kind: 'SelectionSet',
                    selections: [
                        {
                            kind: 'FragmentSpread',
                            name: {
                                kind: 'Name',
                                value: actualFragmentName,
                            },
                        },
                    ],
                },
            }
        ], document.definitions) });
    return query;
}

function assign(target) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    sources.forEach(function (source) {
        if (typeof source === 'undefined' || source === null) {
            return;
        }
        Object.keys(source).forEach(function (key) {
            target[key] = source[key];
        });
    });
    return target;
}

function getMutationDefinition(doc) {
    checkDocument(doc);
    var mutationDef = doc.definitions.filter(function (definition) {
        return definition.kind === 'OperationDefinition' &&
            definition.operation === 'mutation';
    })[0];
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(mutationDef, 7) : undefined;
    return mutationDef;
}
function checkDocument(doc) {
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(doc && doc.kind === 'Document', 8) : undefined;
    var operations = doc.definitions
        .filter(function (d) { return d.kind !== 'FragmentDefinition'; })
        .map(function (definition) {
        if (definition.kind !== 'OperationDefinition') {
            throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](9) : undefined;
        }
        return definition;
    });
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(operations.length <= 1, 10) : undefined;
    return doc;
}
function getOperationDefinition(doc) {
    checkDocument(doc);
    return doc.definitions.filter(function (definition) { return definition.kind === 'OperationDefinition'; })[0];
}
function getOperationDefinitionOrDie(document) {
    var def = getOperationDefinition(document);
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(def, 11) : undefined;
    return def;
}
function getOperationName(doc) {
    return (doc.definitions
        .filter(function (definition) {
        return definition.kind === 'OperationDefinition' && definition.name;
    })
        .map(function (x) { return x.name.value; })[0] || null);
}
function getFragmentDefinitions(doc) {
    return doc.definitions.filter(function (definition) { return definition.kind === 'FragmentDefinition'; });
}
function getQueryDefinition(doc) {
    var queryDef = getOperationDefinition(doc);
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(queryDef && queryDef.operation === 'query', 12) : undefined;
    return queryDef;
}
function getFragmentDefinition(doc) {
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(doc.kind === 'Document', 13) : undefined;
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(doc.definitions.length <= 1, 14) : undefined;
    var fragmentDef = doc.definitions[0];
     true ? Object(ts_invariant__WEBPACK_IMPORTED_MODULE_1__["invariant"])(fragmentDef.kind === 'FragmentDefinition', 15) : undefined;
    return fragmentDef;
}
function getMainDefinition(queryDoc) {
    checkDocument(queryDoc);
    var fragmentDefinition;
    for (var _i = 0, _a = queryDoc.definitions; _i < _a.length; _i++) {
        var definition = _a[_i];
        if (definition.kind === 'OperationDefinition') {
            var operation = definition.operation;
            if (operation === 'query' ||
                operation === 'mutation' ||
                operation === 'subscription') {
                return definition;
            }
        }
        if (definition.kind === 'FragmentDefinition' && !fragmentDefinition) {
            fragmentDefinition = definition;
        }
    }
    if (fragmentDefinition) {
        return fragmentDefinition;
    }
    throw  true ? new ts_invariant__WEBPACK_IMPORTED_MODULE_1__["InvariantError"](16) : undefined;
}
function createFragmentMap(fragments) {
    if (fragments === void 0) { fragments = []; }
    var symTable = {};
    fragments.forEach(function (fragment) {
        symTable[fragment.name.value] = fragment;
    });
    return symTable;
}
function getDefaultValues(definition) {
    if (definition &&
        definition.variableDefinitions &&
        definition.variableDefinitions.length) {
        var defaultValues = definition.variableDefinitions
            .filter(function (_a) {
            var defaultValue = _a.defaultValue;
            return defaultValue;
        })
            .map(function (_a) {
            var variable = _a.variable, defaultValue = _a.defaultValue;
            var defaultValueObj = {};
            valueToObjectRepresentation(defaultValueObj, variable.name, defaultValue);
            return defaultValueObj;
        });
        return assign.apply(void 0, Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__spreadArrays"])([{}], defaultValues));
    }
    return {};
}
function variablesInOperation(operation) {
    var names = new Set();
    if (operation.variableDefinitions) {
        for (var _i = 0, _a = operation.variableDefinitions; _i < _a.length; _i++) {
            var definition = _a[_i];
            names.add(definition.variable.name.value);
        }
    }
    return names;
}

function filterInPlace(array, test, context) {
    var target = 0;
    array.forEach(function (elem, i) {
        if (test.call(this, elem, i, array)) {
            array[target++] = elem;
        }
    }, context);
    array.length = target;
    return array;
}

var TYPENAME_FIELD = {
    kind: 'Field',
    name: {
        kind: 'Name',
        value: '__typename',
    },
};
function isEmpty(op, fragments) {
    return op.selectionSet.selections.every(function (selection) {
        return selection.kind === 'FragmentSpread' &&
            isEmpty(fragments[selection.name.value], fragments);
    });
}
function nullIfDocIsEmpty(doc) {
    return isEmpty(getOperationDefinition(doc) || getFragmentDefinition(doc), createFragmentMap(getFragmentDefinitions(doc)))
        ? null
        : doc;
}
function getDirectiveMatcher(directives) {
    return function directiveMatcher(directive) {
        return directives.some(function (dir) {
            return (dir.name && dir.name === directive.name.value) ||
                (dir.test && dir.test(directive));
        });
    };
}
function removeDirectivesFromDocument(directives, doc) {
    var variablesInUse = Object.create(null);
    var variablesToRemove = [];
    var fragmentSpreadsInUse = Object.create(null);
    var fragmentSpreadsToRemove = [];
    var modifiedDoc = nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        Variable: {
            enter: function (node, _key, parent) {
                if (parent.kind !== 'VariableDefinition') {
                    variablesInUse[node.name.value] = true;
                }
            },
        },
        Field: {
            enter: function (node) {
                if (directives && node.directives) {
                    var shouldRemoveField = directives.some(function (directive) { return directive.remove; });
                    if (shouldRemoveField &&
                        node.directives &&
                        node.directives.some(getDirectiveMatcher(directives))) {
                        if (node.arguments) {
                            node.arguments.forEach(function (arg) {
                                if (arg.value.kind === 'Variable') {
                                    variablesToRemove.push({
                                        name: arg.value.name.value,
                                    });
                                }
                            });
                        }
                        if (node.selectionSet) {
                            getAllFragmentSpreadsFromSelectionSet(node.selectionSet).forEach(function (frag) {
                                fragmentSpreadsToRemove.push({
                                    name: frag.name.value,
                                });
                            });
                        }
                        return null;
                    }
                }
            },
        },
        FragmentSpread: {
            enter: function (node) {
                fragmentSpreadsInUse[node.name.value] = true;
            },
        },
        Directive: {
            enter: function (node) {
                if (getDirectiveMatcher(directives)(node)) {
                    return null;
                }
            },
        },
    }));
    if (modifiedDoc &&
        filterInPlace(variablesToRemove, function (v) { return !variablesInUse[v.name]; }).length) {
        modifiedDoc = removeArgumentsFromDocument(variablesToRemove, modifiedDoc);
    }
    if (modifiedDoc &&
        filterInPlace(fragmentSpreadsToRemove, function (fs) { return !fragmentSpreadsInUse[fs.name]; })
            .length) {
        modifiedDoc = removeFragmentSpreadFromDocument(fragmentSpreadsToRemove, modifiedDoc);
    }
    return modifiedDoc;
}
function addTypenameToDocument(doc) {
    return Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(checkDocument(doc), {
        SelectionSet: {
            enter: function (node, _key, parent) {
                if (parent &&
                    parent.kind === 'OperationDefinition') {
                    return;
                }
                var selections = node.selections;
                if (!selections) {
                    return;
                }
                var skip = selections.some(function (selection) {
                    return (isField(selection) &&
                        (selection.name.value === '__typename' ||
                            selection.name.value.lastIndexOf('__', 0) === 0));
                });
                if (skip) {
                    return;
                }
                var field = parent;
                if (isField(field) &&
                    field.directives &&
                    field.directives.some(function (d) { return d.name.value === 'export'; })) {
                    return;
                }
                return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { selections: Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__spreadArrays"])(selections, [TYPENAME_FIELD]) });
            },
        },
    });
}
var connectionRemoveConfig = {
    test: function (directive) {
        var willRemove = directive.name.value === 'connection';
        if (willRemove) {
            if (!directive.arguments ||
                !directive.arguments.some(function (arg) { return arg.name.value === 'key'; })) {
                 true || false;
            }
        }
        return willRemove;
    },
};
function removeConnectionDirectiveFromDocument(doc) {
    return removeDirectivesFromDocument([connectionRemoveConfig], checkDocument(doc));
}
function hasDirectivesInSelectionSet(directives, selectionSet, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    return (selectionSet &&
        selectionSet.selections &&
        selectionSet.selections.some(function (selection) {
            return hasDirectivesInSelection(directives, selection, nestedCheck);
        }));
}
function hasDirectivesInSelection(directives, selection, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    if (!isField(selection)) {
        return true;
    }
    if (!selection.directives) {
        return false;
    }
    return (selection.directives.some(getDirectiveMatcher(directives)) ||
        (nestedCheck &&
            hasDirectivesInSelectionSet(directives, selection.selectionSet, nestedCheck)));
}
function getDirectivesFromDocument(directives, doc) {
    checkDocument(doc);
    var parentPath;
    return nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        SelectionSet: {
            enter: function (node, _key, _parent, path) {
                var currentPath = path.join('-');
                if (!parentPath ||
                    currentPath === parentPath ||
                    !currentPath.startsWith(parentPath)) {
                    if (node.selections) {
                        var selectionsWithDirectives = node.selections.filter(function (selection) { return hasDirectivesInSelection(directives, selection); });
                        if (hasDirectivesInSelectionSet(directives, node, false)) {
                            parentPath = currentPath;
                        }
                        return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { selections: selectionsWithDirectives });
                    }
                    else {
                        return null;
                    }
                }
            },
        },
    }));
}
function getArgumentMatcher(config) {
    return function argumentMatcher(argument) {
        return config.some(function (aConfig) {
            return argument.value &&
                argument.value.kind === 'Variable' &&
                argument.value.name &&
                (aConfig.name === argument.value.name.value ||
                    (aConfig.test && aConfig.test(argument)));
        });
    };
}
function removeArgumentsFromDocument(config, doc) {
    var argMatcher = getArgumentMatcher(config);
    return nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        OperationDefinition: {
            enter: function (node) {
                return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { variableDefinitions: node.variableDefinitions.filter(function (varDef) {
                        return !config.some(function (arg) { return arg.name === varDef.variable.name.value; });
                    }) });
            },
        },
        Field: {
            enter: function (node) {
                var shouldRemoveField = config.some(function (argConfig) { return argConfig.remove; });
                if (shouldRemoveField) {
                    var argMatchCount_1 = 0;
                    node.arguments.forEach(function (arg) {
                        if (argMatcher(arg)) {
                            argMatchCount_1 += 1;
                        }
                    });
                    if (argMatchCount_1 === 1) {
                        return null;
                    }
                }
            },
        },
        Argument: {
            enter: function (node) {
                if (argMatcher(node)) {
                    return null;
                }
            },
        },
    }));
}
function removeFragmentSpreadFromDocument(config, doc) {
    function enter(node) {
        if (config.some(function (def) { return def.name === node.name.value; })) {
            return null;
        }
    }
    return nullIfDocIsEmpty(Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(doc, {
        FragmentSpread: { enter: enter },
        FragmentDefinition: { enter: enter },
    }));
}
function getAllFragmentSpreadsFromSelectionSet(selectionSet) {
    var allFragments = [];
    selectionSet.selections.forEach(function (selection) {
        if ((isField(selection) || isInlineFragment(selection)) &&
            selection.selectionSet) {
            getAllFragmentSpreadsFromSelectionSet(selection.selectionSet).forEach(function (frag) { return allFragments.push(frag); });
        }
        else if (selection.kind === 'FragmentSpread') {
            allFragments.push(selection);
        }
    });
    return allFragments;
}
function buildQueryFromSelectionSet(document) {
    var definition = getMainDefinition(document);
    var definitionOperation = definition.operation;
    if (definitionOperation === 'query') {
        return document;
    }
    var modifiedDoc = Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(document, {
        OperationDefinition: {
            enter: function (node) {
                return Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])(Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({}, node), { operation: 'query' });
            },
        },
    });
    return modifiedDoc;
}
function removeClientSetsFromDocument(document) {
    checkDocument(document);
    var modifiedDoc = removeDirectivesFromDocument([
        {
            test: function (directive) { return directive.name.value === 'client'; },
            remove: true,
        },
    ], document);
    if (modifiedDoc) {
        modifiedDoc = Object(graphql_language_visitor__WEBPACK_IMPORTED_MODULE_0__["visit"])(modifiedDoc, {
            FragmentDefinition: {
                enter: function (node) {
                    if (node.selectionSet) {
                        var isTypenameOnly = node.selectionSet.selections.every(function (selection) {
                            return isField(selection) && selection.name.value === '__typename';
                        });
                        if (isTypenameOnly) {
                            return null;
                        }
                    }
                },
            },
        });
    }
    return modifiedDoc;
}

var canUseWeakMap = typeof WeakMap === 'function' && !(typeof navigator === 'object' &&
    navigator.product === 'ReactNative');

var toString = Object.prototype.toString;
function cloneDeep(value) {
    return cloneDeepHelper(value, new Map());
}
function cloneDeepHelper(val, seen) {
    switch (toString.call(val)) {
        case "[object Array]": {
            if (seen.has(val))
                return seen.get(val);
            var copy_1 = val.slice(0);
            seen.set(val, copy_1);
            copy_1.forEach(function (child, i) {
                copy_1[i] = cloneDeepHelper(child, seen);
            });
            return copy_1;
        }
        case "[object Object]": {
            if (seen.has(val))
                return seen.get(val);
            var copy_2 = Object.create(Object.getPrototypeOf(val));
            seen.set(val, copy_2);
            Object.keys(val).forEach(function (key) {
                copy_2[key] = cloneDeepHelper(val[key], seen);
            });
            return copy_2;
        }
        default:
            return val;
    }
}

function getEnv() {
    if (typeof process !== 'undefined' && "production") {
        return "production";
    }
    return 'development';
}
function isEnv(env) {
    return getEnv() === env;
}
function isProduction() {
    return isEnv('production') === true;
}
function isDevelopment() {
    return isEnv('development') === true;
}
function isTest() {
    return isEnv('test') === true;
}

function tryFunctionOrLogError(f) {
    try {
        return f();
    }
    catch (e) {
        if (console.error) {
            console.error(e);
        }
    }
}
function graphQLResultHasError(result) {
    return result.errors && result.errors.length;
}

function deepFreeze(o) {
    Object.freeze(o);
    Object.getOwnPropertyNames(o).forEach(function (prop) {
        if (o[prop] !== null &&
            (typeof o[prop] === 'object' || typeof o[prop] === 'function') &&
            !Object.isFrozen(o[prop])) {
            deepFreeze(o[prop]);
        }
    });
    return o;
}
function maybeDeepFreeze(obj) {
    if (isDevelopment() || isTest()) {
        var symbolIsPolyfilled = typeof Symbol === 'function' && typeof Symbol('') === 'string';
        if (!symbolIsPolyfilled) {
            return deepFreeze(obj);
        }
    }
    return obj;
}

var hasOwnProperty = Object.prototype.hasOwnProperty;
function mergeDeep() {
    var sources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        sources[_i] = arguments[_i];
    }
    return mergeDeepArray(sources);
}
function mergeDeepArray(sources) {
    var target = sources[0] || {};
    var count = sources.length;
    if (count > 1) {
        var pastCopies = [];
        target = shallowCopyForMerge(target, pastCopies);
        for (var i = 1; i < count; ++i) {
            target = mergeHelper(target, sources[i], pastCopies);
        }
    }
    return target;
}
function isObject(obj) {
    return obj !== null && typeof obj === 'object';
}
function mergeHelper(target, source, pastCopies) {
    if (isObject(source) && isObject(target)) {
        if (Object.isExtensible && !Object.isExtensible(target)) {
            target = shallowCopyForMerge(target, pastCopies);
        }
        Object.keys(source).forEach(function (sourceKey) {
            var sourceValue = source[sourceKey];
            if (hasOwnProperty.call(target, sourceKey)) {
                var targetValue = target[sourceKey];
                if (sourceValue !== targetValue) {
                    target[sourceKey] = mergeHelper(shallowCopyForMerge(targetValue, pastCopies), sourceValue, pastCopies);
                }
            }
            else {
                target[sourceKey] = sourceValue;
            }
        });
        return target;
    }
    return source;
}
function shallowCopyForMerge(value, pastCopies) {
    if (value !== null &&
        typeof value === 'object' &&
        pastCopies.indexOf(value) < 0) {
        if (Array.isArray(value)) {
            value = value.slice(0);
        }
        else {
            value = Object(tslib__WEBPACK_IMPORTED_MODULE_2__["__assign"])({ __proto__: Object.getPrototypeOf(value) }, value);
        }
        pastCopies.push(value);
    }
    return value;
}

var haveWarned = Object.create({});
function warnOnceInDevelopment(msg, type) {
    if (type === void 0) { type = 'warn'; }
    if (!isProduction() && !haveWarned[msg]) {
        if (!isTest()) {
            haveWarned[msg] = true;
        }
        if (type === 'error') {
            console.error(msg);
        }
        else {
            console.warn(msg);
        }
    }
}

function stripSymbols(data) {
    return JSON.parse(JSON.stringify(data));
}




/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(26)))

/***/ }),
/* 141 */
/***/ (function(module, exports) {

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

module.exports = _createClass;

/***/ }),
/* 142 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(36),
    root = __webpack_require__(14);

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map');

module.exports = Map;


/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

var mapCacheClear = __webpack_require__(418),
    mapCacheDelete = __webpack_require__(425),
    mapCacheGet = __webpack_require__(427),
    mapCacheHas = __webpack_require__(428),
    mapCacheSet = __webpack_require__(429);

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

var Uint8Array = __webpack_require__(213);

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  return result;
}

module.exports = cloneArrayBuffer;


/***/ }),
/* 145 */
/***/ (function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

module.exports = isPrototype;


/***/ }),
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsArguments = __webpack_require__(432),
    isObjectLike = __webpack_require__(10);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

module.exports = isArguments;


/***/ }),
/* 147 */
/***/ (function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ }),
/* 148 */
/***/ (function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ }),
/* 149 */
/***/ (function(module, exports) {

/**
 * The base implementation of `_.propertyOf` without support for deep paths.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyOf(object) {
  return function(key) {
    return object == null ? undefined : object[key];
  };
}

module.exports = basePropertyOf;


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphQLError = GraphQLError;

var _printError = __webpack_require__(228);

var _location = __webpack_require__(229);

/**
 * A GraphQLError describes an Error found during the parse, validate, or
 * execute phases of performing a GraphQL operation. In addition to a message
 * and stack trace, it also includes information about the locations in a
 * GraphQL document and/or execution result that correspond to the Error.
 */
/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict
 */

function GraphQLError( // eslint-disable-line no-redeclare
message, nodes, source, positions, path, originalError, extensions) {
  // Compute list of blame nodes.
  var _nodes = Array.isArray(nodes) ? nodes.length !== 0 ? nodes : undefined : nodes ? [nodes] : undefined;

  // Compute locations in the source for the given nodes/positions.
  var _source = source;
  if (!_source && _nodes) {
    var node = _nodes[0];
    _source = node && node.loc && node.loc.source;
  }

  var _positions = positions;
  if (!_positions && _nodes) {
    _positions = _nodes.reduce(function (list, node) {
      if (node.loc) {
        list.push(node.loc.start);
      }
      return list;
    }, []);
  }
  if (_positions && _positions.length === 0) {
    _positions = undefined;
  }

  var _locations = void 0;
  if (positions && source) {
    _locations = positions.map(function (pos) {
      return (0, _location.getLocation)(source, pos);
    });
  } else if (_nodes) {
    _locations = _nodes.reduce(function (list, node) {
      if (node.loc) {
        list.push((0, _location.getLocation)(node.loc.source, node.loc.start));
      }
      return list;
    }, []);
  }

  Object.defineProperties(this, {
    message: {
      value: message,
      // By being enumerable, JSON.stringify will include `message` in the
      // resulting output. This ensures that the simplest possible GraphQL
      // service adheres to the spec.
      enumerable: true,
      writable: true
    },
    locations: {
      // Coercing falsey values to undefined ensures they will not be included
      // in JSON.stringify() when not provided.
      value: _locations || undefined,
      // By being enumerable, JSON.stringify will include `locations` in the
      // resulting output. This ensures that the simplest possible GraphQL
      // service adheres to the spec.
      enumerable: true
    },
    path: {
      // Coercing falsey values to undefined ensures they will not be included
      // in JSON.stringify() when not provided.
      value: path || undefined,
      // By being enumerable, JSON.stringify will include `path` in the
      // resulting output. This ensures that the simplest possible GraphQL
      // service adheres to the spec.
      enumerable: true
    },
    nodes: {
      value: _nodes || undefined
    },
    source: {
      value: _source || undefined
    },
    positions: {
      value: _positions || undefined
    },
    originalError: {
      value: originalError
    },
    extensions: {
      value: extensions || originalError && originalError.extensions
    }
  });

  // Include (non-enumerable) stack trace.
  if (originalError && originalError.stack) {
    Object.defineProperty(this, 'stack', {
      value: originalError.stack,
      writable: true,
      configurable: true
    });
  } else if (Error.captureStackTrace) {
    Error.captureStackTrace(this, GraphQLError);
  } else {
    Object.defineProperty(this, 'stack', {
      value: Error().stack,
      writable: true,
      configurable: true
    });
  }
}

GraphQLError.prototype = Object.create(Error.prototype, {
  constructor: { value: GraphQLError },
  name: { value: 'GraphQLError' },
  toString: {
    value: function toString() {
      return (0, _printError.printError)(this);
    }
  }
});

/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(6),
    isSymbol = __webpack_require__(104);

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

module.exports = isKey;


/***/ }),
/* 152 */
/***/ (function(module, exports, __webpack_require__) {

var baseFor = __webpack_require__(210),
    keys = __webpack_require__(40);

/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && baseFor(object, iteratee, keys);
}

module.exports = baseForOwn;


/***/ }),
/* 153 */
/***/ (function(module, exports, __webpack_require__) {

var arrayFilter = __webpack_require__(500),
    stubArray = __webpack_require__(245);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

module.exports = getSymbols;


/***/ }),
/* 154 */
/***/ (function(module, exports) {

/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

module.exports = arrayEach;


/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

var moment = module.exports = __webpack_require__(533);
moment.tz.load(__webpack_require__(535));


/***/ }),
/* 156 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault2 = __webpack_require__(0);

var _taggedTemplateLiteral2 = _interopRequireDefault2(__webpack_require__(38));

function _templateObject3() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n            ", "\n          "]);

  _templateObject3 = function _templateObject3() {
    return data;
  };

  return data;
}

function _templateObject2() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n              ", "\n            "]);

  _templateObject2 = function _templateObject2() {
    return data;
  };

  return data;
}

function _templateObject() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n  query FetchShippingMethods {\n    database {\n      id\n      commerceOrder {\n        id\n        availableShippingMethods {\n          id\n          name\n          description\n          price {\n            value\n          }\n        }\n      }\n    }\n  }\n"]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.register = exports.updateWebPaymentsButton = void 0;

var _graphqlTag = _interopRequireDefault(__webpack_require__(39));

var _commerceUtils = __webpack_require__(20);

var _stripeStore = __webpack_require__(62);

var _eventHandlerProxyWithApolloClient = _interopRequireDefault(__webpack_require__(35));

var _checkoutUtils = __webpack_require__(109);

var _cartUtils = __webpack_require__(266);

var _constants = __webpack_require__(15);

var _debug = _interopRequireDefault(__webpack_require__(47));
/* globals window */


var hasItems = function hasItems(response) {
  return response && response.data && response.data.database && response.data.database.commerceOrder && response.data.database.commerceOrder.userItems && response.data.database.commerceOrder.userItems.length > 0;
};

var isWebPaymentsButtonEvent = function isWebPaymentsButtonEvent(_ref) {
  var target = _ref.target;
  var cartCheckoutButton = (0, _commerceUtils.findClosestElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CART_QUICK_CHECKOUT_BUTTON, target);
  var cartApplePayButton = (0, _commerceUtils.findClosestElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CART_APPLE_PAY_BUTTON, target);

  if (cartCheckoutButton) {
    return cartCheckoutButton;
  } else if (cartApplePayButton) {
    return cartApplePayButton;
  } else {
    return false;
  }
};

var updateWebPaymentsButton = function updateWebPaymentsButton(wrapper, data, stripeStore) {
  var webPaymentsActionsElements = (0, _commerceUtils.findAllElementsByNodeType)(_constants.NODE_TYPE_COMMERCE_CART_QUICK_CHECKOUT_ACTIONS, wrapper);

  if (!webPaymentsActionsElements || webPaymentsActionsElements.length === 0 || !hasItems(data)) {
    return;
  }

  webPaymentsActionsElements.forEach(function (webPaymentsActions) {
    (0, _commerceUtils.hideElement)(webPaymentsActions);

    if (!stripeStore || !stripeStore.isInitialized() || !data.data.site.commerce.quickCheckoutEnabled) {
      return;
    }

    var stripeInstance = parseInt(wrapper.getAttribute(_constants.STRIPE_ELEMENT_INSTANCE), 10);
    var paymentRequest = stripeStore.updateCartPaymentRequest(stripeInstance, data.data.database.commerceOrder, data.data.site.commerce);

    if (!paymentRequest || typeof paymentRequest.canMakePayment !== 'function') {
      return;
    }

    if ((0, _commerceUtils.isFreeOrder)(data)) {
      return;
    }

    paymentRequest.canMakePayment().then(function (result) {
      if (!result) {
        return;
      }

      var applePay = result.applePay;
      (0, _commerceUtils.showElement)(webPaymentsActions);
      var cartCheckoutButton = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CART_QUICK_CHECKOUT_BUTTON, webPaymentsActions);
      var cartApplePayButton = (0, _commerceUtils.findElementByNodeType)(_constants.NODE_TYPE_COMMERCE_CART_APPLE_PAY_BUTTON, webPaymentsActions);

      if (!cartCheckoutButton || !cartApplePayButton) {
        return;
      }

      if (applePay) {
        (0, _commerceUtils.hideElement)(cartCheckoutButton);
        (0, _commerceUtils.showElement)(cartApplePayButton);
      } else {
        (0, _commerceUtils.hideElement)(cartApplePayButton);
        (0, _commerceUtils.showElement)(cartCheckoutButton);
      }
    })["catch"](function () {
      _debug["default"].log('PaymentRequest not available in this browser – silently exiting');
    });
  });
};

exports.updateWebPaymentsButton = updateWebPaymentsButton;

var getShippingMethodsQuery = _graphqlTag["default"](_templateObject());

var handleWebPaymentsButton = function handleWebPaymentsButton(event, apolloClient, stripeStore) {
  event.preventDefault();

  if (window.Webflow.env('design') || window.Webflow.env('preview')) {
    if (window.Webflow.env('preview')) {
      window.alert('Web Payments is not available in preview mode.');
    }

    return;
  }

  var currentTarget = event.currentTarget;
  var stripeElement = (0, _commerceUtils.findClosestElementWithAttribute)(_constants.STRIPE_ELEMENT_INSTANCE, currentTarget);

  if (!(stripeElement instanceof Element)) {
    return;
  }

  var stripeInstance = parseInt(stripeElement.getAttribute(_constants.STRIPE_ELEMENT_INSTANCE), 10);
  var paymentRequest = stripeStore.getCartPaymentRequest(stripeInstance);
  paymentRequest.show();

  if (paymentRequest.hasRegisteredListener('paymentmethod')) {
    // we remove any existing event listeners, which can happen if the modal
    // was closed before a successful payment occurred
    paymentRequest.removeAllListeners();
  }

  paymentRequest.on('shippingaddresschange', function (_ref2) {
    var updateWith = _ref2.updateWith,
        shippingAddress = _ref2.shippingAddress;
    var shippingMethods = [];
    var graphQlQuery = stripeElement.getAttribute(_constants.CART_QUERY) || stripeElement.getAttribute(_constants.CHECKOUT_QUERY); // In some cases we receive an obfuscated address from quick checkout service (e.g. Apple pay)
    // We're using a different mutation to mark such address as 'obfuscated' in order to skip address validation when calculating taxes

    (0, _checkoutUtils.createUpdateObfuscatedOrderAddressMutation)(apolloClient, {
      type: 'shipping',
      name: shippingAddress.recipient,
      address_line1: shippingAddress.addressLine[0],
      address_line2: shippingAddress.addressLine[1],
      address_city: shippingAddress.city,
      address_state: shippingAddress.region,
      address_country: shippingAddress.country,
      address_zip: shippingAddress.postalCode
    }).then(function () {
      return apolloClient.query({
        query: getShippingMethodsQuery,
        fetchPolicy: 'network-only',
        errorPolicy: 'all'
      });
    }).then(function (_ref3) {
      var data = _ref3.data;

      if (!data.database.commerceOrder.availableShippingMethods || data.database.commerceOrder.availableShippingMethods.length === 0) {
        updateWith({
          status: 'invalid_shipping_address'
        });
        return Promise.reject('No valid shipping addresses');
      } else {
        shippingMethods = data.database.commerceOrder.availableShippingMethods;
        return (0, _checkoutUtils.createOrderShippingMethodMutation)(apolloClient, data.database.commerceOrder.availableShippingMethods[0].id);
      }
    }).then(function () {
      return (0, _checkoutUtils.createRecalcOrderEstimationsMutation)(apolloClient);
    }).then(function () {
      return apolloClient.query({
        query: _graphqlTag["default"](_templateObject2(), graphQlQuery),
        fetchPolicy: 'network-only',
        errorPolicy: 'all'
      });
    }).then(function (_ref4) {
      var data = _ref4.data;
      updateWith({
        status: 'success',
        displayItems: (0, _stripeStore.generateDisplayItemsFromOrder)(data.database.commerceOrder, true),
        shippingOptions: (0, _stripeStore.generateShippingOptionsFromMethods)(shippingMethods),
        total: {
          amount: data.database.commerceOrder.total.value,
          label: 'Total',
          pending: false
        }
      });
    });
  });
  paymentRequest.on('shippingoptionchange', function (_ref5) {
    var updateWith = _ref5.updateWith,
        shippingOption = _ref5.shippingOption;
    var graphQlQuery = stripeElement.getAttribute(_constants.CART_QUERY) || stripeElement.getAttribute(_constants.CHECKOUT_QUERY);
    (0, _checkoutUtils.createOrderShippingMethodMutation)(apolloClient, shippingOption.id).then(function () {
      return (0, _checkoutUtils.createRecalcOrderEstimationsMutation)(apolloClient);
    }).then(function () {
      return apolloClient.query({
        query: _graphqlTag["default"](_templateObject3(), graphQlQuery),
        fetchPolicy: 'network-only',
        errorPolicy: 'all'
      });
    }).then(function (_ref6) {
      var data = _ref6.data;
      updateWith({
        status: 'success',
        displayItems: (0, _stripeStore.generateDisplayItemsFromOrder)(data.database.commerceOrder, true),
        total: {
          amount: data.database.commerceOrder.total.value,
          label: 'Total',
          pending: false
        }
      });
    });
  });
  paymentRequest.on('paymentmethod', function (ev) {
    (0, _commerceUtils.fetchOrderStatusFlags)(apolloClient).then(function (_ref7) {
      var requiresShipping = _ref7.requiresShipping;
      return Promise.all([(0, _checkoutUtils.createOrderIdentityMutation)(apolloClient, ev.payerEmail), requiresShipping ? (0, _checkoutUtils.createOrderAddressMutation)(apolloClient, {
        type: 'shipping',
        name: ev.shippingAddress.recipient,
        address_line1: ev.shippingAddress.addressLine[0],
        address_line2: ev.shippingAddress.addressLine[1],
        address_city: ev.shippingAddress.city,
        address_state: ev.shippingAddress.region,
        address_country: ev.shippingAddress.country,
        address_zip: ev.shippingAddress.postalCode
      }) : Promise.resolve(), (0, _checkoutUtils.createOrderAddressMutation)(apolloClient, {
        type: 'billing',
        name: ev.paymentMethod.billing_details.name,
        address_line1: ev.paymentMethod.billing_details.address.line1,
        address_line2: ev.paymentMethod.billing_details.address.line2,
        address_city: ev.paymentMethod.billing_details.address.city,
        address_state: ev.paymentMethod.billing_details.address.state,
        address_country: ev.paymentMethod.billing_details.address.country,
        address_zip: ev.paymentMethod.billing_details.address.postal_code
      }), requiresShipping ? (0, _checkoutUtils.createOrderShippingMethodMutation)(apolloClient, ev.shippingOption.id) : Promise.resolve(), (0, _checkoutUtils.createStripePaymentMethodMutation)(apolloClient, ev.paymentMethod.id)]);
    }).then(function () {
      return (0, _checkoutUtils.createAttemptSubmitOrderRequest)(apolloClient, {
        checkoutType: 'quickCheckout'
      });
    }).then(function (data) {
      var order = (0, _checkoutUtils.getOrderDataFromGraphQLResponse)(data);

      if ((0, _checkoutUtils.orderRequiresAdditionalAction)(order.status)) {
        ev.complete('success');
        var stripe = stripeStore.getStripeInstance();
        return stripe.handleCardAction(order.clientSecret).then(function (result) {
          if (result.error) {
            return Promise.reject(new Error('payment_intent_failed'));
          }

          return (0, _checkoutUtils.createAttemptSubmitOrderRequest)(apolloClient, {
            checkoutType: 'quickCheckout',
            paymentIntentId: result.paymentIntent.id
          }).then(function (resp) {
            var finishedOrder = (0, _checkoutUtils.getOrderDataFromGraphQLResponse)(resp);

            if (finishedOrder.ok) {
              (0, _checkoutUtils.trackOrderAndRedirect)(finishedOrder);
            } else {
              return Promise.reject(new Error('payment_intent_failed'));
            }
          });
        });
      }

      if (order.ok) {
        ev.complete('success');
        (0, _checkoutUtils.trackOrderAndRedirect)(order);
      } else {
        return Promise.reject(new Error('order_failed'));
      }
    })["catch"](function (err) {
      var hasGraphQLErrors = err && err.graphQLErrors && err.graphQLErrors.length > 0;

      if (hasGraphQLErrors) {
        switch (err.graphQLErrors[0].code) {
          case 'PriceChanged':
            {
              ev.complete('success'); // We have to wrap this in a small timeout or else the error won't show up and the payment dialog will time out

              setTimeout(function () {
                window.alert('The prices of one or more items in your cart have changed. Please refresh this page and try again.');
              }, 100);
              return;
            }

          case 'ItemNotFound':
            {
              ev.complete('success');
              setTimeout(function () {
                window.alert('One or more of the products in your cart have been removed. Please refresh the page and try again.');
              }, 100);
              return;
            }

          case 'OrderTotalRange':
            {
              ev.complete('success');
              (0, _checkoutUtils.showErrorMessageForError)(err, ev.currentTarget);

              if ((0, _cartUtils.isCartOpen)()) {
                (0, _cartUtils.showErrorMessageForError)(err, ev.currentTarget);
              }

              return;
            }

          default: // noop

        }
      }

      if (err && err.message && err.message === 'payment_intent_failed') {
        // in the case that we failed outside of the browser UI (i.e. when we had to fall back to the page for 3d secure)
        // we're going to not call the `ev.complete`, since we already had to mark it with `success` to get back to the page
        // and since we don't have an error element, we're going to pop up an alert informing them of the issue
        window.alert('There was an error processing your payment. Please try again, or contact us if you continue to have problems.');
      } else {
        // otherwise, since we're still in the native browser UI, we can rely on the browser to tell them that something went wrong
        ev.complete('fail');
      }
    });
  });
};

var register = function register(handlerProxy) {
  handlerProxy.on('click', isWebPaymentsButtonEvent, handleWebPaymentsButton);
};

exports.register = register;
var _default = {
  register: register
};
exports["default"] = _default;

/***/ }),
/* 157 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var has = Object.prototype.hasOwnProperty;
var isArray = Array.isArray;

var hexTable = (function () {
    var array = [];
    for (var i = 0; i < 256; ++i) {
        array.push('%' + ((i < 16 ? '0' : '') + i.toString(16)).toUpperCase());
    }

    return array;
}());

var compactQueue = function compactQueue(queue) {
    while (queue.length > 1) {
        var item = queue.pop();
        var obj = item.obj[item.prop];

        if (isArray(obj)) {
            var compacted = [];

            for (var j = 0; j < obj.length; ++j) {
                if (typeof obj[j] !== 'undefined') {
                    compacted.push(obj[j]);
                }
            }

            item.obj[item.prop] = compacted;
        }
    }
};

var arrayToObject = function arrayToObject(source, options) {
    var obj = options && options.plainObjects ? Object.create(null) : {};
    for (var i = 0; i < source.length; ++i) {
        if (typeof source[i] !== 'undefined') {
            obj[i] = source[i];
        }
    }

    return obj;
};

var merge = function merge(target, source, options) {
    /* eslint no-param-reassign: 0 */
    if (!source) {
        return target;
    }

    if (typeof source !== 'object') {
        if (isArray(target)) {
            target.push(source);
        } else if (target && typeof target === 'object') {
            if ((options && (options.plainObjects || options.allowPrototypes)) || !has.call(Object.prototype, source)) {
                target[source] = true;
            }
        } else {
            return [target, source];
        }

        return target;
    }

    if (!target || typeof target !== 'object') {
        return [target].concat(source);
    }

    var mergeTarget = target;
    if (isArray(target) && !isArray(source)) {
        mergeTarget = arrayToObject(target, options);
    }

    if (isArray(target) && isArray(source)) {
        source.forEach(function (item, i) {
            if (has.call(target, i)) {
                var targetItem = target[i];
                if (targetItem && typeof targetItem === 'object' && item && typeof item === 'object') {
                    target[i] = merge(targetItem, item, options);
                } else {
                    target.push(item);
                }
            } else {
                target[i] = item;
            }
        });
        return target;
    }

    return Object.keys(source).reduce(function (acc, key) {
        var value = source[key];

        if (has.call(acc, key)) {
            acc[key] = merge(acc[key], value, options);
        } else {
            acc[key] = value;
        }
        return acc;
    }, mergeTarget);
};

var assign = function assignSingleSource(target, source) {
    return Object.keys(source).reduce(function (acc, key) {
        acc[key] = source[key];
        return acc;
    }, target);
};

var decode = function (str, decoder, charset) {
    var strWithoutPlus = str.replace(/\+/g, ' ');
    if (charset === 'iso-8859-1') {
        // unescape never throws, no try...catch needed:
        return strWithoutPlus.replace(/%[0-9a-f]{2}/gi, unescape);
    }
    // utf-8
    try {
        return decodeURIComponent(strWithoutPlus);
    } catch (e) {
        return strWithoutPlus;
    }
};

var encode = function encode(str, defaultEncoder, charset) {
    // This code was originally written by Brian White (mscdex) for the io.js core querystring library.
    // It has been adapted here for stricter adherence to RFC 3986
    if (str.length === 0) {
        return str;
    }

    var string = str;
    if (typeof str === 'symbol') {
        string = Symbol.prototype.toString.call(str);
    } else if (typeof str !== 'string') {
        string = String(str);
    }

    if (charset === 'iso-8859-1') {
        return escape(string).replace(/%u[0-9a-f]{4}/gi, function ($0) {
            return '%26%23' + parseInt($0.slice(2), 16) + '%3B';
        });
    }

    var out = '';
    for (var i = 0; i < string.length; ++i) {
        var c = string.charCodeAt(i);

        if (
            c === 0x2D // -
            || c === 0x2E // .
            || c === 0x5F // _
            || c === 0x7E // ~
            || (c >= 0x30 && c <= 0x39) // 0-9
            || (c >= 0x41 && c <= 0x5A) // a-z
            || (c >= 0x61 && c <= 0x7A) // A-Z
        ) {
            out += string.charAt(i);
            continue;
        }

        if (c < 0x80) {
            out = out + hexTable[c];
            continue;
        }

        if (c < 0x800) {
            out = out + (hexTable[0xC0 | (c >> 6)] + hexTable[0x80 | (c & 0x3F)]);
            continue;
        }

        if (c < 0xD800 || c >= 0xE000) {
            out = out + (hexTable[0xE0 | (c >> 12)] + hexTable[0x80 | ((c >> 6) & 0x3F)] + hexTable[0x80 | (c & 0x3F)]);
            continue;
        }

        i += 1;
        c = 0x10000 + (((c & 0x3FF) << 10) | (string.charCodeAt(i) & 0x3FF));
        out += hexTable[0xF0 | (c >> 18)]
            + hexTable[0x80 | ((c >> 12) & 0x3F)]
            + hexTable[0x80 | ((c >> 6) & 0x3F)]
            + hexTable[0x80 | (c & 0x3F)];
    }

    return out;
};

var compact = function compact(value) {
    var queue = [{ obj: { o: value }, prop: 'o' }];
    var refs = [];

    for (var i = 0; i < queue.length; ++i) {
        var item = queue[i];
        var obj = item.obj[item.prop];

        var keys = Object.keys(obj);
        for (var j = 0; j < keys.length; ++j) {
            var key = keys[j];
            var val = obj[key];
            if (typeof val === 'object' && val !== null && refs.indexOf(val) === -1) {
                queue.push({ obj: obj, prop: key });
                refs.push(val);
            }
        }
    }

    compactQueue(queue);

    return value;
};

var isRegExp = function isRegExp(obj) {
    return Object.prototype.toString.call(obj) === '[object RegExp]';
};

var isBuffer = function isBuffer(obj) {
    if (!obj || typeof obj !== 'object') {
        return false;
    }

    return !!(obj.constructor && obj.constructor.isBuffer && obj.constructor.isBuffer(obj));
};

var combine = function combine(a, b) {
    return [].concat(a, b);
};

var maybeMap = function maybeMap(val, fn) {
    if (isArray(val)) {
        var mapped = [];
        for (var i = 0; i < val.length; i += 1) {
            mapped.push(fn(val[i]));
        }
        return mapped;
    }
    return fn(val);
};

module.exports = {
    arrayToObject: arrayToObject,
    assign: assign,
    combine: combine,
    compact: compact,
    decode: decode,
    encode: encode,
    isBuffer: isBuffer,
    isRegExp: isRegExp,
    maybeMap: maybeMap,
    merge: merge
};


/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
 // @wf-will-never-add-flow-to-this-file

/* eslint-disable eslint-comments/no-unlimited-disable */

/* eslint-disable */

/*!
 * tram.js v0.8.2-global
 * Cross-browser CSS3 transitions in JavaScript
 * https://github.com/bkwld/tram
 * MIT License
 */

/* prettier-ignore */

var _interopRequireDefault = __webpack_require__(0);

var _typeof2 = _interopRequireDefault(__webpack_require__(49));

window.tram = function (a) {
  function b(a, b) {
    var c = new M.Bare();
    return c.init(a, b);
  }

  function c(a) {
    return a.replace(/[A-Z]/g, function (a) {
      return "-" + a.toLowerCase();
    });
  }

  function d(a) {
    var b = parseInt(a.slice(1), 16),
        c = b >> 16 & 255,
        d = b >> 8 & 255,
        e = 255 & b;
    return [c, d, e];
  }

  function e(a, b, c) {
    return "#" + (1 << 24 | a << 16 | b << 8 | c).toString(16).slice(1);
  }

  function f() {}

  function g(a, b) {
    j("Type warning: Expected: [" + a + "] Got: [" + (0, _typeof2["default"])(b) + "] " + b);
  }

  function h(a, b, c) {
    j("Units do not match [" + a + "]: " + b + ", " + c);
  }

  function i(a, b, c) {
    if (void 0 !== b && (c = b), void 0 === a) return c;
    var d = c;
    return $.test(a) || !_.test(a) ? d = parseInt(a, 10) : _.test(a) && (d = 1e3 * parseFloat(a)), 0 > d && (d = 0), d === d ? d : c;
  }

  function j(a) {
    U.debug && window && window.console.warn(a);
  }

  function k(a) {
    for (var b = -1, c = a ? a.length : 0, d = []; ++b < c;) {
      var e = a[b];
      e && d.push(e);
    }

    return d;
  }

  var l = function (a, b, c) {
    function d(a) {
      return "object" == (0, _typeof2["default"])(a);
    }

    function e(a) {
      return "function" == typeof a;
    }

    function f() {}

    function g(h, i) {
      function j() {
        var a = new k();
        return e(a.init) && a.init.apply(a, arguments), a;
      }

      function k() {}

      i === c && (i = h, h = Object), j.Bare = k;
      var l,
          m = f[a] = h[a],
          n = k[a] = j[a] = new f();
      return n.constructor = j, j.mixin = function (b) {
        return k[a] = j[a] = g(j, b)[a], j;
      }, j.open = function (a) {
        if (l = {}, e(a) ? l = a.call(j, n, m, j, h) : d(a) && (l = a), d(l)) for (var c in l) {
          b.call(l, c) && (n[c] = l[c]);
        }
        return e(n.init) || (n.init = h), j;
      }, j.open(i);
    }

    return g;
  }("prototype", {}.hasOwnProperty),
      m = {
    ease: ["ease", function (a, b, c, d) {
      var e = (a /= d) * a,
          f = e * a;
      return b + c * (-2.75 * f * e + 11 * e * e + -15.5 * f + 8 * e + .25 * a);
    }],
    "ease-in": ["ease-in", function (a, b, c, d) {
      var e = (a /= d) * a,
          f = e * a;
      return b + c * (-1 * f * e + 3 * e * e + -3 * f + 2 * e);
    }],
    "ease-out": ["ease-out", function (a, b, c, d) {
      var e = (a /= d) * a,
          f = e * a;
      return b + c * (.3 * f * e + -1.6 * e * e + 2.2 * f + -1.8 * e + 1.9 * a);
    }],
    "ease-in-out": ["ease-in-out", function (a, b, c, d) {
      var e = (a /= d) * a,
          f = e * a;
      return b + c * (2 * f * e + -5 * e * e + 2 * f + 2 * e);
    }],
    linear: ["linear", function (a, b, c, d) {
      return c * a / d + b;
    }],
    "ease-in-quad": ["cubic-bezier(0.550, 0.085, 0.680, 0.530)", function (a, b, c, d) {
      return c * (a /= d) * a + b;
    }],
    "ease-out-quad": ["cubic-bezier(0.250, 0.460, 0.450, 0.940)", function (a, b, c, d) {
      return -c * (a /= d) * (a - 2) + b;
    }],
    "ease-in-out-quad": ["cubic-bezier(0.455, 0.030, 0.515, 0.955)", function (a, b, c, d) {
      return (a /= d / 2) < 1 ? c / 2 * a * a + b : -c / 2 * (--a * (a - 2) - 1) + b;
    }],
    "ease-in-cubic": ["cubic-bezier(0.550, 0.055, 0.675, 0.190)", function (a, b, c, d) {
      return c * (a /= d) * a * a + b;
    }],
    "ease-out-cubic": ["cubic-bezier(0.215, 0.610, 0.355, 1)", function (a, b, c, d) {
      return c * ((a = a / d - 1) * a * a + 1) + b;
    }],
    "ease-in-out-cubic": ["cubic-bezier(0.645, 0.045, 0.355, 1)", function (a, b, c, d) {
      return (a /= d / 2) < 1 ? c / 2 * a * a * a + b : c / 2 * ((a -= 2) * a * a + 2) + b;
    }],
    "ease-in-quart": ["cubic-bezier(0.895, 0.030, 0.685, 0.220)", function (a, b, c, d) {
      return c * (a /= d) * a * a * a + b;
    }],
    "ease-out-quart": ["cubic-bezier(0.165, 0.840, 0.440, 1)", function (a, b, c, d) {
      return -c * ((a = a / d - 1) * a * a * a - 1) + b;
    }],
    "ease-in-out-quart": ["cubic-bezier(0.770, 0, 0.175, 1)", function (a, b, c, d) {
      return (a /= d / 2) < 1 ? c / 2 * a * a * a * a + b : -c / 2 * ((a -= 2) * a * a * a - 2) + b;
    }],
    "ease-in-quint": ["cubic-bezier(0.755, 0.050, 0.855, 0.060)", function (a, b, c, d) {
      return c * (a /= d) * a * a * a * a + b;
    }],
    "ease-out-quint": ["cubic-bezier(0.230, 1, 0.320, 1)", function (a, b, c, d) {
      return c * ((a = a / d - 1) * a * a * a * a + 1) + b;
    }],
    "ease-in-out-quint": ["cubic-bezier(0.860, 0, 0.070, 1)", function (a, b, c, d) {
      return (a /= d / 2) < 1 ? c / 2 * a * a * a * a * a + b : c / 2 * ((a -= 2) * a * a * a * a + 2) + b;
    }],
    "ease-in-sine": ["cubic-bezier(0.470, 0, 0.745, 0.715)", function (a, b, c, d) {
      return -c * Math.cos(a / d * (Math.PI / 2)) + c + b;
    }],
    "ease-out-sine": ["cubic-bezier(0.390, 0.575, 0.565, 1)", function (a, b, c, d) {
      return c * Math.sin(a / d * (Math.PI / 2)) + b;
    }],
    "ease-in-out-sine": ["cubic-bezier(0.445, 0.050, 0.550, 0.950)", function (a, b, c, d) {
      return -c / 2 * (Math.cos(Math.PI * a / d) - 1) + b;
    }],
    "ease-in-expo": ["cubic-bezier(0.950, 0.050, 0.795, 0.035)", function (a, b, c, d) {
      return 0 === a ? b : c * Math.pow(2, 10 * (a / d - 1)) + b;
    }],
    "ease-out-expo": ["cubic-bezier(0.190, 1, 0.220, 1)", function (a, b, c, d) {
      return a === d ? b + c : c * (-Math.pow(2, -10 * a / d) + 1) + b;
    }],
    "ease-in-out-expo": ["cubic-bezier(1, 0, 0, 1)", function (a, b, c, d) {
      return 0 === a ? b : a === d ? b + c : (a /= d / 2) < 1 ? c / 2 * Math.pow(2, 10 * (a - 1)) + b : c / 2 * (-Math.pow(2, -10 * --a) + 2) + b;
    }],
    "ease-in-circ": ["cubic-bezier(0.600, 0.040, 0.980, 0.335)", function (a, b, c, d) {
      return -c * (Math.sqrt(1 - (a /= d) * a) - 1) + b;
    }],
    "ease-out-circ": ["cubic-bezier(0.075, 0.820, 0.165, 1)", function (a, b, c, d) {
      return c * Math.sqrt(1 - (a = a / d - 1) * a) + b;
    }],
    "ease-in-out-circ": ["cubic-bezier(0.785, 0.135, 0.150, 0.860)", function (a, b, c, d) {
      return (a /= d / 2) < 1 ? -c / 2 * (Math.sqrt(1 - a * a) - 1) + b : c / 2 * (Math.sqrt(1 - (a -= 2) * a) + 1) + b;
    }],
    "ease-in-back": ["cubic-bezier(0.600, -0.280, 0.735, 0.045)", function (a, b, c, d, e) {
      return void 0 === e && (e = 1.70158), c * (a /= d) * a * ((e + 1) * a - e) + b;
    }],
    "ease-out-back": ["cubic-bezier(0.175, 0.885, 0.320, 1.275)", function (a, b, c, d, e) {
      return void 0 === e && (e = 1.70158), c * ((a = a / d - 1) * a * ((e + 1) * a + e) + 1) + b;
    }],
    "ease-in-out-back": ["cubic-bezier(0.680, -0.550, 0.265, 1.550)", function (a, b, c, d, e) {
      return void 0 === e && (e = 1.70158), (a /= d / 2) < 1 ? c / 2 * a * a * (((e *= 1.525) + 1) * a - e) + b : c / 2 * ((a -= 2) * a * (((e *= 1.525) + 1) * a + e) + 2) + b;
    }]
  },
      n = {
    "ease-in-back": "cubic-bezier(0.600, 0, 0.735, 0.045)",
    "ease-out-back": "cubic-bezier(0.175, 0.885, 0.320, 1)",
    "ease-in-out-back": "cubic-bezier(0.680, 0, 0.265, 1)"
  },
      o = document,
      p = window,
      q = "bkwld-tram",
      r = /[\-\.0-9]/g,
      s = /[A-Z]/,
      t = "number",
      u = /^(rgb|#)/,
      v = /(em|cm|mm|in|pt|pc|px)$/,
      w = /(em|cm|mm|in|pt|pc|px|%)$/,
      x = /(deg|rad|turn)$/,
      y = "unitless",
      z = /(all|none) 0s ease 0s/,
      A = /^(width|height)$/,
      B = " ",
      C = o.createElement("a"),
      D = ["Webkit", "Moz", "O", "ms"],
      E = ["-webkit-", "-moz-", "-o-", "-ms-"],
      F = function F(a) {
    if (a in C.style) return {
      dom: a,
      css: a
    };
    var b,
        c,
        d = "",
        e = a.split("-");

    for (b = 0; b < e.length; b++) {
      d += e[b].charAt(0).toUpperCase() + e[b].slice(1);
    }

    for (b = 0; b < D.length; b++) {
      if (c = D[b] + d, c in C.style) return {
        dom: c,
        css: E[b] + a
      };
    }
  },
      G = b.support = {
    bind: Function.prototype.bind,
    transform: F("transform"),
    transition: F("transition"),
    backface: F("backface-visibility"),
    timing: F("transition-timing-function")
  };

  if (G.transition) {
    var H = G.timing.dom;
    if (C.style[H] = m["ease-in-back"][0], !C.style[H]) for (var I in n) {
      m[I][0] = n[I];
    }
  }

  var J = b.frame = function () {
    var a = p.requestAnimationFrame || p.webkitRequestAnimationFrame || p.mozRequestAnimationFrame || p.oRequestAnimationFrame || p.msRequestAnimationFrame;
    return a && G.bind ? a.bind(p) : function (a) {
      p.setTimeout(a, 16);
    };
  }(),
      K = b.now = function () {
    var a = p.performance,
        b = a && (a.now || a.webkitNow || a.msNow || a.mozNow);
    return b && G.bind ? b.bind(a) : Date.now || function () {
      return +new Date();
    };
  }(),
      L = l(function (b) {
    function d(a, b) {
      var c = k(("" + a).split(B)),
          d = c[0];
      b = b || {};
      var e = Y[d];
      if (!e) return j("Unsupported property: " + d);

      if (!b.weak || !this.props[d]) {
        var f = e[0],
            g = this.props[d];
        return g || (g = this.props[d] = new f.Bare()), g.init(this.$el, c, e, b), g;
      }
    }

    function e(a, b, c) {
      if (a) {
        var e = (0, _typeof2["default"])(a);
        if (b || (this.timer && this.timer.destroy(), this.queue = [], this.active = !1), "number" == e && b) return this.timer = new S({
          duration: a,
          context: this,
          complete: h
        }), void (this.active = !0);

        if ("string" == e && b) {
          switch (a) {
            case "hide":
              o.call(this);
              break;

            case "stop":
              l.call(this);
              break;

            case "redraw":
              p.call(this);
              break;

            default:
              d.call(this, a, c && c[1]);
          }

          return h.call(this);
        }

        if ("function" == e) return void a.call(this, this);

        if ("object" == e) {
          var f = 0;
          u.call(this, a, function (a, b) {
            a.span > f && (f = a.span), a.stop(), a.animate(b);
          }, function (a) {
            "wait" in a && (f = i(a.wait, 0));
          }), t.call(this), f > 0 && (this.timer = new S({
            duration: f,
            context: this
          }), this.active = !0, b && (this.timer.complete = h));
          var g = this,
              j = !1,
              k = {};
          J(function () {
            u.call(g, a, function (a) {
              a.active && (j = !0, k[a.name] = a.nextStyle);
            }), j && g.$el.css(k);
          });
        }
      }
    }

    function f(a) {
      a = i(a, 0), this.active ? this.queue.push({
        options: a
      }) : (this.timer = new S({
        duration: a,
        context: this,
        complete: h
      }), this.active = !0);
    }

    function g(a) {
      return this.active ? (this.queue.push({
        options: a,
        args: arguments
      }), void (this.timer.complete = h)) : j("No active transition timer. Use start() or wait() before then().");
    }

    function h() {
      if (this.timer && this.timer.destroy(), this.active = !1, this.queue.length) {
        var a = this.queue.shift();
        e.call(this, a.options, !0, a.args);
      }
    }

    function l(a) {
      this.timer && this.timer.destroy(), this.queue = [], this.active = !1;
      var b;
      "string" == typeof a ? (b = {}, b[a] = 1) : b = "object" == (0, _typeof2["default"])(a) && null != a ? a : this.props, u.call(this, b, v), t.call(this);
    }

    function m(a) {
      l.call(this, a), u.call(this, a, w, x);
    }

    function n(a) {
      "string" != typeof a && (a = "block"), this.el.style.display = a;
    }

    function o() {
      l.call(this), this.el.style.display = "none";
    }

    function p() {
      this.el.offsetHeight;
    }

    function r() {
      l.call(this), a.removeData(this.el, q), this.$el = this.el = null;
    }

    function t() {
      var a,
          b,
          c = [];
      this.upstream && c.push(this.upstream);

      for (a in this.props) {
        b = this.props[a], b.active && c.push(b.string);
      }

      c = c.join(","), this.style !== c && (this.style = c, this.el.style[G.transition.dom] = c);
    }

    function u(a, b, e) {
      var f,
          g,
          h,
          i,
          j = b !== v,
          k = {};

      for (f in a) {
        h = a[f], f in Z ? (k.transform || (k.transform = {}), k.transform[f] = h) : (s.test(f) && (f = c(f)), f in Y ? k[f] = h : (i || (i = {}), i[f] = h));
      }

      for (f in k) {
        if (h = k[f], g = this.props[f], !g) {
          if (!j) continue;
          g = d.call(this, f);
        }

        b.call(this, g, h);
      }

      e && i && e.call(this, i);
    }

    function v(a) {
      a.stop();
    }

    function w(a, b) {
      a.set(b);
    }

    function x(a) {
      this.$el.css(a);
    }

    function y(a, c) {
      b[a] = function () {
        return this.children ? A.call(this, c, arguments) : (this.el && c.apply(this, arguments), this);
      };
    }

    function A(a, b) {
      var c,
          d = this.children.length;

      for (c = 0; d > c; c++) {
        a.apply(this.children[c], b);
      }

      return this;
    }

    b.init = function (b) {
      if (this.$el = a(b), this.el = this.$el[0], this.props = {}, this.queue = [], this.style = "", this.active = !1, U.keepInherited && !U.fallback) {
        var c = W(this.el, "transition");
        c && !z.test(c) && (this.upstream = c);
      }

      G.backface && U.hideBackface && V(this.el, G.backface.css, "hidden");
    }, y("add", d), y("start", e), y("wait", f), y("then", g), y("next", h), y("stop", l), y("set", m), y("show", n), y("hide", o), y("redraw", p), y("destroy", r);
  }),
      M = l(L, function (b) {
    function c(b, c) {
      var d = a.data(b, q) || a.data(b, q, new L.Bare());
      return d.el || d.init(b), c ? d.start(c) : d;
    }

    b.init = function (b, d) {
      var e = a(b);
      if (!e.length) return this;
      if (1 === e.length) return c(e[0], d);
      var f = [];
      return e.each(function (a, b) {
        f.push(c(b, d));
      }), this.children = f, this;
    };
  }),
      N = l(function (a) {
    function b() {
      var a = this.get();
      this.update("auto");
      var b = this.get();
      return this.update(a), b;
    }

    function c(a, b, c) {
      return void 0 !== b && (c = b), a in m ? a : c;
    }

    function d(a) {
      var b = /rgba?\((\d+),\s*(\d+),\s*(\d+)/.exec(a);
      return (b ? e(b[1], b[2], b[3]) : a).replace(/#(\w)(\w)(\w)$/, "#$1$1$2$2$3$3");
    }

    var f = {
      duration: 500,
      ease: "ease",
      delay: 0
    };
    a.init = function (a, b, d, e) {
      this.$el = a, this.el = a[0];
      var g = b[0];
      d[2] && (g = d[2]), X[g] && (g = X[g]), this.name = g, this.type = d[1], this.duration = i(b[1], this.duration, f.duration), this.ease = c(b[2], this.ease, f.ease), this.delay = i(b[3], this.delay, f.delay), this.span = this.duration + this.delay, this.active = !1, this.nextStyle = null, this.auto = A.test(this.name), this.unit = e.unit || this.unit || U.defaultUnit, this.angle = e.angle || this.angle || U.defaultAngle, U.fallback || e.fallback ? this.animate = this.fallback : (this.animate = this.transition, this.string = this.name + B + this.duration + "ms" + ("ease" != this.ease ? B + m[this.ease][0] : "") + (this.delay ? B + this.delay + "ms" : ""));
    }, a.set = function (a) {
      a = this.convert(a, this.type), this.update(a), this.redraw();
    }, a.transition = function (a) {
      this.active = !0, a = this.convert(a, this.type), this.auto && ("auto" == this.el.style[this.name] && (this.update(this.get()), this.redraw()), "auto" == a && (a = b.call(this))), this.nextStyle = a;
    }, a.fallback = function (a) {
      var c = this.el.style[this.name] || this.convert(this.get(), this.type);
      a = this.convert(a, this.type), this.auto && ("auto" == c && (c = this.convert(this.get(), this.type)), "auto" == a && (a = b.call(this))), this.tween = new R({
        from: c,
        to: a,
        duration: this.duration,
        delay: this.delay,
        ease: this.ease,
        update: this.update,
        context: this
      });
    }, a.get = function () {
      return W(this.el, this.name);
    }, a.update = function (a) {
      V(this.el, this.name, a);
    }, a.stop = function () {
      (this.active || this.nextStyle) && (this.active = !1, this.nextStyle = null, V(this.el, this.name, this.get()));
      var a = this.tween;
      a && a.context && a.destroy();
    }, a.convert = function (a, b) {
      if ("auto" == a && this.auto) return a;
      var c,
          e = "number" == typeof a,
          f = "string" == typeof a;

      switch (b) {
        case t:
          if (e) return a;
          if (f && "" === a.replace(r, "")) return +a;
          c = "number(unitless)";
          break;

        case u:
          if (f) {
            if ("" === a && this.original) return this.original;
            if (b.test(a)) return "#" == a.charAt(0) && 7 == a.length ? a : d(a);
          }

          c = "hex or rgb string";
          break;

        case v:
          if (e) return a + this.unit;
          if (f && b.test(a)) return a;
          c = "number(px) or string(unit)";
          break;

        case w:
          if (e) return a + this.unit;
          if (f && b.test(a)) return a;
          c = "number(px) or string(unit or %)";
          break;

        case x:
          if (e) return a + this.angle;
          if (f && b.test(a)) return a;
          c = "number(deg) or string(angle)";
          break;

        case y:
          if (e) return a;
          if (f && w.test(a)) return a;
          c = "number(unitless) or string(unit or %)";
      }

      return g(c, a), a;
    }, a.redraw = function () {
      this.el.offsetHeight;
    };
  }),
      O = l(N, function (a, b) {
    a.init = function () {
      b.init.apply(this, arguments), this.original || (this.original = this.convert(this.get(), u));
    };
  }),
      P = l(N, function (a, b) {
    a.init = function () {
      b.init.apply(this, arguments), this.animate = this.fallback;
    }, a.get = function () {
      return this.$el[this.name]();
    }, a.update = function (a) {
      this.$el[this.name](a);
    };
  }),
      Q = l(N, function (a, b) {
    function c(a, b) {
      var c, d, e, f, g;

      for (c in a) {
        f = Z[c], e = f[0], d = f[1] || c, g = this.convert(a[c], e), b.call(this, d, g, e);
      }
    }

    a.init = function () {
      b.init.apply(this, arguments), this.current || (this.current = {}, Z.perspective && U.perspective && (this.current.perspective = U.perspective, V(this.el, this.name, this.style(this.current)), this.redraw()));
    }, a.set = function (a) {
      c.call(this, a, function (a, b) {
        this.current[a] = b;
      }), V(this.el, this.name, this.style(this.current)), this.redraw();
    }, a.transition = function (a) {
      var b = this.values(a);
      this.tween = new T({
        current: this.current,
        values: b,
        duration: this.duration,
        delay: this.delay,
        ease: this.ease
      });
      var c,
          d = {};

      for (c in this.current) {
        d[c] = c in b ? b[c] : this.current[c];
      }

      this.active = !0, this.nextStyle = this.style(d);
    }, a.fallback = function (a) {
      var b = this.values(a);
      this.tween = new T({
        current: this.current,
        values: b,
        duration: this.duration,
        delay: this.delay,
        ease: this.ease,
        update: this.update,
        context: this
      });
    }, a.update = function () {
      V(this.el, this.name, this.style(this.current));
    }, a.style = function (a) {
      var b,
          c = "";

      for (b in a) {
        c += b + "(" + a[b] + ") ";
      }

      return c;
    }, a.values = function (a) {
      var b,
          d = {};
      return c.call(this, a, function (a, c, e) {
        d[a] = c, void 0 === this.current[a] && (b = 0, ~a.indexOf("scale") && (b = 1), this.current[a] = this.convert(b, e));
      }), d;
    };
  }),
      R = l(function (b) {
    function c(a) {
      1 === n.push(a) && J(g);
    }

    function g() {
      var a,
          b,
          c,
          d = n.length;
      if (d) for (J(g), b = K(), a = d; a--;) {
        c = n[a], c && c.render(b);
      }
    }

    function i(b) {
      var c,
          d = a.inArray(b, n);
      d >= 0 && (c = n.slice(d + 1), n.length = d, c.length && (n = n.concat(c)));
    }

    function j(a) {
      return Math.round(a * o) / o;
    }

    function k(a, b, c) {
      return e(a[0] + c * (b[0] - a[0]), a[1] + c * (b[1] - a[1]), a[2] + c * (b[2] - a[2]));
    }

    var l = {
      ease: m.ease[1],
      from: 0,
      to: 1
    };
    b.init = function (a) {
      this.duration = a.duration || 0, this.delay = a.delay || 0;
      var b = a.ease || l.ease;
      m[b] && (b = m[b][1]), "function" != typeof b && (b = l.ease), this.ease = b, this.update = a.update || f, this.complete = a.complete || f, this.context = a.context || this, this.name = a.name;
      var c = a.from,
          d = a.to;
      void 0 === c && (c = l.from), void 0 === d && (d = l.to), this.unit = a.unit || "", "number" == typeof c && "number" == typeof d ? (this.begin = c, this.change = d - c) : this.format(d, c), this.value = this.begin + this.unit, this.start = K(), a.autoplay !== !1 && this.play();
    }, b.play = function () {
      this.active || (this.start || (this.start = K()), this.active = !0, c(this));
    }, b.stop = function () {
      this.active && (this.active = !1, i(this));
    }, b.render = function (a) {
      var b,
          c = a - this.start;

      if (this.delay) {
        if (c <= this.delay) return;
        c -= this.delay;
      }

      if (c < this.duration) {
        var d = this.ease(c, 0, 1, this.duration);
        return b = this.startRGB ? k(this.startRGB, this.endRGB, d) : j(this.begin + d * this.change), this.value = b + this.unit, void this.update.call(this.context, this.value);
      }

      b = this.endHex || this.begin + this.change, this.value = b + this.unit, this.update.call(this.context, this.value), this.complete.call(this.context), this.destroy();
    }, b.format = function (a, b) {
      if (b += "", a += "", "#" == a.charAt(0)) return this.startRGB = d(b), this.endRGB = d(a), this.endHex = a, this.begin = 0, void (this.change = 1);

      if (!this.unit) {
        var c = b.replace(r, ""),
            e = a.replace(r, "");
        c !== e && h("tween", b, a), this.unit = c;
      }

      b = parseFloat(b), a = parseFloat(a), this.begin = this.value = b, this.change = a - b;
    }, b.destroy = function () {
      this.stop(), this.context = null, this.ease = this.update = this.complete = f;
    };
    var n = [],
        o = 1e3;
  }),
      S = l(R, function (a) {
    a.init = function (a) {
      this.duration = a.duration || 0, this.complete = a.complete || f, this.context = a.context, this.play();
    }, a.render = function (a) {
      var b = a - this.start;
      b < this.duration || (this.complete.call(this.context), this.destroy());
    };
  }),
      T = l(R, function (a, b) {
    a.init = function (a) {
      this.context = a.context, this.update = a.update, this.tweens = [], this.current = a.current;
      var b, c;

      for (b in a.values) {
        c = a.values[b], this.current[b] !== c && this.tweens.push(new R({
          name: b,
          from: this.current[b],
          to: c,
          duration: a.duration,
          delay: a.delay,
          ease: a.ease,
          autoplay: !1
        }));
      }

      this.play();
    }, a.render = function (a) {
      var b,
          c,
          d = this.tweens.length,
          e = !1;

      for (b = d; b--;) {
        c = this.tweens[b], c.context && (c.render(a), this.current[c.name] = c.value, e = !0);
      }

      return e ? void (this.update && this.update.call(this.context)) : this.destroy();
    }, a.destroy = function () {
      if (b.destroy.call(this), this.tweens) {
        var a,
            c = this.tweens.length;

        for (a = c; a--;) {
          this.tweens[a].destroy();
        }

        this.tweens = null, this.current = null;
      }
    };
  }),
      U = b.config = {
    debug: !1,
    defaultUnit: "px",
    defaultAngle: "deg",
    keepInherited: !1,
    hideBackface: !1,
    perspective: "",
    fallback: !G.transition,
    agentTests: []
  };

  b.fallback = function (a) {
    if (!G.transition) return U.fallback = !0;
    U.agentTests.push("(" + a + ")");
    var b = new RegExp(U.agentTests.join("|"), "i");
    U.fallback = b.test(navigator.userAgent);
  }, b.fallback("6.0.[2-5] Safari"), b.tween = function (a) {
    return new R(a);
  }, b.delay = function (a, b, c) {
    return new S({
      complete: b,
      duration: a,
      context: c
    });
  }, a.fn.tram = function (a) {
    return b.call(null, this, a);
  };
  var V = a.style,
      W = a.css,
      X = {
    transform: G.transform && G.transform.css
  },
      Y = {
    color: [O, u],
    background: [O, u, "background-color"],
    "outline-color": [O, u],
    "border-color": [O, u],
    "border-top-color": [O, u],
    "border-right-color": [O, u],
    "border-bottom-color": [O, u],
    "border-left-color": [O, u],
    "border-width": [N, v],
    "border-top-width": [N, v],
    "border-right-width": [N, v],
    "border-bottom-width": [N, v],
    "border-left-width": [N, v],
    "border-spacing": [N, v],
    "letter-spacing": [N, v],
    margin: [N, v],
    "margin-top": [N, v],
    "margin-right": [N, v],
    "margin-bottom": [N, v],
    "margin-left": [N, v],
    padding: [N, v],
    "padding-top": [N, v],
    "padding-right": [N, v],
    "padding-bottom": [N, v],
    "padding-left": [N, v],
    "outline-width": [N, v],
    opacity: [N, t],
    top: [N, w],
    right: [N, w],
    bottom: [N, w],
    left: [N, w],
    "font-size": [N, w],
    "text-indent": [N, w],
    "word-spacing": [N, w],
    width: [N, w],
    "min-width": [N, w],
    "max-width": [N, w],
    height: [N, w],
    "min-height": [N, w],
    "max-height": [N, w],
    "line-height": [N, y],
    "scroll-top": [P, t, "scrollTop"],
    "scroll-left": [P, t, "scrollLeft"]
  },
      Z = {};
  G.transform && (Y.transform = [Q], Z = {
    x: [w, "translateX"],
    y: [w, "translateY"],
    rotate: [x],
    rotateX: [x],
    rotateY: [x],
    scale: [t],
    scaleX: [t],
    scaleY: [t],
    skew: [x],
    skewX: [x],
    skewY: [x]
  }), G.transform && G.backface && (Z.z = [w, "translateZ"], Z.rotateZ = [x], Z.scaleZ = [t], Z.perspective = [v]);
  var $ = /ms/,
      _ = /s|\./;
  return a.tram = b;
}(window.jQuery);

/***/ }),
/* 159 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(1);
var fails = __webpack_require__(11);
var isArray = __webpack_require__(31);
var isObject = __webpack_require__(17);
var toObject = __webpack_require__(7);
var toLength = __webpack_require__(5);
var createProperty = __webpack_require__(53);
var arraySpeciesCreate = __webpack_require__(54);
var arrayMethodHasSpeciesSupport = __webpack_require__(55);
var wellKnownSymbol = __webpack_require__(3);

var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded';

var IS_CONCAT_SPREADABLE_SUPPORT = !fails(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});

var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');

var isConcatSpreadable = function (O) {
  if (!isObject(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : isArray(O);
};

var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT;

// `Array.prototype.concat` method
// https://tc39.github.io/ecma262/#sec-array.prototype.concat
// with adding support of @@isConcatSpreadable and @@species
$({ target: 'Array', proto: true, forced: FORCED }, {
  concat: function concat(arg) { // eslint-disable-line no-unused-vars
    var O = toObject(this);
    var A = arraySpeciesCreate(O, 0);
    var n = 0;
    var i, k, length, len, E;
    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];
      if (isConcatSpreadable(E)) {
        len = toLength(E.length);
        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
      } else {
        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        createProperty(A, n++, E);
      }
    }
    A.length = n;
    return A;
  }
});


/***/ }),
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var nativePropertyIsEnumerable = {}.propertyIsEnumerable;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor && !nativePropertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.github.io/ecma262/#sec-object.prototype.propertyisenumerable
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : nativePropertyIsEnumerable;


/***/ }),
/* 161 */
/***/ (function(module, exports, __webpack_require__) {

var DESCRIPTORS = __webpack_require__(16);
var fails = __webpack_require__(11);
var createElement = __webpack_require__(162);

// Thank's IE8 for his funny defineProperty
module.exports = !DESCRIPTORS && !fails(function () {
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});


/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(4);
var isObject = __webpack_require__(17);

var document = global.document;
// typeof document.createElement is 'object' in old IE
var EXISTS = isObject(document) && isObject(document.createElement);

module.exports = function (it) {
  return EXISTS ? document.createElement(it) : {};
};


/***/ }),
/* 163 */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(51);

module.exports = shared('native-function-to-string', Function.toString);


/***/ }),
/* 164 */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(12);
var ownKeys = __webpack_require__(283);
var getOwnPropertyDescriptorModule = __webpack_require__(110);
var definePropertyModule = __webpack_require__(13);

module.exports = function (target, source) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!has(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
};


/***/ }),
/* 165 */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(12);
var toIndexedObject = __webpack_require__(21);
var indexOf = __webpack_require__(116).indexOf;
var hiddenKeys = __webpack_require__(76);

module.exports = function (object, names) {
  var O = toIndexedObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !has(hiddenKeys, key) && has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~indexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),
/* 166 */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),
/* 167 */
/***/ (function(module, exports, __webpack_require__) {

var fails = __webpack_require__(11);

module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  // Chrome 38 Symbol has incorrect toString conversion
  // eslint-disable-next-line no-undef
  return !String(Symbol());
});


/***/ }),
/* 168 */
/***/ (function(module, exports, __webpack_require__) {

var classofRaw = __webpack_require__(111);
var wellKnownSymbol = __webpack_require__(3);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
module.exports = function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
};


/***/ }),
/* 169 */
/***/ (function(module, exports, __webpack_require__) {

var internalObjectKeys = __webpack_require__(165);
var enumBugKeys = __webpack_require__(117);

// `Object.keys` method
// https://tc39.github.io/ecma262/#sec-object.keys
module.exports = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys);
};


/***/ }),
/* 170 */
/***/ (function(module, exports, __webpack_require__) {

exports.f = __webpack_require__(3);


/***/ }),
/* 171 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $ = __webpack_require__(1);
var createIteratorConstructor = __webpack_require__(315);
var getPrototypeOf = __webpack_require__(173);
var setPrototypeOf = __webpack_require__(317);
var setToStringTag = __webpack_require__(56);
var hide = __webpack_require__(22);
var redefine = __webpack_require__(72);
var wellKnownSymbol = __webpack_require__(3);
var IS_PURE = __webpack_require__(73);
var Iterators = __webpack_require__(57);
var IteratorsCore = __webpack_require__(172);

var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR = wellKnownSymbol('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
    if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf) {
          setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
        } else if (typeof CurrentIteratorPrototype[ITERATOR] != 'function') {
          hide(CurrentIteratorPrototype, ITERATOR, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
    }
  }

  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    INCORRECT_VALUES_NAME = true;
    defaultIterator = function values() { return nativeIterator.call(this); };
  }

  // define iterator
  if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
    hide(IterablePrototype, ITERATOR, defaultIterator);
  }
  Iterators[NAME] = defaultIterator;

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        redefine(IterablePrototype, KEY, methods[KEY]);
      }
    } else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  return methods;
};


/***/ }),
/* 172 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var getPrototypeOf = __webpack_require__(173);
var hide = __webpack_require__(22);
var has = __webpack_require__(12);
var wellKnownSymbol = __webpack_require__(3);
var IS_PURE = __webpack_require__(73);

var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;

var returnThis = function () { return this; };

// `%IteratorPrototype%` object
// https://tc39.github.io/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
  }
}

if (IteratorPrototype == undefined) IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
if (!IS_PURE && !has(IteratorPrototype, ITERATOR)) hide(IteratorPrototype, ITERATOR, returnThis);

module.exports = {
  IteratorPrototype: IteratorPrototype,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};


/***/ }),
/* 173 */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(12);
var toObject = __webpack_require__(7);
var sharedKey = __webpack_require__(75);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(316);

var IE_PROTO = sharedKey('IE_PROTO');
var ObjectPrototype = Object.prototype;

// `Object.getPrototypeOf` method
// https://tc39.github.io/ecma262/#sec-object.getprototypeof
module.exports = CORRECT_PROTOTYPE_GETTER ? Object.getPrototypeOf : function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectPrototype : null;
};


/***/ }),
/* 174 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var isArray = __webpack_require__(31);
var toLength = __webpack_require__(5);
var bind = __webpack_require__(78);

// `FlattenIntoArray` abstract operation
// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray
var flattenIntoArray = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
  var targetIndex = start;
  var sourceIndex = 0;
  var mapFn = mapper ? bind(mapper, thisArg, 3) : false;
  var element;

  while (sourceIndex < sourceLen) {
    if (sourceIndex in source) {
      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

      if (depth > 0 && isArray(element)) {
        targetIndex = flattenIntoArray(target, original, element, toLength(element.length), targetIndex, depth - 1) - 1;
      } else {
        if (targetIndex >= 0x1FFFFFFFFFFFFF) throw TypeError('Exceed the acceptable array length');
        target[targetIndex] = element;
      }

      targetIndex++;
    }
    sourceIndex++;
  }
  return targetIndex;
};

module.exports = flattenIntoArray;


/***/ }),
/* 175 */
/***/ (function(module, exports, __webpack_require__) {

var aFunction = __webpack_require__(79);
var toObject = __webpack_require__(7);
var IndexedObject = __webpack_require__(69);
var toLength = __webpack_require__(5);

// `Array.prototype.{ reduce, reduceRight }` methods implementation
var createMethod = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    aFunction(callbackfn);
    var O = toObject(that);
    var self = IndexedObject(O);
    var length = toLength(O.length);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (IS_RIGHT ? index < 0 : length <= index) {
        throw TypeError('Reduce of empty array with no initial value');
      }
    }
    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };
};

module.exports = {
  // `Array.prototype.reduce` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.reduce
  left: createMethod(false),
  // `Array.prototype.reduceRight` method
  // https://tc39.github.io/ecma262/#sec-array.prototype.reduceright
  right: createMethod(true)
};


/***/ }),
/* 176 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveInfoFromField", function() { return getDirectiveInfoFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shouldInclude", function() { return shouldInclude; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "flattenSelections", function() { return flattenSelections; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveNames", function() { return getDirectiveNames; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasDirectives", function() { return hasDirectives; });
/* harmony import */ var _storeUtils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83);

function getDirectiveInfoFromField(field, variables) {
    if (field.directives && field.directives.length) {
        var directiveObj_1 = {};
        field.directives.forEach(function (directive) {
            directiveObj_1[directive.name.value] = Object(_storeUtils__WEBPACK_IMPORTED_MODULE_0__["argumentsObjectFromField"])(directive, variables);
        });
        return directiveObj_1;
    }
    return null;
}
function shouldInclude(selection, variables) {
    if (variables === void 0) { variables = {}; }
    if (!selection.directives) {
        return true;
    }
    var res = true;
    selection.directives.forEach(function (directive) {
        // TODO should move this validation to GraphQL validation once that's implemented.
        if (directive.name.value !== 'skip' && directive.name.value !== 'include') {
            // Just don't worry about directives we don't understand
            return;
        }
        //evaluate the "if" argument and skip (i.e. return undefined) if it evaluates to true.
        var directiveArguments = directive.arguments || [];
        var directiveName = directive.name.value;
        if (directiveArguments.length !== 1) {
            throw new Error("Incorrect number of arguments for the @" + directiveName + " directive.");
        }
        var ifArgument = directiveArguments[0];
        if (!ifArgument.name || ifArgument.name.value !== 'if') {
            throw new Error("Invalid argument for the @" + directiveName + " directive.");
        }
        var ifValue = directiveArguments[0].value;
        var evaledValue = false;
        if (!ifValue || ifValue.kind !== 'BooleanValue') {
            // means it has to be a variable value if this is a valid @skip or @include directive
            if (ifValue.kind !== 'Variable') {
                throw new Error("Argument for the @" + directiveName + " directive must be a variable or a boolean value.");
            }
            else {
                evaledValue = variables[ifValue.name.value];
                if (evaledValue === undefined) {
                    throw new Error("Invalid variable referenced in @" + directiveName + " directive.");
                }
            }
        }
        else {
            evaledValue = ifValue.value;
        }
        if (directiveName === 'skip') {
            evaledValue = !evaledValue;
        }
        if (!evaledValue) {
            res = false;
        }
    });
    return res;
}
function flattenSelections(selection) {
    if (!selection.selectionSet ||
        !(selection.selectionSet.selections.length > 0))
        return [selection];
    return [selection].concat(selection.selectionSet.selections
        .map(function (selectionNode) {
        return [selectionNode].concat(flattenSelections(selectionNode));
    })
        .reduce(function (selections, selected) { return selections.concat(selected); }, []));
}
function getDirectiveNames(doc) {
    // operation => [names of directives];
    var directiveNames = doc.definitions
        .filter(function (definition) {
        return definition.selectionSet && definition.selectionSet.selections;
    })
        // operation => [[Selection]]
        .map(function (x) { return flattenSelections(x); })
        // [[Selection]] => [Selection]
        .reduce(function (selections, selected) { return selections.concat(selected); }, [])
        // [Selection] => [Selection with Directives]
        .filter(function (selection) {
        return selection.directives && selection.directives.length > 0;
    })
        // [Selection with Directives] => [[Directives]]
        .map(function (selection) { return selection.directives; })
        // [[Directives]] => [Directives]
        .reduce(function (directives, directive) { return directives.concat(directive); }, [])
        // [Directives] => [Name]
        .map(function (directive) { return directive.name.value; });
    return directiveNames;
}
function hasDirectives(names, doc) {
    return getDirectiveNames(doc).some(function (name) { return names.indexOf(name) > -1; });
}


/***/ }),
/* 177 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentQueryDocument", function() { return getFragmentQueryDocument; });
var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
/**
 * Returns a query document which adds a single query operation that only
 * spreads the target fragment inside of it.
 *
 * So for example a document of:
 *
 * ```graphql
 * fragment foo on Foo { a b c }
 * ```
 *
 * Turns into:
 *
 * ```graphql
 * { ...foo }
 *
 * fragment foo on Foo { a b c }
 * ```
 *
 * The target fragment will either be the only fragment in the document, or a
 * fragment specified by the provided `fragmentName`. If there is more then one
 * fragment, but a `fragmentName` was not defined then an error will be thrown.
 */
function getFragmentQueryDocument(document, fragmentName) {
    var actualFragmentName = fragmentName;
    // Build an array of all our fragment definitions that will be used for
    // validations. We also do some validations on the other definitions in the
    // document while building this list.
    var fragments = [];
    document.definitions.forEach(function (definition) {
        // Throw an error if we encounter an operation definition because we will
        // define our own operation definition later on.
        if (definition.kind === 'OperationDefinition') {
            throw new Error("Found a " + definition.operation + " operation" + (definition.name ? " named '" + definition.name.value + "'" : '') + ". " +
                'No operations are allowed when using a fragment as a query. Only fragments are allowed.');
        }
        // Add our definition to the fragments array if it is a fragment
        // definition.
        if (definition.kind === 'FragmentDefinition') {
            fragments.push(definition);
        }
    });
    // If the user did not give us a fragment name then let us try to get a
    // name from a single fragment in the definition.
    if (typeof actualFragmentName === 'undefined') {
        if (fragments.length !== 1) {
            throw new Error("Found " + fragments.length + " fragments. `fragmentName` must be provided when there is not exactly 1 fragment.");
        }
        actualFragmentName = fragments[0].name.value;
    }
    // Generate a query document with an operation that simply spreads the
    // fragment inside of it.
    var query = __assign({}, document, { definitions: [
            {
                kind: 'OperationDefinition',
                operation: 'query',
                selectionSet: {
                    kind: 'SelectionSet',
                    selections: [
                        {
                            kind: 'FragmentSpread',
                            name: {
                                kind: 'Name',
                                value: actualFragmentName,
                            },
                        },
                    ],
                },
            }
        ].concat(document.definitions) });
    return query;
}


/***/ }),
/* 178 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeDirectivesFromDocument", function() { return removeDirectivesFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addTypenameToDocument", function() { return addTypenameToDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeConnectionDirectiveFromDocument", function() { return removeConnectionDirectiveFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectivesFromDocument", function() { return getDirectivesFromDocument; });
/* harmony import */ var _util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(122);
/* harmony import */ var _getFromAST__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(120);


var TYPENAME_FIELD = {
    kind: 'Field',
    name: {
        kind: 'Name',
        value: '__typename',
    },
};
function isNotEmpty(op, fragments) {
    // keep selections that are still valid
    return (op.selectionSet.selections.filter(function (selectionSet) {
        // anything that doesn't match the compound filter is okay
        return !(selectionSet &&
            // look into fragments to verify they should stay
            selectionSet.kind === 'FragmentSpread' &&
            // see if the fragment in the map is valid (recursively)
            !isNotEmpty(fragments[selectionSet.name.value], fragments));
    }).length > 0);
}
function getDirectiveMatcher(directives) {
    return function directiveMatcher(directive) {
        return directives.some(function (dir) {
            if (dir.name && dir.name === directive.name.value)
                return true;
            if (dir.test && dir.test(directive))
                return true;
            return false;
        });
    };
}
function addTypenameToSelectionSet(selectionSet, isRoot) {
    if (isRoot === void 0) { isRoot = false; }
    if (selectionSet.selections) {
        if (!isRoot) {
            var alreadyHasThisField = selectionSet.selections.some(function (selection) {
                return (selection.kind === 'Field' &&
                    selection.name.value === '__typename');
            });
            if (!alreadyHasThisField) {
                selectionSet.selections.push(TYPENAME_FIELD);
            }
        }
        selectionSet.selections.forEach(function (selection) {
            // Must not add __typename if we're inside an introspection query
            if (selection.kind === 'Field') {
                if (selection.name.value.lastIndexOf('__', 0) !== 0 &&
                    selection.selectionSet) {
                    addTypenameToSelectionSet(selection.selectionSet);
                }
            }
            else if (selection.kind === 'InlineFragment') {
                if (selection.selectionSet) {
                    addTypenameToSelectionSet(selection.selectionSet);
                }
            }
        });
    }
}
function removeDirectivesFromSelectionSet(directives, selectionSet) {
    if (!selectionSet.selections)
        return selectionSet;
    // if any of the directives are set to remove this selectionSet, remove it
    var agressiveRemove = directives.some(function (dir) { return dir.remove; });
    selectionSet.selections = selectionSet.selections
        .map(function (selection) {
        if (selection.kind !== 'Field' ||
            !selection ||
            !selection.directives)
            return selection;
        var directiveMatcher = getDirectiveMatcher(directives);
        var remove;
        selection.directives = selection.directives.filter(function (directive) {
            var shouldKeep = !directiveMatcher(directive);
            if (!remove && !shouldKeep && agressiveRemove)
                remove = true;
            return shouldKeep;
        });
        return remove ? null : selection;
    })
        .filter(function (x) { return !!x; });
    selectionSet.selections.forEach(function (selection) {
        if ((selection.kind === 'Field' || selection.kind === 'InlineFragment') &&
            selection.selectionSet) {
            removeDirectivesFromSelectionSet(directives, selection.selectionSet);
        }
    });
    return selectionSet;
}
function removeDirectivesFromDocument(directives, doc) {
    var docClone = Object(_util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__["cloneDeep"])(doc);
    docClone.definitions.forEach(function (definition) {
        removeDirectivesFromSelectionSet(directives, definition.selectionSet);
    });
    var operation = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getOperationDefinitionOrDie"])(docClone);
    var fragments = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["createFragmentMap"])(Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getFragmentDefinitions"])(docClone));
    return isNotEmpty(operation, fragments) ? docClone : null;
}
function addTypenameToDocument(doc) {
    Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["checkDocument"])(doc);
    var docClone = Object(_util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__["cloneDeep"])(doc);
    docClone.definitions.forEach(function (definition) {
        var isRoot = definition.kind === 'OperationDefinition';
        addTypenameToSelectionSet(definition.selectionSet, isRoot);
    });
    return docClone;
}
var connectionRemoveConfig = {
    test: function (directive) {
        var willRemove = directive.name.value === 'connection';
        if (willRemove) {
            if (!directive.arguments ||
                !directive.arguments.some(function (arg) { return arg.name.value === 'key'; })) {
                console.warn('Removing an @connection directive even though it does not have a key. ' +
                    'You may want to use the key parameter to specify a store key.');
            }
        }
        return willRemove;
    },
};
function removeConnectionDirectiveFromDocument(doc) {
    Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["checkDocument"])(doc);
    return removeDirectivesFromDocument([connectionRemoveConfig], doc);
}
function hasDirectivesInSelectionSet(directives, selectionSet, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    if (!(selectionSet && selectionSet.selections)) {
        return false;
    }
    var matchedSelections = selectionSet.selections.filter(function (selection) {
        return hasDirectivesInSelection(directives, selection, nestedCheck);
    });
    return matchedSelections.length > 0;
}
function hasDirectivesInSelection(directives, selection, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    if (selection.kind !== 'Field' || !selection) {
        return true;
    }
    if (!selection.directives) {
        return false;
    }
    var directiveMatcher = getDirectiveMatcher(directives);
    var matchedDirectives = selection.directives.filter(directiveMatcher);
    return (matchedDirectives.length > 0 ||
        (nestedCheck &&
            hasDirectivesInSelectionSet(directives, selection.selectionSet, nestedCheck)));
}
function getDirectivesFromSelectionSet(directives, selectionSet) {
    selectionSet.selections = selectionSet.selections
        .filter(function (selection) {
        return hasDirectivesInSelection(directives, selection, true);
    })
        .map(function (selection) {
        if (hasDirectivesInSelection(directives, selection, false)) {
            return selection;
        }
        if ((selection.kind === 'Field' || selection.kind === 'InlineFragment') &&
            selection.selectionSet) {
            selection.selectionSet = getDirectivesFromSelectionSet(directives, selection.selectionSet);
        }
        return selection;
    });
    return selectionSet;
}
function getDirectivesFromDocument(directives, doc, includeAllFragments) {
    if (includeAllFragments === void 0) { includeAllFragments = false; }
    Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["checkDocument"])(doc);
    var docClone = Object(_util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__["cloneDeep"])(doc);
    docClone.definitions = docClone.definitions.map(function (definition) {
        if ((definition.kind === 'OperationDefinition' ||
            (definition.kind === 'FragmentDefinition' && !includeAllFragments)) &&
            definition.selectionSet) {
            definition.selectionSet = getDirectivesFromSelectionSet(directives, definition.selectionSet);
        }
        return definition;
    });
    var operation = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getOperationDefinitionOrDie"])(docClone);
    var fragments = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["createFragmentMap"])(Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getFragmentDefinitions"])(docClone));
    return isNotEmpty(operation, fragments) ? docClone : null;
}


/***/ }),
/* 179 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tryFunctionOrLogError", function() { return tryFunctionOrLogError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "graphQLResultHasError", function() { return graphQLResultHasError; });
function tryFunctionOrLogError(f) {
    try {
        return f();
    }
    catch (e) {
        if (console.error) {
            console.error(e);
        }
    }
}
function graphQLResultHasError(result) {
    return result.errors && result.errors.length;
}


/***/ }),
/* 180 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isEqual", function() { return isEqual; });
/**
 * Performs a deep equality check on two JavaScript values.
 */
function isEqual(a, b) {
    // If the two values are strictly equal, we are good.
    if (a === b) {
        return true;
    }
    // Dates are equivalent if their time values are equal.
    if (a instanceof Date && b instanceof Date) {
        return a.getTime() === b.getTime();
    }
    // If a and b are both objects, we will compare their properties. This will compare arrays as
    // well.
    if (a != null &&
        typeof a === 'object' &&
        b != null &&
        typeof b === 'object') {
        // Compare all of the keys in `a`. If one of the keys has a different value, or that key does
        // not exist in `b` return false immediately.
        for (var key in a) {
            if (Object.prototype.hasOwnProperty.call(a, key)) {
                if (!Object.prototype.hasOwnProperty.call(b, key)) {
                    return false;
                }
                if (!isEqual(a[key], b[key])) {
                    return false;
                }
            }
        }
        // Look through all the keys in `b`. If `b` has a key that `a` does not, return false.
        for (var key in b) {
            if (!Object.prototype.hasOwnProperty.call(a, key)) {
                return false;
            }
        }
        // If we made it this far the objects are equal!
        return true;
    }
    // Otherwise the values are not equal.
    return false;
}


/***/ }),
/* 181 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "maybeDeepFreeze", function() { return maybeDeepFreeze; });
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85);

// Taken (mostly) from https://github.com/substack/deep-freeze to avoid
// import hassles with rollup.
function deepFreeze(o) {
    Object.freeze(o);
    Object.getOwnPropertyNames(o).forEach(function (prop) {
        if (o[prop] !== null &&
            (typeof o[prop] === 'object' || typeof o[prop] === 'function') &&
            !Object.isFrozen(o[prop])) {
            deepFreeze(o[prop]);
        }
    });
    return o;
}
function maybeDeepFreeze(obj) {
    if (Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isDevelopment"])() || Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isTest"])()) {
        // Polyfilled Symbols potentially cause infinite / very deep recursion while deep freezing
        // which is known to crash IE11 (https://github.com/apollographql/apollo-client/issues/3043).
        var symbolIsPolyfilled = typeof Symbol === 'function' && typeof Symbol('') === 'string';
        if (!symbolIsPolyfilled) {
            return deepFreeze(obj);
        }
    }
    return obj;
}


/***/ }),
/* 182 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "warnOnceInDevelopment", function() { return warnOnceInDevelopment; });
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85);

var haveWarned = Object.create({});
/**
 * Print a warning only once in development.
 * In production no warnings are printed.
 * In test all warnings are printed.
 *
 * @param msg The warning message
 * @param type warn or error (will call console.warn or console.error)
 */
function warnOnceInDevelopment(msg, type) {
    if (type === void 0) { type = 'warn'; }
    if (Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isProduction"])()) {
        return;
    }
    if (!haveWarned[msg]) {
        if (!Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isTest"])()) {
            haveWarned[msg] = true;
        }
        switch (type) {
            case 'error':
                console.error(msg);
                break;
            default:
                console.warn(msg);
        }
    }
}


/***/ }),
/* 183 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stripSymbols", function() { return stripSymbols; });
/**
 * In order to make assertions easier, this function strips `symbol`'s from
 * the incoming data.
 *
 * This can be handy when running tests against `apollo-client` for example,
 * since it adds `symbol`'s to the data in the store. Jest's `toEqual`
 * function now covers `symbol`'s (https://github.com/facebook/jest/pull/3437),
 * which means all test data used in a `toEqual` comparison would also have to
 * include `symbol`'s, to pass. By stripping `symbol`'s from the cache data
 * we can compare against more simplified test data.
 */
function stripSymbols(data) {
    return JSON.parse(JSON.stringify(data));
}


/***/ }),
/* 184 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Observable", function() { return Observable; });
/* harmony import */ var apollo_link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27);
/* harmony import */ var symbol_observable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(370);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
// This simplified polyfill attempts to follow the ECMAScript Observable proposal.
// See https://github.com/zenparsing/es-observable


// rxjs interopt
var Observable = /** @class */ (function (_super) {
    __extends(Observable, _super);
    function Observable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Observable.prototype[symbol_observable__WEBPACK_IMPORTED_MODULE_1__["default"]] = function () {
        return this;
    };
    Observable.prototype['@@observable'] = function () {
        return this;
    };
    return Observable;
}(apollo_link__WEBPACK_IMPORTED_MODULE_0__["Observable"]));



/***/ }),
/* 185 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "empty", function() { return empty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "from", function() { return from; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "split", function() { return split; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "concat", function() { return concat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApolloLink", function() { return ApolloLink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "execute", function() { return execute; });
/* harmony import */ var zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(86);
/* harmony import */ var _linkUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);


var passthrough = function (op, forward) { return (forward ? forward(op) : zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of()); };
var toLink = function (handler) {
    return typeof handler === 'function' ? new ApolloLink(handler) : handler;
};
var empty = function () {
    return new ApolloLink(function (op, forward) { return zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of(); });
};
var from = function (links) {
    if (links.length === 0)
        return empty();
    return links.map(toLink).reduce(function (x, y) { return x.concat(y); });
};
var split = function (test, left, right) {
    if (right === void 0) { right = new ApolloLink(passthrough); }
    var leftLink = toLink(left);
    var rightLink = toLink(right);
    if (Object(_linkUtils__WEBPACK_IMPORTED_MODULE_1__["isTerminating"])(leftLink) && Object(_linkUtils__WEBPACK_IMPORTED_MODULE_1__["isTerminating"])(rightLink)) {
        return new ApolloLink(function (operation) {
            return test(operation)
                ? leftLink.request(operation) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of()
                : rightLink.request(operation) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of();
        });
    }
    else {
        return new ApolloLink(function (operation, forward) {
            return test(operation)
                ? leftLink.request(operation, forward) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of()
                : rightLink.request(operation, forward) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of();
        });
    }
};
// join two Links together
var concat = function (first, second) {
    var firstLink = toLink(first);
    if (Object(_linkUtils__WEBPACK_IMPORTED_MODULE_1__["isTerminating"])(firstLink)) {
        console.warn(new _linkUtils__WEBPACK_IMPORTED_MODULE_1__["LinkError"]("You are calling concat on a terminating link, which will have no effect", firstLink));
        return firstLink;
    }
    var nextLink = toLink(second);
    if (Object(_linkUtils__WEBPACK_IMPORTED_MODULE_1__["isTerminating"])(nextLink)) {
        return new ApolloLink(function (operation) {
            return firstLink.request(operation, function (op) { return nextLink.request(op) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of(); }) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of();
        });
    }
    else {
        return new ApolloLink(function (operation, forward) {
            return (firstLink.request(operation, function (op) {
                return nextLink.request(op, forward) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of();
            }) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of());
        });
    }
};
var ApolloLink = /** @class */ (function () {
    function ApolloLink(request) {
        if (request)
            this.request = request;
    }
    ApolloLink.prototype.split = function (test, left, right) {
        if (right === void 0) { right = new ApolloLink(passthrough); }
        return this.concat(split(test, left, right));
    };
    ApolloLink.prototype.concat = function (next) {
        return concat(this, next);
    };
    ApolloLink.prototype.request = function (operation, forward) {
        throw new Error('request is not implemented');
    };
    ApolloLink.empty = empty;
    ApolloLink.from = from;
    ApolloLink.split = split;
    ApolloLink.execute = execute;
    return ApolloLink;
}());

function execute(link, operation) {
    return (link.request(Object(_linkUtils__WEBPACK_IMPORTED_MODULE_1__["createOperation"])(operation.context, Object(_linkUtils__WEBPACK_IMPORTED_MODULE_1__["transformOperation"])(Object(_linkUtils__WEBPACK_IMPORTED_MODULE_1__["validateOperation"])(operation)))) || zen_observable_ts__WEBPACK_IMPORTED_MODULE_0__["default"].of());
}


/***/ }),
/* 186 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var apollo_link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27);
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);
/* harmony import */ var _core_QueryManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(373);
/* harmony import */ var _data_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(378);
/* harmony import */ var _version__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(379);
/* harmony import */ var _version__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_version__WEBPACK_IMPORTED_MODULE_4__);
var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};





var hasSuggestedDevtools = false;
var supportedDirectives = new apollo_link__WEBPACK_IMPORTED_MODULE_0__["ApolloLink"](function (operation, forward) {
    operation.query = Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["removeConnectionDirectiveFromDocument"])(operation.query);
    return forward(operation);
});
/**
 * This is the primary Apollo Client class. It is used to send GraphQL documents (i.e. queries
 * and mutations) to a GraphQL spec-compliant server over a {@link NetworkInterface} instance,
 * receive results from the server and cache the results in a store. It also delivers updates
 * to GraphQL queries through {@link Observable} instances.
 */
var ApolloClient = /** @class */ (function () {
    /**
     * Constructs an instance of {@link ApolloClient}.
     *
     * @param link The {@link ApolloLink} over which GraphQL documents will be resolved into a response.
     *
     * @param cache The initial cache to use in the data store.
     *
     * @param ssrMode Determines whether this is being run in Server Side Rendering (SSR) mode.
     *
     * @param ssrForceFetchDelay Determines the time interval before we force fetch queries for a
     * server side render.
     *
     * @param queryDeduplication If set to false, a query will still be sent to the server even if a query
     * with identical parameters (query, variables, operationName) is already in flight.
     *
     */
    function ApolloClient(options) {
        var _this = this;
        this.defaultOptions = {};
        this.resetStoreCallbacks = [];
        var link = options.link, cache = options.cache, _a = options.ssrMode, ssrMode = _a === void 0 ? false : _a, _b = options.ssrForceFetchDelay, ssrForceFetchDelay = _b === void 0 ? 0 : _b, connectToDevTools = options.connectToDevTools, _c = options.queryDeduplication, queryDeduplication = _c === void 0 ? true : _c, defaultOptions = options.defaultOptions;
        if (!link || !cache) {
            throw new Error("\n        In order to initialize Apollo Client, you must specify link & cache properties on the config object.\n        This is part of the required upgrade when migrating from Apollo Client 1.0 to Apollo Client 2.0.\n        For more information, please visit:\n          https://www.apollographql.com/docs/react/basics/setup.html\n        to help you get started.\n      ");
        }
        // remove apollo-client supported directives
        this.link = supportedDirectives.concat(link);
        this.cache = cache;
        this.store = new _data_store__WEBPACK_IMPORTED_MODULE_3__["DataStore"](cache);
        this.disableNetworkFetches = ssrMode || ssrForceFetchDelay > 0;
        this.queryDeduplication = queryDeduplication;
        this.ssrMode = ssrMode;
        this.defaultOptions = defaultOptions || {};
        if (ssrForceFetchDelay) {
            setTimeout(function () { return (_this.disableNetworkFetches = false); }, ssrForceFetchDelay);
        }
        this.watchQuery = this.watchQuery.bind(this);
        this.query = this.query.bind(this);
        this.mutate = this.mutate.bind(this);
        this.resetStore = this.resetStore.bind(this);
        this.reFetchObservableQueries = this.reFetchObservableQueries.bind(this);
        // Attach the client instance to window to let us be found by chrome devtools, but only in
        // development mode
        var defaultConnectToDevTools = !Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isProduction"])() &&
            typeof window !== 'undefined' &&
            !window.__APOLLO_CLIENT__;
        if (typeof connectToDevTools === 'undefined'
            ? defaultConnectToDevTools
            : connectToDevTools && typeof window !== 'undefined') {
            window.__APOLLO_CLIENT__ = this;
        }
        /**
         * Suggest installing the devtools for developers who don't have them
         */
        if (!hasSuggestedDevtools && !Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_1__["isProduction"])()) {
            hasSuggestedDevtools = true;
            if (typeof window !== 'undefined' &&
                window.document &&
                window.top === window.self) {
                // First check if devtools is not installed
                if (typeof window.__APOLLO_DEVTOOLS_GLOBAL_HOOK__ === 'undefined') {
                    // Only for Chrome
                    if (window.navigator &&
                        window.navigator.userAgent.indexOf('Chrome') > -1) {
                        // tslint:disable-next-line
                        console.debug('Download the Apollo DevTools ' +
                            'for a better development experience: ' +
                            'https://chrome.google.com/webstore/detail/apollo-client-developer-t/jdkknkkbebbapilgoeccciglkfbmbnfm');
                    }
                }
            }
        }
        this.version = _version__WEBPACK_IMPORTED_MODULE_4__["version"];
    }
    /**
     * This watches the results of the query according to the options specified and
     * returns an {@link ObservableQuery}. We can subscribe to this {@link ObservableQuery} and
     * receive updated results through a GraphQL observer.
     * <p /><p />
     * Note that this method is not an implementation of GraphQL subscriptions. Rather,
     * it uses Apollo's store in order to reactively deliver updates to your query results.
     * <p /><p />
     * For example, suppose you call watchQuery on a GraphQL query that fetches an person's
     * first name and last name and this person has a particular object identifer, provided by
     * dataIdFromObject. Later, a different query fetches that same person's
     * first and last name and his/her first name has now changed. Then, any observers associated
     * with the results of the first query will be updated with a new result object.
     * <p /><p />
     * See [here](https://medium.com/apollo-stack/the-concepts-of-graphql-bc68bd819be3#.3mb0cbcmc) for
     * a description of store reactivity.
     *
     */
    ApolloClient.prototype.watchQuery = function (options) {
        this.initQueryManager();
        if (this.defaultOptions.watchQuery) {
            options = __assign({}, this.defaultOptions.watchQuery, options);
        }
        // XXX Overwriting options is probably not the best way to do this long term...
        if (this.disableNetworkFetches &&
            (options.fetchPolicy === 'network-only' ||
                options.fetchPolicy === 'cache-and-network')) {
            options = __assign({}, options, { fetchPolicy: 'cache-first' });
        }
        return this.queryManager.watchQuery(options);
    };
    /**
     * This resolves a single query according to the options specified and
     * returns a {@link Promise} which is either resolved with the resulting data
     * or rejected with an error.
     *
     * @param options An object of type {@link QueryOptions} that allows us to
     * describe how this query should be treated e.g. whether it should hit the
     * server at all or just resolve from the cache, etc.
     */
    ApolloClient.prototype.query = function (options) {
        this.initQueryManager();
        if (this.defaultOptions.query) {
            options = __assign({}, this.defaultOptions.query, options);
        }
        if (options.fetchPolicy === 'cache-and-network') {
            throw new Error('cache-and-network fetchPolicy can only be used with watchQuery');
        }
        // XXX Overwriting options is probably not the best way to do this long
        // term...
        if (this.disableNetworkFetches && options.fetchPolicy === 'network-only') {
            options = __assign({}, options, { fetchPolicy: 'cache-first' });
        }
        return this.queryManager.query(options);
    };
    /**
     * This resolves a single mutation according to the options specified and returns a
     * {@link Promise} which is either resolved with the resulting data or rejected with an
     * error.
     *
     * It takes options as an object with the following keys and values:
     */
    ApolloClient.prototype.mutate = function (options) {
        this.initQueryManager();
        if (this.defaultOptions.mutate) {
            options = __assign({}, this.defaultOptions.mutate, options);
        }
        return this.queryManager.mutate(options);
    };
    /**
     * This subscribes to a graphql subscription according to the options specified and returns an
     * {@link Observable} which either emits received data or an error.
     */
    ApolloClient.prototype.subscribe = function (options) {
        this.initQueryManager();
        return this.queryManager.startGraphQLSubscription(options);
    };
    /**
     * Tries to read some data from the store in the shape of the provided
     * GraphQL query without making a network request. This method will start at
     * the root query. To start at a specific id returned by `dataIdFromObject`
     * use `readFragment`.
     */
    ApolloClient.prototype.readQuery = function (options) {
        return this.initProxy().readQuery(options);
    };
    /**
     * Tries to read some data from the store in the shape of the provided
     * GraphQL fragment without making a network request. This method will read a
     * GraphQL fragment from any arbitrary id that is currently cached, unlike
     * `readQuery` which will only read from the root query.
     *
     * You must pass in a GraphQL document with a single fragment or a document
     * with multiple fragments that represent what you are reading. If you pass
     * in a document with multiple fragments then you must also specify a
     * `fragmentName`.
     */
    ApolloClient.prototype.readFragment = function (options) {
        return this.initProxy().readFragment(options);
    };
    /**
     * Writes some data in the shape of the provided GraphQL query directly to
     * the store. This method will start at the root query. To start at a a
     * specific id returned by `dataIdFromObject` then use `writeFragment`.
     */
    ApolloClient.prototype.writeQuery = function (options) {
        var result = this.initProxy().writeQuery(options);
        this.queryManager.broadcastQueries();
        return result;
    };
    /**
     * Writes some data in the shape of the provided GraphQL fragment directly to
     * the store. This method will write to a GraphQL fragment from any arbitrary
     * id that is currently cached, unlike `writeQuery` which will only write
     * from the root query.
     *
     * You must pass in a GraphQL document with a single fragment or a document
     * with multiple fragments that represent what you are writing. If you pass
     * in a document with multiple fragments then you must also specify a
     * `fragmentName`.
     */
    ApolloClient.prototype.writeFragment = function (options) {
        var result = this.initProxy().writeFragment(options);
        this.queryManager.broadcastQueries();
        return result;
    };
    /**
     * Sugar for writeQuery & writeFragment
     * This method will construct a query from the data object passed in.
     * If no id is supplied, writeData will write the data to the root.
     * If an id is supplied, writeData will write a fragment to the object
     * specified by the id in the store.
     *
     * Since you aren't passing in a query to check the shape of the data,
     * you must pass in an object that conforms to the shape of valid GraphQL data.
     */
    ApolloClient.prototype.writeData = function (options) {
        var result = this.initProxy().writeData(options);
        this.queryManager.broadcastQueries();
        return result;
    };
    ApolloClient.prototype.__actionHookForDevTools = function (cb) {
        this.devToolsHookCb = cb;
    };
    ApolloClient.prototype.__requestRaw = function (payload) {
        return Object(apollo_link__WEBPACK_IMPORTED_MODULE_0__["execute"])(this.link, payload);
    };
    /**
     * This initializes the query manager that tracks queries and the cache
     */
    ApolloClient.prototype.initQueryManager = function () {
        var _this = this;
        if (this.queryManager)
            return;
        this.queryManager = new _core_QueryManager__WEBPACK_IMPORTED_MODULE_2__["QueryManager"]({
            link: this.link,
            store: this.store,
            queryDeduplication: this.queryDeduplication,
            ssrMode: this.ssrMode,
            onBroadcast: function () {
                if (_this.devToolsHookCb) {
                    _this.devToolsHookCb({
                        action: {},
                        state: {
                            queries: _this.queryManager.queryStore.getStore(),
                            mutations: _this.queryManager.mutationStore.getStore(),
                        },
                        dataWithOptimisticResults: _this.cache.extract(true),
                    });
                }
            },
        });
    };
    /**
     * Resets your entire store by clearing out your cache and then re-executing
     * all of your active queries. This makes it so that you may guarantee that
     * there is no data left in your store from a time before you called this
     * method.
     *
     * `resetStore()` is useful when your user just logged out. You’ve removed the
     * user session, and you now want to make sure that any references to data you
     * might have fetched while the user session was active is gone.
     *
     * It is important to remember that `resetStore()` *will* refetch any active
     * queries. This means that any components that might be mounted will execute
     * their queries again using your network interface. If you do not want to
     * re-execute any queries then you should make sure to stop watching any
     * active queries.
     */
    ApolloClient.prototype.resetStore = function () {
        var _this = this;
        return Promise.resolve()
            .then(function () {
            return _this.queryManager
                ? _this.queryManager.clearStore()
                : Promise.resolve(null);
        })
            .then(function () { return Promise.all(_this.resetStoreCallbacks.map(function (fn) { return fn(); })); })
            .then(function () {
            return _this.queryManager && _this.queryManager.reFetchObservableQueries
                ? _this.queryManager.reFetchObservableQueries()
                : Promise.resolve(null);
        });
    };
    /**
     * Allows callbacks to be registered that are executed with the store is reset.
     * onResetStore returns an unsubscribe function for removing your registered callbacks.
     */
    ApolloClient.prototype.onResetStore = function (cb) {
        var _this = this;
        this.resetStoreCallbacks.push(cb);
        return function () {
            _this.resetStoreCallbacks = _this.resetStoreCallbacks.filter(function (c) { return c !== cb; });
        };
    };
    /**
     * Refetches all of your active queries.
     *
     * `reFetchObservableQueries()` is useful if you want to bring the client back to proper state in case of a network outage
     *
     * It is important to remember that `reFetchObservableQueries()` *will* refetch any active
     * queries. This means that any components that might be mounted will execute
     * their queries again using your network interface. If you do not want to
     * re-execute any queries then you should make sure to stop watching any
     * active queries.
     * Takes optional parameter `includeStandby` which will include queries in standby-mode when refetching.
     */
    ApolloClient.prototype.reFetchObservableQueries = function (includeStandby) {
        return this.queryManager
            ? this.queryManager.reFetchObservableQueries(includeStandby)
            : Promise.resolve(null);
    };
    /**
     * Exposes the cache's complete state, in a serializable format for later restoration.
     */
    ApolloClient.prototype.extract = function (optimistic) {
        return this.initProxy().extract(optimistic);
    };
    /**
     * Replaces existing state in the cache (if any) with the values expressed by
     * `serializedState`.
     *
     * Called when hydrating a cache (server side rendering, or offline storage),
     * and also (potentially) during hot reloads.
     */
    ApolloClient.prototype.restore = function (serializedState) {
        return this.initProxy().restore(serializedState);
    };
    /**
     * Initializes a data proxy for this client instance if one does not already
     * exist and returns either a previously initialized proxy instance or the
     * newly initialized instance.
     */
    ApolloClient.prototype.initProxy = function () {
        if (!this.proxy) {
            this.initQueryManager();
            this.proxy = this.cache;
        }
        return this.proxy;
    };
    return ApolloClient;
}());
/* harmony default export */ __webpack_exports__["default"] = (ApolloClient);


/***/ }),
/* 187 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DedupLink", function() { return DedupLink; });
/* harmony import */ var apollo_link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

/*
 * Expects context to contain the forceFetch field if no dedup
 */
var DedupLink = /** @class */ (function (_super) {
    __extends(DedupLink, _super);
    function DedupLink() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.inFlightRequestObservables = new Map();
        _this.subscribers = new Map();
        return _this;
    }
    DedupLink.prototype.request = function (operation, forward) {
        var _this = this;
        // sometimes we might not want to deduplicate a request, for example when we want to force fetch it.
        if (operation.getContext().forceFetch) {
            return forward(operation);
        }
        var key = operation.toKey();
        var cleanup = function (key) {
            _this.inFlightRequestObservables.delete(key);
            var prev = _this.subscribers.get(key);
            return prev;
        };
        if (!this.inFlightRequestObservables.get(key)) {
            // this is a new request, i.e. we haven't deduplicated it yet
            // call the next link
            var singleObserver_1 = forward(operation);
            var subscription_1;
            var sharedObserver = new apollo_link__WEBPACK_IMPORTED_MODULE_0__["Observable"](function (observer) {
                // this will still be called by each subscriber regardless of
                // deduplication status
                var prev = _this.subscribers.get(key);
                if (!prev)
                    prev = { next: [], error: [], complete: [] };
                _this.subscribers.set(key, {
                    next: prev.next.concat([observer.next.bind(observer)]),
                    error: prev.error.concat([observer.error.bind(observer)]),
                    complete: prev.complete.concat([observer.complete.bind(observer)]),
                });
                if (!subscription_1) {
                    subscription_1 = singleObserver_1.subscribe({
                        next: function (result) {
                            var prev = cleanup(key);
                            _this.subscribers.delete(key);
                            if (prev) {
                                prev.next.forEach(function (next) { return next(result); });
                                prev.complete.forEach(function (complete) { return complete(); });
                            }
                        },
                        error: function (error) {
                            var prev = cleanup(key);
                            _this.subscribers.delete(key);
                            if (prev)
                                prev.error.forEach(function (err) { return err(error); });
                        },
                    });
                }
                return function () {
                    if (subscription_1)
                        subscription_1.unsubscribe();
                    _this.inFlightRequestObservables.delete(key);
                };
            });
            this.inFlightRequestObservables.set(key, sharedObserver);
        }
        // return shared Observable
        return this.inFlightRequestObservables.get(key);
    };
    return DedupLink;
}(apollo_link__WEBPACK_IMPORTED_MODULE_0__["ApolloLink"]));



/***/ }),
/* 188 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BatchHttpLink", function() { return BatchHttpLink; });
/* harmony import */ var apollo_link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27);
/* harmony import */ var apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(381);
/* harmony import */ var apollo_link_batch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(382);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};



/**
 * Transforms Operation for into HTTP results.
 * context can include the headers property, which will be passed to the fetch function
 */
var BatchHttpLink = /** @class */ (function (_super) {
    __extends(BatchHttpLink, _super);
    function BatchHttpLink(fetchParams) {
        if (fetchParams === void 0) { fetchParams = {}; }
        var _this = _super.call(this) || this;
        var _a = fetchParams.uri, uri = _a === void 0 ? '/graphql' : _a, 
        // use default global fetch is nothing passed in
        fetcher = fetchParams.fetch, includeExtensions = fetchParams.includeExtensions, batchInterval = fetchParams.batchInterval, batchMax = fetchParams.batchMax, batchKey = fetchParams.batchKey, requestOptions = __rest(fetchParams, ["uri", "fetch", "includeExtensions", "batchInterval", "batchMax", "batchKey"]);
        // dev warnings to ensure fetch is present
        Object(apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["checkFetcher"])(fetcher);
        //fetcher is set here rather than the destructuring to ensure fetch is
        //declared before referencing it. Reference in the destructuring would cause
        //a ReferenceError
        if (!fetcher) {
            fetcher = fetch;
        }
        var linkConfig = {
            http: { includeExtensions: includeExtensions },
            options: requestOptions.fetchOptions,
            credentials: requestOptions.credentials,
            headers: requestOptions.headers,
        };
        _this.batchInterval = batchInterval || 10;
        _this.batchMax = batchMax || 10;
        var batchHandler = function (operations) {
            var chosenURI = Object(apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["selectURI"])(operations[0], uri);
            var context = operations[0].getContext();
            var contextConfig = {
                http: context.http,
                options: context.fetchOptions,
                credentials: context.credentials,
                headers: context.headers,
            };
            //uses fallback, link, and then context to build options
            var optsAndBody = operations.map(function (operation) {
                return Object(apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["selectHttpOptionsAndBody"])(operation, apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["fallbackHttpConfig"], linkConfig, contextConfig);
            });
            var body = optsAndBody.map(function (_a) {
                var body = _a.body;
                return body;
            });
            var options = optsAndBody[0].options;
            // There's no spec for using GET with batches.
            if (options.method === 'GET') {
                return Object(apollo_link__WEBPACK_IMPORTED_MODULE_0__["fromError"])(new Error('apollo-link-batch-http does not support GET requests'));
            }
            try {
                options.body = Object(apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["serializeFetchParameter"])(body, 'Payload');
            }
            catch (parseError) {
                return Object(apollo_link__WEBPACK_IMPORTED_MODULE_0__["fromError"])(parseError);
            }
            var controller;
            if (!options.signal) {
                var _a = Object(apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["createSignalIfSupported"])(), _controller = _a.controller, signal = _a.signal;
                controller = _controller;
                if (controller)
                    options.signal = signal;
            }
            return new apollo_link__WEBPACK_IMPORTED_MODULE_0__["Observable"](function (observer) {
                // the raw response is attached to the context in the BatchingLink
                fetcher(chosenURI, options)
                    .then(Object(apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["parseAndCheckHttpResponse"])(operations))
                    .then(function (result) {
                    // we have data and can send it to back up the link chain
                    observer.next(result);
                    observer.complete();
                    return result;
                })
                    .catch(function (err) {
                    // fetch was cancelled so its already been cleaned up in the unsubscribe
                    if (err.name === 'AbortError')
                        return;
                    // if it is a network error, BUT there is graphql result info
                    // fire the next observer before calling error
                    // this gives apollo-client (and react-apollo) the `graphqlErrors` and `networErrors`
                    // to pass to UI
                    // this should only happen if we *also* have data as part of the response key per
                    // the spec
                    if (err.result && err.result.errors && err.result.data) {
                        // if we dont' call next, the UI can only show networkError because AC didn't
                        // get andy graphqlErrors
                        // this is graphql execution result info (i.e errors and possibly data)
                        // this is because there is no formal spec how errors should translate to
                        // http status codes. So an auth error (401) could have both data
                        // from a public field, errors from a private field, and a status of 401
                        // {
                        //  user { // this will have errors
                        //    firstName
                        //  }
                        //  products { // this is public so will have data
                        //    cost
                        //  }
                        // }
                        //
                        // the result of above *could* look like this:
                        // {
                        //   data: { products: [{ cost: "$10" }] },
                        //   errors: [{
                        //      message: 'your session has timed out',
                        //      path: []
                        //   }]
                        // }
                        // status code of above would be a 401
                        // in the UI you want to show data where you can, errors as data where you can
                        // and use correct http status codes
                        observer.next(err.result);
                    }
                    observer.error(err);
                });
                return function () {
                    // XXX support canceling this request
                    // https://developers.google.com/web/updates/2017/09/abortable-fetch
                    if (controller)
                        controller.abort();
                };
            });
        };
        batchKey =
            batchKey ||
                (function (operation) {
                    var context = operation.getContext();
                    var contextConfig = {
                        http: context.http,
                        options: context.fetchOptions,
                        credentials: context.credentials,
                        headers: context.headers,
                    };
                    //may throw error if config not serializable
                    return Object(apollo_link_http_common__WEBPACK_IMPORTED_MODULE_1__["selectURI"])(operation, uri) + JSON.stringify(contextConfig);
                });
        _this.batcher = new apollo_link_batch__WEBPACK_IMPORTED_MODULE_2__["BatchLink"]({
            batchInterval: _this.batchInterval,
            batchMax: _this.batchMax,
            batchKey: batchKey,
            batchHandler: batchHandler,
        });
        return _this;
    }
    BatchHttpLink.prototype.request = function (operation) {
        return this.batcher.request(operation);
    };
    return BatchHttpLink;
}(apollo_link__WEBPACK_IMPORTED_MODULE_0__["ApolloLink"]));



/***/ }),
/* 189 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BatchLink", function() { return BatchLink; });
/* harmony import */ var apollo_link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27);
/* harmony import */ var _batching__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(125);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OperationBatcher", function() { return _batching__WEBPACK_IMPORTED_MODULE_1__["OperationBatcher"]; });

var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var BatchLink = /** @class */ (function (_super) {
    __extends(BatchLink, _super);
    function BatchLink(fetchParams) {
        if (fetchParams === void 0) { fetchParams = {}; }
        var _this = _super.call(this) || this;
        var _a = fetchParams.batchInterval, batchInterval = _a === void 0 ? 10 : _a, _b = fetchParams.batchMax, batchMax = _b === void 0 ? 0 : _b, _c = fetchParams.batchHandler, batchHandler = _c === void 0 ? function () { return null; } : _c, _d = fetchParams.batchKey, batchKey = _d === void 0 ? function () { return ''; } : _d;
        _this.batcher = new _batching__WEBPACK_IMPORTED_MODULE_1__["OperationBatcher"]({
            batchInterval: batchInterval,
            batchMax: batchMax,
            batchHandler: batchHandler,
            batchKey: batchKey,
        });
        //make this link terminating
        if (fetchParams.batchHandler.length <= 1) {
            _this.request = function (operation) { return _this.batcher.enqueueRequest({ operation: operation }); };
        }
        return _this;
    }
    BatchLink.prototype.request = function (operation, forward) {
        return this.batcher.enqueueRequest({
            operation: operation,
            forward: forward,
        });
    };
    return BatchLink;
}(apollo_link__WEBPACK_IMPORTED_MODULE_0__["ApolloLink"]));



/***/ }),
/* 190 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ApolloCache", function() { return ApolloCache; });
/* harmony import */ var apollo_utilities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(386);


var ApolloCache = (function () {
    function ApolloCache() {
    }
    ApolloCache.prototype.transformDocument = function (document) {
        return document;
    };
    ApolloCache.prototype.transformForLink = function (document) {
        return document;
    };
    ApolloCache.prototype.readQuery = function (options, optimistic) {
        if (optimistic === void 0) { optimistic = false; }
        return this.read({
            query: options.query,
            variables: options.variables,
            optimistic: optimistic,
        });
    };
    ApolloCache.prototype.readFragment = function (options, optimistic) {
        if (optimistic === void 0) { optimistic = false; }
        return this.read({
            query: Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getFragmentQueryDocument"])(options.fragment, options.fragmentName),
            variables: options.variables,
            rootId: options.id,
            optimistic: optimistic,
        });
    };
    ApolloCache.prototype.writeQuery = function (options) {
        this.write({
            dataId: 'ROOT_QUERY',
            result: options.data,
            query: options.query,
            variables: options.variables,
        });
    };
    ApolloCache.prototype.writeFragment = function (options) {
        this.write({
            dataId: options.id,
            result: options.data,
            variables: options.variables,
            query: Object(apollo_utilities__WEBPACK_IMPORTED_MODULE_0__["getFragmentQueryDocument"])(options.fragment, options.fragmentName),
        });
    };
    ApolloCache.prototype.writeData = function (_a) {
        var id = _a.id, data = _a.data;
        if (typeof id !== 'undefined') {
            var typenameResult = null;
            try {
                typenameResult = this.read({
                    rootId: id,
                    optimistic: false,
                    query: _utils__WEBPACK_IMPORTED_MODULE_1__["justTypenameQuery"],
                });
            }
            catch (e) {
            }
            var __typename = (typenameResult && typenameResult.__typename) || '__ClientData';
            var dataToWrite = Object.assign({ __typename: __typename }, data);
            this.writeFragment({
                id: id,
                fragment: Object(_utils__WEBPACK_IMPORTED_MODULE_1__["fragmentFromPojo"])(dataToWrite, __typename),
                data: dataToWrite,
            });
        }
        else {
            this.writeQuery({ query: Object(_utils__WEBPACK_IMPORTED_MODULE_1__["queryFromPojo"])(data), data: data });
        }
    };
    return ApolloCache;
}());



/***/ }),
/* 191 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveInfoFromField", function() { return getDirectiveInfoFromField; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shouldInclude", function() { return shouldInclude; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "flattenSelections", function() { return flattenSelections; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectiveNames", function() { return getDirectiveNames; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasDirectives", function() { return hasDirectives; });
/* harmony import */ var _storeUtils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(88);

function getDirectiveInfoFromField(field, variables) {
    if (field.directives && field.directives.length) {
        var directiveObj_1 = {};
        field.directives.forEach(function (directive) {
            directiveObj_1[directive.name.value] = Object(_storeUtils__WEBPACK_IMPORTED_MODULE_0__["argumentsObjectFromField"])(directive, variables);
        });
        return directiveObj_1;
    }
    return null;
}
function shouldInclude(selection, variables) {
    if (variables === void 0) { variables = {}; }
    if (!selection.directives) {
        return true;
    }
    var res = true;
    selection.directives.forEach(function (directive) {
        if (directive.name.value !== 'skip' && directive.name.value !== 'include') {
            return;
        }
        var directiveArguments = directive.arguments || [];
        var directiveName = directive.name.value;
        if (directiveArguments.length !== 1) {
            throw new Error("Incorrect number of arguments for the @" + directiveName + " directive.");
        }
        var ifArgument = directiveArguments[0];
        if (!ifArgument.name || ifArgument.name.value !== 'if') {
            throw new Error("Invalid argument for the @" + directiveName + " directive.");
        }
        var ifValue = directiveArguments[0].value;
        var evaledValue = false;
        if (!ifValue || ifValue.kind !== 'BooleanValue') {
            if (ifValue.kind !== 'Variable') {
                throw new Error("Argument for the @" + directiveName + " directive must be a variable or a boolean value.");
            }
            else {
                evaledValue = variables[ifValue.name.value];
                if (evaledValue === undefined) {
                    throw new Error("Invalid variable referenced in @" + directiveName + " directive.");
                }
            }
        }
        else {
            evaledValue = ifValue.value;
        }
        if (directiveName === 'skip') {
            evaledValue = !evaledValue;
        }
        if (!evaledValue) {
            res = false;
        }
    });
    return res;
}
function flattenSelections(selection) {
    if (!selection.selectionSet ||
        !(selection.selectionSet.selections.length > 0))
        return [selection];
    return [selection].concat(selection.selectionSet.selections
        .map(function (selectionNode) {
        return [selectionNode].concat(flattenSelections(selectionNode));
    })
        .reduce(function (selections, selected) { return selections.concat(selected); }, []));
}
function getDirectiveNames(doc) {
    var directiveNames = doc.definitions
        .filter(function (definition) {
        return definition.selectionSet && definition.selectionSet.selections;
    })
        .map(function (x) { return flattenSelections(x); })
        .reduce(function (selections, selected) { return selections.concat(selected); }, [])
        .filter(function (selection) {
        return selection.directives && selection.directives.length > 0;
    })
        .map(function (selection) { return selection.directives; })
        .reduce(function (directives, directive) { return directives.concat(directive); }, [])
        .map(function (directive) { return directive.name.value; });
    return directiveNames;
}
function hasDirectives(names, doc) {
    return getDirectiveNames(doc).some(function (name) { return names.indexOf(name) > -1; });
}


/***/ }),
/* 192 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFragmentQueryDocument", function() { return getFragmentQueryDocument; });
var __assign = (undefined && undefined.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
function getFragmentQueryDocument(document, fragmentName) {
    var actualFragmentName = fragmentName;
    var fragments = [];
    document.definitions.forEach(function (definition) {
        if (definition.kind === 'OperationDefinition') {
            throw new Error("Found a " + definition.operation + " operation" + (definition.name ? " named '" + definition.name.value + "'" : '') + ". " +
                'No operations are allowed when using a fragment as a query. Only fragments are allowed.');
        }
        if (definition.kind === 'FragmentDefinition') {
            fragments.push(definition);
        }
    });
    if (typeof actualFragmentName === 'undefined') {
        if (fragments.length !== 1) {
            throw new Error("Found " + fragments.length + " fragments. `fragmentName` must be provided when there is not exactly 1 fragment.");
        }
        actualFragmentName = fragments[0].name.value;
    }
    var query = __assign({}, document, { definitions: [
            {
                kind: 'OperationDefinition',
                operation: 'query',
                selectionSet: {
                    kind: 'SelectionSet',
                    selections: [
                        {
                            kind: 'FragmentSpread',
                            name: {
                                kind: 'Name',
                                value: actualFragmentName,
                            },
                        },
                    ],
                },
            }
        ].concat(document.definitions) });
    return query;
}


/***/ }),
/* 193 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeDirectivesFromDocument", function() { return removeDirectivesFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addTypenameToDocument", function() { return addTypenameToDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeConnectionDirectiveFromDocument", function() { return removeConnectionDirectiveFromDocument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getDirectivesFromDocument", function() { return getDirectivesFromDocument; });
/* harmony import */ var _util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(129);
/* harmony import */ var _getFromAST__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(127);


var TYPENAME_FIELD = {
    kind: 'Field',
    name: {
        kind: 'Name',
        value: '__typename',
    },
};
function isNotEmpty(op, fragments) {
    return (op.selectionSet.selections.filter(function (selectionSet) {
        return !(selectionSet &&
            selectionSet.kind === 'FragmentSpread' &&
            !isNotEmpty(fragments[selectionSet.name.value], fragments));
    }).length > 0);
}
function getDirectiveMatcher(directives) {
    return function directiveMatcher(directive) {
        return directives.some(function (dir) {
            if (dir.name && dir.name === directive.name.value)
                return true;
            if (dir.test && dir.test(directive))
                return true;
            return false;
        });
    };
}
function addTypenameToSelectionSet(selectionSet, isRoot) {
    if (isRoot === void 0) { isRoot = false; }
    if (selectionSet.selections) {
        if (!isRoot) {
            var alreadyHasThisField = selectionSet.selections.some(function (selection) {
                return (selection.kind === 'Field' &&
                    selection.name.value === '__typename');
            });
            if (!alreadyHasThisField) {
                selectionSet.selections.push(TYPENAME_FIELD);
            }
        }
        selectionSet.selections.forEach(function (selection) {
            if (selection.kind === 'Field') {
                if (selection.name.value.lastIndexOf('__', 0) !== 0 &&
                    selection.selectionSet) {
                    addTypenameToSelectionSet(selection.selectionSet);
                }
            }
            else if (selection.kind === 'InlineFragment') {
                if (selection.selectionSet) {
                    addTypenameToSelectionSet(selection.selectionSet);
                }
            }
        });
    }
}
function removeDirectivesFromSelectionSet(directives, selectionSet) {
    if (!selectionSet.selections)
        return selectionSet;
    var agressiveRemove = directives.some(function (dir) { return dir.remove; });
    selectionSet.selections = selectionSet.selections
        .map(function (selection) {
        if (selection.kind !== 'Field' ||
            !selection ||
            !selection.directives)
            return selection;
        var directiveMatcher = getDirectiveMatcher(directives);
        var remove;
        selection.directives = selection.directives.filter(function (directive) {
            var shouldKeep = !directiveMatcher(directive);
            if (!remove && !shouldKeep && agressiveRemove)
                remove = true;
            return shouldKeep;
        });
        return remove ? null : selection;
    })
        .filter(function (x) { return !!x; });
    selectionSet.selections.forEach(function (selection) {
        if ((selection.kind === 'Field' || selection.kind === 'InlineFragment') &&
            selection.selectionSet) {
            removeDirectivesFromSelectionSet(directives, selection.selectionSet);
        }
    });
    return selectionSet;
}
function removeDirectivesFromDocument(directives, doc) {
    var docClone = Object(_util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__["cloneDeep"])(doc);
    docClone.definitions.forEach(function (definition) {
        removeDirectivesFromSelectionSet(directives, definition.selectionSet);
    });
    var operation = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getOperationDefinitionOrDie"])(docClone);
    var fragments = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["createFragmentMap"])(Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getFragmentDefinitions"])(docClone));
    return isNotEmpty(operation, fragments) ? docClone : null;
}
function addTypenameToDocument(doc) {
    Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["checkDocument"])(doc);
    var docClone = Object(_util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__["cloneDeep"])(doc);
    docClone.definitions.forEach(function (definition) {
        var isRoot = definition.kind === 'OperationDefinition';
        addTypenameToSelectionSet(definition.selectionSet, isRoot);
    });
    return docClone;
}
var connectionRemoveConfig = {
    test: function (directive) {
        var willRemove = directive.name.value === 'connection';
        if (willRemove) {
            if (!directive.arguments ||
                !directive.arguments.some(function (arg) { return arg.name.value === 'key'; })) {
                console.warn('Removing an @connection directive even though it does not have a key. ' +
                    'You may want to use the key parameter to specify a store key.');
            }
        }
        return willRemove;
    },
};
function removeConnectionDirectiveFromDocument(doc) {
    Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["checkDocument"])(doc);
    return removeDirectivesFromDocument([connectionRemoveConfig], doc);
}
function hasDirectivesInSelectionSet(directives, selectionSet, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    if (!(selectionSet && selectionSet.selections)) {
        return false;
    }
    var matchedSelections = selectionSet.selections.filter(function (selection) {
        return hasDirectivesInSelection(directives, selection, nestedCheck);
    });
    return matchedSelections.length > 0;
}
function hasDirectivesInSelection(directives, selection, nestedCheck) {
    if (nestedCheck === void 0) { nestedCheck = true; }
    if (selection.kind !== 'Field' || !selection) {
        return true;
    }
    if (!selection.directives) {
        return false;
    }
    var directiveMatcher = getDirectiveMatcher(directives);
    var matchedDirectives = selection.directives.filter(directiveMatcher);
    return (matchedDirectives.length > 0 ||
        (nestedCheck &&
            hasDirectivesInSelectionSet(directives, selection.selectionSet, nestedCheck)));
}
function getDirectivesFromSelectionSet(directives, selectionSet) {
    selectionSet.selections = selectionSet.selections
        .filter(function (selection) {
        return hasDirectivesInSelection(directives, selection, true);
    })
        .map(function (selection) {
        if (hasDirectivesInSelection(directives, selection, false)) {
            return selection;
        }
        if ((selection.kind === 'Field' || selection.kind === 'InlineFragment') &&
            selection.selectionSet) {
            selection.selectionSet = getDirectivesFromSelectionSet(directives, selection.selectionSet);
        }
        return selection;
    });
    return selectionSet;
}
function getDirectivesFromDocument(directives, doc, includeAllFragments) {
    if (includeAllFragments === void 0) { includeAllFragments = false; }
    Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["checkDocument"])(doc);
    var docClone = Object(_util_cloneDeep__WEBPACK_IMPORTED_MODULE_0__["cloneDeep"])(doc);
    docClone.definitions = docClone.definitions.map(function (definition) {
        if ((definition.kind === 'OperationDefinition' ||
            (definition.kind === 'FragmentDefinition' && !includeAllFragments)) &&
            definition.selectionSet) {
            definition.selectionSet = getDirectivesFromSelectionSet(directives, definition.selectionSet);
        }
        return definition;
    });
    var operation = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getOperationDefinitionOrDie"])(docClone);
    var fragments = Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["createFragmentMap"])(Object(_getFromAST__WEBPACK_IMPORTED_MODULE_1__["getFragmentDefinitions"])(docClone));
    return isNotEmpty(operation, fragments) ? docClone : null;
}


/***/ }),
/* 194 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tryFunctionOrLogError", function() { return tryFunctionOrLogError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "graphQLResultHasError", function() { return graphQLResultHasError; });
function tryFunctionOrLogError(f) {
    try {
        return f();
    }
    catch (e) {
        if (console.error) {
            console.error(e);
        }
    }
}
function graphQLResultHasError(result) {
    return result.errors && result.errors.length;
}


/***/ }),
/* 195 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isEqual", function() { return isEqual; });
function isEqual(a, b) {
    if (a === b) {
        return true;
    }
    if (a instanceof Date && b instanceof Date) {
        return a.getTime() === b.getTime();
    }
    if (a != null &&
        typeof a === 'object' &&
        b != null &&
        typeof b === 'object') {
        for (var key in a) {
            if (Object.prototype.hasOwnProperty.call(a, key)) {
                if (!Object.prototype.hasOwnProperty.call(b, key)) {
                    return false;
                }
                if (!isEqual(a[key], b[key])) {
                    return false;
                }
            }
        }
        for (var key in b) {
            if (Object.prototype.hasOwnProperty.call(b, key) &&
                !Object.prototype.hasOwnProperty.call(a, key)) {
                return false;
            }
        }
        return true;
    }
    return false;
}


/***/ }),
/* 196 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "maybeDeepFreeze", function() { return maybeDeepFreeze; });
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(89);

function deepFreeze(o) {
    Object.freeze(o);
    Object.getOwnPropertyNames(o).forEach(function (prop) {
        if (o[prop] !== null &&
            (typeof o[prop] === 'object' || typeof o[prop] === 'function') &&
            !Object.isFrozen(o[prop])) {
            deepFreeze(o[prop]);
        }
    });
    return o;
}
function maybeDeepFreeze(obj) {
    if (Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isDevelopment"])() || Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isTest"])()) {
        var symbolIsPolyfilled = typeof Symbol === 'function' && typeof Symbol('') === 'string';
        if (!symbolIsPolyfilled) {
            return deepFreeze(obj);
        }
    }
    return obj;
}


/***/ }),
/* 197 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "warnOnceInDevelopment", function() { return warnOnceInDevelopment; });
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(89);

var haveWarned = Object.create({});
function warnOnceInDevelopment(msg, type) {
    if (type === void 0) { type = 'warn'; }
    if (Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isProduction"])()) {
        return;
    }
    if (!haveWarned[msg]) {
        if (!Object(_environment__WEBPACK_IMPORTED_MODULE_0__["isTest"])()) {
            haveWarned[msg] = true;
        }
        switch (type) {
            case 'error':
                console.error(msg);
                break;
            default:
                console.warn(msg);
        }
    }
}


/***/ }),
/* 198 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stripSymbols", function() { return stripSymbols; });
function stripSymbols(data) {
    return JSON.parse(JSON.stringify(data));
}


/***/ }),
/* 199 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(200);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Cache", function() { return _Cache__WEBPACK_IMPORTED_MODULE_0__["Cache"]; });




/***/ }),
/* 200 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Cache", function() { return Cache; });
var Cache;
(function (Cache) {
})(Cache || (Cache = {}));


/***/ }),
/* 201 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(module) {

var fakeNullFiber = new (function Fiber(){});
var localKey = "_optimism_local";

function getCurrentFiber() {
  return fakeNullFiber;
}

if (true) {
  try {
    var Fiber = module["eriuqer".split("").reverse().join("")]("fibers");
    // If we were able to require fibers, redefine the getCurrentFiber
    // function so that it has a chance to return Fiber.current.
    getCurrentFiber = function () {
      return Fiber.current || fakeNullFiber;
    };
  } catch (e) {}
}

// Returns an object unique to Fiber.current, if fibers are enabled.
// This object is used for Fiber-local storage in ./entry.js.
exports.get = function () {
  var fiber = getCurrentFiber();
  return fiber[localKey] || (fiber[localKey] = Object.create(null));
};

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(60)(module)))

/***/ }),
/* 202 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRetryLink = exports.waitForInFlightQueries = void 0;

var _apolloClient = _interopRequireDefault(__webpack_require__(80));

var _apolloLinkRetry = __webpack_require__(396);

var waitForInFlightQueries = function waitForInFlightQueries(apolloClient) {
  if (!apolloClient || !apolloClient.queryManager) {
    return Promise.resolve(null);
  }

  var queries = apolloClient.queryManager.queries;
  var promises = Array.from(queries.values()).reduce(function (memo, _ref) {
    var observableQuery = _ref.observableQuery;
    var loading = observableQuery && observableQuery.currentResult().loading || false;
    return loading ? memo.concat(observableQuery.result()) : memo;
  }, []);
  return Promise.all(promises).then(function () {
    return null;
  });
};

exports.waitForInFlightQueries = waitForInFlightQueries;

var createRetryLink = function createRetryLink(maxAttempts) {
  return new _apolloLinkRetry.RetryLink({
    attempts: function attempts(count, operation, error) {
      if (count >= maxAttempts) {
        return false;
      } // if the request fails, let's try it again because it was probably
      // a temporary issue.


      if (error && error.statusCode >= 500) {
        return true;
      } // if CORS fails, it means we used a stale token so we can try it again
      // with the correct one


      if (error && error.result && error.result.code === 'BadCrossOriginRequest') {
        return true;
      }

      return false;
    },
    delay: function delay(count) {
      // delay in ms
      return count * 500 + Math.random() * 500;
    }
  });
};

exports.createRetryLink = createRetryLink;

/***/ }),
/* 203 */
/***/ (function(module, exports) {

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

module.exports = _iterableToArray;

/***/ }),
/* 204 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault2 = __webpack_require__(0);

var _classCallCheck2 = _interopRequireDefault2(__webpack_require__(28));

var _createClass2 = _interopRequireDefault2(__webpack_require__(141));

var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(__webpack_require__(8));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(44));

var _merge = _interopRequireDefault(__webpack_require__(401));

var _tinycolor = _interopRequireDefault(__webpack_require__(448));

var _breakpointsConfig = __webpack_require__(449);

var _breakpointIds = __webpack_require__(223);

var STYLE_MAP_ATTR = 'data-wf-style-map';
/**
 * In order of application, where each query values
 * overrides the media queries above it.
 */

var orderedBreakpointIds = [_breakpointIds.BREAKPOINT_ID_MAIN, _breakpointIds.BREAKPOINT_ID_LARGE, _breakpointIds.BREAKPOINT_ID_XL, _breakpointIds.BREAKPOINT_ID_XXL, _breakpointIds.BREAKPOINT_ID_MEDIUM, _breakpointIds.BREAKPOINT_ID_SMALL, _breakpointIds.BREAKPOINT_ID_TINY];
var ORDERED_MEDIA_QUERIES = orderedBreakpointIds.map(function (breakpointId) {
  var config = _breakpointsConfig.LARGER_BREAKPOINTS_CONFIG[breakpointId];
  var prop;
  var value;

  if ('minWidth' in config) {
    prop = 'min-width';
    value = config.minWidth;
  }

  if ('maxWidth' in config) {
    prop = 'max-width';
    value = config.maxWidth;
  }

  if (prop === undefined || value === undefined) {
    throw new Error('Bad breakpoint config, expected either "minWidth" or "maxWidth".');
  }

  return {
    name: breakpointId,
    query: "(".concat(prop, ": ").concat(value, "px)")
  };
});

var StyleMapObserver =
/*#__PURE__*/
function () {
  function StyleMapObserver(element, options) {
    var _this = this;

    (0, _classCallCheck2["default"])(this, StyleMapObserver);
    (0, _defineProperty2["default"])(this, "styles", undefined);
    (0, _defineProperty2["default"])(this, "observer", undefined);
    (0, _defineProperty2["default"])(this, "mediaQueries", []);
    (0, _defineProperty2["default"])(this, "options", {
      onChange: function onChange() {}
    });
    (0, _defineProperty2["default"])(this, "dispatch", function () {
      _this.options.onChange(_this.getAppliedStyles());
    });
    (0, _defineProperty2["default"])(this, "handleMutationObserver", function (mutationList) {
      mutationList.forEach(function (mutation) {
        if (mutation.type === 'attributes' && mutation.attributeName === STYLE_MAP_ATTR && mutation.target.hasAttribute(STYLE_MAP_ATTR)) {
          var styleMapJSON = mutation.target.getAttribute(STYLE_MAP_ATTR);

          if (styleMapJSON) {
            _this.setStylesFromJSON(styleMapJSON);

            _this.dispatch();
          }
        }
      });
    });
    this.options = options;

    if (element.hasAttribute(STYLE_MAP_ATTR)) {
      var styleMapJSON = element.getAttribute(STYLE_MAP_ATTR);

      if (styleMapJSON) {
        this.setStylesFromJSON(styleMapJSON);
        var doc = element.ownerDocument;
        var win = doc.defaultView;
        this.mediaQueries = ORDERED_MEDIA_QUERIES.map(function (mq) {
          return (0, _extends2["default"])({}, mq, {
            listener: win.matchMedia(mq.query)
          });
        });
        this.observer = new win.MutationObserver(this.handleMutationObserver);
        this.observer.observe(element, {
          attributes: true
        });
        this.mediaQueries.forEach(function (_ref) {
          var listener = _ref.listener;
          listener.addListener(_this.dispatch);
        });
        this.dispatch();
      }
    }
  }

  (0, _createClass2["default"])(StyleMapObserver, [{
    key: "setStylesFromJSON",
    value: function setStylesFromJSON(styleMapJSON) {
      try {
        this.styles = JSON.parse(styleMapJSON);
      } catch (e) {
        this.styles = {};
      }
    }
  }, {
    key: "getAppliedStyles",
    value: function getAppliedStyles() {
      if (!this.styles) {
        return;
      }

      var styles = this.styles;
      var appliedStyles = this.mediaQueries.reduce(function (stylesMap, _ref2) {
        var listener = _ref2.listener,
            name = _ref2.name;
        return listener.matches ? (0, _merge["default"])(stylesMap, styles[name]) : stylesMap;
      }, {});
      return appliedStyles;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      var _this2 = this;

      if (this.observer) {
        this.observer.disconnect();
      }

      this.mediaQueries.forEach(function (_ref3) {
        var listener = _ref3.listener;
        listener.removeListener(_this2.dispatch);
      });
    }
  }]);
  return StyleMapObserver;
}();

exports["default"] = StyleMapObserver;
(0, _defineProperty2["default"])(StyleMapObserver, "appliedStylesToStripeElementStyles", function (appliedStylesMap) {
  if (!appliedStylesMap) {
    return {};
  } // Need to update color values to rgba because Stripe doesn't accept hsla format


  var appliedStylesMapWithUpdatedColorValues = Object.keys(appliedStylesMap).reduce(function (updatedStyles, styleKey) {
    var colorVal = appliedStylesMap[styleKey].color;
    var textShadowVal = appliedStylesMap[styleKey].textShadow && appliedStylesMap[styleKey].textShadow.split(/(?=hsla)/);
    updatedStyles[styleKey] = appliedStylesMap[styleKey]; // Update color to rgba string

    if (colorVal) {
      updatedStyles[styleKey].color = (0, _tinycolor["default"])(colorVal).toRgbString();
    } // Want to update only if hsla val is within textShaodw string


    if (textShadowVal && textShadowVal.length > 1) {
      updatedStyles[styleKey].textShadow = textShadowVal[0] + (0, _tinycolor["default"])(textShadowVal[1]).toRgbString();
    }

    return updatedStyles;
  }, {});
  var styles = (0, _extends2["default"])({}, appliedStylesMapWithUpdatedColorValues.noPseudo, {
    ':hover': appliedStylesMapWithUpdatedColorValues.hover,
    ':focus': appliedStylesMapWithUpdatedColorValues.focus,
    '::placeholder': appliedStylesMapWithUpdatedColorValues.placeholder
  });
  return {
    base: styles,
    invalid: styles,
    empty: styles,
    complete: styles
  };
});

/***/ }),
/* 205 */
/***/ (function(module, exports, __webpack_require__) {

var Stack = __webpack_require__(93),
    assignMergeValue = __webpack_require__(208),
    baseFor = __webpack_require__(210),
    baseMergeDeep = __webpack_require__(431),
    isObject = __webpack_require__(9),
    keysIn = __webpack_require__(103),
    safeGet = __webpack_require__(218);

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor(source, function(srcValue, key) {
    stack || (stack = new Stack);
    if (isObject(srcValue)) {
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

module.exports = baseMerge;


/***/ }),
/* 206 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

module.exports = freeGlobal;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(42)))

/***/ }),
/* 207 */
/***/ (function(module, exports) {

/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

module.exports = toSource;


/***/ }),
/* 208 */
/***/ (function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(98),
    eq = __webpack_require__(63);

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignMergeValue;


/***/ }),
/* 209 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(36);

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ }),
/* 210 */
/***/ (function(module, exports, __webpack_require__) {

var createBaseFor = __webpack_require__(430);

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

module.exports = baseFor;


/***/ }),
/* 211 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(14);

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

module.exports = cloneBuffer;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(60)(module)))

/***/ }),
/* 212 */
/***/ (function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(144);

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

module.exports = cloneTypedArray;


/***/ }),
/* 213 */
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__(14);

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ }),
/* 214 */
/***/ (function(module, exports) {

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

module.exports = copyArray;


/***/ }),
/* 215 */
/***/ (function(module, exports, __webpack_require__) {

var baseCreate = __webpack_require__(216),
    getPrototype = __webpack_require__(99),
    isPrototype = __webpack_require__(145);

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

module.exports = initCloneObject;


/***/ }),
/* 216 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(9);

/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

module.exports = baseCreate;


/***/ }),
/* 217 */
/***/ (function(module, exports) {

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

module.exports = overArg;


/***/ }),
/* 218 */
/***/ (function(module, exports) {

/**
 * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function safeGet(object, key) {
  if (key === 'constructor' && typeof object[key] === 'function') {
    return;
  }

  if (key == '__proto__') {
    return;
  }

  return object[key];
}

module.exports = safeGet;


/***/ }),
/* 219 */
/***/ (function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(98),
    eq = __webpack_require__(63);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignValue;


/***/ }),
/* 220 */
/***/ (function(module, exports, __webpack_require__) {

var baseTimes = __webpack_require__(438),
    isArguments = __webpack_require__(146),
    isArray = __webpack_require__(6),
    isBuffer = __webpack_require__(65),
    isIndex = __webpack_require__(148),
    isTypedArray = __webpack_require__(100);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ }),
/* 221 */
/***/ (function(module, exports, __webpack_require__) {

var baseRest = __webpack_require__(441),
    isIterateeCall = __webpack_require__(447);

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

module.exports = createAssigner;


/***/ }),
/* 222 */
/***/ (function(module, exports) {

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

module.exports = constant;


/***/ }),
/* 223 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_BREAKPOINT_IDS = exports.BREAKPOINT_ID_TINY = exports.BREAKPOINT_ID_SMALL = exports.BREAKPOINT_ID_MEDIUM = exports.BREAKPOINT_ID_MAIN = exports.BREAKPOINT_ID_LARGE = exports.BREAKPOINT_ID_XL = exports.BREAKPOINT_ID_XXL = void 0;
var BREAKPOINT_ID_XXL = 'xxl';
exports.BREAKPOINT_ID_XXL = BREAKPOINT_ID_XXL;
var BREAKPOINT_ID_XL = 'xl';
exports.BREAKPOINT_ID_XL = BREAKPOINT_ID_XL;
var BREAKPOINT_ID_LARGE = 'large';
exports.BREAKPOINT_ID_LARGE = BREAKPOINT_ID_LARGE;
var BREAKPOINT_ID_MAIN = 'main';
exports.BREAKPOINT_ID_MAIN = BREAKPOINT_ID_MAIN;
var BREAKPOINT_ID_MEDIUM = 'medium';
exports.BREAKPOINT_ID_MEDIUM = BREAKPOINT_ID_MEDIUM;
var BREAKPOINT_ID_SMALL = 'small';
exports.BREAKPOINT_ID_SMALL = BREAKPOINT_ID_SMALL;
var BREAKPOINT_ID_TINY = 'tiny';
exports.BREAKPOINT_ID_TINY = BREAKPOINT_ID_TINY;
var DEFAULT_BREAKPOINT_IDS = [BREAKPOINT_ID_MAIN, BREAKPOINT_ID_MEDIUM, BREAKPOINT_ID_SMALL, BREAKPOINT_ID_TINY];
exports.DEFAULT_BREAKPOINT_IDS = DEFAULT_BREAKPOINT_IDS;

/***/ }),
/* 224 */
/***/ (function(module, exports) {

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;


/***/ }),
/* 225 */
/***/ (function(module, exports) {

/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

module.exports = hasUnicode;


/***/ }),
/* 226 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = invariant;
/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict
 */

function invariant(condition, message) {
  /* istanbul ignore else */
  if (!condition) {
    throw new Error(message);
  }
}

/***/ }),
/* 227 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _GraphQLError = __webpack_require__(150);

Object.defineProperty(exports, 'GraphQLError', {
  enumerable: true,
  get: function get() {
    return _GraphQLError.GraphQLError;
  }
});

var _syntaxError = __webpack_require__(472);

Object.defineProperty(exports, 'syntaxError', {
  enumerable: true,
  get: function get() {
    return _syntaxError.syntaxError;
  }
});

var _locatedError = __webpack_require__(473);

Object.defineProperty(exports, 'locatedError', {
  enumerable: true,
  get: function get() {
    return _locatedError.locatedError;
  }
});

var _printError = __webpack_require__(228);

Object.defineProperty(exports, 'printError', {
  enumerable: true,
  get: function get() {
    return _printError.printError;
  }
});

var _formatError = __webpack_require__(474);

Object.defineProperty(exports, 'formatError', {
  enumerable: true,
  get: function get() {
    return _formatError.formatError;
  }
});

/***/ }),
/* 228 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.printError = printError;

var _location = __webpack_require__(229);

/**
 * Prints a GraphQLError to a string, representing useful location information
 * about the error's position in the source.
 */
function printError(error) {
  var printedLocations = [];
  if (error.nodes) {
    error.nodes.forEach(function (node) {
      if (node.loc) {
        printedLocations.push(highlightSourceAtLocation(node.loc.source, (0, _location.getLocation)(node.loc.source, node.loc.start)));
      }
    });
  } else if (error.source && error.locations) {
    var source = error.source;
    error.locations.forEach(function (location) {
      printedLocations.push(highlightSourceAtLocation(source, location));
    });
  }
  return printedLocations.length === 0 ? error.message : [error.message].concat(printedLocations).join('\n\n') + '\n';
}

/**
 * Render a helpful description of the location of the error in the GraphQL
 * Source document.
 */
/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict
 */

function highlightSourceAtLocation(source, location) {
  var line = location.line;
  var lineOffset = source.locationOffset.line - 1;
  var columnOffset = getColumnOffset(source, location);
  var contextLine = line + lineOffset;
  var contextColumn = location.column + columnOffset;
  var prevLineNum = (contextLine - 1).toString();
  var lineNum = contextLine.toString();
  var nextLineNum = (contextLine + 1).toString();
  var padLen = nextLineNum.length;
  var lines = source.body.split(/\r\n|[\n\r]/g);
  lines[0] = whitespace(source.locationOffset.column - 1) + lines[0];
  var outputLines = [source.name + ' (' + contextLine + ':' + contextColumn + ')', line >= 2 && lpad(padLen, prevLineNum) + ': ' + lines[line - 2], lpad(padLen, lineNum) + ': ' + lines[line - 1], whitespace(2 + padLen + contextColumn - 1) + '^', line < lines.length && lpad(padLen, nextLineNum) + ': ' + lines[line]];
  return outputLines.filter(Boolean).join('\n');
}

function getColumnOffset(source, location) {
  return location.line === 1 ? source.locationOffset.column - 1 : 0;
}

function whitespace(len) {
  return Array(len + 1).join(' ');
}

function lpad(len, str) {
  return whitespace(len - str.length) + str;
}

/***/ }),
/* 229 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocation = getLocation;


/**
 * Takes a Source and a UTF-8 character offset, and returns the corresponding
 * line and column as a SourceLocation.
 */
/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict
 */

function getLocation(source, position) {
  var lineRegexp = /\r\n|[\n\r]/g;
  var line = 1;
  var column = position + 1;
  var match = void 0;
  while ((match = lineRegexp.exec(source.body)) && match.index < position) {
    line += 1;
    column = position + 1 - (match.index + match[0].length);
  }
  return { line: line, column: column };
}

/**
 * Represents a location in a Source.
 */

/***/ }),
/* 230 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CLASS_NAME_W_DYN_BIND_EMPTY = exports.getColumnNumberClassName = exports.CLASS_NAME_DYNAMIC_LIST_COLUMN = exports.CLASS_NAME_DYNAMIC_LIST_ROW = exports.CLASS_NAME_DYNAMIC_LIST_REPEATER_ITEM = exports.CLASS_NAME_DYNAMIC_LIST_ITEM = exports.CLASS_NAME_DYNAMIC_LIST_REPEATER_REF = exports.CLASS_NAME_DYNAMIC_LIST = exports.CLASS_NAME_DYNAMIC_WRAPPER = void 0;
var CLASS_NAME_DYNAMIC_WRAPPER = 'w-dyn-list';
exports.CLASS_NAME_DYNAMIC_WRAPPER = CLASS_NAME_DYNAMIC_WRAPPER;
var CLASS_NAME_DYNAMIC_LIST = 'w-dyn-items';
exports.CLASS_NAME_DYNAMIC_LIST = CLASS_NAME_DYNAMIC_LIST;
var CLASS_NAME_DYNAMIC_LIST_REPEATER_REF = 'w-dyn-items-repeater-ref';
exports.CLASS_NAME_DYNAMIC_LIST_REPEATER_REF = CLASS_NAME_DYNAMIC_LIST_REPEATER_REF;
var CLASS_NAME_DYNAMIC_LIST_ITEM = 'w-dyn-item';
exports.CLASS_NAME_DYNAMIC_LIST_ITEM = CLASS_NAME_DYNAMIC_LIST_ITEM;
var CLASS_NAME_DYNAMIC_LIST_REPEATER_ITEM = 'w-dyn-repeater-item';
exports.CLASS_NAME_DYNAMIC_LIST_REPEATER_ITEM = CLASS_NAME_DYNAMIC_LIST_REPEATER_ITEM;
var CLASS_NAME_DYNAMIC_LIST_ROW = 'w-row';
exports.CLASS_NAME_DYNAMIC_LIST_ROW = CLASS_NAME_DYNAMIC_LIST_ROW;
var CLASS_NAME_DYNAMIC_LIST_COLUMN = 'w-col';
exports.CLASS_NAME_DYNAMIC_LIST_COLUMN = CLASS_NAME_DYNAMIC_LIST_COLUMN;

var getColumnNumberClassName = function getColumnNumberClassName(cols) {
  return "w-col-".concat(cols);
};

exports.getColumnNumberClassName = getColumnNumberClassName;
var CLASS_NAME_W_DYN_BIND_EMPTY = 'w-dyn-bind-empty';
exports.CLASS_NAME_W_DYN_BIND_EMPTY = CLASS_NAME_W_DYN_BIND_EMPTY;

/***/ }),
/* 231 */
/***/ (function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(232),
    toKey = __webpack_require__(106);

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;


/***/ }),
/* 232 */
/***/ (function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(6),
    isKey = __webpack_require__(151),
    stringToPath = __webpack_require__(480),
    toString = __webpack_require__(37);

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (isArray(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath(toString(value));
}

module.exports = castPath;


/***/ }),
/* 233 */
/***/ (function(module, exports, __webpack_require__) {

var MapCache = __webpack_require__(143);

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = MapCache;

module.exports = memoize;


/***/ }),
/* 234 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProductOptionValueName = exports.simplifySkuValues = void 0; // keep this file as simple as possible and avoid any additional imports, as this can increase published site bundle size a location

var simplifySkuValues = function simplifySkuValues(skuValues) {
  return skuValues.reduce(function (acc, pair) {
    acc[pair.property.id] = pair.value.id;
    return acc;
  }, {});
};

exports.simplifySkuValues = simplifySkuValues;

var getProductOptionValueName = function getProductOptionValueName(property, simplifiedSkuValues) {
  if (property.id && property["enum"]) {
    var propValueId = simplifiedSkuValues[property.id];
    var propValue = property["enum"].find(function (value) {
      return value.id === propValueId;
    });

    if (propValue && typeof propValue.name === 'string') {
      return propValue.name;
    }
  }

  return '';
};

exports.getProductOptionValueName = getProductOptionValueName;

/***/ }),
/* 235 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DYNAMIC_CONTENT_COMPLEXITY_LIMIT = exports.DEFAULT_COLLECTION_LIMIT = exports.DEFAULT_NESTED_COLLECTION_LIMIT = exports.COLLECTION_TYPES = exports.SCHEDULED_PUBLISH_GRACE_PERIOD_IN_MS = exports.SCHEDULED_PUBLISH_LIMIT_IN_MS = exports.SCHEDULED_PUBLISH_GRANULARITY_IN_MIN = exports.SET_FIELD_MAX_ITEMS = exports.QUERY_FILTER_FOR_STATES = exports.NON_EXISTING_ITEM_ID = exports.CONDITION_INVISIBLE_CLASS = exports.TENSES_TO_HUMAN_PHRASES_MAP = exports.TENSES_ENUM = exports.PAST = exports.FUTURE = exports.TIME_INTERVALS_ENUM = void 0; // Internal useful constants.

var SECOND = 1000;
var MINUTE = 60 * SECOND;
var HOUR = 60 * MINUTE;
var DAY = 24 * HOUR;
var YEAR = 365 * DAY; // Intervals of time related to Dates in Collection List Filters

var TIME_INTERVALS_ENUM = {
  days: 'days',
  weeks: 'weeks',
  months: 'months',
  years: 'years'
}; // Tenses of time related to Dates for Collection List Filters

exports.TIME_INTERVALS_ENUM = TIME_INTERVALS_ENUM;
var FUTURE = 'FUTURE';
exports.FUTURE = FUTURE;
var PAST = 'PAST';
exports.PAST = PAST;
var TENSES_ENUM = {
  FUTURE: FUTURE,
  PAST: PAST
};
exports.TENSES_ENUM = TENSES_ENUM;
var TENSES_TO_HUMAN_PHRASES_MAP = {
  FUTURE: 'in the future',
  PAST: 'in the past'
};
exports.TENSES_TO_HUMAN_PHRASES_MAP = TENSES_TO_HUMAN_PHRASES_MAP;
var CONDITION_INVISIBLE_CLASS = 'w-condition-invisible';
exports.CONDITION_INVISIBLE_CLASS = CONDITION_INVISIBLE_CLASS;
var NON_EXISTING_ITEM_ID = '000000000000000000000000';
exports.NON_EXISTING_ITEM_ID = NON_EXISTING_ITEM_ID;
var FILTER_FOR_ALL = 'ALL';
var FILTER_FOR_ANY = 'ANY';
var QUERY_FILTER_FOR_STATES = {
  ALL: FILTER_FOR_ALL,
  ANY: FILTER_FOR_ANY
}; // The maximum number of items a set field can contain.

exports.QUERY_FILTER_FOR_STATES = QUERY_FILTER_FOR_STATES;
var SET_FIELD_MAX_ITEMS = 25;
/**
 * Granularity in minutes used to schedule publishes. For example: 8:00, 8:05,
 * etc.
 */

exports.SET_FIELD_MAX_ITEMS = SET_FIELD_MAX_ITEMS;
var SCHEDULED_PUBLISH_GRANULARITY_IN_MIN = 5;
/**
 * How far in the future an item can be scheduled for SIP.
 */

exports.SCHEDULED_PUBLISH_GRANULARITY_IN_MIN = SCHEDULED_PUBLISH_GRANULARITY_IN_MIN;
var SCHEDULED_PUBLISH_LIMIT_IN_MS = 5 * YEAR;
/**
 * Grace period to execute a scheduled publish. Let's say something is scheduled
 * to publish at 8:10 and it's 8:20. Is it still ok to publish?
 */

exports.SCHEDULED_PUBLISH_LIMIT_IN_MS = SCHEDULED_PUBLISH_LIMIT_IN_MS;
var SCHEDULED_PUBLISH_GRACE_PERIOD_IN_MS = 30 * MINUTE;
/* An enum of the types of collections in our app. This allows us to handle
 * cases based on collection type by using the function getCollectionType
 */

exports.SCHEDULED_PUBLISH_GRACE_PERIOD_IN_MS = SCHEDULED_PUBLISH_GRACE_PERIOD_IN_MS;
var COLLECTION_TYPES = {
  CATEGORIES: 'CATEGORIES',
  CMS_COLLECTIONS: 'CMS_COLLECTIONS',
  PRODUCTS: 'PRODUCTS',
  SKUS: 'SKUS'
};
exports.COLLECTION_TYPES = COLLECTION_TYPES;
var DEFAULT_NESTED_COLLECTION_LIMIT = 5;
exports.DEFAULT_NESTED_COLLECTION_LIMIT = DEFAULT_NESTED_COLLECTION_LIMIT;
var DEFAULT_COLLECTION_LIMIT = 100;
exports.DEFAULT_COLLECTION_LIMIT = DEFAULT_COLLECTION_LIMIT;
var DYNAMIC_CONTENT_COMPLEXITY_LIMIT = 2400;
exports.DYNAMIC_CONTENT_COMPLEXITY_LIMIT = DYNAMIC_CONTENT_COMPLEXITY_LIMIT;

/***/ }),
/* 236 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _CurrencyUtils = __webpack_require__(237);

Object.keys(_CurrencyUtils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _CurrencyUtils[key];
    }
  });
});

var _renderPrice = __webpack_require__(515);

Object.keys(_renderPrice).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _renderPrice[key];
    }
  });
});

/***/ }),
/* 237 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault2 = __webpack_require__(0);

var _typeof2 = _interopRequireDefault2(__webpack_require__(49));

var _classCallCheck2 = _interopRequireDefault2(__webpack_require__(28));

var _createClass2 = _interopRequireDefault2(__webpack_require__(141));

var _interopRequireDefault = __webpack_require__(0);

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCurrencyInfo = getCurrencyInfo;
exports.getCurrencyInfoPaypal = getCurrencyInfoPaypal;
exports.renderPrice = renderPrice;
exports.formatPrice = formatPrice;
exports.validatePrice = validatePrice;
exports.sumPrice = sumPrice;
exports.subtractPrice = subtractPrice;
exports.scalePrice = scalePrice;
exports.equalPrice = equalPrice;
exports.parsePrice = parsePrice;
exports._invalid = _invalid;
exports.zeroUnitWF = zeroUnitWF;
exports.zeroUnitPaypal = zeroUnitPaypal;
exports.convertWFPriceToPaypalAmountWithBreakdown = convertWFPriceToPaypalAmountWithBreakdown;
exports.convertWFPriceToPaypalAmount = convertWFPriceToPaypalAmount;
exports.convertPaypalAmountToWFPrice = convertPaypalAmountToWFPrice;
exports.intToUnsafeFloat = exports.unsafeFloatToInt = exports.getCurrencySymbol = exports.currencyInfoByCodePaypal = exports.currencyInfoByCode = void 0;

var _extends2 = _interopRequireDefault(__webpack_require__(8));

var _keyBy = _interopRequireDefault(__webpack_require__(482));

var _memoize = _interopRequireDefault(__webpack_require__(233));

var _isString = _interopRequireDefault(__webpack_require__(513));

var _isNumber = _interopRequireDefault(__webpack_require__(514));

var _SharedConfig = __webpack_require__(248);

var currencyInfoByCode = (0, _keyBy["default"])(_SharedConfig.stripeCurrencyList, 'code');
exports.currencyInfoByCode = currencyInfoByCode;
var currencyInfoByCodePaypal = (0, _keyBy["default"])(_SharedConfig.paypalCurrencyList, 'code');
exports.currencyInfoByCodePaypal = currencyInfoByCodePaypal;

function getCurrencyInfo(code) {
  var platform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'stripe';

  if (isValidCurrency(code)) {
    return platform === 'stripe' ? // $FlowIgnore
    currencyInfoByCode[code.toUpperCase()] : // $FlowIgnore
    currencyInfoByCodePaypal[code.toUpperCase()];
  }

  return {
    code: '???',
    digits: 2,
    minCharge: 0,
    name: "Unknown currency"
  };
}

function getCurrencyInfoPaypal(code) {
  // $FlowIgnore
  return getCurrencyInfo(code, 'paypal');
}

var isValidCurrency = function isValidCurrency(currencyCode) {
  return typeof currencyCode === 'string' && currencyInfoByCode.hasOwnProperty(currencyCode.toUpperCase());
};

var NullNumberFormat =
/*#__PURE__*/
function () {
  function NullNumberFormat() {
    (0, _classCallCheck2["default"])(this, NullNumberFormat);
  }

  (0, _createClass2["default"])(NullNumberFormat, [{
    key: "format",
    value: function format(_value) {
      return 'NaN';
    }
  }]);
  return NullNumberFormat;
}();

var getNumberFormat = (0, _memoize["default"])(function (unit // HACK: for some reason, GraphQL is returning a currency of '???' for null
// prices; we're temporarily glossing over this fact, and will address the
// backend at a later time..
) {
  var currencyDisplay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'symbol';
  return unit != null && isValidCurrency(unit) ? new Intl.NumberFormat('en-US', {
    currency: unit,
    style: 'currency',
    currencyDisplay: currencyDisplay
  }) : new NullNumberFormat();
},
/* cache key function **/
function (unit) {
  var currencyDisplay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'symbol';
  return [String(unit), currencyDisplay].join('::');
});

var getCurrencySymbol = function getCurrencySymbol(unit) {
  // As Intl.Numberformat.prototype.formatToParts is still experimental
  var symbol = String(getNumberFormat(unit).format(0)).match(/^([^0-9\s]*)/);
  return symbol ? symbol[0] : unit;
};

exports.getCurrencySymbol = getCurrencySymbol;

var unsafeFloatToInt = function unsafeFloatToInt(floatValue, currency
/* integer value */
) {
  var round = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Math.round;
  var currencyInfo = (0, _typeof2["default"])(currency) === 'object' ? currency : getCurrencyInfo(currency);
  return round(floatValue * Math.pow(10, currencyInfo.digits));
};

exports.unsafeFloatToInt = unsafeFloatToInt;

var intToUnsafeFloat = function intToUnsafeFloat(intValue, currency
/* float value */
) {
  var currencyInfo = (0, _typeof2["default"])(currency) === 'object' ? currency : getCurrencyInfo(currency);
  return intValue / Math.pow(10, currencyInfo.digits);
};
/**
 * Will convert a Price object (ie: object with value and unit) into a formatted string. Uses Intl.NumberFormat for
 * all its number formatey goodness.
 *
 * @param  {Number}  price.value The integer value, in the currency's smallest denomination. (This smallest denomination
 *                               is defined by stripe, and documented in our SharedConfig.js)
 * @param  {String}  price.unit  An ISO 4217 currency code. We define which ones are available in SharedConfig.js
 * @param  {boolean} isoFormat   If true it will render the price with ISO 4217 currency code instead of currency symbol
 *
 * @return {String}             A formatted currency string.
 */


exports.intToUnsafeFloat = intToUnsafeFloat;

function renderPrice(price) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _opts$isoFormat = opts.isoFormat,
      isoFormat = _opts$isoFormat === void 0 ? false : _opts$isoFormat,
      _opts$noCurrency = opts.noCurrency,
      noCurrency = _opts$noCurrency === void 0 ? false : _opts$noCurrency;
  price = validatePrice(price) ? price : _invalid();
  var normal_value = Number(price.value);
  var currencyInfo = getCurrencyInfo(price.unit);
  var float_value = intToUnsafeFloat(normal_value, currencyInfo);

  if (Number.isNaN(float_value)) {
    return 'NaN';
  }

  if (noCurrency) {
    return String(float_value);
  }

  var fmt = getNumberFormat(price.unit, isoFormat ? 'code' : 'symbol');
  return fmt.format(float_value);
}
/**
 * Will convert a Price ({ value, unit }) into a FormattedPrice ({ value, unit, string }).
 *
 * @param  {Price} price A basic price object.
 * @return {FormattedPrice} That same price object, extended with a string version.
 */


function formatPrice(price) {
  price = validatePrice(price) ? price : _invalid();
  var string = renderPrice(price);
  return {
    unit: price.unit,
    value: price.value,
    string: string
  };
}
/**
 * Returns true IFF the provided object is a compatible price object.
 *
 * @param  {Object} a  The object under question.
 * @return {Boolean}   True IFF that object is a Price.
 */


function validatePrice(a) {
  if (!a || (0, _typeof2["default"])(a) !== 'object') {
    return false;
  }

  if (!(0, _isNumber["default"])(a.value)) {
    return false;
  }

  if (!(0, _isString["default"])(a.unit)) {
    return false;
  }

  if (!isValidCurrency(a.unit)) {
    return false;
  }

  return true;
}
/**
 * Will add two prices together. Returns invalid if they aren't the same currency.
 *
 * @param  {Price} a  One of the prices.
 * @param  {Price} b  The other of the prices.
 * @return {Price}    The sum.
 */


function sumPrice(a, b) {
  if (!validatePrice(a) || !validatePrice(b)) {
    return _invalid();
  } // No defined behavior, if the Prices don't have a common currency...


  if (a.unit !== b.unit) {
    return _invalid();
  }

  return {
    value: a.value + b.value,
    unit: a.unit
  };
}
/**
 * Will subtract two prices. Returns invalid if they aren't the same currency.
 *
 * @param  {Price} a  One of the prices.
 * @param  {Price} b  The other of the prices.
 * @return {Price}    The sum.
 */


function subtractPrice(a, b) {
  if (!validatePrice(a) || !validatePrice(b)) {
    return _invalid();
  } // No defined behavior, if the Prices don't have a common currency...


  if (a.unit !== b.unit) {
    return _invalid();
  }

  return {
    value: a.value - b.value,
    unit: a.unit
  };
}
/**
 * Will multiply a Price by a scalar.
 *
 * @param  {Price}  a       The price.
 * @param  {Number} scalar  A unitless value that we're multiplying the price by.
 * @return {Price}          The multiplied price.
 */


function scalePrice(a, scalar) {
  if (!validatePrice(a) || !(0, _isNumber["default"])(scalar)) {
    return _invalid();
  }

  var value = Math.round(a.value * scalar);
  var unit = a.unit;
  return {
    value: value,
    unit: unit
  };
}
/**
 * Returns true IFF both prices exist, and are equivalent to each other.
 *
 * @param  {Price} a  One price.
 * @param  {Price} b  The other price.
 * @return {boolean}  True IFF they both exist and are equal.
 */


function equalPrice(a, b) {
  return Boolean(a && b && a.value === b.value && a.unit === b.unit);
}

function parsePrice(priceString, unit, fallback) {
  if (typeof priceString !== 'string') {
    throw new Error('parsePrice must be called with a string');
  }

  if (!isValidCurrency(unit)) {
    throw new Error("parsePrice called with invalid currency ".concat(unit));
  }

  if (!priceString) {
    return fallback;
  } // TODO: Fails on
  // 1,000.00 -> NaN
  // 0,99 -> NaN
  // Also it passes numbers we shouldn't allow:
  // 0x11 -> 17
  // 0b11 -> 3


  var rawNumber = Number(priceString);

  if (Number.isNaN(rawNumber)) {
    return fallback;
  }

  return {
    value: unsafeFloatToInt(rawNumber, unit),
    unit: unit
  };
} // Simple helper method, which gives the "invalid" currency. (NaN as value, "???" as currency.)


function _invalid() {
  return {
    value: NaN,
    unit: '???'
  };
}
/**
 * Returns a Price object with a value of zero.
 *
 * @param  {String} unit    Currency code
 * @return {Price}          Price object
 */


function zeroUnitWF(unit) {
  return {
    unit: unit,
    value: 0
  };
} // Paypal

/**
 * Returns a Paypal Amount (price object) with a value of zero.
 *
 * @param  {String} unit    Currency code
 * @return {PaypalAmount}   Paypal price object
 */


function zeroUnitPaypal(unit) {
  return convertWFPriceToPaypalAmount(zeroUnitWF(unit));
}
/**
 * Returns a Paypal Amount with Breakdown.
 *
 * @param  {OrderPrices}    orderPrices     Object of webflow order prices.
 * @return {PaypalAmount}   Paypal price object (with breakdown)
 */


function convertWFPriceToPaypalAmountWithBreakdown(orderPrices) {
  var total = orderPrices.total,
      subtotal = orderPrices.subtotal,
      shipping = orderPrices.shipping,
      tax = orderPrices.tax,
      discount = orderPrices.discount,
      discountShipping = orderPrices.discountShipping;

  var convertOrZero = function convertOrZero(price, scalar) {
    return price ? convertWFPriceToPaypalAmount(price, scalar) : zeroUnitPaypal(total.unit);
  };

  return (0, _extends2["default"])({}, convertWFPriceToPaypalAmount(total), {
    breakdown: {
      item_total: convertOrZero(subtotal),
      shipping: convertOrZero(shipping),
      tax_total: convertOrZero(tax),
      discount: convertOrZero(discount, -1),
      shipping_discount: convertOrZero(discountShipping, -1)
    }
  });
}
/**
 * Returns a Paypal Amount (price object).
 *
 * @param  {Price} a        Webflow price object.
 * @param  {Number} scalar  A unitless value that we're multiplying the price by.
 * @return {PaypalAmount}   Paypal price object
 */


function convertWFPriceToPaypalAmount(a, scalar) {
  // TODO:
  // - May have to account for in-country PayPal accounts only support for some currencies
  var unitInfo = getCurrencyInfoPaypal(a.unit);
  var wfValue = scalar ? scalePrice(a, scalar).value : a.value;
  var value = intToUnsafeFloat(wfValue, unitInfo).toFixed(unitInfo.digits);
  return {
    currency_code: a.unit,
    value: value
  };
}
/**
 * Returns a WF Price object.
 *
 * @param  {PaypalAmount} a   A paypal price object.
 * @return {Price}            Webflow price object
 */


function convertPaypalAmountToWFPrice(a) {
  // TODO:
  // - May have to account for in-country PayPal accounts only support for some currencies
  var unitInfo = getCurrencyInfoPaypal(a.currency_code);
  var value = unsafeFloatToInt(parseFloat(a.value), unitInfo);
  return {
    unit: a.currency_code,
    value: value
  };
}

/***/ }),
/* 238 */
/***/ (function(module, exports, __webpack_require__) {

var baseForOwn = __webpack_require__(152),
    createBaseEach = __webpack_require__(488);

/**
 * The base implementation of `_.forEach` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array|Object} Returns `collection`.
 */
var baseEach = createBaseEach(baseForOwn);

module.exports = baseEach;


/***/ }),
/* 239 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsEqualDeep = __webpack_require__(491),
    isObjectLike = __webpack_require__(10);

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

module.exports = baseIsEqual;


/***/ }),
/* 240 */
/***/ (function(module, exports, __webpack_require__) {

var SetCache = __webpack_require__(492),
    arraySome = __webpack_require__(495),
    cacheHas = __webpack_require__(496);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(array);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),
/* 241 */
/***/ (function(module, exports) {

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

module.exports = mapToArray;


/***/ }),
/* 242 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetAllKeys = __webpack_require__(243),
    getSymbols = __webpack_require__(153),
    keys = __webpack_require__(40);

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

module.exports = getAllKeys;


/***/ }),
/* 243 */
/***/ (function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(244),
    isArray = __webpack_require__(6);

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

module.exports = baseGetAllKeys;


/***/ }),
/* 244 */
/***/ (function(module, exports) {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ }),
/* 245 */
/***/ (function(module, exports) {

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

module.exports = stubArray;


/***/ }),
/* 246 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(9);

/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !isObject(value);
}

module.exports = isStrictComparable;


/***/ }),
/* 247 */
/***/ (function(module, exports) {

/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

module.exports = matchesStrictComparable;


/***/ }),
/* 248 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
 // @wf-will-never-add-flow-to-this-file
// TODO: add flow to this file

/**
 * Contains static config shared by server and designer
 */
// eslint-disable-next-line no-unused-vars

var SharedConfig = function () {
  'use strict';

  var api = {};
  var index;
  var innerIndex; // Stripe supported countries extracted from:
  // https://stripe.com/global

  var STRIPE_SUPPORTED_COUNTRIES = [{
    name: 'Australia',
    code: 'AU'
  }, {
    name: 'Austria',
    code: 'AT'
  }, {
    name: 'Belgium',
    code: 'BE'
  }, {
    name: 'Bulgaria',
    code: 'BG'
  }, {
    name: 'Brazil',
    code: 'BR'
  }, {
    name: 'Canada',
    code: 'CA'
  }, {
    name: 'Cyprus',
    code: 'CY'
  }, {
    name: 'Czech Republic',
    code: 'CZ'
  }, {
    name: 'Denmark',
    code: 'DK'
  }, {
    name: 'Estonia',
    code: 'EE'
  }, {
    name: 'Finland',
    code: 'FI'
  }, {
    name: 'France',
    code: 'FR'
  }, {
    name: 'Germany',
    code: 'DE'
  }, {
    name: 'Greece',
    code: 'GR'
  }, {
    name: 'Hong Kong',
    code: 'HK'
  }, {
    name: 'India',
    code: 'IN'
  }, {
    name: 'Ireland',
    code: 'IE'
  }, {
    name: 'Italy',
    code: 'IT'
  }, {
    name: 'Japan',
    code: 'JP'
  }, {
    name: 'Latvia',
    code: 'LV'
  }, {
    name: 'Lithuania',
    code: 'LT'
  }, {
    name: 'Luxembourg',
    code: 'LU'
  }, {
    name: 'Malaysia',
    code: 'MY'
  }, {
    name: 'Malta',
    code: 'MT'
  }, {
    name: 'Mexico',
    code: 'MX'
  }, {
    name: 'Netherlands',
    code: 'NL'
  }, {
    name: 'New Zealand',
    code: 'NZ'
  }, {
    name: 'Norway',
    code: 'NO'
  }, {
    name: 'Poland',
    code: 'PL'
  }, {
    name: 'Portugal',
    code: 'PT'
  }, {
    name: 'Romania',
    code: 'RO'
  }, {
    name: 'Singapore',
    code: 'SG'
  }, {
    name: 'Slovakia',
    code: 'SK'
  }, {
    name: 'Slovenia',
    code: 'SI'
  }, {
    name: 'Spain',
    code: 'ES'
  }, {
    name: 'Sweden',
    code: 'SE'
  }, {
    name: 'Switzerland',
    code: 'CH'
  }, {
    name: 'United Kingdom',
    code: 'GB'
  }, {
    name: 'United States',
    code: 'US'
  }]; // PayPal supported countries extracted from:
  // curl https://developer.paypal.com/docs/api/reference/country-codes/

  var PAYPAL_SUPPORTED_COUNTRIES = [{
    name: 'Albania',
    code: 'AL',
    postalCodeRequired: false
  }, {
    name: 'Algeria',
    code: 'DZ',
    postalCodeRequired: false
  }, {
    name: 'Andorra',
    code: 'AD',
    postalCodeRequired: false
  }, {
    name: 'Angola',
    code: 'AO',
    postalCodeRequired: false
  }, {
    name: 'Anguilla',
    code: 'AI',
    postalCodeRequired: false
  }, {
    name: 'Antigua and Barbuda',
    code: 'AG',
    postalCodeRequired: false
  }, {
    name: 'Argentina',
    code: 'AR',
    postalCodeRequired: true
  }, {
    name: 'Armenia',
    code: 'AM',
    postalCodeRequired: false
  }, {
    name: 'Aruba',
    code: 'AW',
    postalCodeRequired: false
  }, {
    name: 'Australia',
    code: 'AU',
    postalCodeRequired: true
  }, {
    name: 'Austria',
    code: 'AT',
    postalCodeRequired: true
  }, {
    name: 'Azerbaijan',
    code: 'AZ',
    postalCodeRequired: false
  }, {
    name: 'Bahamas',
    code: 'BS',
    postalCodeRequired: false
  }, {
    name: 'Bahrain',
    code: 'BH',
    postalCodeRequired: false
  }, {
    name: 'Barbados',
    code: 'BB',
    postalCodeRequired: false
  }, {
    name: 'Belarus',
    code: 'BY',
    postalCodeRequired: false
  }, {
    name: 'Belgium',
    code: 'BE',
    postalCodeRequired: false
  }, {
    name: 'Belize',
    code: 'BZ',
    postalCodeRequired: false
  }, {
    name: 'Benin',
    code: 'BJ',
    postalCodeRequired: false
  }, {
    name: 'Bermuda',
    code: 'BM',
    postalCodeRequired: false
  }, {
    name: 'Bhutan',
    code: 'BT',
    postalCodeRequired: true
  }, {
    name: 'Bolivia',
    code: 'BO',
    postalCodeRequired: false
  }, {
    name: 'Bosnia and Herzegovina',
    code: 'BA',
    postalCodeRequired: false
  }, {
    name: 'Botswana',
    code: 'BW',
    postalCodeRequired: false
  }, {
    name: 'Brazil',
    code: 'BR',
    postalCodeRequired: true
  }, {
    name: 'British Virgin Islands',
    code: 'VG',
    postalCodeRequired: false
  }, {
    name: 'Brunei',
    code: 'BN',
    postalCodeRequired: false
  }, {
    name: 'Bulgaria',
    code: 'BG',
    postalCodeRequired: false
  }, {
    name: 'Burkina Faso',
    code: 'BF',
    postalCodeRequired: false
  }, {
    name: 'Burundi',
    code: 'BI',
    postalCodeRequired: false
  }, {
    name: 'Cambodia',
    code: 'KH',
    postalCodeRequired: false
  }, {
    name: 'Cameroon',
    code: 'CM',
    postalCodeRequired: false
  }, {
    name: 'Canada',
    code: 'CA',
    postalCodeRequired: true
  }, {
    name: 'Cape Verde',
    code: 'CV',
    postalCodeRequired: false
  }, {
    name: 'Cayman Islands',
    code: 'KY',
    postalCodeRequired: false
  }, {
    name: 'Chad',
    code: 'TD',
    postalCodeRequired: false
  }, {
    name: 'Chile',
    code: 'CL',
    postalCodeRequired: false
  }, {
    name: 'China',
    code: 'C2',
    postalCodeRequired: true
  }, {
    name: 'Colombia',
    code: 'CO',
    postalCodeRequired: false
  }, {
    name: 'Comoros',
    code: 'KM',
    postalCodeRequired: true
  }, {
    name: 'Congo - Brazzaville',
    code: 'CG',
    postalCodeRequired: false
  }, {
    name: 'Congo - Kinshasa',
    code: 'CD',
    postalCodeRequired: false
  }, {
    name: 'Cook Islands',
    code: 'CK',
    postalCodeRequired: false
  }, {
    name: 'Costa Rica',
    code: 'CR',
    postalCodeRequired: false
  }, {
    name: 'Côte D’ivoire',
    code: 'CI',
    postalCodeRequired: false
  }, {
    name: 'Croatia',
    code: 'HR',
    postalCodeRequired: false
  }, {
    name: 'Cyprus',
    code: 'CY',
    postalCodeRequired: false
  }, {
    name: 'Czech Republic',
    code: 'CZ',
    postalCodeRequired: false
  }, {
    name: 'Denmark',
    code: 'DK',
    postalCodeRequired: true
  }, {
    name: 'Djibouti',
    code: 'DJ',
    postalCodeRequired: false
  }, {
    name: 'Dominica',
    code: 'DM',
    postalCodeRequired: false
  }, {
    name: 'Dominican Republic',
    code: 'DO',
    postalCodeRequired: false
  }, {
    name: 'Ecuador',
    code: 'EC',
    postalCodeRequired: false
  }, {
    name: 'Egypt',
    code: 'EG',
    postalCodeRequired: false
  }, {
    name: 'El Salvador',
    code: 'SV',
    postalCodeRequired: false
  }, {
    name: 'Eritrea',
    code: 'ER',
    postalCodeRequired: false
  }, {
    name: 'Estonia',
    code: 'EE',
    postalCodeRequired: false
  }, {
    name: 'Ethiopia',
    code: 'ET',
    postalCodeRequired: false
  }, {
    name: 'Falkland Islands',
    code: 'FK',
    postalCodeRequired: true
  }, {
    name: 'Faroe Islands',
    code: 'FO',
    postalCodeRequired: true
  }, {
    name: 'Fiji',
    code: 'FJ',
    postalCodeRequired: false
  }, {
    name: 'Finland',
    code: 'FI',
    postalCodeRequired: false
  }, {
    name: 'France',
    code: 'FR',
    postalCodeRequired: true
  }, {
    name: 'French Guiana',
    code: 'GF',
    postalCodeRequired: false
  }, {
    name: 'French Polynesia',
    code: 'PF',
    postalCodeRequired: false
  }, {
    name: 'Gabon',
    code: 'GA',
    postalCodeRequired: false
  }, {
    name: 'Gambia',
    code: 'GM',
    postalCodeRequired: true
  }, {
    name: 'Georgia',
    code: 'GE',
    postalCodeRequired: false
  }, {
    name: 'Germany',
    code: 'DE',
    postalCodeRequired: true
  }, {
    name: 'Gibraltar',
    code: 'GI',
    postalCodeRequired: false
  }, {
    name: 'Greece',
    code: 'GR',
    postalCodeRequired: false
  }, {
    name: 'Greenland',
    code: 'GL',
    postalCodeRequired: true
  }, {
    name: 'Grenada',
    code: 'GD',
    postalCodeRequired: false
  }, {
    name: 'Guadeloupe',
    code: 'GP',
    postalCodeRequired: false
  }, {
    name: 'Guatemala',
    code: 'GT',
    postalCodeRequired: false
  }, {
    name: 'Guinea',
    code: 'GN',
    postalCodeRequired: false
  }, {
    name: 'Guinea-bissau',
    code: 'GW',
    postalCodeRequired: false
  }, {
    name: 'Guyana',
    code: 'GY',
    postalCodeRequired: false
  }, {
    name: 'Honduras',
    code: 'HN',
    postalCodeRequired: false
  }, {
    name: 'Hong Kong Sar China',
    code: 'HK',
    postalCodeRequired: false
  }, {
    name: 'Hungary',
    code: 'HU',
    postalCodeRequired: false
  }, {
    name: 'Iceland',
    code: 'IS',
    postalCodeRequired: false
  }, {
    name: 'Indonesia',
    code: 'ID',
    postalCodeRequired: false
  }, {
    name: 'Ireland',
    code: 'IE',
    postalCodeRequired: false
  }, {
    name: 'Italy',
    code: 'IT',
    postalCodeRequired: true
  }, {
    name: 'Jamaica',
    code: 'JM',
    postalCodeRequired: false
  }, {
    name: 'Jordan',
    code: 'JO',
    postalCodeRequired: false
  }, {
    name: 'Kazakhstan',
    code: 'KZ',
    postalCodeRequired: false
  }, {
    name: 'Kenya',
    code: 'KE',
    postalCodeRequired: false
  }, {
    name: 'Kiribati',
    code: 'KI',
    postalCodeRequired: true
  }, {
    name: 'Kuwait',
    code: 'KW',
    postalCodeRequired: false
  }, {
    name: 'Kyrgyzstan',
    code: 'KG',
    postalCodeRequired: true
  }, {
    name: 'Laos',
    code: 'LA',
    postalCodeRequired: false
  }, {
    name: 'Latvia',
    code: 'LV',
    postalCodeRequired: false
  }, {
    name: 'Lesotho',
    code: 'LS',
    postalCodeRequired: false
  }, {
    name: 'Liechtenstein',
    code: 'LI',
    postalCodeRequired: false
  }, {
    name: 'Lithuania',
    code: 'LT',
    postalCodeRequired: false
  }, {
    name: 'Luxembourg',
    code: 'LU',
    postalCodeRequired: false
  }, {
    name: 'Macedonia',
    code: 'MK',
    postalCodeRequired: false
  }, {
    name: 'Madagascar',
    code: 'MG',
    postalCodeRequired: false
  }, {
    name: 'Malawi',
    code: 'MW',
    postalCodeRequired: true
  }, {
    name: 'Malaysia',
    code: 'MY',
    postalCodeRequired: false
  }, {
    name: 'Maldives',
    code: 'MV',
    postalCodeRequired: false
  }, {
    name: 'Mali',
    code: 'ML',
    postalCodeRequired: false
  }, {
    name: 'Malta',
    code: 'MT',
    postalCodeRequired: false
  }, {
    name: 'Marshall Islands',
    code: 'MH',
    postalCodeRequired: false
  }, {
    name: 'Martinique',
    code: 'MQ',
    postalCodeRequired: false
  }, {
    name: 'Mauritania',
    code: 'MR',
    postalCodeRequired: true
  }, {
    name: 'Mauritius',
    code: 'MU',
    postalCodeRequired: false
  }, {
    name: 'Mayotte',
    code: 'YT',
    postalCodeRequired: true
  }, {
    name: 'Mexico',
    code: 'MX',
    postalCodeRequired: true
  }, {
    name: 'Moldova',
    code: 'MD',
    postalCodeRequired: false
  }, {
    name: 'Monaco',
    code: 'MC',
    postalCodeRequired: false
  }, {
    name: 'Mongolia',
    code: 'MN',
    postalCodeRequired: false
  }, {
    name: 'Montenegro',
    code: 'ME',
    postalCodeRequired: false
  }, {
    name: 'Montserrat',
    code: 'MS',
    postalCodeRequired: false
  }, {
    name: 'Morocco',
    code: 'MA',
    postalCodeRequired: false
  }, {
    name: 'Mozambique',
    code: 'MZ',
    postalCodeRequired: false
  }, {
    name: 'Namibia',
    code: 'NA',
    postalCodeRequired: false
  }, {
    name: 'Nauru',
    code: 'NR',
    postalCodeRequired: true
  }, {
    name: 'Nepal',
    code: 'NP',
    postalCodeRequired: false
  }, {
    name: 'Netherlands',
    code: 'NL',
    postalCodeRequired: true
  }, {
    name: 'New Caledonia',
    code: 'NC',
    postalCodeRequired: false
  }, {
    name: 'New Zealand',
    code: 'NZ',
    postalCodeRequired: false
  }, {
    name: 'Nicaragua',
    code: 'NI',
    postalCodeRequired: false
  }, {
    name: 'Niger',
    code: 'NE',
    postalCodeRequired: true
  }, {
    name: 'Nigeria',
    code: 'NG',
    postalCodeRequired: false
  }, {
    name: 'Niue',
    code: 'NU',
    postalCodeRequired: true
  }, {
    name: 'Norfolk Island',
    code: 'NF',
    postalCodeRequired: true
  }, {
    name: 'Norway',
    code: 'NO',
    postalCodeRequired: true
  }, {
    name: 'Oman',
    code: 'OM',
    postalCodeRequired: false
  }, {
    name: 'Palau',
    code: 'PW',
    postalCodeRequired: false
  }, {
    name: 'Panama',
    code: 'PA',
    postalCodeRequired: false
  }, {
    name: 'Papua New Guinea',
    code: 'PG',
    postalCodeRequired: false
  }, {
    name: 'Paraguay',
    code: 'PY',
    postalCodeRequired: false
  }, {
    name: 'Peru',
    code: 'PE',
    postalCodeRequired: false
  }, {
    name: 'Philippines',
    code: 'PH',
    postalCodeRequired: false
  }, {
    name: 'Pitcairn Islands',
    code: 'PN',
    postalCodeRequired: true
  }, {
    name: 'Poland',
    code: 'PL',
    postalCodeRequired: true
  }, {
    name: 'Portugal',
    code: 'PT',
    postalCodeRequired: false
  }, {
    name: 'Qatar',
    code: 'QA',
    postalCodeRequired: false
  }, {
    name: 'Réunion',
    code: 'RE',
    postalCodeRequired: false
  }, {
    name: 'Romania',
    code: 'RO',
    postalCodeRequired: false
  }, {
    name: 'Russion',
    code: 'RU',
    postalCodeRequired: true
  }, {
    name: 'Rwanda',
    code: 'RW',
    postalCodeRequired: false
  }, {
    name: 'Samoa',
    code: 'WS',
    postalCodeRequired: false
  }, {
    name: 'San Marino',
    code: 'SM',
    postalCodeRequired: false
  }, {
    name: 'São Tomé and Príncipe',
    code: 'ST',
    postalCodeRequired: false
  }, {
    name: 'Saudi Arabia',
    code: 'SA',
    postalCodeRequired: false
  }, {
    name: 'Senegal',
    code: 'SN',
    postalCodeRequired: false
  }, {
    name: 'Serbia',
    code: 'RS',
    postalCodeRequired: false
  }, {
    name: 'Seychelles',
    code: 'SC',
    postalCodeRequired: false
  }, {
    name: 'Sierra Leone',
    code: 'SL',
    postalCodeRequired: false
  }, {
    name: 'Singapore',
    code: 'SG',
    postalCodeRequired: true
  }, {
    name: 'Slovakia',
    code: 'SK',
    postalCodeRequired: false
  }, {
    name: 'Slovenia',
    code: 'SI',
    postalCodeRequired: false
  }, {
    name: 'Solomon Islands',
    code: 'SB',
    postalCodeRequired: false
  }, {
    name: 'Somalia',
    code: 'SO',
    postalCodeRequired: false
  }, {
    name: 'South Africa',
    code: 'ZA',
    postalCodeRequired: false
  }, {
    name: 'South Korea',
    code: 'KR',
    postalCodeRequired: false
  }, {
    name: 'Spain',
    code: 'ES',
    postalCodeRequired: true
  }, {
    name: 'Sri Lanka',
    code: 'LK',
    postalCodeRequired: false
  }, {
    name: 'St. Helena',
    code: 'SH',
    postalCodeRequired: true
  }, {
    name: 'St. Kitts and Nevis',
    code: 'KN',
    postalCodeRequired: false
  }, {
    name: 'St. Lucia',
    code: 'LC',
    postalCodeRequired: false
  }, {
    name: 'St. Pierre and Miquelon',
    code: 'PM',
    postalCodeRequired: true
  }, {
    name: 'St. Vincent and Grenadines',
    code: 'VC',
    postalCodeRequired: false
  }, {
    name: 'Suriname',
    code: 'SR',
    postalCodeRequired: true
  }, {
    name: 'Svalbard and Jan Mayen',
    code: 'SJ',
    postalCodeRequired: true
  }, {
    name: 'Swaziland',
    code: 'SZ',
    postalCodeRequired: false
  }, {
    name: 'Sweden',
    code: 'SE',
    postalCodeRequired: true
  }, {
    name: 'Switzerland',
    code: 'CH',
    postalCodeRequired: true
  }, {
    name: 'Taiwan',
    code: 'TW',
    postalCodeRequired: false
  }, {
    name: 'Tajikistan',
    code: 'TJ',
    postalCodeRequired: false
  }, {
    name: 'Tanzania',
    code: 'TZ',
    postalCodeRequired: false
  }, {
    name: 'Thailand',
    code: 'TH',
    postalCodeRequired: false
  }, {
    name: 'Togo',
    code: 'TG',
    postalCodeRequired: false
  }, {
    name: 'Tonga',
    code: 'TO',
    postalCodeRequired: false
  }, {
    name: 'Trinidad and Tobago',
    code: 'TT',
    postalCodeRequired: false
  }, {
    name: 'Tunisia',
    code: 'TN',
    postalCodeRequired: false
  }, {
    name: 'Turkmenistan',
    code: 'TM',
    postalCodeRequired: false
  }, {
    name: 'Turks and Caicos Islands',
    code: 'TC',
    postalCodeRequired: false
  }, {
    name: 'Tuvalu',
    code: 'TV',
    postalCodeRequired: true
  }, {
    name: 'Uganda',
    code: 'UG',
    postalCodeRequired: false
  }, {
    name: 'Ukraine',
    code: 'UA',
    postalCodeRequired: false
  }, {
    name: 'United Arab Emirates',
    code: 'AE',
    postalCodeRequired: false
  }, {
    name: 'United Kingdom',
    code: 'GB',
    postalCodeRequired: true
  }, {
    name: 'United States',
    code: 'US',
    postalCodeRequired: true
  }, {
    name: 'Uruguay',
    code: 'UY',
    postalCodeRequired: false
  }, {
    name: 'Vanuatu',
    code: 'VU',
    postalCodeRequired: false
  }, {
    name: 'Vatican City',
    code: 'VA',
    postalCodeRequired: true
  }, {
    name: 'Venezuela',
    code: 'VE',
    postalCodeRequired: false
  }, {
    name: 'Vietnam',
    code: 'VN',
    postalCodeRequired: false
  }, {
    name: 'Wallis and Futuna',
    code: 'WF',
    postalCodeRequired: true
  }, {
    name: 'Yemen',
    code: 'YE',
    postalCodeRequired: false
  }, {
    name: 'Zambia',
    code: 'ZM',
    postalCodeRequired: false
  }, {
    name: 'Zimbabwe',
    code: 'ZW',
    postalCodeRequired: false
  }]; // list of country codes extracted from STRIPE_SUPPORTED_COUNTRIES

  var STRIPE_COUNTRY_LIST = [];

  for (index = 0; index < STRIPE_SUPPORTED_COUNTRIES.length; index++) {
    STRIPE_COUNTRY_LIST.push(STRIPE_SUPPORTED_COUNTRIES[index].code);
  } // list of country codes extracted from payaplSupportedCountries


  var PAYPAL_COUNTRY_LIST = [];

  for (index = 0; index < PAYPAL_SUPPORTED_COUNTRIES.length; index++) {
    // PayPal uses C2 country code to indicate Chinese users who trade in USD
    if (PAYPAL_SUPPORTED_COUNTRIES[index].code === 'C2') {
      PAYPAL_COUNTRY_LIST.push('CN');
    } else {
      PAYPAL_COUNTRY_LIST.push(PAYPAL_SUPPORTED_COUNTRIES[index].code);
    }
  }

  var COMBINED_COUNTRY_LIST = STRIPE_COUNTRY_LIST.concat(PAYPAL_COUNTRY_LIST); // list of country codes supported by available payement gateways (currently PayPal and Stripe)

  var COMMERCE_SUPPORTED_COUNTRY_LIST = COMBINED_COUNTRY_LIST.filter(function (countryCode, i) {
    return COMBINED_COUNTRY_LIST.indexOf(countryCode) === i;
  });
  /**
   * SharedConfig.paths - common CDN asset path constants
   */

  var paths = api.paths = {};
  var CDN_ROOT = 'https://d3e54v103j8qbb.cloudfront.net/';
  var PLACEHOLDER_ROOT = CDN_ROOT + 'img/'; // Date sites have to be published after to have the editor code published on them.

  var DYNAMO_PUBLISH_DATE = new Date('2015/10/07 07:00:00 GMT+0000'); // Update on public release.
  // Placeholder inline image

  paths.EXAMPLE_IMG_ID = 'example_img';
  paths.EXAMPLE_IMG_NAME = 'image-placeholder.svg';
  paths.EXAMPLE_IMG_URL = PLACEHOLDER_ROOT + paths.EXAMPLE_IMG_NAME; // Placeholder background image

  paths.EXAMPLE_BG_ID = 'example_bg';
  paths.EXAMPLE_BG_NAME = 'background-image.svg';
  paths.EXAMPLE_BG_URL = PLACEHOLDER_ROOT + paths.EXAMPLE_BG_NAME; // Placeholder thumbnail image

  paths.EXAMPLE_THUMB_ID = 'example_thumb';
  paths.EXAMPLE_THUMB_NAME = 'placeholder-thumb.svg';
  paths.EXAMPLE_THUMB_URL = PLACEHOLDER_ROOT + paths.EXAMPLE_THUMB_NAME;
  var STATIC_ROOT = CDN_ROOT + 'static/';
  paths.PAGE_NOT_FOUND_ICON_ID = 'page_not_found';
  paths.PAGE_NOT_FOUND_ICON_NAME = 'page-not-found.svg';
  paths.PAGE_NOT_FOUND_ICON_URL = STATIC_ROOT + 'page-not-found.211a85e40c.svg';
  paths.PASSWORD_PAGE_ICON_ID = 'password_page_icon';
  paths.PASSWORD_PAGE_ICON_NAME = 'password-page-lock.svg';
  paths.PASSWORD_PAGE_ICON_URL = STATIC_ROOT + 'password-page-lock.832ca8e2c9.svg';
  paths.YOUTUBE_PLACEHOLDER_ID = 'youtube_placeholder';
  paths.YOUTUBE_PLACEHOLDER_NAME = 'youtube-placeholder.svg';
  paths.YOUTUBE_PLACEHOLDER_URL = STATIC_ROOT + 'youtube-placeholder.2b05e7d68d.svg';
  paths.CUSTOM_CHECKBOX_CHECK_ID = 'custom_checkbox_check';
  paths.CUSTOM_CHECKBOX_CHECK_NAME = 'custom-checkbox-check.svg';
  paths.CUSTOM_CHECKBOX_CHECK_URL = STATIC_ROOT + 'custom-checkbox-checkmark.589d534424.svg'; // Should match sslCdn in production.js

  paths.UPLOADS_CDN_ROOT = 'https://daks2k3a4ib2z.cloudfront.net/'; // Lambda prism root

  var PRISM_ENDPOINTS = {
    dev: 'https://aco4jiy5g9.execute-api.us-east-1.amazonaws.com/dev/',
    staging: 'https://kkbii6szaa.execute-api.us-east-1.amazonaws.com/staging/',
    production: 'https://prism.webflow.com/' // prism.webflow.com -> https://n1hn78c5ge.execute-api.us-east-1.amazonaws.com/production/

  }; // NOTE: When developing new PRISM code, you can manually set PRISM_DEV_ROOT to PRISM_ENDPOINTS.dev
  // other devs not working on PRISM should be hitting the PRISM_ENDPOINTS.staging endpoint.
  // NOTE: When merging a feature branch into dev that contains PRISM changes, you should deploy the new PRISM code to PRISM_ENDPOINTS.staging
  // NOTE: When merging dev into main that contains PRISM changes, you should deploy the new PRISM code to PRISM_ENDPOINTS.production

  paths.PRISM_DEV_ROOT = PRISM_ENDPOINTS.staging;
  paths.PRISM_ROOT = PRISM_ENDPOINTS.production; // Dummy images

  paths.GENERAL_DUMMY_IMG_PATH = CDN_ROOT + 'img/generic/image';
  paths.PEOPLE_DUMMY_IMG_PATH = CDN_ROOT + 'img/people/image'; // Each node in the canvas that has a DomNode attached to it will also have a data-w-id attribute that stores the node's guid
  // In most cases, these IDs are not persisted to the server, but they saved for typographic node descendants (micro nodes)

  api.WEBFLOW_NODE_ID_ATTR = 'data-w-id'; // This is the dom node attribute used to expressed the exact path to a dom node.

  api.WEBFLOW_NODE_ID_PATH_ATTR = 'data-wf-id'; // For symbol instance descendants we keep the original id in a different attribute

  api.webflowNodeInstanceIdAttr = 'data-w-instance-of';
  api.VALID_CONTENT_NODES = ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'blockquote', 'figure', 'figcaption', 'a', 'strong', 'em', 'div', 'span', 'img', 'iframe', 'ul', 'ol', 'li', 'br'];
  api.VALID_TYPOGRAPHIC_CONTENT_NODES = ['a', 'strong', 'em', 'br', 'span']; // RTE link attributes, used when an element lacks a domNode

  api.RTE_LINK_TYPE_ATTR = 'data-rt-link-type';
  api.RTE_LINK_PAGE_ID_ATTR = 'data-rt-link-pageid';
  api.RTE_LINK_ITEM_ID_ATTR = 'data-rt-link-itemid';
  api.RTE_LINK_COLLECTION_ID_ATTR = 'data-rt-link-collectionid';
  api.RTE_LINK_DOM_ID_ATTR = 'data-rt-link-domid';
  api.RTE_LINK_DATA_ATTRS = [api.RTE_LINK_PAGE_ID_ATTR, api.RTE_LINK_TYPE_ATTR, api.RTE_LINK_ITEM_ID_ATTR, api.RTE_LINK_COLLECTION_ID_ATTR, api.RTE_LINK_DOM_ID_ATTR]; // RTE figure attributes, used when a figure lacks a domNode

  api.RTE_FIGURE_TYPE_ATTR = 'data-rt-type';
  api.RTE_FIGURE_ALIGN_ATTR = 'data-rt-align';
  api.RTE_FIGURE_MAX_WIDTH_ATTR = 'data-rt-max-width';
  api.RTE_FIGURE_MAX_HEIGHT_ATTR = 'data-rt-max-height';
  api.RTE_FIGURE_DIMENSIONS_ATTR = 'data-rt-dimensions';
  api.RTE_FIGURE_PAGE_URL_ATTR = 'data-page-url';
  api.RTE_FIGURE_DATA_ATTRS = [api.RTE_FIGURE_TYPE_ATTR, api.RTE_FIGURE_ALIGN_ATTR, api.RTE_FIGURE_MAX_WIDTH_ATTR, api.RTE_FIGURE_MAX_HEIGHT_ATTR, api.RTE_FIGURE_DIMENSIONS_ATTR, api.RTE_FIGURE_PAGE_URL_ATTR];
  api.HREF = 'href';
  api.HREF_DISABLED = api.HREF + '-disabled';
  api.HREF_DISABLED_DEFAULT_COLOR = api.HREF_DISABLED + '-default-color';
  api.HREF_DISABLED_UNDERLINE = api.HREF_DISABLED + '-underline';
  api.MAILTO_EMAIL_REGEX = /^mailto:([^?$]*)/;
  api.MAILTO_SUBJECT_REGEX = /^mailto:.*\?.*subject=([^&$]+)/;
  api.TEL_NUMBER_REGEX = /^tel:([^$]*)/;
  api.DEPRECATED_WF_GOOGLE_MAPS_KEY = 'AIzaSyBQ4EYEg4aRz9-yiCnerTV7bk8GCWgZOhk';
  api.RTE_FIGURE_TYPE_CLASS = 'w-richtext-figure-type-';
  api.RTE_FIGURE_TYPE_IMAGE_CLASS = api.RTE_FIGURE_TYPE_CLASS + 'image';
  api.RTE_FIGURE_TYPE_VIDEO_CLASS = api.RTE_FIGURE_TYPE_CLASS + 'video';
  api.FIGURE_ALIGN_MAP = {
    center: 'w-richtext-align-center',
    fullwidth: 'w-richtext-align-fullwidth',
    normal: 'w-richtext-align-normal',
    floatleft: 'w-richtext-align-floatleft',
    floatright: 'w-richtext-align-floatright'
  }; // An attribute used to mark newly created typographic content node links and span nodes so that we can auto-select them after the RTE unbinds in the designer-canvas.

  api.RTE_LEGACY_TEMP_ELEM_ATTR = 'wf-temp-elem';
  api.RTE_NEW_ELEMENT_MARKER_ATTR = 'wf-rte-new-element';
  api.TYPOGRAPHIC_TAG_REGEX = /^(?:h[1-6]|p|blockquote|span|label|button|q|i|em|strong|b|u|s|small|abbr|cite|dfn|sub|sup|time|code|kbd)$/;
  api.richTextPageAnchorRegex = new RegExp('<a[^>]+' + api.RTE_LINK_PAGE_ID_ATTR + '[^>]+>', 'g'); // used to replace the href value from an opening anchor tag matched in richTextPageAnchorRegex. $0 is the attr="val", $1 is just val

  api.richTextHrefReplaceRegex = /href=(?:"|')([^'"]+)(?:"|')/; // used on the opening tag of an anchor to remove the RTE link attributes. (mostly on publish and export)

  api.richTextLinkAttrsReplaceRegex = new RegExp('(' + [api.RTE_LINK_TYPE_ATTR, api.RTE_LINK_PAGE_ID_ATTR, api.RTE_LINK_ITEM_ID_ATTR, api.RTE_LINK_COLLECTION_ID_ATTR, api.RTE_LINK_DOM_ID_ATTR].join('|') + ')=(\'|")[^\'"]*(\'|") ?', 'g'); // used to match the value of the static page id attribute (RTE_LINK_PAGE_ID_ATTR)

  api.richTextPageAttrRegex = new RegExp(api.RTE_LINK_PAGE_ID_ATTR + '=(?:"|\')([^\'"]+)(?:"|\')');
  api.editorPublishDate = DYNAMO_PUBLISH_DATE; // used for detecting legacy micro node ids

  api.microNodeIdLength = 8;
  api.DYN_BOUND_PLACEHOLDER_TEXT = '[dynamic-text]';
  api.MAX_DYNLISTS_PER_PAGE = 20;
  api.MAX_NESTED_DYNLISTS_PER_PAGE = 1;
  api.allowedTypoContentTags = ['a', 'span', 'strong', 'em', 'br']; // Nodes that should not be closed in HTML5

  api.VOID_HTML_TAGS = ['area', 'base', 'br', 'col', 'embed', 'hr', 'img', 'input', 'keygen', 'link', 'meta', 'param', 'source', 'track', 'wbr'];
  api.dynamicContextConstant = 'DYN_CONTEXT'; // Lowercase field names that are reserved/blacklisted

  api.FIELD_NAME_BLACKLIST = ['_id', 'id']; // Managed Plan limits:

  api.MAX_MANAGED_PLAN_AMOUNT = 20000000; // in cents

  /**
   * Default fields - should be in the format in which they are stored in the Collection model.
   * @type {Array}
   */

  api.dynamoCollectionDefaultFields = [{
    name: 'Name',
    slug: 'name',
    type: 'PlainText',
    required: true,
    editable: true,
    validations: {
      maxLength: 256
    }
  }, {
    name: 'Slug',
    slug: 'slug',
    type: 'PlainText',
    required: true,
    editable: true,
    unique: true,
    validations: {
      maxLength: 256,
      pattern: /^[_a-zA-Z0-9][-_a-zA-Z0-9]*$/,
      messages: {
        pattern: 'Must be alphanumerical and not contain any spaces or special characters',
        maxLength: 'Must be less than 256 characters'
      }
    }
  }, {
    name: 'Archived',
    slug: '_archived',
    type: 'Bool',
    required: true,
    editable: true,
    "default": false
  }, {
    name: 'Draft',
    slug: '_draft',
    type: 'Bool',
    required: true,
    editable: true,
    "default": false
  }, {
    name: 'Created On',
    slug: 'created-on',
    type: 'Date',
    required: false,
    editable: false
  }, {
    name: 'Updated On',
    slug: 'updated-on',
    type: 'Date',
    required: false,
    editable: false
  }, {
    name: 'Published On',
    slug: 'published-on',
    type: 'Date',
    required: false,
    editable: false
  }, {
    name: 'Created By',
    slug: 'created-by',
    type: 'User',
    required: false,
    editable: false
  }, {
    name: 'Updated By',
    slug: 'updated-by',
    type: 'User',
    required: false,
    editable: false
  }, {
    name: 'Published By',
    slug: 'published-by',
    type: 'User',
    required: false,
    editable: false
  }]; // In addition to the "default" fields, these are other fields that the user gets for "free":
  // Note: These get baked into site data when a store is set up, so they will not change on an
  // existing site without a migration. New not-required fields will get added via `upgradeEcommCollections`.
  // ---------------------------------------------------------------------------------------------------
  // Adding a new field may require published site snapshots in Cypress tests to be updated, refer to
  // `docs/tools/cypress/published-site-tests.md` for steps.
  // ---------------------------------------------------------------------------------------------------
  // In order for new fields to show up for a certain product type on the product or variant form, the field will
  // need to be added to a specific template type or a default (`DEFAULT_PRODUCT_TYPE_PRODUCT_FIELDS` or `DEFAULT_PRODUCT_TYPE_SKU_FIELDS`).
  // See `docs/app/ecommerce/product-types.md/#ii-template-product-types` for more info.
  // ---------------------------------------------------------------------------------------------------

  api.ecommExtraFields = {
    category: [],
    product: [{
      name: 'SKU Properties',
      slug: 'sku-properties',
      type: 'CommercePropTable',
      required: false,
      editable: true
    }, {
      name: 'Categories',
      slug: 'category',
      type: 'ItemRefSet',
      helpText: 'Add this product to one or more categories.',
      required: false,
      editable: true,
      validations: {
        collectionId: null // Will be populated with correct value at creation.

      }
    }, {
      name: 'Description',
      slug: 'description',
      type: 'PlainText',
      required: false,
      editable: true
    }, {
      name: 'Requires Shipping',
      slug: 'shippable',
      type: 'Bool',
      required: false,
      editable: true
    }, {
      name: 'Tax Category',
      slug: 'tax-category',
      type: 'EnumOption',
      required: false,
      editable: true,
      validations: {
        enumName: 'TaxCategories'
      }
    }, {
      name: 'Default SKU',
      slug: 'default-sku',
      type: 'ItemRef',
      required: false,
      // False, so we can create the SKU, and then update.
      editable: true,
      validations: {
        collectionId: null // Will be populated with correct value at creation.

      }
    }, {
      name: 'Product type',
      slug: 'ec-product-type',
      type: 'Option',
      required: false,
      editable: true,
      validations: {
        options: [{
          id: 'ff42fee0113744f693a764e3431a9cc2',
          name: 'Physical'
        }, {
          id: 'f22027db68002190aef89a4a2b7ac8a1',
          name: 'Digital'
        }, {
          id: 'c599e43b1a1c34d5a323aedf75d3adf6',
          name: 'Service'
        }, {
          id: 'b6ccc1830db4b1babeb06a9ac5f6dd76',
          name: 'Advanced'
        }]
      }
    }],
    sku: [{
      name: 'SKU Values',
      slug: 'sku-values',
      type: 'CommercePropValues',
      required: true,
      editable: true
    }, {
      name: 'Product',
      slug: 'product',
      type: 'ItemRef',
      required: true,
      editable: true,
      validations: {
        collectionId: null // Will be populated with correct value at creation.

      }
    }, {
      name: 'Main Image',
      slug: 'main-image',
      type: 'ImageRef',
      required: false,
      editable: true,
      validations: {
        acceptedExtensions: ['jpeg', 'jpg', 'gif', 'png'] // To prevent upload svg as product image, as it is not render properly in Gmail web client

      }
    }, {
      name: 'More Images',
      slug: 'more-images',
      type: 'Set',
      innerType: 'ImageRef',
      required: false,
      editable: true,
      validations: {
        acceptedExtensions: ['jpeg', 'jpg', 'gif', 'png'] // To prevent upload svg as product image, as it is not render properly in Gmail web client

      }
    }, {
      name: 'Price',
      slug: 'price',
      type: 'CommercePrice',
      required: true,
      editable: true
    }, {
      name: 'Compare-at price',
      slug: 'compare-at-price',
      type: 'CommercePrice',
      required: false,
      editable: true
    }, {
      name: 'Downloads',
      slug: 'download-files',
      type: 'Set',
      innerType: 'ExtFileRef',
      required: false,
      editable: true
    }, {
      name: 'Subscription Plan',
      slug: 'ec-sku-subscription-plan',
      type: 'SubscriptionPlan',
      required: false,
      editable: true
    }, {
      name: 'Width',
      slug: 'width',
      type: 'Number',
      required: false,
      editable: true,
      validations: {
        minValue: 0
      }
    }, {
      name: 'Length',
      slug: 'length',
      type: 'Number',
      required: false,
      editable: true,
      validations: {
        minValue: 0
      }
    }, {
      name: 'Height',
      slug: 'height',
      type: 'Number',
      required: false,
      editable: true,
      validations: {
        minValue: 0
      }
    }, {
      name: 'Weight',
      slug: 'weight',
      type: 'Number',
      required: false,
      editable: true,
      validations: {
        minValue: 0
      }
    }, {
      name: 'SKU',
      slug: 'sku',
      type: 'PlainText',
      required: false,
      editable: true,
      validations: {
        singleLine: true
      }
    }, {
      name: 'Billing method',
      slug: 'ec-sku-billing-method',
      type: 'EnumOption',
      required: false,
      editable: true,
      validations: {
        enumName: 'BillingMethods'
      }
    }]
  };

  api.dynamoCollectionDefaultFieldSlugs = function () {
    var ret = [];
    api.dynamoCollectionDefaultFields.forEach(function (field) {
      ret.push(field.slug);
    });
    return ret;
  }();

  api.frontEndBlacklistFieldSlugs = function () {
    var ret = [];
    return ret.concat(api.dynamoCollectionDefaultFieldSlugs).concat(api.FIELD_NAME_BLACKLIST);
  }();

  api.frontEndBlacklistFieldNames = function () {
    var ret = [];
    api.dynamoCollectionDefaultFields.forEach(function (field) {
      ret.push(field.name);
    });
    return ret;
  }();

  api.enumOptionValueSets = {
    TaxCategories: ['books', 'books-religious', 'books-textbook', 'clothing', 'clothing-swimwear', 'digital-goods', 'digital-service', 'drugs-non-prescription', 'drugs-prescription', 'food-bottled-water', 'food-candy', 'food-groceries', 'food-prepared', 'food-soda', 'food-supplements', 'magazine-individual', 'magazine-subscription', 'service-admission', 'service-advertising', 'service-dry-cleaning', 'service-hairdressing', 'service-installation', 'service-miscellaneous', 'service-parking', 'service-printing', 'service-professional', 'service-repair', 'service-training', 'standard-exempt', 'standard-taxable'],
    BillingMethods: ['one-time', 'subscription'],
    BillingPeriods: ['day', 'week', 'month', 'year']
  };
  api.enumOptionMapSets = {
    TaxCategories: [{
      code: 'standard-taxable',
      name: 'Standard automatic tax calculation'
    }, {
      code: 'standard-exempt',
      name: 'Exempt from taxes'
    }, {
      code: 'books',
      name: 'Books'
    }, {
      code: 'books-religious',
      name: 'Books - Religious'
    }, {
      code: 'books-textbook',
      name: 'Books - Textbooks'
    }, {
      code: 'clothing',
      name: 'Clothing'
    }, {
      code: 'clothing-swimwear',
      name: 'Clothing - Swimwear'
    }, {
      code: 'digital-goods',
      name: 'Digital Goods'
    }, {
      code: 'digital-service',
      name: 'Digital Services'
    }, {
      code: 'drugs-non-prescription',
      name: 'Drugs - Non-Prescription'
    }, {
      code: 'drugs-prescription',
      name: 'Drugs - Prescription'
    }, {
      code: 'food-bottled-water',
      name: 'Food - Bottled Water'
    }, {
      code: 'food-candy',
      name: 'Food - Candy'
    }, {
      code: 'food-groceries',
      name: 'Food - Groceries'
    }, {
      code: 'food-prepared',
      name: 'Food - Prepared'
    }, {
      code: 'food-soda',
      name: 'Food - Soda'
    }, {
      code: 'food-supplements',
      name: 'Food - Supplements'
    }, {
      code: 'magazine-individual',
      name: 'Magazine - Individual'
    }, {
      code: 'magazine-subscription',
      name: 'Magazine - Subscription'
    }, {
      code: 'service-admission',
      name: 'Service - Admission'
    }, {
      code: 'service-advertising',
      name: 'Service - Advertising'
    }, {
      code: 'service-dry-cleaning',
      name: 'Service - Dry Cleaning'
    }, {
      code: 'service-hairdressing',
      name: 'Service - Hairdressing'
    }, {
      code: 'service-installation',
      name: 'Service - Installation'
    }, {
      code: 'service-miscellaneous',
      name: 'Service - Miscellaneous'
    }, {
      code: 'service-parking',
      name: 'Service - Parking'
    }, {
      code: 'service-printing',
      name: 'Service - Printing'
    }, {
      code: 'service-professional',
      name: 'Service - Professional'
    }, {
      code: 'service-repair',
      name: 'Service - Repair'
    }, {
      code: 'service-training',
      name: 'Service - Training'
    }],
    BillingMethods: [{
      code: 'one-time',
      name: 'One-time payment'
    }, {
      code: 'subscription',
      name: 'Subscription'
    }],
    BillingPeriods: [{
      code: 'day',
      name: 'Day'
    }, {
      code: 'week',
      name: 'Week'
    }, {
      code: 'month',
      name: 'Month'
    }, {
      code: 'year',
      name: 'Year'
    }]
  };
  api.dynamoPageSlugPrefix = 'detail_';
  api.collectionPresets = [{
    id: 'blog-post',
    // The id field is not important, any random field that doesn't clash with other ids defined here is good.
    name: 'Blog Post',
    // Name in drop down
    properties: {
      editable: true,
      // Editable by contributors
      name: 'Blog Post',
      slug: 'blog-post',
      fields: [{
        name: 'Blog Post Body',
        type: 'RichText',
        required: true,
        validations: {
          minLength: 20
        }
      }, {
        name: 'Thumbnail Image',
        type: 'ImageRef',
        required: false
      }, {
        name: 'Main Image',
        type: 'ImageRef',
        required: false
      }, {
        name: 'Category',
        slug: 'category',
        type: 'PlainText',
        validations: {
          minLength: 1,
          maxLength: 100
        }
      }]
    }
  }];
  api.sortableFieldTypes = ['PlainText', 'Number', 'Date', 'Bool'];
  api.expandableFieldTypes = ['ItemRef', 'ItemRefSet', 'Option'];
  api.heavyExpandableFieldTypes = ['ItemRef', 'ItemRefSet'];
  api.richTextSanitizerOptions = {
    tags: {
      p: true,
      div: {
        "class": true
      },
      span: true,
      a: {
        href: true
      },
      strong: true,
      ul: true,
      ol: true,
      li: true,
      br: true,
      b: true,
      i: true,
      h1: true,
      h2: true,
      h3: true,
      h4: true,
      h5: true,
      h6: true,
      img: {
        src: true,
        style: true
      },
      blockquote: true
    }
  }; // NOTE: Some of these versions have corresponding constants in /render/lib/versions.js

  api.MIN_VERSION_CONDITIONAL_VISIBILITY = '1.1.0';
  api.MIN_VERSION_JSON_RENDER = '2.0.2';
  api.MIN_VERSION_EXPANDED_TEXT_NODES = '3.0.0'; // TODO autogenerate APP_AND_DATA_VERSION
  // it's value should be MIGRATIONS.length from shared/constants/JsonDomMigrations.js

  api.APP_AND_DATA_VERSION = 88;
  api.CURRENT_PUBLISH_VERSION = api.APP_AND_DATA_VERSION; // This is used to force stale clients to refresh. It only needs to be
  // incremented when we want to trigger the 24 hour countdown that forces stale
  // clients to refresh. Technically the client version updates any time someone
  // pushes front-end code to prod, don't worry about considering those pushes /
  // changes in this semver.
  // When incrementing it just increment the segment that makes most sense for
  // the changes that led you to want to force stale clients to refresh by 1.
  // and add a comment here to log that history.
  //
  // 1.0.0 : The initial rollout of stale client auto-refreshing
  // 1.0.1 : Migrating Lightbox bindings to the new *.bind.media data path
  // 1.0.2 : Migrating Twitter to Data Types structure
  // 1.0.3 : Migrating data.dyn.query.fields data structure

  api.MIN_CLIENT_VERSION = '1.0.4'; // NOTE: the CLIENT_VERSION should always be equal to MIN_CLIENT_VERSION in prod.
  // That way refreshing the client gets the latest version along with the app code.
  // CLIENT_VERSION only exists to make local QA faster and easier. CLIENT_VERSION is
  // imported by the front-end app code and MIN_CLIENT_VERSION is imported by the
  // server code to compare the value and ensure the front-end's version matches the
  // backend's MIN_CLIENT_VERSION.

  api.CLIENT_VERSION = api.MIN_CLIENT_VERSION;
  api.SITE_PLANS = {
    "static": {
      price: 1500,
      numCollaborators: 0,
      numCollections: 0,
      pageViews: 25000,
      planId: 'hosting-static01',
      stripePlanName: 'Basic Hosting',
      currency: 'usd',
      maxPages: 80,
      metadata: {
        type: 'static'
      }
    },
    cms: {
      price: 2000,
      numCollaborators: 1,
      numCollections: 20,
      pageViews: 25000,
      maxItems: 500,
      planId: 'hosting-cms01',
      stripePlanName: 'CMS Hosting',
      currency: 'usd',
      maxPages: 80,
      metadata: {
        type: 'cms'
      }
    }
  };
  api.SITE_STRIPE_PLANS = {
    "static": {
      free: {
        price: 1500,
        brandingPrice: 1000,
        interval: 'month',
        planId: 'hosting-static01-free',
        stripePlanName: 'Basic Hosting',
        currency: 'usd'
      },
      micro: {
        price: 1500,
        brandingPrice: 1000,
        interval: 'month',
        planId: 'hosting-static01-micro',
        stripePlanName: 'Basic Hosting (Micro)',
        currency: 'usd'
      },
      personal: {
        price: 500,
        brandingPrice: 1000,
        interval: 'month',
        planId: 'hosting-static01-personal',
        stripePlanName: 'Basic Hosting (Personal)',
        currency: 'usd'
      },
      professional: {
        price: 500,
        brandingPrice: 500,
        interval: 'month',
        planId: 'hosting-static01-professional',
        stripePlanName: 'Basic Hosting (Professional)',
        currency: 'usd'
      }
    },
    cms: {
      free: {
        price: 2000,
        brandingPrice: 1000,
        interval: 'month',
        planId: 'hosting-cms01-free',
        stripePlanName: 'CMS Hosting',
        currency: 'usd'
      },
      micro: {
        price: 2000,
        brandingPrice: 1000,
        interval: 'month',
        planId: 'hosting-cms01-micro',
        stripePlanName: 'CMS Hosting (Micro)',
        currency: 'usd'
      },
      personal: {
        price: 1000,
        brandingPrice: 1000,
        interval: 'month',
        planId: 'hosting-cms01-personal',
        stripePlanName: 'CMS Hosting (Personal)',
        currency: 'usd'
      },
      professional: {
        price: 1000,
        brandingPrice: 500,
        interval: 'month',
        planId: 'hosting-cms01-professional',
        stripePlanName: 'CMS Hosting (Professional)',
        currency: 'usd'
      }
    }
  }; // TODO: Remove this:

  api.SITE_STRIPE_YEARLY_PLANS = {
    "static": {
      free: {
        price: 1500 * 12,
        brandingPrice: 1000,
        interval: 'year',
        planId: 'hosting-static01-year-free',
        stripePlanName: 'Yearly Basic Hosting',
        currency: 'usd'
      },
      micro: {
        price: 1500 * 12,
        brandingPrice: 1000,
        interval: 'year',
        planId: 'hosting-static01-year-micro',
        stripePlanName: 'Yearly Basic Hosting (Micro)',
        currency: 'usd'
      },
      personal: {
        price: 500 * 12,
        brandingPrice: 1000,
        interval: 'year',
        planId: 'hosting-static01-year-personal',
        stripePlanName: 'Yearly Basic Hosting (Personal)',
        currency: 'usd'
      },
      professional: {
        price: 500 * 12,
        brandingPrice: 500,
        interval: 'year',
        planId: 'hosting-static01-year-professional',
        stripePlanName: 'Yearly Basic Hosting (Professional)',
        currency: 'usd'
      }
    },
    cms: {
      free: {
        price: 2000 * 12,
        brandingPrice: 1000,
        interval: 'year',
        planId: 'hosting-cms01-year-free',
        stripePlanName: 'Yearly CMS Hosting',
        currency: 'usd'
      },
      micro: {
        price: 2000 * 12,
        brandingPrice: 1000,
        interval: 'year',
        planId: 'hosting-cms01-year-micro',
        stripePlanName: 'Yearly CMS Hosting (Micro)',
        currency: 'usd'
      },
      personal: {
        price: 1000 * 12,
        brandingPrice: 1000,
        interval: 'year',
        planId: 'hosting-cms01-year-personal',
        stripePlanName: 'Yearly CMS Hosting (Personal)',
        currency: 'usd'
      },
      professional: {
        price: 1000 * 12,
        brandingPrice: 500,
        interval: 'year',
        planId: 'hosting-cms01-year-professional',
        stripePlanName: 'Yearly CMS Hosting (Professional)',
        currency: 'usd'
      }
    }
  };
  api.ADDITIONAL_PRICES = {
    pageViews: {
      mode: 'tier',
      price: 1000,
      forEach: 100000,
      after: 100000
    },
    cmsItems: {
      mode: 'tier',
      price: 1000,
      forEach: 500,
      after: 500
    },
    collaborators: {
      mode: 'tier',
      price: 600,
      forEach: 1,
      after: 1
    },
    formSubmissions: {
      mode: 'tier',
      price: 200,
      forEach: 100,
      after: 100
    },
    customBranding: {
      mode: 'bool',
      price: 1000 // Overridden by plan's branding price.

    }
  };
  api.DYNAMO_PLANS = {
    free: {
      price: {
        month: 0,
        year: 0,
        forms: 2,
        customDomain: 0
      },
      numFreeFormEntries: 500,
      maxPages: 2,
      maxSites: 2,
      maxPublicSites: 5,
      numExports: 0,
      canCustomFont: true,
      canSetTypeKit: true,
      numDomains: 0,
      numBackups: 20
    },
    micro: {
      price: {
        month: 1600,
        year: 1400 * 12,
        forms: 2,
        customDomain: 0
      },
      numFreeFormEntries: 500,
      maxPages: 100,
      maxSites: 1,
      maxPublicSites: 20,
      numDomains: 1,
      canCustomFont: true,
      canSetTypeKit: false,
      stripeIdPre: 'micro',
      name: 'Micro'
    },
    personal: {
      price: {
        month: 2000,
        year: 1600 * 12,
        forms: 1,
        customDomain: 499
      },
      numFreeFormEntries: 500,
      maxPages: 100,
      maxSites: 20,
      maxPublicSites: 100,
      numDomains: 0,
      canCustomFont: true,
      canSetTypeKit: true,
      stripeIdPre: 'personal',
      name: 'Personal',
      hostingDiscount: {
        "static": 66 / 100,
        cms: 50 / 100
      }
    },
    professional: {
      price: {
        month: 4200,
        year: 3500 * 12,
        forms: 1,
        customDomain: 499
      },
      numFreeFormEntries: 500,
      maxPages: 100,
      maxSites: 100,
      maxPublicSites: 100,
      numDomains: 0,
      canCustomFont: true,
      canSetTypeKit: true,
      stripeIdPre: 'professional',
      name: 'Professional',
      hostingDiscount: {
        "static": 66 / 100,
        cms: 50 / 100
      }
    }
  };
  api.ORG_DISCOUNT = {
    "static": api.DYNAMO_PLANS.professional.hostingDiscount["static"],
    // assuming static hosting is $15, static custom domains should cost $5 for orgs
    cms: api.DYNAMO_PLANS.professional.hostingDiscount.cms
  };
  api.ORG_PLANS = {
    small: {
      seats: 2,
      maxTemplates: 3,
      maxSites: 100,
      maxPages: 100,
      price: {
        month: 8400,
        year: 7800 * 12,
        customDomain: 499
      },
      stripeIdPre: 'team-small',
      name: 'Team Small'
    },
    medium: {
      seats: 4,
      maxTemplates: 6,
      maxSites: 200,
      maxPages: 100,
      price: {
        month: 16800,
        year: 15600 * 12,
        customDomain: 499
      },
      stripeIdPre: 'team-medium',
      name: 'Team Medium'
    },
    large: {
      seats: 8,
      maxTemplates: 12,
      maxSites: 400,
      maxPages: 100,
      price: {
        month: 33600,
        year: 31500 * 12,
        customDomain: 499
      },
      stripeIdPre: 'team-large',
      name: 'Team Large'
    }
  };
  api.managedBilling = {}; // https://en.wikipedia.org/wiki/Single_Euro_Payments_Area
  // For SEPA states, we have to also collect names / addresses / id documents for
  // anybody with more than 25% ownership of the company. Implementing this is a
  // massive PITA, so we'll filter this for now...

  api.managedBilling.sepaCountries = ['AT', 'BE', 'DK', 'FI', 'FR', 'DE', 'IE', 'IT', 'LU', 'NL', 'NO', 'SP', 'SE', 'GB'];
  api.managedBilling.supportedCountryList = [{
    code: 'AT',
    name: 'Austria',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'AU',
    name: 'Australia',
    status: '',
    bankMode: 'BSB',
    bankCurrencies: ['AUD']
  }, {
    code: 'BE',
    name: 'Belgium',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'CA',
    name: 'Canada',
    status: '',
    bankMode: 'TRANSIT',
    bankCurrencies: ['CAD', 'USD']
  }, {
    code: 'DK',
    name: 'Denmark',
    status: '',
    bankMode: 'IBAN',
    bankCurrencies: ['DKK', 'NOK', 'SEK', 'EUR', 'USD']
  }, {
    code: 'FI',
    name: 'Finland',
    status: '',
    bankMode: 'IBAN',
    bankCurrencies: ['DKK', 'NOK', 'SEK', 'EUR', 'USD']
  }, {
    code: 'FR',
    name: 'France',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'DE',
    name: 'Germany',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'IE',
    name: 'Ireland',
    status: '',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'IT',
    name: 'Italy',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'LU',
    name: 'Luxembourg',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'NL',
    name: 'Netherlands',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'NZ',
    name: 'New Zealand',
    status: 'Beta',
    bankMode: 'ROUTE',
    bankCurrencies: ['NZD', 'USD']
  }, {
    code: 'NO',
    name: 'Norway',
    status: '',
    bankMode: 'IBAN',
    bankCurrencies: ['DKK', 'NOK', 'SEK', 'EUR', 'USD']
  }, {
    code: 'PT',
    name: 'Portugal',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'ES',
    name: 'Spain',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'USD']
  }, {
    code: 'SE',
    name: 'Sweden',
    status: '',
    bankMode: 'IBAN',
    bankCurrencies: ['DKK', 'NOK', 'SEK', 'EUR', 'USD']
  }, {
    code: 'CH',
    name: 'Switzerland',
    status: 'Beta',
    bankMode: 'IBAN',
    bankCurrencies: ['CHF', 'EUR', 'USD']
  }, {
    code: 'GB',
    name: 'United Kingdom',
    status: '',
    bankMode: 'IBAN',
    bankCurrencies: ['EUR', 'GBP', 'USD']
  }, {
    code: 'US',
    name: 'United States',
    status: '',
    bankMode: 'ROUTE',
    bankCurrencies: ['USD']
  }]; // Note: These currencies are extracted by getting Stripe compatible currencies with:
  //
  // curl https://api.stripe.com/v1/country_specs\?limit\=100 -u $STRIPE_TEST_KEY: -G \
  //   | jq '.data|.[]|.supported_payment_currencies|.[]' \
  //   | sort \
  //   | uniq
  //
  // And then populating in the names from ISO 4217:
  //
  // Digit counts are also added. Stripe is treated as the source-of-truth for that number, even though their
  // numbers are often at odds with ISO 4217. Notes:
  //
  //  - CVE had a subunit (centavo), that has been discontinued. The ISO reflects this, but stripe sticks
  //    with 2 digits, since the currency is still commonly formatted as "1$00". ¯\_(ツ)_/¯
  //  - ISK had a subunit (eyrir) that was obsoleted in 2003, but Stripe sticks with 2 digits instead of
  //    the ISO's 0.
  //  - MGA is strange, since it's smallest denomination is a 1/5th piece (the Iraimbilanja), but is
  //    represented as a decimal, so the currency goes "1.3, 1.4, 2.0, ...". Stripe dodges this strangeness
  //    by ignoring that minimum unit, and so do we, since it has so little value.
  //  - UGX had a subunit (cent) that was discontinued in 2013. Stripe still counts it, tho, even though
  //    that cent is work 1/350000th of a penny.

  api.stripeCurrencyList = [{
    code: 'AED',
    digits: 2,
    minCharge: 0,
    name: 'United Arab Emirates Dirham'
  }, {
    code: 'AFN',
    digits: 2,
    minCharge: 0,
    name: 'Afghanistan Afghani'
  }, {
    code: 'ALL',
    digits: 2,
    minCharge: 0,
    name: 'Albanian Lek'
  }, {
    code: 'AMD',
    digits: 2,
    minCharge: 0,
    name: 'Armenia Dram'
  }, {
    code: 'ANG',
    digits: 2,
    minCharge: 0,
    name: 'Netherlands Antillean Gulden'
  }, {
    code: 'AOA',
    digits: 2,
    minCharge: 0,
    name: 'Angola Kwanza'
  }, {
    code: 'ARS',
    digits: 2,
    minCharge: 0,
    name: 'Argentine Peso'
  }, {
    code: 'AUD',
    digits: 2,
    minCharge: 50,
    name: 'Australian Dollar'
  }, {
    code: 'AWG',
    digits: 2,
    minCharge: 0,
    name: 'Aruban Florin'
  }, {
    code: 'AZN',
    digits: 2,
    minCharge: 0,
    name: 'Azerbaijan Manat'
  }, {
    code: 'BAM',
    digits: 2,
    minCharge: 0,
    name: 'Bosnia and Herzegovina Convertible Marka'
  }, {
    code: 'BBD',
    digits: 2,
    minCharge: 0,
    name: 'Barbadian Dollar'
  }, {
    code: 'BDT',
    digits: 2,
    minCharge: 0,
    name: 'Bangladeshi Taka'
  }, {
    code: 'BGN',
    digits: 2,
    minCharge: 0,
    name: 'Bulgaria Lev'
  }, {
    code: 'BIF',
    digits: 0,
    minCharge: 0,
    name: 'Burundian Franc'
  }, {
    code: 'BMD',
    digits: 2,
    minCharge: 0,
    name: 'Bermudian Dollar'
  }, {
    code: 'BND',
    digits: 2,
    minCharge: 0,
    name: 'Brunei Dollar'
  }, {
    code: 'BOB',
    digits: 2,
    minCharge: 0,
    name: 'Bolivian Boliviano'
  }, {
    code: 'BRL',
    digits: 2,
    minCharge: 50,
    name: 'Brazilian Real'
  }, {
    code: 'BSD',
    digits: 2,
    minCharge: 0,
    name: 'Bahamian Dollar'
  }, {
    code: 'BWP',
    digits: 2,
    minCharge: 0,
    name: 'Botswana Pula'
  }, {
    code: 'BZD',
    digits: 2,
    minCharge: 0,
    name: 'Belize Dollar'
  }, {
    code: 'CAD',
    digits: 2,
    minCharge: 50,
    name: 'Canadian Dollar'
  }, {
    code: 'CDF',
    digits: 2,
    minCharge: 0,
    name: 'Congo/Kinshasa Franc'
  }, {
    code: 'CHF',
    digits: 2,
    minCharge: 50,
    name: 'Swiss Franc'
  }, {
    code: 'CLP',
    digits: 0,
    minCharge: 0,
    name: 'Chilean Peso'
  }, {
    code: 'CNY',
    digits: 2,
    minCharge: 0,
    name: 'Chinese Renminbi Yuan'
  }, {
    code: 'COP',
    digits: 2,
    minCharge: 0,
    name: 'Colombian Peso'
  }, {
    code: 'CRC',
    digits: 2,
    minCharge: 0,
    name: 'Costa Rican Colón'
  }, {
    code: 'CVE',
    digits: 2,
    minCharge: 0,
    name: 'Cape Verdean Escudo'
  }, // See above.
  {
    code: 'CZK',
    digits: 2,
    minCharge: 0,
    name: 'Czech Koruna'
  }, {
    code: 'DJF',
    digits: 0,
    minCharge: 0,
    name: 'Djiboutian Franc'
  }, {
    code: 'DKK',
    digits: 2,
    minCharge: 250,
    name: 'Danish Krone'
  }, {
    code: 'DOP',
    digits: 2,
    minCharge: 0,
    name: 'Dominican Peso'
  }, {
    code: 'DZD',
    digits: 2,
    minCharge: 0,
    name: 'Algerian Dinar'
  }, {
    code: 'EGP',
    digits: 2,
    minCharge: 0,
    name: 'Egyptian Pound'
  }, {
    code: 'ETB',
    digits: 2,
    minCharge: 0,
    name: 'Ethiopian Birr'
  }, {
    code: 'EUR',
    digits: 2,
    minCharge: 50,
    name: 'Euro'
  }, {
    code: 'FJD',
    digits: 2,
    minCharge: 0,
    name: 'Fijian Dollar'
  }, {
    code: 'FKP',
    digits: 2,
    minCharge: 0,
    name: 'Falkland Islands Pound'
  }, {
    code: 'GBP',
    digits: 2,
    minCharge: 30,
    name: 'British Pound'
  }, {
    code: 'GEL',
    digits: 2,
    minCharge: 0,
    name: 'Georgia Lari'
  }, {
    code: 'GIP',
    digits: 2,
    minCharge: 0,
    name: 'Gibraltar Pound'
  }, {
    code: 'GMD',
    digits: 2,
    minCharge: 0,
    name: 'Gambian Dalasi'
  }, {
    code: 'GNF',
    digits: 0,
    minCharge: 0,
    name: 'Guinean Franc'
  }, {
    code: 'GTQ',
    digits: 2,
    minCharge: 0,
    name: 'Guatemalan Quetzal'
  }, {
    code: 'GYD',
    digits: 2,
    minCharge: 0,
    name: 'Guyanese Dollar'
  }, {
    code: 'HKD',
    digits: 2,
    minCharge: 400,
    name: 'Hong Kong Dollar'
  }, {
    code: 'HNL',
    digits: 2,
    minCharge: 0,
    name: 'Honduran Lempira'
  }, {
    code: 'HRK',
    digits: 2,
    minCharge: 0,
    name: 'Croatian Kuna'
  }, {
    code: 'HTG',
    digits: 2,
    minCharge: 0,
    name: 'Haitian Gourde'
  }, {
    code: 'HUF',
    digits: 2,
    minCharge: 0,
    name: 'Hungarian Forint'
  }, {
    code: 'IDR',
    digits: 2,
    minCharge: 0,
    name: 'Indonesian Rupiah'
  }, {
    code: 'ILS',
    digits: 2,
    minCharge: 0,
    name: 'Israeli New Sheqel'
  }, {
    code: 'INR',
    digits: 2,
    minCharge: 50,
    name: 'Indian Rupee'
  }, {
    code: 'ISK',
    digits: 2,
    minCharge: 0,
    name: 'Icelandic Króna'
  }, // See above.
  {
    code: 'JMD',
    digits: 2,
    minCharge: 0,
    name: 'Jamaican Dollar'
  }, {
    code: 'JPY',
    digits: 0,
    minCharge: 50,
    name: 'Japanese Yen'
  }, {
    code: 'KES',
    digits: 2,
    minCharge: 0,
    name: 'Kenyan Shilling'
  }, {
    code: 'KGS',
    digits: 2,
    minCharge: 0,
    name: 'Kyrgyzstan Som'
  }, {
    code: 'KHR',
    digits: 2,
    minCharge: 0,
    name: 'Cambodian Riel'
  }, {
    code: 'KMF',
    digits: 0,
    minCharge: 0,
    name: 'Comorian Franc'
  }, {
    code: 'KRW',
    digits: 0,
    minCharge: 0,
    name: 'South Korean Won'
  }, {
    code: 'KYD',
    digits: 2,
    minCharge: 0,
    name: 'Cayman Islands Dollar'
  }, {
    code: 'KZT',
    digits: 2,
    minCharge: 0,
    name: 'Kazakhstani Tenge'
  }, {
    code: 'LAK',
    digits: 2,
    minCharge: 0,
    name: 'Lao Kip'
  }, {
    code: 'LBP',
    digits: 2,
    minCharge: 0,
    name: 'Lebanese Pound'
  }, {
    code: 'LKR',
    digits: 2,
    minCharge: 0,
    name: 'Sri Lankan Rupee'
  }, {
    code: 'LRD',
    digits: 2,
    minCharge: 0,
    name: 'Liberian Dollar'
  }, {
    code: 'LSL',
    digits: 2,
    minCharge: 0,
    name: 'Lesotho Loti'
  }, {
    code: 'MAD',
    digits: 2,
    minCharge: 0,
    name: 'Moroccan Dirham'
  }, {
    code: 'MDL',
    digits: 2,
    minCharge: 0,
    name: 'Moldovan Leu'
  }, {
    code: 'MGA',
    digits: 0,
    minCharge: 0,
    name: 'Madagascar Ariary'
  }, // See above.
  {
    code: 'MKD',
    digits: 2,
    minCharge: 0,
    name: 'Macedonia Denar'
  }, {
    code: 'MMK',
    digits: 2,
    minCharge: 0,
    name: 'Myanmar (Burma) Kyat'
  }, {
    code: 'MNT',
    digits: 2,
    minCharge: 0,
    name: 'Mongolian Tögrög'
  }, {
    code: 'MOP',
    digits: 2,
    minCharge: 0,
    name: 'Macanese Pataca'
  }, {
    code: 'MRO',
    digits: 2,
    minCharge: 0,
    name: 'Mauritanian Ouguiya'
  }, {
    code: 'MUR',
    digits: 2,
    minCharge: 0,
    name: 'Mauritian Rupee'
  }, {
    code: 'MVR',
    digits: 2,
    minCharge: 0,
    name: 'Maldivian Rufiyaa'
  }, {
    code: 'MWK',
    digits: 2,
    minCharge: 0,
    name: 'Malawian Kwacha'
  }, {
    code: 'MXN',
    digits: 2,
    minCharge: 1000,
    name: 'Mexican Peso'
  }, {
    code: 'MYR',
    digits: 2,
    minCharge: 200,
    name: 'Malaysian Ringgit'
  }, {
    code: 'MZN',
    digits: 2,
    minCharge: 0,
    name: 'Mozambique Metical'
  }, {
    code: 'NAD',
    digits: 2,
    minCharge: 0,
    name: 'Namibian Dollar'
  }, {
    code: 'NGN',
    digits: 2,
    minCharge: 0,
    name: 'Nigerian Naira'
  }, {
    code: 'NIO',
    digits: 2,
    minCharge: 0,
    name: 'Nicaraguan Córdoba'
  }, {
    code: 'NOK',
    digits: 2,
    minCharge: 300,
    name: 'Norwegian Krone'
  }, {
    code: 'NPR',
    digits: 2,
    minCharge: 0,
    name: 'Nepalese Rupee'
  }, {
    code: 'NZD',
    digits: 2,
    minCharge: 50,
    name: 'New Zealand Dollar'
  }, {
    code: 'PAB',
    digits: 2,
    minCharge: 0,
    name: 'Panamanian Balboa'
  }, {
    code: 'PEN',
    digits: 2,
    minCharge: 0,
    name: 'Peruvian Nuevo Sol'
  }, {
    code: 'PGK',
    digits: 2,
    minCharge: 0,
    name: 'Papua New Guinean Kina'
  }, {
    code: 'PHP',
    digits: 2,
    minCharge: 0,
    name: 'Philippine Peso'
  }, {
    code: 'PKR',
    digits: 2,
    minCharge: 0,
    name: 'Pakistani Rupee'
  }, {
    code: 'PLN',
    digits: 2,
    minCharge: 200,
    name: 'Polish Złoty'
  }, {
    code: 'PYG',
    digits: 0,
    minCharge: 0,
    name: 'Paraguayan Guaraní'
  }, {
    code: 'QAR',
    digits: 2,
    minCharge: 0,
    name: 'Qatari Riyal'
  }, {
    code: 'RON',
    digits: 2,
    minCharge: 0,
    name: 'Romania Leu'
  }, {
    code: 'RSD',
    digits: 2,
    minCharge: 0,
    name: 'Serbia Dinar'
  }, {
    code: 'RUB',
    digits: 2,
    minCharge: 0,
    name: 'Russian Ruble'
  }, {
    code: 'RWF',
    digits: 0,
    minCharge: 0,
    name: 'Rwanda Franc'
  }, {
    code: 'SAR',
    digits: 2,
    minCharge: 0,
    name: 'Saudi Riyal'
  }, {
    code: 'SBD',
    digits: 2,
    minCharge: 0,
    name: 'Solomon Islands Dollar'
  }, {
    code: 'SCR',
    digits: 2,
    minCharge: 0,
    name: 'Seychellois Rupee'
  }, {
    code: 'SEK',
    digits: 2,
    minCharge: 300,
    name: 'Swedish Krona'
  }, {
    code: 'SGD',
    digits: 2,
    minCharge: 50,
    name: 'Singapore Dollar'
  }, {
    code: 'SHP',
    digits: 2,
    minCharge: 0,
    name: 'Saint Helenian Pound'
  }, {
    code: 'SLL',
    digits: 2,
    minCharge: 0,
    name: 'Sierra Leonean Leone'
  }, {
    code: 'SOS',
    digits: 2,
    minCharge: 0,
    name: 'Somali Shilling'
  }, {
    code: 'SRD',
    digits: 2,
    minCharge: 0,
    name: 'Suriname Dollar'
  }, {
    code: 'STD',
    digits: 2,
    minCharge: 0,
    name: 'São Tomé and Príncipe Dobra'
  }, {
    code: 'SZL',
    digits: 2,
    minCharge: 0,
    name: 'Swazi Lilangeni'
  }, {
    code: 'THB',
    digits: 2,
    minCharge: 0,
    name: 'Thai Baht'
  }, {
    code: 'TJS',
    digits: 2,
    minCharge: 0,
    name: 'Tajikistan Somoni'
  }, {
    code: 'TOP',
    digits: 2,
    minCharge: 0,
    name: 'Tongan Paʻanga'
  }, {
    code: 'TRY',
    digits: 2,
    minCharge: 0,
    name: 'Turkey Lira'
  }, {
    code: 'TTD',
    digits: 2,
    minCharge: 0,
    name: 'Trinidad and Tobago Dollar'
  }, {
    code: 'TWD',
    digits: 2,
    minCharge: 0,
    name: 'New Taiwan Dollar'
  }, {
    code: 'TZS',
    digits: 2,
    minCharge: 0,
    name: 'Tanzanian Shilling'
  }, {
    code: 'UAH',
    digits: 2,
    minCharge: 0,
    name: 'Ukrainian Hryvnia'
  }, {
    code: 'UGX',
    digits: 0,
    minCharge: 0,
    name: 'Ugandan Shilling'
  }, // See above.
  {
    code: 'USD',
    digits: 2,
    minCharge: 50,
    name: 'United States Dollar'
  }, {
    code: 'UYU',
    digits: 2,
    minCharge: 0,
    name: 'Uruguayan Peso'
  }, {
    code: 'UZS',
    digits: 2,
    minCharge: 0,
    name: 'Uzbekistani Som'
  }, {
    code: 'VND',
    digits: 0,
    minCharge: 0,
    name: 'Vietnamese Đồng'
  }, {
    code: 'VUV',
    digits: 0,
    minCharge: 0,
    name: 'Vanuatu Vatu'
  }, {
    code: 'WST',
    digits: 2,
    minCharge: 0,
    name: 'Samoan Tala'
  }, {
    code: 'XAF',
    digits: 0,
    minCharge: 0,
    name: 'Central African Cfa Franc'
  }, {
    code: 'XCD',
    digits: 2,
    minCharge: 0,
    name: 'East Caribbean Dollar'
  }, {
    code: 'XOF',
    digits: 0,
    minCharge: 0,
    name: 'West African Cfa Franc'
  }, {
    code: 'XPF',
    digits: 0,
    minCharge: 0,
    name: 'Cfp Franc'
  }, {
    code: 'YER',
    digits: 2,
    minCharge: 0,
    name: 'Yemeni Rial'
  }, {
    code: 'ZAR',
    digits: 2,
    minCharge: 0,
    name: 'South African Rand'
  }, {
    code: 'ZMW',
    digits: 2,
    minCharge: 0,
    name: 'Zambia Kwacha'
  }]; // used to determine Stripe support for a currency

  api.stripeCurrencyCodes = {};

  for (index = 0; index < api.stripeCurrencyList.length; index++) {
    api.stripeCurrencyCodes[api.stripeCurrencyList[index].code] = true;
  } // Note: These currencies are extracted by getting Paypal compatible currencies from:
  //
  // curl https://developer.paypal.com/docs/api/reference/currency-codes
  //
  // And then populating in the names from ISO 4217:


  api.paypalCurrencyList = [{
    code: 'AUD',
    digits: 2,
    minCharge: 1,
    name: 'Australian Dollar'
  }, {
    code: 'BRL',
    digits: 2,
    minCharge: 1,
    name: 'Brazilian Real'
  }, {
    code: 'CAD',
    digits: 2,
    minCharge: 1,
    name: 'Canadian Dollar'
  }, {
    code: 'CZK',
    digits: 2,
    minCharge: 1,
    name: 'Czech Koruna'
  }, {
    code: 'DKK',
    digits: 2,
    minCharge: 1,
    name: 'Danish Krone'
  }, {
    code: 'EUR',
    digits: 2,
    minCharge: 1,
    name: 'Euro'
  }, {
    code: 'HKD',
    digits: 2,
    minCharge: 1,
    name: 'Hong Kong Dollar'
  }, // HUF is currently disabled, due to issues with PayPal's 0-decimal implementation
  // See: https://github.com/webflow/webflow/issues/32865
  // {code: 'HUF', digits: 0, minCharge: 1, name: 'Hungarian Forint'},
  {
    code: 'INR',
    digits: 2,
    minCharge: 1,
    name: 'Indian Rupee'
  }, {
    code: 'ILS',
    digits: 2,
    minCharge: 1,
    name: 'Israeli New Sheqel'
  }, {
    code: 'JPY',
    digits: 0,
    minCharge: 1,
    name: 'Japanese Yen'
  }, {
    code: 'MYR',
    digits: 2,
    minCharge: 1,
    name: 'Malaysian Ringgit'
  }, {
    code: 'MXN',
    digits: 2,
    minCharge: 1,
    name: 'Mexican Peso'
  }, {
    code: 'TWD',
    digits: 0,
    minCharge: 1,
    name: 'New Taiwan Dollar'
  }, {
    code: 'NZD',
    digits: 2,
    minCharge: 1,
    name: 'New Zealand Dollar'
  }, {
    code: 'NOK',
    digits: 2,
    minCharge: 1,
    name: 'Norwegian Krone'
  }, {
    code: 'PHP',
    digits: 2,
    minCharge: 1,
    name: 'Philippine Peso'
  }, {
    code: 'PLN',
    digits: 2,
    minCharge: 1,
    name: 'Polish Złoty'
  }, {
    code: 'GBP',
    digits: 2,
    minCharge: 1,
    name: 'British Pound'
  }, {
    code: 'RUB',
    digits: 2,
    minCharge: 1,
    name: 'Russian Ruble'
  }, {
    code: 'SGD',
    digits: 2,
    minCharge: 1,
    name: 'Singapore Dollar'
  }, {
    code: 'SEK',
    digits: 2,
    minCharge: 1,
    name: 'Swedish Krona'
  }, {
    code: 'CHF',
    digits: 2,
    minCharge: 1,
    name: 'Swiss Franc'
  }, {
    code: 'THB',
    digits: 2,
    minCharge: 1,
    name: 'Thai Baht'
  }, {
    code: 'USD',
    digits: 2,
    minCharge: 1,
    name: 'United States Dollar'
  }]; // used to determine PayPal support for a currency

  api.paypalCurrencyCodes = {};

  for (index = 0; index < api.paypalCurrencyList.length; index++) {
    api.paypalCurrencyCodes[api.paypalCurrencyList[index].code] = true;
  }

  api.popularCommerceCountryList = [{
    code: 'US',
    code3: 'USA',
    name: 'United States',
    currency: 'USD',
    units: 'imperial',
    priceIncludesTax: false,
    group: 'Popular countries'
  }, {
    code: 'GB',
    code3: 'GBR',
    name: 'United Kingdom',
    currency: 'GBP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'Popular countries'
  }, {
    code: 'CA',
    code3: 'CAN',
    name: 'Canada',
    currency: 'CAD',
    units: 'metric',
    priceIncludesTax: false,
    group: 'Popular countries'
  }]; // Built by running `./bin/babel-run ./ops/entrypoints/server/refreshCountryList`

  api.commerceCountryList = [{
    code: 'AF',
    code3: 'AFG',
    name: 'Afghanistan',
    currency: 'AFN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AX',
    code3: 'ALA',
    name: 'Aland Islands',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AL',
    code3: 'ALB',
    name: 'Albania',
    currency: 'ALL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'DZ',
    code3: 'DZA',
    name: 'Algeria',
    currency: 'DZD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AS',
    code3: 'ASM',
    name: 'American Samoa',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AD',
    code3: 'AND',
    name: 'Andorra',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AO',
    code3: 'AGO',
    name: 'Angola',
    currency: 'AOA',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AI',
    code3: 'AIA',
    name: 'Anguilla',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AG',
    code3: 'ATG',
    name: 'Antigua and Barbuda',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AR',
    code3: 'ARG',
    name: 'Argentina',
    currency: 'ARS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AM',
    code3: 'ARM',
    name: 'Armenia',
    currency: 'AMD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AW',
    code3: 'ABW',
    name: 'Aruba',
    currency: 'AWG',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AU',
    code3: 'AUS',
    name: 'Australia',
    currency: 'AUD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AT',
    code3: 'AUT',
    name: 'Austria',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AZ',
    code3: 'AZE',
    name: 'Azerbaijan',
    currency: 'AZN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BS',
    code3: 'BHS',
    name: 'Bahamas',
    currency: 'BSD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BH',
    code3: 'BHR',
    name: 'Bahrain',
    currency: 'BHD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BD',
    code3: 'BGD',
    name: 'Bangladesh',
    currency: 'BDT',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BB',
    code3: 'BRB',
    name: 'Barbados',
    currency: 'BBD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BY',
    code3: 'BLR',
    name: 'Belarus',
    currency: 'BYN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BE',
    code3: 'BEL',
    name: 'Belgium',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BZ',
    code3: 'BLZ',
    name: 'Belize',
    currency: 'BZD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BJ',
    code3: 'BEN',
    name: 'Benin',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BM',
    code3: 'BMU',
    name: 'Bermuda',
    currency: 'BMD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BT',
    code3: 'BTN',
    name: 'Bhutan',
    currency: 'BTN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BO',
    code3: 'BOL',
    name: 'Bolivia',
    currency: 'BOB',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BQ',
    code3: 'BES',
    name: 'Bonaire, Saint Eustatius and Saba',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BA',
    code3: 'BIH',
    name: 'Bosnia and Herzegovina',
    currency: 'BAM',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BW',
    code3: 'BWA',
    name: 'Botswana',
    currency: 'BWP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BR',
    code3: 'BRA',
    name: 'Brazil',
    currency: 'BRL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IO',
    code3: 'IOT',
    name: 'British Indian Ocean Territory',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'VG',
    code3: 'VGB',
    name: 'British Virgin Islands',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BN',
    code3: 'BRN',
    name: 'Brunei',
    currency: 'BND',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BG',
    code3: 'BGR',
    name: 'Bulgaria',
    currency: 'BGN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BF',
    code3: 'BFA',
    name: 'Burkina Faso',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BI',
    code3: 'BDI',
    name: 'Burundi',
    currency: 'BIF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KH',
    code3: 'KHM',
    name: 'Cambodia',
    currency: 'KHR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CM',
    code3: 'CMR',
    name: 'Cameroon',
    currency: 'XAF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CA',
    code3: 'CAN',
    name: 'Canada',
    currency: 'CAD',
    units: 'metric',
    priceIncludesTax: false,
    group: 'All countries'
  }, {
    code: 'CV',
    code3: 'CPV',
    name: 'Cape Verde',
    currency: 'CVE',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KY',
    code3: 'CYM',
    name: 'Cayman Islands',
    currency: 'KYD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CF',
    code3: 'CAF',
    name: 'Central African Republic',
    currency: 'XAF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TD',
    code3: 'TCD',
    name: 'Chad',
    currency: 'XAF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CL',
    code3: 'CHL',
    name: 'Chile',
    currency: 'CLP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CN',
    code3: 'CHN',
    name: 'China',
    currency: 'CNY',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CX',
    code3: 'CXR',
    name: 'Christmas Island',
    currency: 'AUD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CC',
    code3: 'CCK',
    name: 'Cocos Islands',
    currency: 'AUD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CO',
    code3: 'COL',
    name: 'Colombia',
    currency: 'COP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KM',
    code3: 'COM',
    name: 'Comoros',
    currency: 'KMF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CK',
    code3: 'COK',
    name: 'Cook Islands',
    currency: 'NZD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CR',
    code3: 'CRI',
    name: 'Costa Rica',
    currency: 'CRC',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'HR',
    code3: 'HRV',
    name: 'Croatia',
    currency: 'HRK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CU',
    code3: 'CUB',
    name: 'Cuba',
    currency: 'CUP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CW',
    code3: 'CUW',
    name: 'Curacao',
    currency: 'ANG',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CY',
    code3: 'CYP',
    name: 'Cyprus',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CZ',
    code3: 'CZE',
    name: 'Czechia',
    currency: 'CZK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CD',
    code3: 'COD',
    name: 'Democratic Republic of the Congo',
    currency: 'CDF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'DK',
    code3: 'DNK',
    name: 'Denmark',
    currency: 'DKK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'DJ',
    code3: 'DJI',
    name: 'Djibouti',
    currency: 'DJF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'DM',
    code3: 'DMA',
    name: 'Dominica',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'DO',
    code3: 'DOM',
    name: 'Dominican Republic',
    currency: 'DOP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'EC',
    code3: 'ECU',
    name: 'Ecuador',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'EG',
    code3: 'EGY',
    name: 'Egypt',
    currency: 'EGP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SV',
    code3: 'SLV',
    name: 'El Salvador',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GQ',
    code3: 'GNQ',
    name: 'Equatorial Guinea',
    currency: 'XAF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ER',
    code3: 'ERI',
    name: 'Eritrea',
    currency: 'ERN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'EE',
    code3: 'EST',
    name: 'Estonia',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ET',
    code3: 'ETH',
    name: 'Ethiopia',
    currency: 'ETB',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'FK',
    code3: 'FLK',
    name: 'Falkland Islands',
    currency: 'FKP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'FO',
    code3: 'FRO',
    name: 'Faroe Islands',
    currency: 'DKK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'FJ',
    code3: 'FJI',
    name: 'Fiji',
    currency: 'FJD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'FI',
    code3: 'FIN',
    name: 'Finland',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'FR',
    code3: 'FRA',
    name: 'France',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GF',
    code3: 'GUF',
    name: 'French Guiana',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PF',
    code3: 'PYF',
    name: 'French Polynesia',
    currency: 'XPF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TF',
    code3: 'ATF',
    name: 'French Southern Territories',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GA',
    code3: 'GAB',
    name: 'Gabon',
    currency: 'XAF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GM',
    code3: 'GMB',
    name: 'Gambia',
    currency: 'GMD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GE',
    code3: 'GEO',
    name: 'Georgia',
    currency: 'GEL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'DE',
    code3: 'DEU',
    name: 'Germany',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GH',
    code3: 'GHA',
    name: 'Ghana',
    currency: 'GHS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GI',
    code3: 'GIB',
    name: 'Gibraltar',
    currency: 'GIP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GR',
    code3: 'GRC',
    name: 'Greece',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GL',
    code3: 'GRL',
    name: 'Greenland',
    currency: 'DKK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GD',
    code3: 'GRD',
    name: 'Grenada',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GP',
    code3: 'GLP',
    name: 'Guadeloupe',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GU',
    code3: 'GUM',
    name: 'Guam',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GT',
    code3: 'GTM',
    name: 'Guatemala',
    currency: 'GTQ',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GG',
    code3: 'GGY',
    name: 'Guernsey',
    currency: 'GBP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GN',
    code3: 'GIN',
    name: 'Guinea',
    currency: 'GNF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GW',
    code3: 'GNB',
    name: 'Guinea-Bissau',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GY',
    code3: 'GUY',
    name: 'Guyana',
    currency: 'GYD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'HT',
    code3: 'HTI',
    name: 'Haiti',
    currency: 'HTG',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'HN',
    code3: 'HND',
    name: 'Honduras',
    currency: 'HNL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'HK',
    code3: 'HKG',
    name: 'Hong Kong',
    currency: 'HKD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'HU',
    code3: 'HUN',
    name: 'Hungary',
    currency: 'HUF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IS',
    code3: 'ISL',
    name: 'Iceland',
    currency: 'ISK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IN',
    code3: 'IND',
    name: 'India',
    currency: 'INR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ID',
    code3: 'IDN',
    name: 'Indonesia',
    currency: 'IDR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IR',
    code3: 'IRN',
    name: 'Iran',
    currency: 'IRR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IQ',
    code3: 'IRQ',
    name: 'Iraq',
    currency: 'IQD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IE',
    code3: 'IRL',
    name: 'Ireland',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IM',
    code3: 'IMN',
    name: 'Isle of Man',
    currency: 'GBP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IL',
    code3: 'ISR',
    name: 'Israel',
    currency: 'ILS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'IT',
    code3: 'ITA',
    name: 'Italy',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CI',
    code3: 'CIV',
    name: 'Ivory Coast',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'JM',
    code3: 'JAM',
    name: 'Jamaica',
    currency: 'JMD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'JP',
    code3: 'JPN',
    name: 'Japan',
    currency: 'JPY',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'JE',
    code3: 'JEY',
    name: 'Jersey',
    currency: 'GBP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'JO',
    code3: 'JOR',
    name: 'Jordan',
    currency: 'JOD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KZ',
    code3: 'KAZ',
    name: 'Kazakhstan',
    currency: 'KZT',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KE',
    code3: 'KEN',
    name: 'Kenya',
    currency: 'KES',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KI',
    code3: 'KIR',
    name: 'Kiribati',
    currency: 'AUD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'XK',
    code3: 'XKX',
    name: 'Kosovo',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KW',
    code3: 'KWT',
    name: 'Kuwait',
    currency: 'KWD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KG',
    code3: 'KGZ',
    name: 'Kyrgyzstan',
    currency: 'KGS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LA',
    code3: 'LAO',
    name: 'Laos',
    currency: 'LAK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LV',
    code3: 'LVA',
    name: 'Latvia',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LB',
    code3: 'LBN',
    name: 'Lebanon',
    currency: 'LBP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LS',
    code3: 'LSO',
    name: 'Lesotho',
    currency: 'LSL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LR',
    code3: 'LBR',
    name: 'Liberia',
    currency: 'LRD',
    units: 'imperial',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LY',
    code3: 'LBY',
    name: 'Libya',
    currency: 'LYD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LI',
    code3: 'LIE',
    name: 'Liechtenstein',
    currency: 'CHF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LT',
    code3: 'LTU',
    name: 'Lithuania',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LU',
    code3: 'LUX',
    name: 'Luxembourg',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MO',
    code3: 'MAC',
    name: 'Macao',
    currency: 'MOP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MK',
    code3: 'MKD',
    name: 'Macedonia',
    currency: 'MKD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MG',
    code3: 'MDG',
    name: 'Madagascar',
    currency: 'MGA',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MW',
    code3: 'MWI',
    name: 'Malawi',
    currency: 'MWK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MY',
    code3: 'MYS',
    name: 'Malaysia',
    currency: 'MYR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MV',
    code3: 'MDV',
    name: 'Maldives',
    currency: 'MVR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ML',
    code3: 'MLI',
    name: 'Mali',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MT',
    code3: 'MLT',
    name: 'Malta',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MH',
    code3: 'MHL',
    name: 'Marshall Islands',
    currency: 'USD',
    units: 'imperial',
    priceIncludesTax: false,
    group: 'All countries'
  }, {
    code: 'MQ',
    code3: 'MTQ',
    name: 'Martinique',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MR',
    code3: 'MRT',
    name: 'Mauritania',
    currency: 'MRO',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MU',
    code3: 'MUS',
    name: 'Mauritius',
    currency: 'MUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'YT',
    code3: 'MYT',
    name: 'Mayotte',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MX',
    code3: 'MEX',
    name: 'Mexico',
    currency: 'MXN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'FM',
    code3: 'FSM',
    name: 'Micronesia',
    currency: 'USD',
    units: 'imperial',
    priceIncludesTax: false,
    group: 'All countries'
  }, {
    code: 'MD',
    code3: 'MDA',
    name: 'Moldova',
    currency: 'MDL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MC',
    code3: 'MCO',
    name: 'Monaco',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MN',
    code3: 'MNG',
    name: 'Mongolia',
    currency: 'MNT',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ME',
    code3: 'MNE',
    name: 'Montenegro',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MS',
    code3: 'MSR',
    name: 'Montserrat',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MA',
    code3: 'MAR',
    name: 'Morocco',
    currency: 'MAD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MZ',
    code3: 'MOZ',
    name: 'Mozambique',
    currency: 'MZN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MM',
    code3: 'MMR',
    name: 'Myanmar',
    currency: 'MMK',
    units: 'imperial',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NA',
    code3: 'NAM',
    name: 'Namibia',
    currency: 'NAD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NR',
    code3: 'NRU',
    name: 'Nauru',
    currency: 'AUD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NP',
    code3: 'NPL',
    name: 'Nepal',
    currency: 'NPR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NL',
    code3: 'NLD',
    name: 'Netherlands',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NC',
    code3: 'NCL',
    name: 'New Caledonia',
    currency: 'XPF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NZ',
    code3: 'NZL',
    name: 'New Zealand',
    currency: 'NZD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NI',
    code3: 'NIC',
    name: 'Nicaragua',
    currency: 'NIO',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NE',
    code3: 'NER',
    name: 'Niger',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NG',
    code3: 'NGA',
    name: 'Nigeria',
    currency: 'NGN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NU',
    code3: 'NIU',
    name: 'Niue',
    currency: 'NZD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NF',
    code3: 'NFK',
    name: 'Norfolk Island',
    currency: 'AUD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KP',
    code3: 'PRK',
    name: 'North Korea',
    currency: 'KPW',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MP',
    code3: 'MNP',
    name: 'Northern Mariana Islands',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'NO',
    code3: 'NOR',
    name: 'Norway',
    currency: 'NOK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'OM',
    code3: 'OMN',
    name: 'Oman',
    currency: 'OMR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PK',
    code3: 'PAK',
    name: 'Pakistan',
    currency: 'PKR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PW',
    code3: 'PLW',
    name: 'Palau',
    currency: 'USD',
    units: 'imperial',
    priceIncludesTax: false,
    group: 'All countries'
  }, {
    code: 'PS',
    code3: 'PSE',
    name: 'Palestinian Territory',
    currency: 'ILS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PA',
    code3: 'PAN',
    name: 'Panama',
    currency: 'PAB',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PG',
    code3: 'PNG',
    name: 'Papua New Guinea',
    currency: 'PGK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PY',
    code3: 'PRY',
    name: 'Paraguay',
    currency: 'PYG',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PE',
    code3: 'PER',
    name: 'Peru',
    currency: 'PEN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PH',
    code3: 'PHL',
    name: 'Philippines',
    currency: 'PHP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PN',
    code3: 'PCN',
    name: 'Pitcairn',
    currency: 'NZD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PL',
    code3: 'POL',
    name: 'Poland',
    currency: 'PLN',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PT',
    code3: 'PRT',
    name: 'Portugal',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PR',
    code3: 'PRI',
    name: 'Puerto Rico',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'QA',
    code3: 'QAT',
    name: 'Qatar',
    currency: 'QAR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CG',
    code3: 'COG',
    name: 'Republic of the Congo',
    currency: 'XAF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'RE',
    code3: 'REU',
    name: 'Reunion',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'RO',
    code3: 'ROU',
    name: 'Romania',
    currency: 'RON',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'RU',
    code3: 'RUS',
    name: 'Russia',
    currency: 'RUB',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'RW',
    code3: 'RWA',
    name: 'Rwanda',
    currency: 'RWF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'BL',
    code3: 'BLM',
    name: 'Saint Barthelemy',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SH',
    code3: 'SHN',
    name: 'Saint Helena',
    currency: 'SHP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KN',
    code3: 'KNA',
    name: 'Saint Kitts and Nevis',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LC',
    code3: 'LCA',
    name: 'Saint Lucia',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'MF',
    code3: 'MAF',
    name: 'Saint Martin',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'PM',
    code3: 'SPM',
    name: 'Saint Pierre and Miquelon',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'VC',
    code3: 'VCT',
    name: 'Saint Vincent and the Grenadines',
    currency: 'XCD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'WS',
    code3: 'WSM',
    name: 'Samoa',
    currency: 'WST',
    units: 'imperial',
    priceIncludesTax: false,
    group: 'All countries'
  }, {
    code: 'SM',
    code3: 'SMR',
    name: 'San Marino',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ST',
    code3: 'STP',
    name: 'Sao Tome and Principe',
    currency: 'STD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SA',
    code3: 'SAU',
    name: 'Saudi Arabia',
    currency: 'SAR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SN',
    code3: 'SEN',
    name: 'Senegal',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'RS',
    code3: 'SRB',
    name: 'Serbia',
    currency: 'RSD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SC',
    code3: 'SYC',
    name: 'Seychelles',
    currency: 'SCR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SL',
    code3: 'SLE',
    name: 'Sierra Leone',
    currency: 'SLL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SG',
    code3: 'SGP',
    name: 'Singapore',
    currency: 'SGD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SX',
    code3: 'SXM',
    name: 'Sint Maarten',
    currency: 'ANG',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SK',
    code3: 'SVK',
    name: 'Slovakia',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SI',
    code3: 'SVN',
    name: 'Slovenia',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SB',
    code3: 'SLB',
    name: 'Solomon Islands',
    currency: 'SBD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SO',
    code3: 'SOM',
    name: 'Somalia',
    currency: 'SOS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ZA',
    code3: 'ZAF',
    name: 'South Africa',
    currency: 'ZAR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GS',
    code3: 'SGS',
    name: 'South Georgia and the South Sandwich Islands',
    currency: 'GBP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'KR',
    code3: 'KOR',
    name: 'South Korea',
    currency: 'KRW',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SS',
    code3: 'SSD',
    name: 'South Sudan',
    currency: 'SSP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ES',
    code3: 'ESP',
    name: 'Spain',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'LK',
    code3: 'LKA',
    name: 'Sri Lanka',
    currency: 'LKR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SD',
    code3: 'SDN',
    name: 'Sudan',
    currency: 'SDG',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SR',
    code3: 'SUR',
    name: 'Suriname',
    currency: 'SRD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SJ',
    code3: 'SJM',
    name: 'Svalbard and Jan Mayen',
    currency: 'NOK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SZ',
    code3: 'SWZ',
    name: 'Swaziland',
    currency: 'SZL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SE',
    code3: 'SWE',
    name: 'Sweden',
    currency: 'SEK',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'CH',
    code3: 'CHE',
    name: 'Switzerland',
    currency: 'CHF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'SY',
    code3: 'SYR',
    name: 'Syria',
    currency: 'SYP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TW',
    code3: 'TWN',
    name: 'Taiwan',
    currency: 'TWD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TJ',
    code3: 'TJK',
    name: 'Tajikistan',
    currency: 'TJS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TZ',
    code3: 'TZA',
    name: 'Tanzania',
    currency: 'TZS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TH',
    code3: 'THA',
    name: 'Thailand',
    currency: 'THB',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TL',
    code3: 'TLS',
    name: 'Timor Leste',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TG',
    code3: 'TGO',
    name: 'Togo',
    currency: 'XOF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TK',
    code3: 'TKL',
    name: 'Tokelau',
    currency: 'NZD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TO',
    code3: 'TON',
    name: 'Tonga',
    currency: 'TOP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TT',
    code3: 'TTO',
    name: 'Trinidad and Tobago',
    currency: 'TTD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TN',
    code3: 'TUN',
    name: 'Tunisia',
    currency: 'TND',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TR',
    code3: 'TUR',
    name: 'Turkey',
    currency: 'TRY',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TM',
    code3: 'TKM',
    name: 'Turkmenistan',
    currency: 'TMT',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TC',
    code3: 'TCA',
    name: 'Turks and Caicos Islands',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'TV',
    code3: 'TUV',
    name: 'Tuvalu',
    currency: 'AUD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'VI',
    code3: 'VIR',
    name: 'U.S. Virgin Islands',
    currency: 'USD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'UG',
    code3: 'UGA',
    name: 'Uganda',
    currency: 'UGX',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'UA',
    code3: 'UKR',
    name: 'Ukraine',
    currency: 'UAH',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'AE',
    code3: 'ARE',
    name: 'United Arab Emirates',
    currency: 'AED',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'GB',
    code3: 'GBR',
    name: 'United Kingdom',
    currency: 'GBP',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'UM',
    code3: 'UMI',
    name: 'United States Minor Outlying Islands',
    currency: 'USD',
    units: 'imperial',
    priceIncludesTax: false,
    group: 'All countries'
  }, {
    code: 'US',
    code3: 'USA',
    name: 'United States',
    currency: 'USD',
    units: 'imperial',
    priceIncludesTax: false,
    group: 'All countries'
  }, {
    code: 'UY',
    code3: 'URY',
    name: 'Uruguay',
    currency: 'UYU',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'UZ',
    code3: 'UZB',
    name: 'Uzbekistan',
    currency: 'UZS',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'VU',
    code3: 'VUT',
    name: 'Vanuatu',
    currency: 'VUV',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'VA',
    code3: 'VAT',
    name: 'Vatican',
    currency: 'EUR',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'VE',
    code3: 'VEN',
    name: 'Venezuela',
    currency: 'VES',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'VN',
    code3: 'VNM',
    name: 'Vietnam',
    currency: 'VND',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'WF',
    code3: 'WLF',
    name: 'Wallis and Futuna',
    currency: 'XPF',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'EH',
    code3: 'ESH',
    name: 'Western Sahara',
    currency: 'MAD',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'YE',
    code3: 'YEM',
    name: 'Yemen',
    currency: 'YER',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ZM',
    code3: 'ZMB',
    name: 'Zambia',
    currency: 'ZMW',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }, {
    code: 'ZW',
    code3: 'ZWE',
    name: 'Zimbabwe',
    currency: 'ZWL',
    units: 'metric',
    priceIncludesTax: true,
    group: 'All countries'
  }]; // selects country data from commerceCountryList based on COMMERCE_SUPPORTED_COUNTRY_LIST

  api.commerceSupportedCountryList = []; // used to determine if a country is supported by at least one availble payment provider

  api.commerceSupportedCountryCodes = {};

  for (index = 0; index < COMMERCE_SUPPORTED_COUNTRY_LIST.length; index++) {
    api.commerceSupportedCountryCodes[COMMERCE_SUPPORTED_COUNTRY_LIST[index]] = true;

    for (innerIndex = 0; innerIndex < api.commerceCountryList.length; innerIndex++) {
      if (api.commerceCountryList[innerIndex].code === COMMERCE_SUPPORTED_COUNTRY_LIST[index]) {
        api.commerceSupportedCountryList.push(api.commerceCountryList[innerIndex]);
        break;
      }
    }
  } // used to determine Stripe support for a country


  api.stripeCountryCodes = {};

  for (index = 0; index < STRIPE_COUNTRY_LIST.length; index++) {
    api.stripeCountryCodes[STRIPE_COUNTRY_LIST[index]] = true;
  } // used to determine PayPal support for a country


  api.paypalCountryCodes = {};

  for (index = 0; index < PAYPAL_COUNTRY_LIST.length; index++) {
    api.paypalCountryCodes[PAYPAL_COUNTRY_LIST[index]] = true;
  } // list of all the locales for the list of countries provided in commerceCountryList


  api.commerceCurrencyLocales = [{
    name: 'Afar',
    location: 'Djibouti',
    tag: 'aa-DJ'
  }, {
    name: 'Afar',
    location: 'Eritrea',
    tag: 'aa-ER'
  }, {
    name: 'Afar',
    location: 'Ethiopia',
    tag: 'aa-ET'
  }, {
    name: 'Afrikaans',
    location: 'Namibia',
    tag: 'af-NA'
  }, {
    name: 'Afrikaans',
    location: 'South Africa',
    tag: 'af-ZA'
  }, {
    name: 'Aghem',
    location: 'Cameroon',
    tag: 'agq-CM'
  }, {
    name: 'Akan',
    location: 'Ghana',
    tag: 'ak-GH'
  }, {
    name: 'Albanian',
    location: 'Albania',
    tag: 'sq-AL'
  }, {
    name: 'Alsatian',
    location: 'France',
    tag: 'gsw-FR'
  }, {
    name: 'Alsatian',
    location: 'Liechtenstein',
    tag: 'gsw-LI'
  }, {
    name: 'Alsatian',
    location: 'Switzerland',
    tag: 'gsw-CH'
  }, {
    name: 'Amharic',
    location: 'Ethiopia',
    tag: 'am-ET'
  }, {
    name: 'Arabic',
    location: 'Algeria',
    tag: 'ar-DZ'
  }, {
    name: 'Arabic',
    location: 'Bahrain',
    tag: 'ar-BH'
  }, {
    name: 'Arabic',
    location: 'Chad',
    tag: 'ar-TD'
  }, {
    name: 'Arabic',
    location: 'Comoros',
    tag: 'ar-KM'
  }, {
    name: 'Arabic',
    location: 'Djibouti',
    tag: 'ar-DJ'
  }, {
    name: 'Arabic',
    location: 'Egypt',
    tag: 'ar-EG'
  }, {
    name: 'Arabic',
    location: 'Eritrea',
    tag: 'ar-ER'
  }, {
    name: 'Arabic',
    location: 'Iraq',
    tag: 'ar-IQ'
  }, {
    name: 'Arabic',
    location: 'Israel',
    tag: 'ar-IL'
  }, {
    name: 'Arabic',
    location: 'Jordan',
    tag: 'ar-JO'
  }, {
    name: 'Arabic',
    location: 'Kuwait',
    tag: 'ar-KW'
  }, {
    name: 'Arabic',
    location: 'Lebanon',
    tag: 'ar-LB'
  }, {
    name: 'Arabic',
    location: 'Libya',
    tag: 'ar-LY'
  }, {
    name: 'Arabic',
    location: 'Mauritania',
    tag: 'ar-MR'
  }, {
    name: 'Arabic',
    location: 'Morocco',
    tag: 'ar-MA'
  }, {
    name: 'Arabic',
    location: 'Oman',
    tag: 'ar-OM'
  }, {
    name: 'Arabic',
    location: 'Qatar',
    tag: 'ar-QA'
  }, {
    name: 'Arabic',
    location: 'Saudi Arabia',
    tag: 'ar-SA'
  }, {
    name: 'Arabic',
    location: 'Somalia',
    tag: 'ar-SO'
  }, {
    name: 'Arabic',
    location: 'South Sudan',
    tag: 'ar-SS'
  }, {
    name: 'Arabic',
    location: 'Sudan',
    tag: 'ar-SD'
  }, {
    name: 'Arabic',
    location: 'Syria',
    tag: 'ar-SY'
  }, {
    name: 'Arabic',
    location: 'Tunisia',
    tag: 'ar-TN'
  }, {
    name: 'Arabic',
    location: 'Yemen',
    tag: 'ar-YE'
  }, {
    name: 'Armenian',
    location: 'Armenia',
    tag: 'hy-AM'
  }, {
    name: 'Assamese',
    location: 'India',
    tag: 'as-IN'
  }, {
    name: 'Asturian',
    location: 'Spain',
    tag: 'ast-ES'
  }, {
    name: 'Asu',
    location: 'Tanzania',
    tag: 'asa-TZ'
  }, {
    name: 'Azerbaijani (Cyrillic)',
    location: 'Azerbaijan',
    tag: 'az-Cyrl-AZ'
  }, {
    name: 'Azerbaijani (Latin)',
    location: 'Azerbaijan',
    tag: 'az-Latn-AZ'
  }, {
    name: 'Bafia',
    location: 'Cameroon',
    tag: 'ksf-CM'
  }, {
    name: 'Bamanankan (Latin)',
    location: 'Mali',
    tag: 'bm-Latn-ML'
  }, {
    name: 'Bangla',
    location: 'Bangladesh',
    tag: 'bn-BD'
  }, {
    name: 'Bangla',
    location: 'India',
    tag: 'bn-IN'
  }, {
    name: 'Basaa',
    location: 'Cameroon',
    tag: 'bas-CM'
  }, {
    name: 'Bashkir',
    location: 'Russia',
    tag: 'ba-RU'
  }, {
    name: 'Basque',
    location: 'Spain',
    tag: 'eu-ES'
  }, {
    name: 'Belarusian',
    location: 'Belarus',
    tag: 'be-BY'
  }, {
    name: 'Bemba',
    location: 'Zambia',
    tag: 'bem-ZM'
  }, {
    name: 'Bena',
    location: 'Tanzania',
    tag: 'bez-TZ'
  }, {
    name: 'Blin',
    location: 'Eritrea',
    tag: 'byn-ER'
  }, {
    name: 'Bodo',
    location: 'India',
    tag: 'brx-IN'
  }, {
    name: 'Bosnian (Cyrillic)',
    location: 'Bosnia and Herzegovina',
    tag: 'bs-Cyrl-BA'
  }, {
    name: 'Bosnian (Latin)',
    location: 'Bosnia and Herzegovina',
    tag: 'bs-Latn-BA'
  }, {
    name: 'Breton',
    location: 'France',
    tag: 'br-FR'
  }, {
    name: 'Bulgarian',
    location: 'Bulgaria',
    tag: 'bg-BG'
  }, {
    name: 'Burmese',
    location: 'Myanmar',
    tag: 'my-MM'
  }, {
    name: 'Catalan',
    location: 'Andorra',
    tag: 'ca-AD'
  }, {
    name: 'Catalan',
    location: 'France',
    tag: 'ca-FR'
  }, {
    name: 'Catalan',
    location: 'Italy',
    tag: 'ca-IT'
  }, {
    name: 'Catalan',
    location: 'Spain',
    tag: 'ca-ES'
  }, {
    name: 'Central Atlas Tamazight ',
    location: 'Morocco',
    tag: 'tzm-Latn'
  }, {
    name: 'Central Kurdish',
    location: 'Iraq',
    tag: 'ku-Arab-IQ'
  }, {
    name: 'Chechen',
    location: 'Russia',
    tag: 'cd-RU'
  }, {
    name: 'Cherokee',
    location: 'United States',
    tag: 'chr-Cher-US'
  }, {
    name: 'Chiga',
    location: 'Uganda',
    tag: 'cgg-UG'
  }, {
    name: 'Chinese (Simplified)',
    location: 'Singapore',
    tag: 'zh-SG'
  }, {
    name: 'Chinese (Traditional)',
    location: 'Taiwan',
    tag: 'zh-TW'
  }, {
    name: 'Church Slavic',
    location: 'Russia',
    tag: 'cu-RU'
  }, {
    name: 'Cornish',
    location: 'United Kingdom',
    tag: 'kw-GB'
  }, {
    name: 'Corsican',
    location: 'France',
    tag: 'co-FR'
  }, {
    name: 'Croatian',
    location: 'Croatia',
    tag: 'hr-HR'
  }, {
    name: 'Croatian (Latin)',
    location: 'Bosnia and Herzegovina',
    tag: 'hr-BA'
  }, {
    name: 'Danish',
    location: 'Denmark',
    tag: 'da-DK'
  }, {
    name: 'Danish',
    location: 'Greenland',
    tag: 'da-GL'
  }, {
    name: 'Dari',
    location: 'Afghanistan',
    tag: 'prs-AF'
  }, {
    name: 'Divehi',
    location: 'Maldives',
    tag: 'dv-MV'
  }, {
    name: 'Duala',
    location: 'Cameroon',
    tag: 'dua-CM'
  }, {
    name: 'Dutch',
    location: 'Aruba',
    tag: 'nl-AW'
  }, {
    name: 'Dutch',
    location: 'Belgium',
    tag: 'nl-BE'
  }, {
    name: 'Dutch',
    location: 'Netherlands',
    tag: 'nl-NL'
  }, {
    name: 'Dutch',
    location: 'Sint Maarten',
    tag: 'nl-SX'
  }, {
    name: 'Dutch',
    location: 'Suriname',
    tag: 'nl-SR'
  }, {
    name: 'Dzongkha',
    location: 'Bhutan',
    tag: 'dz-BT'
  }, {
    name: 'Embu',
    location: 'Kenya',
    tag: 'ebu-KE'
  }, {
    name: 'English',
    location: 'American Samoa',
    tag: 'en-AS'
  }, {
    name: 'English',
    location: 'Anguilla',
    tag: 'en-AI'
  }, {
    name: 'English',
    location: 'Antigua and Barbuda',
    tag: 'en-AG'
  }, {
    name: 'English',
    location: 'Australia',
    tag: 'en-AU'
  }, {
    name: 'English',
    location: 'Austria',
    tag: 'en-AT'
  }, {
    name: 'English',
    location: 'Bahamas',
    tag: 'en-BS'
  }, {
    name: 'English',
    location: 'Barbados',
    tag: 'en-BB'
  }, {
    name: 'English',
    location: 'Belgium',
    tag: 'en-BE'
  }, {
    name: 'English',
    location: 'Belize',
    tag: 'en-BZ'
  }, {
    name: 'English',
    location: 'Bermuda',
    tag: 'en-BM'
  }, {
    name: 'English',
    location: 'Botswana',
    tag: 'en-BW'
  }, {
    name: 'English',
    location: 'British Indian Ocean Territory',
    tag: 'en-IO'
  }, {
    name: 'English',
    location: 'British Virgin Islands',
    tag: 'en-VG'
  }, {
    name: 'English',
    location: 'Burundi',
    tag: 'en-BI'
  }, {
    name: 'English',
    location: 'Cameroon',
    tag: 'en-CM'
  }, {
    name: 'English',
    location: 'Canada',
    tag: 'en-CA'
  }, {
    name: 'English',
    location: 'Cayman Islands',
    tag: 'en-KY'
  }, {
    name: 'English',
    location: 'Christmas Island',
    tag: 'en-CX'
  }, {
    name: 'English',
    location: 'Cook Islands',
    tag: 'en-CK'
  }, {
    name: 'English',
    location: 'Cyprus',
    tag: 'en-CY'
  }, {
    name: 'English',
    location: 'Denmark',
    tag: 'en-DK'
  }, {
    name: 'English',
    location: 'Dominica',
    tag: 'en-DM'
  }, {
    name: 'English',
    location: 'Eritrea',
    tag: 'en-ER'
  }, {
    name: 'English',
    location: 'Falkland Islands',
    tag: 'en-FK'
  }, {
    name: 'English',
    location: 'Finland',
    tag: 'en-FI'
  }, {
    name: 'English',
    location: 'Fiji',
    tag: 'en-FJ'
  }, {
    name: 'English',
    location: 'Gambia',
    tag: 'en-GM'
  }, {
    name: 'English',
    location: 'Germany',
    tag: 'en-DE'
  }, {
    name: 'English',
    location: 'Ghana',
    tag: 'en-GH'
  }, {
    name: 'English',
    location: 'Gibraltar',
    tag: 'en-GI'
  }, {
    name: 'English',
    location: 'Grenada',
    tag: 'en-GD'
  }, {
    name: 'English',
    location: 'Guam',
    tag: 'en-GU'
  }, {
    name: 'English',
    location: 'Guernsey',
    tag: 'en-GG'
  }, {
    name: 'English',
    location: 'Guyana',
    tag: 'en-GY'
  }, {
    name: 'English',
    location: 'Hong Kong',
    tag: 'en-HK'
  }, {
    name: 'English',
    location: 'India',
    tag: 'en-IN'
  }, {
    name: 'English',
    location: 'Ireland',
    tag: 'en-IE'
  }, {
    name: 'English',
    location: 'Isle of Man',
    tag: 'en-IM'
  }, {
    name: 'English',
    location: 'Israel',
    tag: 'en-IL'
  }, {
    name: 'English',
    location: 'Jamaica',
    tag: 'en-JM'
  }, {
    name: 'English',
    location: 'Jersey',
    tag: 'en-JE'
  }, {
    name: 'English',
    location: 'Kenya',
    tag: 'en-KE'
  }, {
    name: 'English',
    location: 'Kiribati',
    tag: 'en-KI'
  }, {
    name: 'English',
    location: 'Lesotho',
    tag: 'en-LS'
  }, {
    name: 'English',
    location: 'Liberia',
    tag: 'en-LR'
  }, {
    name: 'English',
    location: 'Madagascar',
    tag: 'en-MG'
  }, {
    name: 'English',
    location: 'Malawi',
    tag: 'en-MW'
  }, {
    name: 'English',
    location: 'Malaysia',
    tag: 'en-MY'
  }, {
    name: 'English',
    location: 'Malta',
    tag: 'en-MT'
  }, {
    name: 'English',
    location: 'Marshall Islands',
    tag: 'en-MH'
  }, {
    name: 'English',
    location: 'Mauritius',
    tag: 'en-MU'
  }, {
    name: 'English',
    location: 'Micronesia',
    tag: 'en-FM'
  }, {
    name: 'English',
    location: 'Montserrat',
    tag: 'en-MS'
  }, {
    name: 'English',
    location: 'Namibia',
    tag: 'en-NA'
  }, {
    name: 'English',
    location: 'Nauru',
    tag: 'en-NR'
  }, {
    name: 'English',
    location: 'Netherlands',
    tag: 'en-NL'
  }, {
    name: 'English',
    location: 'New Zealand',
    tag: 'en-NZ'
  }, {
    name: 'English',
    location: 'Nigeria',
    tag: 'en-NG'
  }, {
    name: 'English',
    location: 'Niue',
    tag: 'en-NU'
  }, {
    name: 'English',
    location: 'Norfolk Island',
    tag: 'en-NF'
  }, {
    name: 'English',
    location: 'Northern Mariana Islands',
    tag: 'en-MP'
  }, {
    name: 'English',
    location: 'Pakistan',
    tag: 'en-PK'
  }, {
    name: 'English',
    location: 'Palau',
    tag: 'en-PW'
  }, {
    name: 'English',
    location: 'Papua New Guinea',
    tag: 'en-PG'
  }, {
    name: 'English',
    location: 'Puerto Rico',
    tag: 'en-PR'
  }, {
    name: 'English',
    location: 'Rwanda',
    tag: 'en-RW'
  }, {
    name: 'English',
    location: 'Saint Kitts and Nevis',
    tag: 'en-KN'
  }, {
    name: 'English',
    location: 'Saint Lucia',
    tag: 'en-LC'
  }, {
    name: 'English',
    location: 'Saint Vincent and the Grenadines',
    tag: 'en-VC'
  }, {
    name: 'English',
    location: 'Samoa',
    tag: 'en-WS'
  }, {
    name: 'English',
    location: 'Seychelles',
    tag: 'en-SC'
  }, {
    name: 'English',
    location: 'Sierra Leone',
    tag: 'en-SL'
  }, {
    name: 'English',
    location: 'Singapore',
    tag: 'en-SG'
  }, {
    name: 'English',
    location: 'Sint Maarten',
    tag: 'en-SX'
  }, {
    name: 'English',
    location: 'Slovenia',
    tag: 'en-SI'
  }, {
    name: 'English',
    location: 'Solomon Islands',
    tag: 'en-SB'
  }, {
    name: 'English',
    location: 'South Africa',
    tag: 'en-ZA'
  }, {
    name: 'English',
    location: 'South Sudan',
    tag: 'en-SS'
  }, {
    name: 'English',
    location: 'Sudan',
    tag: 'en-SD'
  }, {
    name: 'English',
    location: 'Swaziland',
    tag: 'en-SZ'
  }, {
    name: 'English',
    location: 'Sweden',
    tag: 'en-SE'
  }, {
    name: 'English',
    location: 'Switzerland',
    tag: 'en-CH'
  }, {
    name: 'English',
    location: 'Tanzania',
    tag: 'en-TZ'
  }, {
    name: 'English',
    location: 'Tokelau',
    tag: 'en-TK'
  }, {
    name: 'English',
    location: 'Tonga',
    tag: 'en-TO'
  }, {
    name: 'English',
    location: 'Trinidad and Tobago',
    tag: 'en-TT'
  }, {
    name: 'English',
    location: 'Turks and Caicos Islands',
    tag: 'en-TC'
  }, {
    name: 'English',
    location: 'Tuvalu',
    tag: 'en-TV'
  }, {
    name: 'English',
    location: 'Uganda',
    tag: 'en-UG'
  }, {
    name: 'English',
    location: 'United Kingdom',
    tag: 'en-GB'
  }, {
    name: 'English',
    location: 'United States',
    tag: 'en-US'
  }, {
    name: 'English',
    location: 'Vanuatu',
    tag: 'en-VU'
  }, {
    name: 'English',
    location: 'Zambia',
    tag: 'en-ZM'
  }, {
    name: 'English',
    location: 'Zimbabwe',
    tag: 'en-ZW'
  }, {
    name: 'Estonian',
    location: 'Estonia',
    tag: 'et-EE'
  }, {
    name: 'Ewe',
    location: 'Ghana',
    tag: 'ee-GH'
  }, {
    name: 'Ewe',
    location: 'Togo',
    tag: 'ee-TG'
  }, {
    name: 'Ewondo',
    location: 'Cameroon',
    tag: 'ewo-CM'
  }, {
    name: 'Faroese',
    location: 'Denmark',
    tag: 'fo-DK'
  }, {
    name: 'Faroese',
    location: 'Faroe Islands',
    tag: 'fo-FO'
  }, {
    name: 'Filipino',
    location: 'Philippines',
    tag: 'fil-PH'
  }, {
    name: 'Finnish',
    location: 'Finland',
    tag: 'fi-FI'
  }, {
    name: 'French',
    location: 'Algeria',
    tag: 'fr-DZ'
  }, {
    name: 'French',
    location: 'Belgium',
    tag: 'fr-BE'
  }, {
    name: 'French',
    location: 'Benin',
    tag: 'fr-BJ'
  }, {
    name: 'French',
    location: 'Burkina Faso',
    tag: 'fr-BF'
  }, {
    name: 'French',
    location: 'Burundi',
    tag: 'fr-BI'
  }, {
    name: 'French',
    location: 'Cameroon',
    tag: 'fr-CM'
  }, {
    name: 'French',
    location: 'Canada',
    tag: 'fr-CA'
  }, {
    name: 'French',
    location: 'Central African Republic',
    tag: 'fr-CF'
  }, {
    name: 'French',
    location: 'Chad',
    tag: 'fr-TD'
  }, {
    name: 'French',
    location: 'Comoros',
    tag: 'fr-KM'
  }, {
    name: 'French',
    location: 'Djibouti',
    tag: 'fr-DJ'
  }, {
    name: 'French',
    location: 'Equatorial Guinea',
    tag: 'fr-GQ'
  }, {
    name: 'French',
    location: 'France',
    tag: 'fr-FR'
  }, {
    name: 'French',
    location: 'French Guiana',
    tag: 'fr-GF'
  }, {
    name: 'French',
    location: 'French Polynesia',
    tag: 'fr-PF'
  }, {
    name: 'French',
    location: 'Gabon',
    tag: 'fr-GA'
  }, {
    name: 'French',
    location: 'Guadeloupe',
    tag: 'fr-GP'
  }, {
    name: 'French',
    location: 'Guinea',
    tag: 'fr-GN'
  }, {
    name: 'French',
    location: 'Haiti',
    tag: 'fr-HT'
  }, {
    name: 'French',
    location: 'Luxembourg',
    tag: 'fr-LU'
  }, {
    name: 'French',
    location: 'Madagascar',
    tag: 'fr-MG'
  }, {
    name: 'French',
    location: 'Mali',
    tag: 'fr-ML'
  }, {
    name: 'French',
    location: 'Martinique',
    tag: 'fr-MQ'
  }, {
    name: 'French',
    location: 'Mauritania',
    tag: 'fr-MR'
  }, {
    name: 'French',
    location: 'Mauritius',
    tag: 'fr-MU'
  }, {
    name: 'French',
    location: 'Mayotte',
    tag: 'fr-YT'
  }, {
    name: 'French',
    location: 'Morocco',
    tag: 'fr-MA'
  }, {
    name: 'French',
    location: 'New Caledonia',
    tag: 'fr-NC'
  }, {
    name: 'French',
    location: 'Niger',
    tag: 'fr-NE'
  }, {
    name: 'French',
    location: 'Reunion',
    tag: 'fr-RE'
  }, {
    name: 'French',
    location: 'Rwanda',
    tag: 'fr-RW'
  }, {
    name: 'French',
    location: 'Saint Martin',
    tag: 'fr-MF'
  }, {
    name: 'French',
    location: 'Saint Pierre and Miquelon',
    tag: 'fr-PM'
  }, {
    name: 'French',
    location: 'Senegal',
    tag: 'fr-SN'
  }, {
    name: 'French',
    location: 'Seychelles',
    tag: 'fr-SC'
  }, {
    name: 'French',
    location: 'Switzerland',
    tag: 'fr-CH'
  }, {
    name: 'French',
    location: 'Syria',
    tag: 'fr-SY'
  }, {
    name: 'French',
    location: 'Togo',
    tag: 'fr-TG'
  }, {
    name: 'French',
    location: 'Tunisia',
    tag: 'fr-TN'
  }, {
    name: 'French',
    location: 'Vanuatu',
    tag: 'fr-VU'
  }, {
    name: 'French',
    location: 'Wallis and Futuna',
    tag: 'fr-WF'
  }, {
    name: 'Frisian',
    location: 'Netherlands',
    tag: 'fy-NL'
  }, {
    name: 'Friulian',
    location: 'Italy',
    tag: 'fur-IT'
  }, {
    name: 'Fulah (Latin)',
    location: 'Burkina Faso',
    tag: 'ff-Latn-BF'
  }, {
    name: 'Fulah (Latin)',
    location: 'Cameroon',
    tag: 'ff-Latn-CM'
  }, {
    name: 'Fulah (Latin)',
    location: 'Gambia',
    tag: 'ff-Latn-GM'
  }, {
    name: 'Fulah (Latin)',
    location: 'Ghana',
    tag: 'ff-Latn-GH'
  }, {
    name: 'Fulah (Latin)',
    location: 'Guinea',
    tag: 'ff-Latn-GN'
  }, {
    name: 'Fulah (Latin)',
    location: 'Guinea-Bissau',
    tag: 'ff-Latn-GW'
  }, {
    name: 'Fulah (Latin)',
    location: 'Liberia',
    tag: 'ff-Latn-LR'
  }, {
    name: 'Fulah (Latin)',
    location: 'Mauritania',
    tag: 'ff-Latn-MR'
  }, {
    name: 'Fulah (Latin)',
    location: 'Niger',
    tag: 'ff-Latn-NE'
  }, {
    name: 'Fulah (Latin)',
    location: 'Nigeria',
    tag: 'ff-Latn-NG'
  }, {
    name: 'Fulah (Latin)',
    location: 'Sierra Leone',
    tag: 'ff-Latn-SL'
  }, {
    name: 'Fulah',
    location: 'Cameroon',
    tag: 'ff-CM'
  }, {
    name: 'Fulah',
    location: 'Guinea',
    tag: 'ff-GN'
  }, {
    name: 'Fulah',
    location: 'Mauritania',
    tag: 'ff-MR'
  }, {
    name: 'Fulah',
    location: 'Nigeria',
    tag: 'ff-NG'
  }, {
    name: 'Fulah',
    location: 'Senegal',
    tag: 'ff-Latn-SN'
  }, {
    name: 'Galician',
    location: 'Spain',
    tag: 'gl-ES'
  }, {
    name: 'Ganda',
    location: 'Uganda',
    tag: 'lg-UG'
  }, {
    name: 'Georgian',
    location: 'Georgia',
    tag: 'ka-GE'
  }, {
    name: 'German',
    location: 'Austria',
    tag: 'de-AT'
  }, {
    name: 'German',
    location: 'Belgium',
    tag: 'de-BE'
  }, {
    name: 'German',
    location: 'Germany',
    tag: 'de-DE'
  }, {
    name: 'German',
    location: 'Italy',
    tag: 'de-IT'
  }, {
    name: 'German',
    location: 'Liechtenstein',
    tag: 'de-LI'
  }, {
    name: 'German',
    location: 'Luxembourg',
    tag: 'de-LU'
  }, {
    name: 'German',
    location: 'Switzerland',
    tag: 'de-CH'
  }, {
    name: 'Greek',
    location: 'Cyprus',
    tag: 'el-CY'
  }, {
    name: 'Greek',
    location: 'Greece',
    tag: 'el-GR'
  }, {
    name: 'Greenlandic',
    location: 'Greenland',
    tag: 'kl-GL'
  }, {
    name: 'Guarani',
    location: 'Paraguay',
    tag: 'gn-PY'
  }, {
    name: 'Gujarati',
    location: 'India',
    tag: 'gu-IN'
  }, {
    name: 'Gusii',
    location: 'Kenya',
    tag: 'guz-KE'
  }, {
    name: 'Hausa (Latin)',
    location: 'Ghana',
    tag: 'ha-Latn-GH'
  }, {
    name: 'Hausa (Latin)',
    location: 'Niger',
    tag: 'ha-Latn-NE'
  }, {
    name: 'Hausa (Latin)',
    location: 'Nigeria',
    tag: 'ha-Latn-NG'
  }, {
    name: 'Hawaiian',
    location: 'United States',
    tag: 'haw-US'
  }, {
    name: 'Hebrew',
    location: 'Israel',
    tag: 'he-IL'
  }, {
    name: 'Hindi',
    location: 'India',
    tag: 'hi-IN'
  }, {
    name: 'Hungarian',
    location: 'Hungary',
    tag: 'hu-HU'
  }, {
    name: 'Icelandic',
    location: 'Iceland',
    tag: 'is-IS'
  }, {
    name: 'Igbo',
    location: 'Nigeria',
    tag: 'ig-NG'
  }, {
    name: 'Indonesian',
    location: 'Indonesia',
    tag: 'id-ID'
  }, {
    name: 'Interlingua',
    location: 'France',
    tag: 'ia-FR'
  }, {
    name: 'Inuktitut (Latin)',
    location: 'Canada',
    tag: 'iu-Latn-CA'
  }, {
    name: 'Inuktitut (Syllabics)',
    location: 'Canada',
    tag: 'iu-Cans-CA'
  }, {
    name: 'Irish',
    location: 'Ireland',
    tag: 'ga-IE'
  }, {
    name: 'Italian',
    location: 'Italy',
    tag: 'it-IT'
  }, {
    name: 'Italian',
    location: 'San Marino',
    tag: 'it-SM'
  }, {
    name: 'Italian',
    location: 'Switzerland',
    tag: 'it-CH'
  }, {
    name: 'Japanese',
    location: 'Japan',
    tag: 'ja-JP'
  }, {
    name: 'Jola-Fonyi',
    location: 'Senegal',
    tag: 'dyo-SN'
  }, {
    name: 'Kabyle',
    location: 'Algeria',
    tag: 'kab-DZ'
  }, {
    name: 'Kako',
    location: 'Cameroon',
    tag: 'kkj-CM'
  }, {
    name: 'Kalenjin',
    location: 'Kenya',
    tag: 'kln-KE'
  }, {
    name: 'Kamba',
    location: 'Kenya',
    tag: 'kam-KE'
  }, {
    name: 'Kannada',
    location: 'India',
    tag: 'kn-IN'
  }, {
    name: 'Kazakh',
    location: 'Kazakhstan',
    tag: 'kk-KZ'
  }, {
    name: 'Khmer',
    location: 'Cambodia',
    tag: 'km-KH'
  }, {
    name: "K'iche",
    location: 'Guatemala',
    tag: 'quc-Latn-GT'
  }, {
    name: 'Kikuyu',
    location: 'Kenya',
    tag: 'ki-KE'
  }, {
    name: 'Kinyarwanda',
    location: 'Rwanda',
    tag: 'rw-RW'
  }, {
    name: 'Kiswahili',
    location: 'Kenya',
    tag: 'sw-KE'
  }, {
    name: 'Kiswahili',
    location: 'Tanzania',
    tag: 'sw-TZ'
  }, {
    name: 'Kiswahili',
    location: 'Uganda',
    tag: 'sw-UG'
  }, {
    name: 'Konkani',
    location: 'India',
    tag: 'kok-IN'
  }, {
    name: 'Korean',
    location: 'North Korea',
    tag: 'ko-KP'
  }, {
    name: 'Koyra Chiini',
    location: 'Mali',
    tag: 'khq-ML'
  }, {
    name: 'Koyraboro Senni',
    location: 'Mali',
    tag: 'ses-ML'
  }, {
    name: 'Kwasio',
    location: 'Cameroon',
    tag: 'nmg-CM'
  }, {
    name: 'Kyrgyz',
    location: 'Kyrgyzstan',
    tag: 'ky-KG'
  }, {
    name: 'Lakota',
    location: 'United States',
    tag: 'lkt-US'
  }, {
    name: 'Langi',
    location: 'Tanzania',
    tag: 'lag-TZ'
  }, {
    name: 'Latvian',
    location: 'Latvia',
    tag: 'lv-LV'
  }, {
    name: 'Lingala',
    location: 'Angola',
    tag: 'ln-AO'
  }, {
    name: 'Lingala',
    location: 'Central African Republic',
    tag: 'ln-CF'
  }, {
    name: 'Lithuanian',
    location: 'Lithuania',
    tag: 'lt-LT'
  }, {
    name: 'Low German ',
    location: 'Germany',
    tag: 'nds-DE'
  }, {
    name: 'Low German',
    location: 'Netherlands',
    tag: 'nds-NL'
  }, {
    name: 'Lower Sorbian',
    location: 'Germany',
    tag: 'dsb-DE'
  }, {
    name: 'Luo',
    location: 'Kenya',
    tag: 'luo-KE'
  }, {
    name: 'Luxembourgish',
    location: 'Luxembourg',
    tag: 'lb-LU'
  }, {
    name: 'Luyia',
    location: 'Kenya',
    tag: 'luy-KE'
  }, {
    name: 'Machame',
    location: 'Tanzania',
    tag: 'jmc-TZ'
  }, {
    name: 'Makhuwa-Meetto',
    location: 'Mozambique',
    tag: 'mgh-MZ'
  }, {
    name: 'Makonde',
    location: 'Tanzania',
    tag: 'kde-TZ'
  }, {
    name: 'Malagasy',
    location: 'Madagascar',
    tag: 'mg-MG'
  }, {
    name: 'Malay',
    location: 'Malaysia',
    tag: 'ms-MY'
  }, {
    name: 'Malayalam',
    location: 'India',
    tag: 'ml-IN'
  }, {
    name: 'Maltese',
    location: 'Malta',
    tag: 'mt-MT'
  }, {
    name: 'Manx',
    location: 'Isle of Man',
    tag: 'gv-IM'
  }, {
    name: 'Maori',
    location: 'New Zealand',
    tag: 'mi-NZ'
  }, {
    name: 'Mapudungun',
    location: 'Chile',
    tag: 'arn-CL'
  }, {
    name: 'Marathi',
    location: 'India',
    tag: 'mr-IN'
  }, {
    name: 'Masai',
    location: 'Kenya',
    tag: 'mas-KE'
  }, {
    name: 'Masai',
    location: 'Tanzania',
    tag: 'mas-TZ'
  }, {
    name: 'Mazanderani',
    location: 'Iran',
    tag: 'mzn-IR'
  }, {
    name: 'Meru',
    location: 'Kenya',
    tag: 'mer-KE'
  }, {
    name: "Meta'",
    location: 'Cameroon',
    tag: 'mgo-CM'
  }, {
    name: 'Mohawk',
    location: 'Canada',
    tag: 'moh-CA'
  }, {
    name: 'Mongolian (Cyrillic)',
    location: 'Mongolia',
    tag: 'mn-MN'
  }, {
    name: 'Mongolian (Traditional)',
    location: 'Mongolia',
    tag: 'mn-Mong'
  }, {
    name: 'Morisyen',
    location: 'Mauritius',
    tag: 'mfe-MU'
  }, {
    name: 'Mundang',
    location: 'Cameroon',
    tag: 'mua-CM'
  }, {
    name: "N'ko",
    location: 'Guinea',
    tag: 'nqo-GN'
  }, {
    name: 'Nama',
    location: 'Namibia',
    tag: 'naq-NA'
  }, {
    name: 'Nepali',
    location: 'India',
    tag: 'ne-IN'
  }, {
    name: 'Nepali',
    location: 'Nepal',
    tag: 'ne-NP'
  }, {
    name: 'Ngiemboon',
    location: 'Cameroon',
    tag: 'nnh-CM'
  }, {
    name: 'Ngomba',
    location: 'Cameroon',
    tag: 'jgo-CM'
  }, {
    name: 'Northern Luri',
    location: 'Iraq',
    tag: 'lrc-IQ'
  }, {
    name: 'Northern Luri',
    location: 'Iran',
    tag: 'lrc-IR'
  }, {
    name: 'North Ndebele',
    location: 'Zimbabwe',
    tag: 'nd-ZW'
  }, {
    name: 'Norwegian (Bokmal)',
    location: 'Norway',
    tag: 'nb-NO'
  }, {
    name: 'Norwegian (Nynorsk)',
    location: 'Norway',
    tag: 'nn-NO'
  }, {
    name: 'Norwegian Bokmål',
    location: 'Svalbard and Jan Mayen',
    tag: 'nb-SJ'
  }, {
    name: 'Nuer',
    location: 'Sudan',
    tag: 'nus-SD'
  }, {
    name: 'Nuer',
    location: 'South Sudan',
    tag: 'nus-SS'
  }, {
    name: 'Nyankole',
    location: 'Uganda',
    tag: 'nyn-UG'
  }, {
    name: 'Occitan',
    location: 'France',
    tag: 'oc-FR'
  }, {
    name: 'Odia',
    location: 'India',
    tag: 'or-IN'
  }, {
    name: 'Oromo',
    location: 'Ethiopia',
    tag: 'om-ET'
  }, {
    name: 'Oromo',
    location: 'Kenya',
    tag: 'om-KE'
  }, {
    name: 'Pashto',
    location: 'Afghanistan',
    tag: 'ps-AF'
  }, {
    name: 'Persian',
    location: 'Afghanistan',
    tag: 'fa-AF'
  }, {
    name: 'Persian',
    location: 'Iran',
    tag: 'fa-IR'
  }, {
    name: 'Polish',
    location: 'Poland',
    tag: 'pl-PL'
  }, {
    name: 'Portuguese',
    location: 'Angola',
    tag: 'pt-AO'
  }, {
    name: 'Portuguese',
    location: 'Brazil',
    tag: 'pt-BR'
  }, {
    name: 'Portuguese',
    location: 'Equatorial Guinea',
    tag: 'pt-GQ'
  }, {
    name: 'Portuguese',
    location: 'Guinea-Bissau',
    tag: 'pt-GW'
  }, {
    name: 'Portuguese',
    location: 'Luxembourg',
    tag: 'pt-LU'
  }, {
    name: 'Portuguese',
    location: 'Mozambique',
    tag: 'pt-MZ'
  }, {
    name: 'Portuguese',
    location: 'Portugal',
    tag: 'pt-PT'
  }, {
    name: 'Portuguese',
    location: 'Switzerland',
    tag: 'pt-CH'
  }, {
    name: 'Punjabi',
    location: 'India',
    tag: 'pa-IN'
  }, {
    name: 'Quechua',
    location: 'Bolivia',
    tag: 'quz-BO'
  }, {
    name: 'Quechua',
    location: 'Ecuador',
    tag: 'quz-EC'
  }, {
    name: 'Quechua',
    location: 'Peru',
    tag: 'quz-PE'
  }, {
    name: 'Ripuarian',
    location: 'Germany',
    tag: 'ksh-DE'
  }, {
    name: 'Romanian',
    location: 'Moldova',
    tag: 'ro-MD'
  }, {
    name: 'Romanian',
    location: 'Romania',
    tag: 'ro-RO'
  }, {
    name: 'Romansh',
    location: 'Switzerland',
    tag: 'rm-CH'
  }, {
    name: 'Rombo',
    location: 'Tanzania',
    tag: 'rof-TZ'
  }, {
    name: 'Rundi',
    location: 'Burundi',
    tag: 'rn-BI'
  }, {
    name: 'Russian',
    location: 'Belarus',
    tag: 'ru-BY'
  }, {
    name: 'Russian',
    location: 'Kazakhstan',
    tag: 'ru-KZ'
  }, {
    name: 'Russian',
    location: 'Kyrgyzstan',
    tag: 'ru-KG'
  }, {
    name: 'Russian',
    location: 'Moldova',
    tag: 'ru-MD'
  }, {
    name: 'Russian',
    location: 'Russia',
    tag: 'ru-RU'
  }, {
    name: 'Russian',
    location: 'Ukraine',
    tag: 'ru-UA'
  }, {
    name: 'Rwa',
    location: 'Tanzania',
    tag: 'rwk-TZ'
  }, {
    name: 'Saho',
    location: 'Eritrea',
    tag: 'ssy-ER'
  }, {
    name: 'Sakha',
    location: 'Russia',
    tag: 'sah-RU'
  }, {
    name: 'Samburu',
    location: 'Kenya',
    tag: 'saq-KE'
  }, {
    name: 'Sami (Inari)',
    location: 'Finland',
    tag: 'smn-FI'
  }, {
    name: 'Sami (Lule)',
    location: 'Norway',
    tag: 'smj-NO'
  }, {
    name: 'Sami (Lule)',
    location: 'Sweden',
    tag: 'smj-SE'
  }, {
    name: 'Sami (Northern)',
    location: 'Finland',
    tag: 'se-FI'
  }, {
    name: 'Sami (Northern)',
    location: 'Norway',
    tag: 'se-NO'
  }, {
    name: 'Sami (Northern)',
    location: 'Sweden',
    tag: 'se-SE'
  }, {
    name: 'Sami (Skolt)',
    location: 'Finland',
    tag: 'sms-FI'
  }, {
    name: 'Sami (Southern)',
    location: 'Norway',
    tag: 'sma-NO'
  }, {
    name: 'Sami (Southern)',
    location: 'Sweden',
    tag: 'sma-SE'
  }, {
    name: 'Sango',
    location: 'Central African Republic',
    tag: 'sg-CF'
  }, {
    name: 'Sangu',
    location: 'Tanzania',
    tag: 'sbp-TZ'
  }, {
    name: 'Sanskrit',
    location: 'India',
    tag: 'sa-IN'
  }, {
    name: 'Scottish Gaelic',
    location: 'United Kingdom',
    tag: 'gd-GB'
  }, {
    name: 'Sena',
    location: 'Mozambique',
    tag: 'seh-MZ'
  }, {
    name: 'Serbian (Cyrillic)',
    location: 'Bosnia and Herzegovina',
    tag: 'sr-Cyrl-BA'
  }, {
    name: 'Serbian (Cyrillic)',
    location: 'Montenegro',
    tag: 'sr-Cyrl-ME'
  }, {
    name: 'Serbian (Cyrillic)',
    location: 'Serbia',
    tag: 'sr-Cyrl-RS'
  }, {
    name: 'Serbian (Latin)',
    location: 'Bosnia and Herzegovina',
    tag: 'sr-Latn-BA'
  }, {
    name: 'Serbian (Latin)',
    location: 'Montenegro',
    tag: 'sr-Latn-ME'
  }, {
    name: 'Serbian (Latin)',
    location: 'Serbia',
    tag: 'sr-Latn-RS'
  }, {
    name: 'Sesotho sa Leboa',
    location: 'South Africa',
    tag: 'nso-ZA'
  }, {
    name: 'Setswana',
    location: 'Botswana',
    tag: 'tn-BW'
  }, {
    name: 'Setswana',
    location: 'South Africa',
    tag: 'tn-ZA'
  }, {
    name: 'Shambala',
    location: 'Tanzania',
    tag: 'ksb-TZ'
  }, {
    name: 'Shona',
    location: 'Zimbabwe',
    tag: 'sn-Latn-ZW'
  }, {
    name: 'Sinhala',
    location: 'Sri Lanka',
    tag: 'si-LK'
  }, {
    name: 'Slovak',
    location: 'Slovakia',
    tag: 'sk-SK'
  }, {
    name: 'Slovenian',
    location: 'Slovenia',
    tag: 'sl-SI'
  }, {
    name: 'Soga',
    location: 'Uganda',
    tag: 'xog-UG'
  }, {
    name: 'Somali',
    location: 'Djibouti',
    tag: 'so-DJ'
  }, {
    name: 'Somali',
    location: 'Ethiopia',
    tag: 'so-ET'
  }, {
    name: 'Somali',
    location: 'Kenya',
    tag: 'so-KE'
  }, {
    name: 'Somali',
    location: 'Somalia',
    tag: 'so-SO'
  }, {
    name: 'Sotho',
    location: 'South Africa',
    tag: 'st-ZA'
  }, {
    name: 'South Ndebele',
    location: 'South Africa',
    tag: 'nr-ZA'
  }, {
    name: 'Southern Sotho',
    location: 'Lesotho',
    tag: 'st-LS'
  }, {
    name: 'Spanish',
    location: 'Argentina',
    tag: 'es-AR'
  }, {
    name: 'Spanish',
    location: 'Belize',
    tag: 'es-BZ'
  }, {
    name: 'Spanish',
    location: 'Bolivia',
    tag: 'es-BO'
  }, {
    name: 'Spanish',
    location: 'Brazil',
    tag: 'es-BR'
  }, {
    name: 'Spanish',
    location: 'Chile',
    tag: 'es-CL'
  }, {
    name: 'Spanish',
    location: 'Colombia',
    tag: 'es-CO'
  }, {
    name: 'Spanish',
    location: 'Costa Rica',
    tag: 'es-CR'
  }, {
    name: 'Spanish',
    location: 'Cuba',
    tag: 'es-CU'
  }, {
    name: 'Spanish',
    location: 'Dominican Republic',
    tag: 'es-DO'
  }, {
    name: 'Spanish',
    location: 'Ecuador',
    tag: 'es-EC'
  }, {
    name: 'Spanish',
    location: 'El Salvador',
    tag: 'es-SV'
  }, {
    name: 'Spanish',
    location: 'Equatorial Guinea',
    tag: 'es-GQ'
  }, {
    name: 'Spanish',
    location: 'Guatemala',
    tag: 'es-GT'
  }, {
    name: 'Spanish',
    location: 'Honduras',
    tag: 'es-HN'
  }, {
    name: 'Spanish',
    location: 'Mexico',
    tag: 'es-MX'
  }, {
    name: 'Spanish',
    location: 'Nicaragua',
    tag: 'es-NI'
  }, {
    name: 'Spanish',
    location: 'Panama',
    tag: 'es-PA'
  }, {
    name: 'Spanish',
    location: 'Paraguay',
    tag: 'es-PY'
  }, {
    name: 'Spanish',
    location: 'Peru',
    tag: 'es-PE'
  }, {
    name: 'Spanish',
    location: 'Philippines',
    tag: 'es-PH'
  }, {
    name: 'Spanish',
    location: 'Puerto Rico',
    tag: 'es-PR'
  }, {
    name: 'Spanish',
    location: 'Spain',
    tag: 'es-ES'
  }, {
    name: 'Spanish',
    location: 'United States',
    tag: 'es-US'
  }, {
    name: 'Spanish',
    location: 'Uruguay',
    tag: 'es-UY'
  }, {
    name: 'Standard Moroccan ',
    location: 'Morocco',
    tag: 'zgh-Tfng-MA'
  }, {
    name: 'Swati',
    location: 'South Africa',
    tag: 'ss-ZA'
  }, {
    name: 'Swati',
    location: 'Swaziland',
    tag: 'ss-SZ'
  }, {
    name: 'Swedish',
    location: 'Finland',
    tag: 'sv-FI'
  }, {
    name: 'Swedish',
    location: 'Sweden',
    tag: 'sv-SE'
  }, {
    name: 'Syriac',
    location: 'Syria',
    tag: 'syr-SY'
  }, {
    name: 'Tachelhit (Latin)',
    location: 'Morocco',
    tag: 'shi-Latn-MA'
  }, {
    name: 'Taita',
    location: 'Kenya',
    tag: 'dav-KE'
  }, {
    name: 'Tajik (Cyrillic)',
    location: 'Tajikistan',
    tag: 'tg-Cyrl-TJ'
  }, {
    name: 'Tamazight (Latin)',
    location: 'Algeria',
    tag: 'tzm-Latn-DZ'
  }, {
    name: 'Tamil',
    location: 'India',
    tag: 'ta-IN'
  }, {
    name: 'Tamil',
    location: 'Malaysia',
    tag: 'ta-MY'
  }, {
    name: 'Tamil',
    location: 'Singapore',
    tag: 'ta-SG'
  }, {
    name: 'Tamil',
    location: 'Sri Lanka',
    tag: 'ta-LK'
  }, {
    name: 'Tasawaq',
    location: 'Niger',
    tag: 'twq-NE'
  }, {
    name: 'Tatar',
    location: 'Russia',
    tag: 'tt-RU'
  }, {
    name: 'Telugu',
    location: 'India',
    tag: 'te-IN'
  }, {
    name: 'Teso',
    location: 'Kenya',
    tag: 'teo-KE'
  }, {
    name: 'Teso',
    location: 'Uganda',
    tag: 'teo-UG'
  }, {
    name: 'Thai',
    location: 'Thailand',
    tag: 'th-TH'
  }, {
    name: 'Tibetan',
    location: 'India',
    tag: 'bo-IN'
  }, {
    name: 'Tigre',
    location: 'Eritrea',
    tag: 'tig-ER'
  }, {
    name: 'Tigrinya',
    location: 'Eritrea',
    tag: 'ti-ER'
  }, {
    name: 'Tigrinya',
    location: 'Ethiopia',
    tag: 'ti-ET'
  }, {
    name: 'Tongan',
    location: 'Tonga',
    tag: 'to-TO'
  }, {
    name: 'Tsonga',
    location: 'South Africa',
    tag: 'ts-ZA'
  }, {
    name: 'Turkish',
    location: 'Cyprus',
    tag: 'tr-CY'
  }, {
    name: 'Turkish',
    location: 'Turkey',
    tag: 'tr-TR'
  }, {
    name: 'Turkmen',
    location: 'Turkmenistan',
    tag: 'tk-TM'
  }, {
    name: 'Ukrainian',
    location: 'Ukraine',
    tag: 'uk-UA'
  }, {
    name: 'Upper Sorbian',
    location: 'Germany',
    tag: 'hsb-DE'
  }, {
    name: 'Urdu',
    location: 'India',
    tag: 'ur-IN'
  }, {
    name: 'Uzbek (Cyrillic)',
    location: 'Uzbekistan',
    tag: 'uz-Cyrl-UZ'
  }, {
    name: 'Uzbek (Latin)',
    location: 'Uzbekistan',
    tag: 'uz-Latn-UZ'
  }, {
    name: 'Vai',
    location: 'Liberia',
    tag: 'vai-Vaii-LR'
  }, {
    name: 'Vai (Latin)',
    location: 'Liberia',
    tag: 'vai-Latn-LR'
  }, {
    name: 'Valencian',
    location: 'Spain',
    tag: 'ca-ES'
  }, {
    name: 'Venda',
    location: 'South Africa',
    tag: 've-ZA'
  }, {
    name: 'Vietnamese',
    location: 'Vietnam',
    tag: 'vi-VN'
  }, {
    name: 'Vunjo',
    location: 'Tanzania',
    tag: 'vun-TZ'
  }, {
    name: 'Walser',
    location: 'Switzerland',
    tag: 'wae-CH'
  }, {
    name: 'Welsh',
    location: 'United Kingdom',
    tag: 'cy-GB'
  }, {
    name: 'Wolaytta',
    location: 'Ethiopia',
    tag: 'wal-ET'
  }, {
    name: 'Wolof',
    location: 'Senegal',
    tag: 'wo-SN'
  }, {
    name: 'Xhosa',
    location: 'South Africa',
    tag: 'xh-ZA'
  }, {
    name: 'Yangben',
    location: 'Cameroon',
    tag: 'yav-CM'
  }, {
    name: 'Yoruba',
    location: 'Benin',
    tag: 'yo-BJ'
  }, {
    name: 'Yoruba',
    location: 'Nigeria',
    tag: 'yo-NG'
  }, {
    name: 'Zarma',
    location: 'Niger',
    tag: 'dje-NE'
  }, {
    name: 'Zulu',
    location: 'South Africa',
    tag: 'zu-ZA'
  }]; // list of all the languages for the list of locales provided in commerceCurrencyLocales

  api.commerceLanguages = [{
    name: 'Afar',
    tag: 'aa'
  }, {
    name: 'Afrikaans',
    tag: 'af'
  }, {
    name: 'Aghem',
    tag: 'agq'
  }, {
    name: 'Akan',
    tag: 'ak'
  }, {
    name: 'Albanian',
    tag: 'sq'
  }, {
    name: 'Alsatian',
    tag: 'gsw'
  }, {
    name: 'Amharic',
    tag: 'am'
  }, {
    name: 'Arabic',
    tag: 'ar'
  }, {
    name: 'Armenian',
    tag: 'hy'
  }, {
    name: 'Assamese',
    tag: 'as'
  }, {
    name: 'Asturian',
    tag: 'ast'
  }, {
    name: 'Asu',
    tag: 'asa'
  }, {
    name: 'Azerbaijani (Cyrillic)',
    tag: 'az-Cyrl'
  }, {
    name: 'Azerbaijani (Latin)',
    tag: 'az-Latn'
  }, {
    name: 'Bafia',
    tag: 'ksf'
  }, {
    name: 'Bamanankan (Latin)',
    tag: 'bm-Latn'
  }, {
    name: 'Bangla',
    tag: 'bn'
  }, {
    name: 'Basaa',
    tag: 'bas'
  }, {
    name: 'Bashkir',
    tag: 'ba'
  }, {
    name: 'Basque',
    tag: 'eu'
  }, {
    name: 'Belarusian',
    tag: 'be'
  }, {
    name: 'Bemba',
    tag: 'bem'
  }, {
    name: 'Bena',
    tag: 'bez'
  }, {
    name: 'Blin',
    tag: 'byn'
  }, {
    name: 'Bodo',
    tag: 'brx'
  }, {
    name: 'Bosnian (Cyrillic)',
    tag: 'bs-Cyrl'
  }, {
    name: 'Bosnian (Latin)',
    tag: 'bs-Latn'
  }, {
    name: 'Breton',
    tag: 'br'
  }, {
    name: 'Bulgarian',
    tag: 'bg'
  }, {
    name: 'Burmese',
    tag: 'my'
  }, {
    name: 'Catalan',
    tag: 'ca'
  }, {
    name: 'Central Atlas Tamazight ',
    tag: 'tzm'
  }, {
    name: 'Central Kurdish',
    tag: 'ku-Arab'
  }, {
    name: 'Chechen',
    tag: 'cd'
  }, {
    name: 'Cherokee',
    tag: 'chr-Cher'
  }, {
    name: 'Chiga',
    tag: 'cgg'
  }, {
    name: 'Chinese (Simplified)',
    tag: 'zh'
  }, {
    name: 'Chinese (Traditional)',
    tag: 'zh'
  }, {
    name: 'Church Slavic',
    tag: 'cu'
  }, {
    name: 'Cornish',
    tag: 'kw'
  }, {
    name: 'Corsican',
    tag: 'co'
  }, {
    name: 'Croatian',
    tag: 'hr'
  }, {
    name: 'Croatian (Latin)',
    tag: 'hr'
  }, {
    name: 'Danish',
    tag: 'da'
  }, {
    name: 'Dari',
    tag: 'prs'
  }, {
    name: 'Divehi',
    tag: 'dv'
  }, {
    name: 'Duala',
    tag: 'dua'
  }, {
    name: 'Dutch',
    tag: 'nl'
  }, {
    name: 'Dzongkha',
    tag: 'dz'
  }, {
    name: 'Embu',
    tag: 'ebu'
  }, {
    name: 'English',
    tag: 'en'
  }, {
    name: 'Estonian',
    tag: 'et'
  }, {
    name: 'Ewe',
    tag: 'ee'
  }, {
    name: 'Ewondo',
    tag: 'ewo'
  }, {
    name: 'Faroese',
    tag: 'fo'
  }, {
    name: 'Filipino',
    tag: 'fil'
  }, {
    name: 'Finnish',
    tag: 'fi'
  }, {
    name: 'French',
    tag: 'fr'
  }, {
    name: 'Frisian',
    tag: 'fy'
  }, {
    name: 'Friulian',
    tag: 'fur'
  }, {
    name: 'Fulah (Latin)',
    tag: 'ff-Latn'
  }, {
    name: 'Fulah',
    tag: 'ff'
  }, {
    name: 'Galician',
    tag: 'gl'
  }, {
    name: 'Ganda',
    tag: 'lg'
  }, {
    name: 'Georgian',
    tag: 'ka'
  }, {
    name: 'German',
    tag: 'de'
  }, {
    name: 'Greek',
    tag: 'el'
  }, {
    name: 'Greenlandic',
    tag: 'kl'
  }, {
    name: 'Guarani',
    tag: 'gn'
  }, {
    name: 'Gujarati',
    tag: 'gu'
  }, {
    name: 'Gusii',
    tag: 'guz'
  }, {
    name: 'Hausa (Latin)',
    tag: 'ha-Latn'
  }, {
    name: 'Hawaiian',
    tag: 'haw'
  }, {
    name: 'Hebrew',
    tag: 'he'
  }, {
    name: 'Hindi',
    tag: 'hi'
  }, {
    name: 'Hungarian',
    tag: 'hu'
  }, {
    name: 'Icelandic',
    tag: 'is'
  }, {
    name: 'Igbo',
    tag: 'ig'
  }, {
    name: 'Indonesian',
    tag: 'id'
  }, {
    name: 'Interlingua',
    tag: 'ia'
  }, {
    name: 'Inuktitut (Latin)',
    tag: 'iu-Latn'
  }, {
    name: 'Inuktitut (Syllabics)',
    tag: 'iu-Cans'
  }, {
    name: 'Irish',
    tag: 'ga'
  }, {
    name: 'Italian',
    tag: 'it'
  }, {
    name: 'Japanese',
    tag: 'ja'
  }, {
    name: 'Jola-Fonyi',
    tag: 'dyo'
  }, {
    name: 'Kabyle',
    tag: 'kab'
  }, {
    name: 'Kako',
    tag: 'kkj'
  }, {
    name: 'Kalenjin',
    tag: 'kln'
  }, {
    name: 'Kamba',
    tag: 'kam'
  }, {
    name: 'Kannada',
    tag: 'kn'
  }, {
    name: 'Kazakh',
    tag: 'kk'
  }, {
    name: 'Khmer',
    tag: 'km'
  }, {
    name: "K'iche",
    tag: 'quc-Latn'
  }, {
    name: 'Kikuyu',
    tag: 'ki'
  }, {
    name: 'Kinyarwanda',
    tag: 'rw'
  }, {
    name: 'Kiswahili',
    tag: 'sw'
  }, {
    name: 'Konkani',
    tag: 'kok'
  }, {
    name: 'Korean',
    tag: 'ko'
  }, {
    name: 'Koyra Chiini',
    tag: 'khq'
  }, {
    name: 'Koyraboro Senni',
    tag: 'ses'
  }, {
    name: 'Kwasio',
    tag: 'nmg'
  }, {
    name: 'Kyrgyz',
    tag: 'ky'
  }, {
    name: 'Lakota',
    tag: 'lkt'
  }, {
    name: 'Langi',
    tag: 'lag'
  }, {
    name: 'Latvian',
    tag: 'lv'
  }, {
    name: 'Lingala',
    tag: 'ln'
  }, {
    name: 'Lithuanian',
    tag: 'lt'
  }, {
    name: 'Low German ',
    tag: 'nds'
  }, {
    name: 'Low German',
    tag: 'nds'
  }, {
    name: 'Lower Sorbian',
    tag: 'dsb'
  }, {
    name: 'Luo',
    tag: 'luo'
  }, {
    name: 'Luxembourgish',
    tag: 'lb'
  }, {
    name: 'Luyia',
    tag: 'luy'
  }, {
    name: 'Machame',
    tag: 'jmc'
  }, {
    name: 'Makhuwa-Meetto',
    tag: 'mgh'
  }, {
    name: 'Makonde',
    tag: 'kde'
  }, {
    name: 'Malagasy',
    tag: 'mg'
  }, {
    name: 'Malay',
    tag: 'ms'
  }, {
    name: 'Malayalam',
    tag: 'ml'
  }, {
    name: 'Maltese',
    tag: 'mt'
  }, {
    name: 'Manx',
    tag: 'gv'
  }, {
    name: 'Maori',
    tag: 'mi'
  }, {
    name: 'Mapudungun',
    tag: 'arn'
  }, {
    name: 'Marathi',
    tag: 'mr'
  }, {
    name: 'Masai',
    tag: 'mas'
  }, {
    name: 'Mazanderani',
    tag: 'mzn'
  }, {
    name: 'Meru',
    tag: 'mer'
  }, {
    name: "Meta'",
    tag: 'mgo'
  }, {
    name: 'Mohawk',
    tag: 'moh'
  }, {
    name: 'Mongolian (Cyrillic)',
    tag: 'mn'
  }, {
    name: 'Mongolian (Traditional)',
    tag: 'mn'
  }, {
    name: 'Morisyen',
    tag: 'mfe'
  }, {
    name: 'Mundang',
    tag: 'mua'
  }, {
    name: "N'ko",
    tag: 'nqo'
  }, {
    name: 'Nama',
    tag: 'naq'
  }, {
    name: 'Nepali',
    tag: 'ne'
  }, {
    name: 'Ngiemboon',
    tag: 'nnh'
  }, {
    name: 'Ngomba',
    tag: 'jgo'
  }, {
    name: 'Northern Luri',
    tag: 'lrc'
  }, {
    name: 'North Ndebele',
    tag: 'nd'
  }, {
    name: 'Norwegian (Bokmal)',
    tag: 'nb'
  }, {
    name: 'Norwegian (Nynorsk)',
    tag: 'nn'
  }, {
    name: 'Norwegian Bokmål',
    tag: 'nb'
  }, {
    name: 'Nuer',
    tag: 'nus'
  }, {
    name: 'Nyankole',
    tag: 'nyn'
  }, {
    name: 'Occitan',
    tag: 'oc'
  }, {
    name: 'Odia',
    tag: 'or'
  }, {
    name: 'Oromo',
    tag: 'om'
  }, {
    name: 'Pashto',
    tag: 'ps'
  }, {
    name: 'Persian',
    tag: 'fa'
  }, {
    name: 'Polish',
    tag: 'pl'
  }, {
    name: 'Portuguese',
    tag: 'pt'
  }, {
    name: 'Punjabi',
    tag: 'pa'
  }, {
    name: 'Quechua',
    tag: 'quz'
  }, {
    name: 'Ripuarian',
    tag: 'ksh'
  }, {
    name: 'Romanian',
    tag: 'ro'
  }, {
    name: 'Romansh',
    tag: 'rm'
  }, {
    name: 'Rombo',
    tag: 'rof'
  }, {
    name: 'Rundi',
    tag: 'rn'
  }, {
    name: 'Russian',
    tag: 'ru'
  }, {
    name: 'Rwa',
    tag: 'rwk'
  }, {
    name: 'Saho',
    tag: 'ssy'
  }, {
    name: 'Sakha',
    tag: 'sah'
  }, {
    name: 'Samburu',
    tag: 'saq'
  }, {
    name: 'Sami (Inari)',
    tag: 'smn'
  }, {
    name: 'Sami (Lule)',
    tag: 'smj'
  }, {
    name: 'Sami (Northern)',
    tag: 'se'
  }, {
    name: 'Sami (Skolt)',
    tag: 'sms'
  }, {
    name: 'Sami (Southern)',
    tag: 'sma'
  }, {
    name: 'Sango',
    tag: 'sg'
  }, {
    name: 'Sangu',
    tag: 'sbp'
  }, {
    name: 'Sanskrit',
    tag: 'sa'
  }, {
    name: 'Scottish Gaelic',
    tag: 'gd'
  }, {
    name: 'Sena',
    tag: 'seh'
  }, {
    name: 'Serbian (Cyrillic)',
    tag: 'sr-Cyrl'
  }, {
    name: 'Serbian (Latin)',
    tag: 'sr-Latn'
  }, {
    name: 'Sesotho sa Leboa',
    tag: 'nso'
  }, {
    name: 'Setswana',
    tag: 'tn'
  }, {
    name: 'Shambala',
    tag: 'ksb'
  }, {
    name: 'Shona',
    tag: 'sn-Latn'
  }, {
    name: 'Sinhala',
    tag: 'si'
  }, {
    name: 'Slovak',
    tag: 'sk'
  }, {
    name: 'Slovenian',
    tag: 'sl'
  }, {
    name: 'Soga',
    tag: 'xog'
  }, {
    name: 'Somali',
    tag: 'so'
  }, {
    name: 'Sotho',
    tag: 'st'
  }, {
    name: 'South Ndebele',
    tag: 'nr'
  }, {
    name: 'Southern Sotho',
    tag: 'st'
  }, {
    name: 'Spanish',
    tag: 'es'
  }, {
    name: 'Standard Moroccan ',
    tag: 'zgh-Tfng'
  }, {
    name: 'Swati',
    tag: 'ss'
  }, {
    name: 'Swedish',
    tag: 'sv'
  }, {
    name: 'Syriac',
    tag: 'syr'
  }, {
    name: 'Tachelhit (Latin)',
    tag: 'shi-Latn'
  }, {
    name: 'Taita',
    tag: 'dav'
  }, {
    name: 'Tajik (Cyrillic)',
    tag: 'tg-Cyrl'
  }, {
    name: 'Tamazight (Latin)',
    tag: 'tzm-Latn'
  }, {
    name: 'Tamil',
    tag: 'ta'
  }, {
    name: 'Tasawaq',
    ag: 'twq'
  }, {
    name: 'Tatar',
    tag: 'tt'
  }, {
    name: 'Telugu',
    tag: 'te'
  }, {
    name: 'Teso',
    tag: 'teo'
  }, {
    name: 'Thai',
    tag: 'th'
  }, {
    name: 'Tibetan',
    tag: 'bo'
  }, {
    name: 'Tigre',
    tag: 'tig'
  }, {
    name: 'Tigrinya',
    tag: 'ti'
  }, {
    name: 'Tongan',
    tag: 'to'
  }, {
    name: 'Tsonga',
    tag: 'ts'
  }, {
    name: 'Turkish',
    tag: 'tr'
  }, {
    name: 'Turkmen',
    tag: 'tk'
  }, {
    name: 'Ukrainian',
    tag: 'uk'
  }, {
    name: 'Upper Sorbian',
    tag: 'hsb'
  }, {
    name: 'Urdu',
    tag: 'ur'
  }, {
    name: 'Uzbek (Cyrillic)',
    tag: 'uz-Cyrl'
  }, {
    name: 'Uzbek (Latin)',
    tag: 'uz-Latn'
  }, {
    name: 'Vai',
    tag: 'vai-Vaii'
  }, {
    name: 'Vai (Latin)',
    tag: 'vai-Latn'
  }, {
    name: 'Valencian',
    tag: 'ca'
  }, {
    name: 'Venda',
    tag: 've'
  }, {
    name: 'Vietnamese',
    tag: 'vi'
  }, {
    name: 'Vunjo',
    tag: 'vun'
  }, {
    name: 'Walser',
    tag: 'wae'
  }, {
    name: 'Welsh',
    tag: 'cy'
  }, {
    name: 'Wolaytta',
    tag: 'wal'
  }, {
    name: 'Wolof',
    tag: 'wo'
  }, {
    name: 'Xhosa',
    tag: 'xh'
  }, {
    name: 'Yangben',
    tag: 'yav'
  }, {
    name: 'Yoruba',
    tag: 'yo'
  }, {
    name: 'Zarma',
    tag: 'dje'
  }, {
    name: 'Zulu',
    tag: 'zu'
  }]; // List adapted from: https://developers.taxjar.com/api/reference/#countries

  api.commerceTaxJarCountryList = [// North America:
  'US', 'CA', // Oceania:
  'AU', // European Union:
  'AT', 'BE', 'BG', 'HR', 'CY', 'CZ', 'DK', 'EE', 'FI', 'FR', 'DE', 'GR', 'HU', 'IE', 'IT', 'LV', 'LT', 'LU', 'MT', 'NL', 'PL', 'PT', 'RO', 'SK', 'SI', 'ES', 'SE', 'GB'];
  api.commerceUnitSystemOptions = [{
    code: 'imperial',
    name: 'Imperial system'
  }, {
    code: 'metric',
    name: 'Metric system'
  }];
  api.DEFAULT_PROFILE_IMAGE = 'https://daks2k3a4ib2z.cloudfront.net/img/profile-user.png';
  api.DEFAULT_OAUTH_APP_IMAGE = 'https://daks2k3a4ib2z.cloudfront.net/img/integrations.png'; // getWfBadgeStatus :: ({}, {}, {}, Boolean) -> Boolean

  api.getWfBadgeStatus = function (siteMeta, user, subscription, isOrg) {
    if (siteMeta && siteMeta.showWebflowBadge !== undefined) {
      return siteMeta.showWebflowBadge;
    }

    if (isOrg) {
      return false;
    }

    if (subscription) {
      return false;
    }

    if (!user || user.plan === 'free' || user.plan === 'lite') {
      return true;
    }

    return false;
  };

  api.PUBLISH_TASK = {
    POLLING_INTERVAL: 1500,
    POLLING_TIMEOUT: 5 * 60 * 1000
  };
  api.PUBLISH_TASK.MAX_POLL_RETRIES = Math.floor(api.PUBLISH_TASK.POLLING_TIMEOUT / api.PUBLISH_TASK.POLLING_INTERVAL);
  api.SYBG_HOURS = 2;
  api.USER_ID_COOKIE = 'wf_user';
  api.MKTG_CHANNEL_COOKIE = 'wf_mktg_channel';
  api.FIRST_TOUCH_COOKIE = 'wf_first_touch';
  api.EXP_UNIQUE_ID_COOKIE = 'wf_exp_uniqueId';
  api.EXP_ASSIGNMENTS_COOKIE = 'wf_exp_assignments';
  api.EXP_CACHE_EXPIRATION_HOURS = 12;
  api.RESUME_TUTORIALS_LOCALSTORAGE_KEY = 'wf_resume_tutorials';
  api.LOGGED_OUT_COOKIE = 'wf_logout';
  api.DNSSEC_STATUS = {
    enabled: 'enabled',
    disabled: 'disabled',
    misconfigured: 'misconfigured',
    unknown: 'unknown'
  };
  api.ANALYTICS_SESSION_POLLING_FREQUENCY = 30000;
  api.NUX_TEMPLATE_NAME = 'NUX Guided Creation Template';
  api.blankTemplate = {
    name: 'Blank Site',
    description: 'Start from a blank canvas — and build exactly what you’re envisioning.',
    starter: true
  }; // Export commonjs module

  if ( true && module.exports) {
    module.exports = api;
  } // Export public api


  return api;
}();

/***/ }),
/* 249 */
/***/ (function(module, exports, __webpack_require__) {

var toFinite = __webpack_require__(517);

/**
 * Converts `value` to an integer.
 *
 * **Note:** This method is loosely based on
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted integer.
 * @example
 *
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 */
function toInteger(value) {
  var result = toFinite(value),
      remainder = result % 1;

  return result === result ? (remainder ? result - remainder : result) : 0;
}

module.exports = toInteger;


/***/ }),
/* 250 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(9),
    isSymbol = __webpack_require__(104);

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to match leading and trailing whitespace. */
var reTrim = /^\s+|\s+$/g;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, '');
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = toNumber;


/***/ }),
/* 251 */
/***/ (function(module, exports, __webpack_require__) {

var arrayEach = __webpack_require__(154),
    baseEach = __webpack_require__(238),
    castFunction = __webpack_require__(523),
    isArray = __webpack_require__(6);

/**
 * Iterates over elements of `collection` and invokes `iteratee` for each element.
 * The iteratee is invoked with three arguments: (value, index|key, collection).
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * **Note:** As with other "Collections" methods, objects with a "length"
 * property are iterated like arrays. To avoid this behavior use `_.forIn`
 * or `_.forOwn` for object iteration.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @alias each
 * @category Collection
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @returns {Array|Object} Returns `collection`.
 * @see _.forEachRight
 * @example
 *
 * _.forEach([1, 2], function(value) {
 *   console.log(value);
 * });
 * // => Logs `1` then `2`.
 *
 * _.forEach({ 'a': 1, 'b': 2 }, function(value, key) {
 *   console.log(key);
 * });
 * // => Logs 'a' then 'b' (iteration order is not guaranteed).
 */
function forEach(collection, iteratee) {
  var func = isArray(collection) ? arrayEach : baseEach;
  return func(collection, castFunction(iteratee));
}

module.exports = forEach;


/***/ }),
/* 252 */
/***/ (function(module, exports) {

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

module.exports = _arrayWithHoles;

/***/ }),
/* 253 */
/***/ (function(module, exports) {

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

module.exports = _nonIterableRest;

/***/ }),
/* 254 */
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration

;(function (global, factory) {
    true ? factory(__webpack_require__(41)) :
   undefined
}(this, (function (moment) { 'use strict';


    var enAu = moment.defineLocale('en-au', {
        months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
        monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
        weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
        weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
        weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
        longDateFormat : {
            LT : 'h:mm A',
            LTS : 'h:mm:ss A',
            L : 'DD/MM/YYYY',
            LL : 'D MMMM YYYY',
            LLL : 'D MMMM YYYY h:mm A',
            LLLL : 'dddd, D MMMM YYYY h:mm A'
        },
        calendar : {
            sameDay : '[Today at] LT',
            nextDay : '[Tomorrow at] LT',
            nextWeek : 'dddd [at] LT',
            lastDay : '[Yesterday at] LT',
            lastWeek : '[Last] dddd [at] LT',
            sameElse : 'L'
        },
        relativeTime : {
            future : 'in %s',
            past : '%s ago',
            s : 'a few seconds',
            ss : '%d seconds',
            m : 'a minute',
            mm : '%d minutes',
            h : 'an hour',
            hh : '%d hours',
            d : 'a day',
            dd : '%d days',
            M : 'a month',
            MM : '%d months',
            y : 'a year',
            yy : '%d years'
        },
        dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        },
        week : {
            dow : 1, // Monday is the first day of the week.
            doy : 4  // The week that contains Jan 4th is the first week of the year.
        }
    });

    return enAu;

})));


/***/ }),
/* 255 */
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration

;(function (global, factory) {
    true ? factory(__webpack_require__(41)) :
   undefined
}(this, (function (moment) { 'use strict';


    var enCa = moment.defineLocale('en-ca', {
        months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
        monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
        weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
        weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
        weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
        longDateFormat : {
            LT : 'h:mm A',
            LTS : 'h:mm:ss A',
            L : 'YYYY-MM-DD',
            LL : 'MMMM D, YYYY',
            LLL : 'MMMM D, YYYY h:mm A',
            LLLL : 'dddd, MMMM D, YYYY h:mm A'
        },
        calendar : {
            sameDay : '[Today at] LT',
            nextDay : '[Tomorrow at] LT',
            nextWeek : 'dddd [at] LT',
            lastDay : '[Yesterday at] LT',
            lastWeek : '[Last] dddd [at] LT',
            sameElse : 'L'
        },
        relativeTime : {
            future : 'in %s',
            past : '%s ago',
            s : 'a few seconds',
            ss : '%d seconds',
            m : 'a minute',
            mm : '%d minutes',
            h : 'an hour',
            hh : '%d hours',
            d : 'a day',
            dd : '%d days',
            M : 'a month',
            MM : '%d months',
            y : 'a year',
            yy : '%d years'
        },
        dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        }
    });

    return enCa;

})));


/***/ }),
/* 256 */
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration

;(function (global, factory) {
    true ? factory(__webpack_require__(41)) :
   undefined
}(this, (function (moment) { 'use strict';


    var enGb = moment.defineLocale('en-gb', {
        months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
        monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
        weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
        weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
        weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
        longDateFormat : {
            LT : 'HH:mm',
            LTS : 'HH:mm:ss',
            L : 'DD/MM/YYYY',
            LL : 'D MMMM YYYY',
            LLL : 'D MMMM YYYY HH:mm',
            LLLL : 'dddd, D MMMM YYYY HH:mm'
        },
        calendar : {
            sameDay : '[Today at] LT',
            nextDay : '[Tomorrow at] LT',
            nextWeek : 'dddd [at] LT',
            lastDay : '[Yesterday at] LT',
            lastWeek : '[Last] dddd [at] LT',
            sameElse : 'L'
        },
        relativeTime : {
            future : 'in %s',
            past : '%s ago',
            s : 'a few seconds',
            ss : '%d seconds',
            m : 'a minute',
            mm : '%d minutes',
            h : 'an hour',
            hh : '%d hours',
            d : 'a day',
            dd : '%d days',
            M : 'a month',
            MM : '%d months',
            y : 'a year',
            yy : '%d years'
        },
        dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        },
        week : {
            dow : 1, // Monday is the first day of the week.
            doy : 4  // The week that contains Jan 4th is the first week of the year.
        }
    });

    return enGb;

})));


/***/ }),
/* 257 */
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration

;(function (global, factory) {
    true ? factory(__webpack_require__(41)) :
   undefined
}(this, (function (moment) { 'use strict';


    var enIe = moment.defineLocale('en-ie', {
        months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
        monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
        weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
        weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
        weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
        longDateFormat : {
            LT : 'HH:mm',
            LTS : 'HH:mm:ss',
            L : 'DD-MM-YYYY',
            LL : 'D MMMM YYYY',
            LLL : 'D MMMM YYYY HH:mm',
            LLLL : 'dddd D MMMM YYYY HH:mm'
        },
        calendar : {
            sameDay : '[Today at] LT',
            nextDay : '[Tomorrow at] LT',
            nextWeek : 'dddd [at] LT',
            lastDay : '[Yesterday at] LT',
            lastWeek : '[Last] dddd [at] LT',
            sameElse : 'L'
        },
        relativeTime : {
            future : 'in %s',
            past : '%s ago',
            s : 'a few seconds',
            ss : '%d seconds',
            m : 'a minute',
            mm : '%d minutes',
            h : 'an hour',
            hh : '%d hours',
            d : 'a day',
            dd : '%d days',
            M : 'a month',
            MM : '%d months',
            y : 'a year',
            yy : '%d years'
        },
        dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        },
        week : {
            dow : 1, // Monday is the first day of the week.
            doy : 4  // The week that contains Jan 4th is the first week of the year.
        }
    });

    return enIe;

})));


/***/ }),
/* 258 */
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration

;(function (global, factory) {
    true ? factory(__webpack_require__(41)) :
   undefined
}(this, (function (moment) { 'use strict';


    var enIl = moment.defineLocale('en-il', {
        months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
        monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
        weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
        weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
        weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
        longDateFormat : {
            LT : 'HH:mm',
            LTS : 'HH:mm:ss',
            L : 'DD/MM/YYYY',
            LL : 'D MMMM YYYY',
            LLL : 'D MMMM YYYY HH:mm',
            LLLL : 'dddd, D MMMM YYYY HH:mm'
        },
        calendar : {
            sameDay : '[Today at] LT',
            nextDay : '[Tomorrow at] LT',
            nextWeek : 'dddd [at] LT',
            lastDay : '[Yesterday at] LT',
            lastWeek : '[Last] dddd [at] LT',
            sameElse : 'L'
        },
        relativeTime : {
            future : 'in %s',
            past : '%s ago',
            s : 'a few seconds',
            m : 'a minute',
            mm : '%d minutes',
            h : 'an hour',
            hh : '%d hours',
            d : 'a day',
            dd : '%d days',
            M : 'a month',
            MM : '%d months',
            y : 'a year',
            yy : '%d years'
        },
        dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        }
    });

    return enIl;

})));


/***/ }),
/* 259 */
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration

;(function (global, factory) {
    true ? factory(__webpack_require__(41)) :
   undefined
}(this, (function (moment) { 'use strict';


    var enNz = moment.defineLocale('en-nz', {
        months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
        monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
        weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
        weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
        weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
        longDateFormat : {
            LT : 'h:mm A',
            LTS : 'h:mm:ss A',
            L : 'DD/MM/YYYY',
            LL : 'D MMMM YYYY',
            LLL : 'D MMMM YYYY h:mm A',
            LLLL : 'dddd, D MMMM YYYY h:mm A'
        },
        calendar : {
            sameDay : '[Today at] LT',
            nextDay : '[Tomorrow at] LT',
            nextWeek : 'dddd [at] LT',
            lastDay : '[Yesterday at] LT',
            lastWeek : '[Last] dddd [at] LT',
            sameElse : 'L'
        },
        relativeTime : {
            future : 'in %s',
            past : '%s ago',
            s : 'a few seconds',
            ss : '%d seconds',
            m : 'a minute',
            mm : '%d minutes',
            h : 'an hour',
            hh : '%d hours',
            d : 'a day',
            dd : '%d days',
            M : 'a month',
            MM : '%d months',
            y : 'a year',
            yy : '%d years'
        },
        dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
        ordinal : function (number) {
            var b = number % 10,
                output = (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                (b === 2) ? 'nd' :
                (b === 3) ? 'rd' : 'th';
            return number + output;
        },
        week : {
            dow : 1, // Monday is the first day of the week.
            doy : 4  // The week that contains Jan 4th is the first week of the year.
        }
    });

    return enNz;

})));


/***/ }),
/* 260 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ParamFieldPathUtils = __webpack_require__(536);

Object.keys(_ParamFieldPathUtils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _ParamFieldPathUtils[key];
    }
  });
});

/***/ }),
/* 261 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _FilterUtils = __webpack_require__(540);

Object.keys(_FilterUtils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _FilterUtils[key];
    }
  });
});

/***/ }),
/* 262 */
/***/ (function(module, exports, __webpack_require__) {

var escapeHtmlChar = __webpack_require__(572),
    toString = __webpack_require__(37);

/** Used to match HTML entities and HTML characters. */
var reUnescapedHtml = /[&<>"']/g,
    reHasUnescapedHtml = RegExp(reUnescapedHtml.source);

/**
 * Converts the characters "&", "<", ">", '"', and "'" in `string` to their
 * corresponding HTML entities.
 *
 * **Note:** No other characters are escaped. To escape additional
 * characters use a third-party library like [_he_](https://mths.be/he).
 *
 * Though the ">" character is escaped for symmetry, characters like
 * ">" and "/" don't need escaping in HTML and have no special meaning
 * unless they're part of a tag or unquoted attribute value. See
 * [Mathias Bynens's article](https://mathiasbynens.be/notes/ambiguous-ampersands)
 * (under "semi-related fun fact") for more details.
 *
 * When working with HTML you should always
 * [quote attribute values](http://wonko.com/post/html-escaping) to reduce
 * XSS vectors.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category String
 * @param {string} [string=''] The string to escape.
 * @returns {string} Returns the escaped string.
 * @example
 *
 * _.escape('fred, barney, & pebbles');
 * // => 'fred, barney, &amp; pebbles'
 */
function escape(string) {
  string = toString(string);
  return (string && reHasUnescapedHtml.test(string))
    ? string.replace(reUnescapedHtml, escapeHtmlChar)
    : string;
}

module.exports = escape;


/***/ }),
/* 263 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__(0);

var _slicedToArray2 = _interopRequireDefault(__webpack_require__(48));

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatNumber = formatNumber;
exports.formatEmail = formatEmail;
exports.formatPhone = formatPhone;

function formatNumber(n, formatType) {
  if (typeof n === 'number') {
    var precision = formatType === '' || formatType === 'none' ? NaN : Number(formatType);

    if (!isNaN(precision)) {
      return n.toFixed(precision);
    } else {
      return String(n);
    }
  } else {
    return '';
  }
} // Format email depending on the binding property being an href and having a subject


function formatEmai